/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler.decompose;

import java.util.HashMap;
import java.util.Map;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.struct.StructMethod;

class DomTracer {
    private static final boolean COLLECT_STRINGS = false;
    private static final boolean COLLECT_DOTS = false;
    private final String filePrefix;
    private final StructMethod structMethod;
    private String string = "";
    private int counter = 0;

    DomTracer(String filePrefix, StructMethod structMethod) {
        this.filePrefix = filePrefix;
        this.structMethod = structMethod;
    }

    private void add(Statement gen, String s, Map<Statement, String> props) {
        ++this.counter;
    }

    void error(Statement stat, String s) {
        this.add(stat, s, Map.of(stat, "fillcolor=coral1,style=filled"));
    }

    void warn(Statement stat, String s) {
        this.add(stat, s, Map.of(stat, "fillcolor=tan1,style=filled"));
    }

    void info(Statement stat, String s) {
        this.add(stat, s, Map.of(stat, "fillcolor=lightblue,style=filled"));
    }

    void success(Statement stat, String s) {
        this.add(stat, s, Map.of(stat, "fillcolor=lawngreen,style=filled"));
    }

    void successCreated(Statement stat, String s, Statement newStat) {
        HashMap<Statement, String> props = new HashMap<Statement, String>();
        props.put(stat, "fillcolor=orange,style=filled");
        props.put(newStat, "fillcolor=lawngreen,style=filled");
        for (Statement st : newStat.getStats()) {
            props.put(st, "fillcolor=pink,style=filled");
        }
        this.add(stat, s, props);
    }

    public String toString() {
        return this.string;
    }
}

