/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.vineflower.java.decompiler.modules.decompiler.MergeHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectNode;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectNodeType;
import org.vineflower.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DoStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.util.DotExporter;
import org.vineflower.java.decompiler.util.collections.ListStack;
import org.vineflower.java.decompiler.util.collections.VBStyleCollection;

public final class ValidationHelper {
    public static final boolean VALIDATE = System.getProperty("VALIDATE_DECOMPILED_CODE", "false").equals("true");

    public static void validateStatement(RootStatement statement) {
        DirectGraph directGraph;
        if (!VALIDATE) {
            return;
        }
        VBStyleCollection<Statement, Integer> statements = new VBStyleCollection<Statement, Integer>();
        LinkedList<Statement> stack = new LinkedList<Statement>();
        stack.push(statement.getDummyExit());
        stack.push(statement);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.pop();
            statements.putWithKey(stat, stat.id);
            stack.addAll(stat.getStats());
        }
        for (Statement stat : statements) {
            for (StatEdge edge : stat.getAllSuccessorEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            for (StatEdge edge : stat.getAllPredecessorEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            for (StatEdge edge : stat.getLabelEdges()) {
                ValidationHelper.validateEdgeContext(statements, stat, edge);
            }
            if (stat.getExprents() != null) {
                for (Exprent exprent : stat.getExprents()) {
                    ValidationHelper.validateExprent(exprent);
                }
            }
            if (!(statements.contains(stat.getFirst()) || stat instanceof DummyExitStatement || stat instanceof BasicBlockStatement)) {
                throw new IllegalStateException("Non-existing first statement: [" + String.valueOf(stat) + "] " + String.valueOf(stat.getFirst()));
            }
            for (Statement statStat : stat.getStats()) {
                if (statStat.getParent() == stat) continue;
                throw new IllegalStateException("Statement parent is not set correctly: " + String.valueOf(statStat));
            }
            ValidationHelper.validateSingleStatement(stat);
        }
        try {
            FlattenStatementsHelper flatten = new FlattenStatementsHelper();
            directGraph = flatten.buildDirectGraph(statement);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to build direct graph", e);
        }
        ValidationHelper.validateDGraph(directGraph, statement);
    }

    private static void validateEdgeContext(VBStyleCollection<Statement, Integer> statements, Statement stat, StatEdge edge) {
        if (!statements.contains(edge.getSource())) {
            throw new IllegalStateException("Edge pointing from non-existing statement: [" + String.valueOf(stat) + "] " + String.valueOf(edge));
        }
        if (!statements.contains(edge.getDestination())) {
            throw new IllegalStateException("Edge pointing to non-existing statement: [" + String.valueOf(stat) + "] " + String.valueOf(edge));
        }
        if (edge.closure != null && !statements.contains(edge.closure)) {
            throw new IllegalStateException("Edge with non-existing closure: [" + String.valueOf(stat) + "] " + String.valueOf(edge));
        }
        ValidationHelper.validateEdge(edge);
    }

    public static void validateEdge(StatEdge edge) {
        if (!VALIDATE) {
            return;
        }
        if (!edge.labeled || edge.closure == null) {
            // empty if block
        }
        if (!ValidationHelper.isSuccessor(edge.getSource(), edge)) {
            throw new IllegalStateException("Edge pointing from statement but it isn't a successor: " + String.valueOf(edge.getSource()) + " " + String.valueOf(edge));
        }
        if (!edge.getDestination().getAllPredecessorEdges().contains(edge)) {
            throw new IllegalStateException("Edge pointing to statement but it isn't a predecessor: " + String.valueOf(edge));
        }
        if (!edge.labeled || edge.getType() != 4 || !edge.getDestination().getLabelEdges().contains(edge)) {
            // empty if block
        }
        switch (edge.getType()) {
            case 1: {
                if (edge.closure == null) break;
                break;
            }
            case 4: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Break edge with break type, but no closure: " + String.valueOf(edge));
                }
                if (edge.closure.type == Statement.StatementType.BASIC_BLOCK) {
                    throw new IllegalStateException("Break edge closure to basic block: " + String.valueOf(edge));
                }
                if (edge.getSource() == edge.closure && !edge.phantomContinue) {
                    throw new IllegalStateException("Break edge with closure pointing to itself: " + String.valueOf(edge));
                }
                if (edge.getDestination() == edge.closure) {
                    throw new IllegalStateException("Break edge with closure pointing to itself: " + String.valueOf(edge));
                }
                if (edge.getSource() == edge.getDestination()) {
                    throw new IllegalStateException("Break edge pointing to itself: " + String.valueOf(edge));
                }
                if (edge.getDestination() instanceof DummyExitStatement || MergeHelper.isDirectPath(edge.closure, edge.getDestination())) break;
                throw new IllegalStateException("Break edge with closure with invalid direct path: " + String.valueOf(edge));
            }
            case 8: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Continue edge with continue type, but no closure: " + String.valueOf(edge));
                }
                if (edge.closure != edge.getDestination()) {
                    throw new IllegalStateException("Continue edge with closure pointing to different destination: " + String.valueOf(edge));
                }
                if (edge.getDestination() instanceof DoStatement) break;
                throw new IllegalStateException("Continue edge where closure isn't pointing to a do: " + String.valueOf(edge));
            }
            case 32: {
                if (edge.closure == null) {
                    throw new IllegalStateException("Finally exit edge with finally exit type, but no closure: " + String.valueOf(edge));
                }
                if (edge.getDestination() instanceof DummyExitStatement) break;
                throw new IllegalStateException("Finally exit edge where closure isn't pointing to the dummy exit: " + String.valueOf(edge));
            }
        }
    }

    public static void validateSingleStatement(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        if (stat.type == Statement.StatementType.BASIC_BLOCK && stat.getAllSuccessorEdges().isEmpty()) {
            throw new IllegalStateException("Basic block " + String.valueOf(stat) + " has no edges");
        }
        switch (stat.type) {
            case IF: {
                ValidationHelper.validateIfStatement((IfStatement)stat);
                break;
            }
            case TRY_CATCH: {
                ValidationHelper.validateTrycatchStatement((CatchStatement)stat);
            }
        }
    }

    public static void validateTrycatchStatement(CatchStatement catchStat) {
        if (catchStat.getStats().size() == 1 && catchStat.getResources().isEmpty()) {
            throw new IllegalStateException("Try statement with single statement: " + String.valueOf(catchStat));
        }
    }

    public static void validateIfStatement(IfStatement ifStat) {
        if (!VALIDATE) {
            return;
        }
        VBStyleCollection<Statement, Integer> stats = ifStat.getStats();
        if (ifStat.getFirst() == null) {
            throw new IllegalStateException("If statement without a first statement: " + String.valueOf(ifStat));
        }
        if (!stats.contains(ifStat.getFirst())) {
            throw new IllegalStateException("If statement does not contain own first statement: " + String.valueOf(ifStat));
        }
        if (ifStat.getIfEdge() == null) {
            throw new IllegalStateException("If statement without an if edge: " + String.valueOf(ifStat));
        }
        if (ifStat.getIfstat() != null) {
            if (ifStat.getIfEdge().getDestination() != ifStat.getIfstat()) {
                throw new IllegalStateException("If statement if edge destination is not ifStat: " + String.valueOf(ifStat) + " (destination is: " + String.valueOf(ifStat.getIfEdge().getDestination()) + " but ifStat is: " + String.valueOf(ifStat.getIfstat()) + ")");
            }
            if (!stats.contains(ifStat.getIfstat())) {
                throw new IllegalStateException("If statement does not contain own ifStat: " + String.valueOf(ifStat));
            }
        }
        if (ifStat.iftype == 0) {
            if (ifStat.getElseEdge() != null) {
                throw new IllegalStateException("If statement with unexpected else edge: " + String.valueOf(ifStat));
            }
            if (ifStat.getSuccessorEdges(0x40000000).isEmpty()) {
                throw new IllegalStateException("If statement with no else edge and no successors: " + String.valueOf(ifStat));
            }
            if (ifStat.getSuccessorEdges(0x40000000).size() > 1) {
                throw new IllegalStateException("If statement with more than one successor: " + String.valueOf(ifStat) + " (successors: " + String.valueOf(ifStat.getSuccessorEdges(0x40000000)) + ")");
            }
        } else if (ifStat.iftype == 1) {
            if (ifStat.getElseEdge() == null) {
                throw new IllegalStateException("IfElse statement without else edge: " + String.valueOf(ifStat));
            }
            if (ifStat.getIfstat() == null) {
                throw new IllegalStateException("IfElse statement without ifStat: " + String.valueOf(ifStat));
            }
            if (ifStat.getElsestat() == null) {
                throw new IllegalStateException("IfElse statement without elseStat: " + String.valueOf(ifStat));
            }
            if (ifStat.getElseEdge().getDestination() != ifStat.getElsestat()) {
                throw new IllegalStateException("IfElse statement else edge destination is not elseStat: " + String.valueOf(ifStat));
            }
            if (!stats.contains(ifStat.getElsestat())) {
                throw new IllegalStateException("IfElse statement does not contain own elseStat: " + String.valueOf(ifStat));
            }
        } else {
            throw new IllegalStateException("Unknown if type: " + String.valueOf(ifStat));
        }
        if (ifStat.getIfEdge() != null && ifStat.getIfEdge().getSource() != ifStat.getFirst()) {
            throw new IllegalStateException("If statement if edge source is not first statement: [" + String.valueOf(ifStat.getIfEdge()) + "] " + String.valueOf(ifStat) + " (source is: " + String.valueOf(ifStat.getIfEdge().getSource()) + " but first is: " + String.valueOf(ifStat.getFirst()) + ")");
        }
        if (ifStat.getElseEdge() != null && ifStat.getElseEdge().getSource() != ifStat.getFirst()) {
            throw new IllegalStateException("IfElse statement else edge source is not first statement: " + String.valueOf(ifStat) + " (elseEdge: " + String.valueOf(ifStat.getElseEdge()) + ")");
        }
        if (stats.size() > 3) {
            throw new IllegalStateException("If statement with more than 3 sub statements: " + String.valueOf(ifStat));
        }
        for (Statement stat : stats) {
            if (stat == ifStat.getFirst() || stat == ifStat.getIfstat() || stat == ifStat.getElsestat()) continue;
            throw new IllegalStateException("If statement contains unknown sub statement: " + String.valueOf(ifStat) + " (subStatement: " + String.valueOf(stat) + ")");
        }
        for (StatEdge edge : ifStat.getFirst().getSuccessorEdges(0x40000000)) {
            if (ifStat.getIfEdge() == edge || ifStat.getElseEdge() == edge) continue;
            throw new IllegalStateException("If statement first contains unknown successor edge: " + String.valueOf(ifStat) + " (edge: " + String.valueOf(edge) + ")");
        }
    }

    public static void validateDGraph(DirectGraph graph, RootStatement root) {
        if (!VALIDATE) {
            return;
        }
        try {
            HashSet inaccessibleNodes = new HashSet(graph.nodes);
            ListStack<DirectNode> stack = new ListStack<DirectNode>();
            stack.push(graph.first);
            inaccessibleNodes.remove(graph.first);
            while (!stack.isEmpty()) {
                DirectNode node = (DirectNode)stack.pop();
                for (DirectEdge pred : node.getPredecessors(DirectEdgeType.REGULAR)) {
                    if (pred.getSource().getSuccessors(DirectEdgeType.REGULAR).contains(pred)) continue;
                    throw new IllegalStateException("Predecessor " + String.valueOf(pred) + " does not have " + String.valueOf(node) + " as a successor");
                }
                for (DirectEdge succ : node.getSuccessors(DirectEdgeType.REGULAR)) {
                    if (!succ.getDestination().getPredecessors(DirectEdgeType.REGULAR).contains(succ)) {
                        throw new IllegalStateException("Successor " + String.valueOf(succ) + " does not have " + String.valueOf(node) + " as a predecessor");
                    }
                    if (!inaccessibleNodes.remove(succ.getDestination())) continue;
                    stack.push(succ.getDestination());
                }
            }
            if (!inaccessibleNodes.isEmpty()) {
                for (DirectNode inaccessibleNode : inaccessibleNodes) {
                    if (inaccessibleNode.type == DirectNodeType.FINALLY_END) continue;
                    throw new IllegalStateException("Inaccessible direct graph nodes: " + String.valueOf(inaccessibleNodes));
                }
            }
            HashMap<ID<Exprent>, DirectNode> allExprents = new HashMap<ID<Exprent>, DirectNode>();
            for (DirectNode node : graph.nodes) {
                for (Exprent exprent : node.exprents) {
                    for (Exprent subExprent : exprent.getAllExprents(true, true)) {
                        ID<Exprent> key = new ID<Exprent>(subExprent);
                        if (allExprents.containsKey(key) && !(subExprent instanceof VarExprent)) {
                            throw new IllegalStateException("Duplicated exprent: " + String.valueOf(subExprent) + " (Sub exprent of: " + String.valueOf(exprent) + ") in dgraph. Appears in both node " + node.id + " and node " + ((DirectNode)allExprents.get(key)).id + "!");
                        }
                        allExprents.put(key, node);
                    }
                }
            }
        }
        catch (Throwable e) {
            DotExporter.errorToDotFile(graph, root.mt, "erroring_dgraph");
            throw e;
        }
    }

    public static void validateVars(DirectGraph dgraph, RootStatement root, Predicate<VarExprent> predicate, String message) {
        if (!VALIDATE) {
            return;
        }
        try {
            for (DirectNode node : dgraph.nodes) {
                if (node.exprents == null) continue;
                for (Exprent exprent : node.exprents) {
                    for (Exprent sub : exprent.getAllExprents(true, true)) {
                        VarExprent var;
                        if (!(sub instanceof VarExprent) || predicate.test(var = (VarExprent)sub)) continue;
                        System.out.println(root.toJava().convertToStringAndAllowDataDiscard());
                        throw new IllegalStateException(message + ": " + var.getIndex() + "_" + var.getVersion() + " " + String.valueOf(var.getVarType()));
                    }
                }
            }
        }
        catch (Throwable e) {
            DotExporter.errorToDotFile(dgraph, root.mt, "erroring_dgraph");
            throw e;
        }
    }

    public static void notNull(Object o) {
        if (!VALIDATE) {
            return;
        }
        if (o == null) {
            throw new NullPointerException("Validation: null object");
        }
    }

    public static void validateExitExprent(ExitExprent exit) {
        if (!VALIDATE) {
            return;
        }
        if (exit.getExitType() == ExitExprent.Type.RETURN) {
            if (exit.getRetType().equals(VarType.VARTYPE_VOID)) {
                if (exit.getValue() != null) {
                    throw new IllegalStateException("Void return with value: " + String.valueOf(exit));
                }
            } else if (exit.getValue() == null) {
                throw new IllegalStateException("Non-void return without value: " + String.valueOf(exit));
            }
        }
        for (Exprent subExprents : exit.getAllExprents()) {
            ValidationHelper.validateExprent(subExprents);
        }
    }

    public static void validateExprent(Exprent exprent) {
        if (!VALIDATE) {
            return;
        }
        switch (exprent.type) {
            case EXIT: {
                ValidationHelper.validateExitExprent((ExitExprent)exprent);
                break;
            }
            default: {
                for (Exprent subExprents : exprent.getAllExprents()) {
                    ValidationHelper.validateExprent(subExprents);
                }
            }
        }
    }

    public static void successorsExist(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        if (stat.getAllSuccessorEdges().isEmpty()) {
            throw new IllegalStateException("Statement has no successors: " + String.valueOf(stat));
        }
    }

    public static void oneSuccessor(Statement stat) {
        if (!VALIDATE) {
            return;
        }
        if (stat.getAllSuccessorEdges().size() != 1) {
            throw new IllegalStateException("Statement has more than one successor: [" + String.valueOf(stat) + "] " + String.valueOf(stat.getAllSuccessorEdges()));
        }
    }

    private static boolean isSuccessor(Statement source, StatEdge edge) {
        IfStatement ifstat;
        if (source.getAllSuccessorEdges().contains(edge)) {
            return true;
        }
        return source.getParent() instanceof IfStatement && (ifstat = (IfStatement)source.getParent()).getFirst() == source && (edge == ifstat.getIfEdge() || edge == ifstat.getElseEdge());
    }

    public static void validateTrue(boolean condition, String message) {
        if (VALIDATE && !condition) {
            throw new IllegalStateException("Validation failed: " + message);
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException("Assertion failed: " + message);
        }
    }

    public static void validateVarVersionsGraph(VarVersionsGraph graph, RootStatement statement, Map<VarVersionPair, VarVersionPair> varAssignmentMap) {
        if (!VALIDATE) {
            return;
        }
        HashSet<VarVersionNode> roots = new HashSet<VarVersionNode>();
        for (VarVersionNode node : graph.nodes) {
            if (!node.predecessors.isEmpty()) continue;
            roots.add(node);
        }
        Set<VarVersionNode> reached = VarVersionsGraph.rootReachability(roots);
        if (graph.nodes.size() != reached.size()) {
            DotExporter.errorToDotFile(graph, statement.mt, "erroring_varVersionGraph", varAssignmentMap);
            throw new IllegalStateException("Highly cyclic varversions graph!");
        }
    }

    private static class ID<T> {
        private final T obj;

        private ID(T obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ID id = (ID)o;
            return this.obj == id.obj;
        }
    }
}

