/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.modules.decompiler.SequenceHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.struct.gen.VarType;

public final class TryWithResourcesProcessor {
    public static boolean makeTryWithResource(CatchAllStatement finallyStat) {
        Exprent exp;
        Statement handler = finallyStat.getHandler();
        if (handler.getStats().size() != 2) {
            return false;
        }
        Statement toCheck = finallyStat.getHandler().getFirst();
        if (!(toCheck instanceof IfStatement) || ((IfStatement)toCheck).getIfstat() == null || !(((IfStatement)toCheck).getIfstat() instanceof IfStatement)) {
            return false;
        }
        if (((IfStatement)(toCheck = ((IfStatement)toCheck).getIfstat())).getElsestat() == null) {
            return false;
        }
        Statement elseBlock = ((IfStatement)toCheck).getElsestat();
        VarExprent var = null;
        if (elseBlock.getExprents() != null && elseBlock.getExprents().size() == 1 && TryWithResourcesProcessor.isCloseable(exp = elseBlock.getExprents().get(0))) {
            var = (VarExprent)((InvocationExprent)exp).getInstance();
        }
        if (var != null) {
            AssignmentExprent ass = null;
            BasicBlockStatement initBlock = null;
            for (StatEdge edge : finallyStat.getAllPredecessorEdges()) {
                if (!edge.getDestination().equals(finallyStat) || !(edge.getSource() instanceof BasicBlockStatement) || (ass = TryWithResourcesProcessor.findResourceDef(var, edge.getSource())) == null) continue;
                initBlock = (BasicBlockStatement)edge.getSource();
                break;
            }
            if (ass != null) {
                Statement stat = finallyStat.getParent();
                Statement stat2 = finallyStat.getFirst();
                if (stat2 instanceof CatchStatement) {
                    CatchStatement child = (CatchStatement)stat2;
                    AssignmentExprent resourceDef = (AssignmentExprent)ass.copy();
                    if (ass.getRight().getExprType().equals(VarType.VARTYPE_NULL) && child.getFirst() != null) {
                        TryWithResourcesProcessor.fixResourceAssignment(resourceDef, child.getFirst());
                    }
                    if (resourceDef.getRight().getExprType().equals(VarType.VARTYPE_NULL)) {
                        return false;
                    }
                    initBlock.getExprents().remove(ass);
                    child.getResources().add(0, resourceDef);
                    if (!finallyStat.getVarDefinitions().isEmpty()) {
                        child.getVarDefinitions().addAll(0, finallyStat.getVarDefinitions());
                    }
                    stat.replaceStatement(finallyStat, child);
                    SequenceHelper.destroyAndFlattenStatement(finallyStat.getHandler());
                    TryWithResourcesProcessor.removeRedundantThrow(initBlock, child);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean makeTryWithResourceJ11(CatchStatement tryStatement) {
        if (tryStatement.getStats().size() < 2) {
            return false;
        }
        if (!tryStatement.getVars().get((int)0).getVarType().value.equals("java/lang/Throwable")) {
            return false;
        }
        Statement inner = (Statement)tryStatement.getStats().get(1);
        VarExprent closeable = null;
        boolean nullable = false;
        if (inner instanceof SequenceStatement) {
            Exprent ifCase;
            if ((inner = (Statement)inner.getStats().get(0)) instanceof CatchStatement) {
                Exprent first;
                if (inner.getStats().isEmpty()) {
                    return false;
                }
                CatchStatement innerTry = (CatchStatement)inner;
                if (!innerTry.getVars().get((int)0).getVarType().value.equals("java/lang/Throwable")) {
                    return false;
                }
                Statement inTry = (Statement)inner.getStats().get(0);
                if (inTry instanceof BasicBlockStatement && !inTry.getExprents().isEmpty() && TryWithResourcesProcessor.isCloseable(first = inTry.getExprents().get(0))) {
                    closeable = (VarExprent)((InvocationExprent)first).getInstance();
                }
            }
            if (inner instanceof IfStatement && (ifCase = ((IfStatement)inner).getHeadexprent().getCondition()) instanceof FunctionExprent) {
                FunctionExprent func = TryWithResourcesProcessor.unwrapNegations((FunctionExprent)ifCase);
                Exprent check = func.getLstOperands().get(0);
                if (!(check instanceof VarExprent)) {
                    return false;
                }
                if (func.getLstOperands().get(1).getExprType().equals(VarType.VARTYPE_NULL)) {
                    if ((inner = ((IfStatement)inner).getIfstat()) == null) {
                        return false;
                    }
                    if (inner instanceof CatchStatement && !inner.getStats().isEmpty()) {
                        Object first;
                        if (inner.getStats().isEmpty()) {
                            return false;
                        }
                        CatchStatement innerTry = (CatchStatement)inner;
                        if (!innerTry.getVars().get((int)0).getVarType().value.equals("java/lang/Throwable")) {
                            return false;
                        }
                        Statement inTry = (Statement)inner.getStats().get(0);
                        if (inTry instanceof BasicBlockStatement && !inTry.getExprents().isEmpty() && TryWithResourcesProcessor.isCloseable((Exprent)(first = inTry.getExprents().get(0)))) {
                            closeable = (VarExprent)((InvocationExprent)first).getInstance();
                            nullable = true;
                            if (!closeable.getVarVersionPair().equals(((VarExprent)check).getVarVersionPair())) {
                                closeable = null;
                            }
                        }
                    }
                }
            }
        }
        if (closeable == null) {
            return false;
        }
        Set<Statement> destinations = TryWithResourcesProcessor.findExitpoints(tryStatement);
        if (destinations.isEmpty()) {
            return false;
        }
        List<Object> preds = new ArrayList();
        for (Statement check = tryStatement; check != null && preds.isEmpty(); check = check.getParent()) {
            preds = check.getPredecessorEdges(1);
        }
        if (preds.isEmpty()) {
            return false;
        }
        StatEdge edge = (StatEdge)preds.get(0);
        if (edge.getSource() instanceof BasicBlockStatement) {
            AssignmentExprent assignment = TryWithResourcesProcessor.findResourceDef(closeable, edge.getSource());
            if (assignment == null) {
                return false;
            }
            for (Statement destination : destinations) {
                if (TryWithResourcesProcessor.isValid(destination, closeable, nullable)) continue;
                return false;
            }
            for (Statement destination : destinations) {
                TryWithResourcesProcessor.removeClose(destination, nullable);
            }
            edge.getSource().getExprents().remove(assignment);
            tryStatement.getResources().add(0, assignment);
            Statement remove = (Statement)tryStatement.getStats().get(1);
            SequenceHelper.destroyAndFlattenStatement(remove);
            tryStatement.getStats().remove(1);
            return true;
        }
        return false;
    }

    private static boolean isValid(Statement stat, VarExprent closeable, boolean nullable) {
        Exprent inst;
        Exprent exprent;
        FunctionExprent func;
        IfStatement ifStat;
        Exprent condition;
        return nullable ? stat instanceof IfStatement && (condition = (ifStat = (IfStatement)stat).getHeadexprent().getCondition()) instanceof FunctionExprent && (func = TryWithResourcesProcessor.unwrapNegations((FunctionExprent)condition)).getFuncType() == FunctionExprent.FunctionType.NE && func.getLstOperands().get(0) instanceof VarExprent && func.getLstOperands().get(1).getExprType().equals(VarType.VARTYPE_NULL) && func.getLstOperands().get(0) instanceof VarExprent && ((VarExprent)func.getLstOperands().get(0)).getVarVersionPair().equals(closeable.getVarVersionPair()) : stat instanceof BasicBlockStatement && stat.getExprents() != null && !stat.getExprents().isEmpty() && (exprent = stat.getExprents().get(0)) instanceof InvocationExprent && (inst = ((InvocationExprent)exprent).getInstance()) instanceof VarExprent && inst.equals(closeable) && TryWithResourcesProcessor.isCloseable(exprent);
    }

    private static void removeClose(Statement statement, boolean nullable) {
        if (nullable) {
            List<StatEdge> edges = statement.getAllSuccessorEdges();
            if (!edges.isEmpty() && edges.get((int)0).closure == statement.getParent()) {
                SequenceHelper.destroyAndFlattenStatement(statement);
            } else {
                for (StatEdge edge : statement.getFirst().getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                }
                for (StatEdge edge : ((IfStatement)statement).getIfstat().getAllSuccessorEdges()) {
                    edge.getDestination().removePredecessor(edge);
                    if (edge.closure == null) continue;
                    edge.closure.getLabelEdges().remove(edge);
                }
                statement.replaceWithEmpty();
            }
        } else {
            statement.getExprents().remove(0);
        }
    }

    private static Set<Statement> findExitpoints(Statement stat) {
        LinkedHashSet<StatEdge> edges = new LinkedHashSet<StatEdge>();
        TryWithResourcesProcessor.findEdgesLeaving(stat.getFirst(), stat, edges);
        return edges.stream().map(StatEdge::getDestination).collect(Collectors.toSet());
    }

    public static void findEdgesLeaving(Statement curr, Statement check, Set<StatEdge> edges) {
        TryWithResourcesProcessor.findEdgesLeaving(curr, check, edges, false);
    }

    public static void findEdgesLeaving(Statement curr, Statement check, Set<StatEdge> edges, boolean allowExit) {
        TryWithResourcesProcessor.findEdgesLeaving(curr, check, edges, allowExit, new HashMap<Statement, Set<Statement>>());
    }

    private static void findEdgesLeaving(Statement curr, Statement check, Set<StatEdge> edges, boolean allowExit, Map<Statement, Set<Statement>> found) {
        for (StatEdge edge : curr.getAllSuccessorEdges()) {
            if (check.containsStatement(edge.getDestination()) || !allowExit && edge.getDestination() instanceof DummyExitStatement || !edge.explicit && !found.entrySet().stream().allMatch(e -> !((Statement)e.getKey()).containsStatement(curr) || !((Set)e.getValue()).contains(edge.getDestination()))) continue;
            edges.add(edge);
            found.computeIfAbsent(curr, stat -> new HashSet()).add(edge.getDestination());
        }
        for (Statement stat2 : curr.getStats()) {
            TryWithResourcesProcessor.findEdgesLeaving(stat2, check, edges, allowExit, found);
        }
    }

    private static FunctionExprent unwrapNegations(FunctionExprent func) {
        Exprent expr;
        while (func.getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && (expr = func.getLstOperands().get(0)) instanceof FunctionExprent) {
            func = (FunctionExprent)expr;
        }
        return func;
    }

    private static AssignmentExprent findResourceDef(VarExprent var, Statement prevStatement) {
        for (Exprent exp : prevStatement.getExprents()) {
            VarExprent left;
            AssignmentExprent ass;
            if (!(exp instanceof AssignmentExprent) || !((ass = (AssignmentExprent)exp).getLeft() instanceof VarExprent) || !(left = (VarExprent)ass.getLeft()).getVarVersionPair().equals(var.getVarVersionPair())) continue;
            return ass;
        }
        return null;
    }

    private static boolean isCloseable(Exprent exp) {
        InvocationExprent invocExp;
        if (exp instanceof InvocationExprent && (invocExp = (InvocationExprent)exp).getName().equals("close") && invocExp.getStringDescriptor().equals("()V") && invocExp.getInstance() != null && invocExp.getInstance() instanceof VarExprent) {
            return DecompilerContext.getStructContext().instanceOf(invocExp.getClassname(), "java/lang/AutoCloseable");
        }
        return false;
    }

    private static void fixResourceAssignment(AssignmentExprent ass, Statement statement) {
        if (statement.getExprents() != null) {
            for (Exprent exp : statement.getExprents()) {
                if (!(exp instanceof AssignmentExprent)) continue;
                AssignmentExprent toRemove = (AssignmentExprent)exp;
                if (!ass.getLeft().equals(toRemove.getLeft()) || toRemove.getRight().getExprType().equals(VarType.VARTYPE_NULL)) continue;
                ass.setRight(toRemove.getRight());
                statement.getExprents().remove(toRemove);
                break;
            }
        }
    }

    private static boolean removeRedundantThrow(BasicBlockStatement initBlock, CatchStatement catchStat) {
        if (catchStat.getStats().size() > 1) {
            boolean removed = false;
            Statement temp = null;
            for (int i = 1; i < catchStat.getStats().size(); ++i) {
                ExitExprent exitExprent;
                temp = (Statement)catchStat.getStats().get(i);
                if (!(temp instanceof BasicBlockStatement) || temp.getExprents() == null || temp.getExprents().size() < 2 || !catchStat.getVars().get((int)(i - 1)).getVarType().value.equals("java/lang/Throwable") || !(temp.getExprents().get(temp.getExprents().size() - 1) instanceof ExitExprent) || (exitExprent = (ExitExprent)temp.getExprents().get(temp.getExprents().size() - 1)).getExitType() != ExitExprent.Type.THROW || !exitExprent.getValue().equals(catchStat.getVars().get(i - 1))) continue;
                catchStat.getExctStrings().remove(i - 1);
                catchStat.getVars().remove(i - 1);
                catchStat.getStats().remove(i);
                for (StatEdge edge : temp.getAllSuccessorEdges()) {
                    edge.getSource().removeSuccessor(edge);
                }
                removed = true;
                break;
            }
            if (removed && temp.getExprents().get(temp.getExprents().size() - 2) instanceof AssignmentExprent) {
                AssignmentExprent assignmentExp = (AssignmentExprent)temp.getExprents().get(temp.getExprents().size() - 2);
                if (assignmentExp.getLeft().getExprType().value.equals("java/lang/Throwable")) {
                    for (Exprent exprent : initBlock.getExprents()) {
                        AssignmentExprent toRemove;
                        if (!(exprent instanceof AssignmentExprent) || !(toRemove = (AssignmentExprent)exprent).getLeft().equals(assignmentExp.getLeft())) continue;
                        initBlock.getExprents().remove(toRemove);
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

