/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.rels.ClassWrapper;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.IfHelper;
import org.vineflower.java.decompiler.modules.decompiler.SequenceHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.IfExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.NewExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.match.IMatchable;
import org.vineflower.java.decompiler.struct.match.MatchEngine;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.Pair;
import org.vineflower.java.decompiler.util.collections.FastSparseSetFactory;

public class SimplifyExprentsHelper {
    private static final MatchEngine class14Builder = new MatchEngine("statement type:if iftype:if exprsize:-1", " exprent position:head type:if", "  exprent type:function functype:eq", "   exprent type:field name:$fieldname$", "   exprent type:constant consttype:null", " statement type:basicblock", "  exprent position:-1 type:assignment ret:$assignfield$", "   exprent type:var index:$var$", "   exprent type:field name:$fieldname$", " statement type:sequence statsize:2", "  statement type:trycatch", "   statement type:basicblock exprsize:1", "    exprent type:assignment", "     exprent type:var index:$var$", "     exprent type:invocation invclass:java/lang/Class signature:forName(Ljava/lang/String;)Ljava/lang/Class;", "      exprent position:0 type:constant consttype:string constvalue:$classname$", "   statement type:basicblock exprsize:1", "    exprent type:exit exittype:throw", "  statement type:basicblock exprsize:1", "   exprent type:assignment", "    exprent type:field name:$fieldname$ ret:$field$", "    exprent type:var index:$var$");

    public static boolean simplifyStackVarsStatement(Statement stat, Set<Integer> setReorderedIfs, SSAConstructorSparseEx ssa, StructClass cl, boolean firstInvocation) {
        boolean res = false;
        List<Exprent> expressions = stat.getExprents();
        if (expressions == null) {
            boolean changed;
            boolean processClass14 = DecompilerContext.getOption("decompile-java4");
            do {
                changed = false;
                for (Statement st : stat.getStats()) {
                    res |= SimplifyExprentsHelper.simplifyStackVarsStatement(st, setReorderedIfs, ssa, cl, firstInvocation);
                    boolean bl = changed = IfHelper.mergeIfs(st, setReorderedIfs) || SimplifyExprentsHelper.buildIff(st, ssa) || processClass14 && SimplifyExprentsHelper.collapseInlinedClass14(st);
                    if (!changed && (st.getStats().isEmpty() || !SimplifyExprentsHelper.hasQualifiedNewGetClass(st, (Statement)st.getStats().get(0)))) continue;
                    break;
                }
                res |= changed;
            } while (changed);
        } else {
            res = SimplifyExprentsHelper.simplifyStackVarsExprents(expressions, cl, stat, firstInvocation);
        }
        return res;
    }

    private static boolean simplifyStackVarsExprents(List<Exprent> list, StructClass cl, Statement stat, boolean firstInvocation) {
        boolean res = false;
        int index = 0;
        while (index < list.size()) {
            Exprent prev;
            Exprent current = list.get(index);
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(current);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            ret = SimplifyExprentsHelper.isLambda(current, cl);
            if (ret != null) {
                list.set(index, ret);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isMonitorExit(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isTrivialStackAssignment(current)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (index == list.size() - 1) break;
            Exprent next = list.get(index + 1);
            if (index > 0 && SimplifyExprentsHelper.isSwapConstructorInvocation(prev = list.get(index - 1), current, next)) {
                list.remove(index - 1);
                list.remove(index);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isAssignmentReturn(current, next, stat)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isConstructorInvocationRemote(list, index)) {
                list.remove(index);
                res = true;
                continue;
            }
            if (DecompilerContext.getOption("remove-getclass") && SimplifyExprentsHelper.isQualifiedNewGetClass(current, next)) {
                list.remove(index);
                res = true;
                continue;
            }
            int arrCount = SimplifyExprentsHelper.isArrayInitializer(list, index);
            if (arrCount > 0) {
                for (int i = 0; i < arrCount; ++i) {
                    list.remove(index + 1);
                }
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.addArrayInitializer(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            Exprent func = SimplifyExprentsHelper.isPPIorMMI(current);
            if (func != null) {
                list.set(index, func);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isIPPorIMM(current, next) || SimplifyExprentsHelper.isIPPorIMM2(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (SimplifyExprentsHelper.isStackAssignment(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (!firstInvocation && SimplifyExprentsHelper.isStackAssignment2(current, next)) {
                list.remove(index + 1);
                res = true;
                continue;
            }
            if (firstInvocation && SimplifyExprentsHelper.inlinePPIAndMMI(current, next)) {
                list.remove(index);
                res = true;
                continue;
            }
            ++index;
        }
        return res;
    }

    private static boolean addArrayInitializer(Exprent first, Exprent second) {
        NewExprent newExpr;
        AssignmentExprent as;
        if (first instanceof AssignmentExprent && (as = (AssignmentExprent)first).getRight() instanceof NewExprent && as.getLeft() instanceof VarExprent && !(newExpr = (NewExprent)as.getRight()).getLstArrayElements().isEmpty()) {
            VarType arrType;
            ConstExprent defaultVal;
            ConstExprent cinit;
            Exprent init;
            int constValue;
            ArrayExprent arrExpr;
            AssignmentExprent aas;
            VarExprent arrVar = (VarExprent)as.getLeft();
            if (second instanceof AssignmentExprent && (aas = (AssignmentExprent)second).getLeft() instanceof ArrayExprent && (arrExpr = (ArrayExprent)aas.getLeft()).getArray() instanceof VarExprent && arrVar.equals(arrExpr.getArray()) && arrExpr.getIndex() instanceof ConstExprent && (constValue = ((ConstExprent)arrExpr.getIndex()).getIntValue()) < newExpr.getLstArrayElements().size() && (init = newExpr.getLstArrayElements().get(constValue)) instanceof ConstExprent && (cinit = (ConstExprent)init).equals(defaultVal = ExprProcessor.getDefaultArrayValue(arrType = newExpr.getNewType().decreaseArrayDim()))) {
                Exprent tempExpr = aas.getRight();
                if ((tempExpr.getExprentUse() & 2) == 0) {
                    for (int i = constValue + 1; i < newExpr.getLstArrayElements().size(); ++i) {
                        Exprent exprent = newExpr.getLstArrayElements().get(i);
                        if ((exprent.getExprentUse() & 2) != 0) continue;
                        return false;
                    }
                }
                if (!tempExpr.containsExprent(arrVar)) {
                    newExpr.getLstArrayElements().set(constValue, tempExpr);
                    if (tempExpr instanceof NewExprent) {
                        NewExprent tempNewExpr = (NewExprent)tempExpr;
                        int dims = newExpr.getNewType().arrayDim;
                        if (dims > 1 && !tempNewExpr.getLstArrayElements().isEmpty()) {
                            tempNewExpr.setDirectArrayInit(true);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static int isArrayInitializer(List<Exprent> list, int index) {
        AssignmentExprent as;
        Exprent current = list.get(index);
        if (current instanceof AssignmentExprent && (as = (AssignmentExprent)current).getRight() instanceof NewExprent && as.getLeft() instanceof VarExprent) {
            NewExprent newExpr = (NewExprent)as.getRight();
            if (newExpr.getExprType().arrayDim > 0 && newExpr.getLstDims().size() == 1 && newExpr.getLstArrayElements().isEmpty() && newExpr.getLstDims().get(0) instanceof ConstExprent) {
                int constValue;
                ArrayExprent arrExpr;
                AssignmentExprent aas;
                Exprent expr;
                int size = (Integer)((ConstExprent)newExpr.getLstDims().get(0)).getValue();
                if (size == 0) {
                    return 0;
                }
                VarExprent arrVar = (VarExprent)as.getLeft();
                HashMap<Integer, Exprent> mapInit = new HashMap<Integer, Exprent>();
                int lastImpure = -1;
                for (int i = 1; index + i < list.size() && i <= size && (expr = list.get(index + i)) instanceof AssignmentExprent && (aas = (AssignmentExprent)expr).getLeft() instanceof ArrayExprent && (arrExpr = (ArrayExprent)aas.getLeft()).getArray() instanceof VarExprent && arrVar.equals(arrExpr.getArray()) && arrExpr.getIndex() instanceof ConstExprent && (constValue = ((ConstExprent)arrExpr.getIndex()).getIntValue()) < size && !mapInit.containsKey(constValue); ++i) {
                    if ((aas.getRight().getExprentUse() & 2) == 0) {
                        if (constValue < lastImpure) break;
                        lastImpure = constValue;
                    }
                    if (aas.getRight().containsExprent(arrVar)) break;
                    mapInit.put(constValue, aas.getRight());
                }
                double fraction = (double)mapInit.size() / (double)size;
                if (arrVar.isStack() && fraction > 0.0 || size <= 7 && fraction >= 0.3 || size > 7 && fraction >= 0.7) {
                    ArrayList<Exprent> lstRet = new ArrayList<Exprent>();
                    VarType arrayType = newExpr.getNewType().decreaseArrayDim();
                    ConstExprent defaultVal = ExprProcessor.getDefaultArrayValue(arrayType);
                    for (int j = 0; j < size; ++j) {
                        lstRet.add(defaultVal.copy());
                    }
                    int dims = newExpr.getNewType().arrayDim;
                    for (Map.Entry ent : mapInit.entrySet()) {
                        Exprent tempExpr = (Exprent)ent.getValue();
                        lstRet.set((Integer)ent.getKey(), tempExpr);
                        if (!(tempExpr instanceof NewExprent)) continue;
                        NewExprent tempNewExpr = (NewExprent)tempExpr;
                        if (dims <= 1 || tempNewExpr.getLstArrayElements().isEmpty()) continue;
                        tempNewExpr.setDirectArrayInit(true);
                    }
                    newExpr.setLstArrayElements(lstRet);
                    return mapInit.size();
                }
            }
        }
        return 0;
    }

    private static boolean isAssignmentReturn(Exprent first, Exprent second, Statement stat) {
        if (first instanceof AssignmentExprent && second instanceof ExitExprent) {
            Exprent exprent;
            AssignmentExprent assignment = (AssignmentExprent)first;
            ExitExprent exit = (ExitExprent)second;
            if (assignment.getCondType() == null && exit.getExitType() == ExitExprent.Type.RETURN && exit.getValue() != null && (exprent = assignment.getLeft()) instanceof VarExprent) {
                VarExprent exitValue;
                VarExprent assignmentLeft = (VarExprent)exprent;
                exprent = exit.getValue();
                if (exprent instanceof VarExprent && assignmentLeft.equals(exitValue = (VarExprent)exprent) && !assignmentLeft.isStack() && !exitValue.isStack()) {
                    FunctionExprent func;
                    IfStatement ifst;
                    IMatchable iMatchable;
                    if (stat.getTopParent().mt.getBytecodeVersion().hasIfPatternMatching() && (iMatchable = stat.getParent()) instanceof IfStatement && !(ifst = (IfStatement)iMatchable).isPatternMatched() && stat.getExprents().indexOf(first) == 0 && (iMatchable = assignment.getRight()) instanceof FunctionExprent && (func = (FunctionExprent)iMatchable).getFuncType() == FunctionExprent.FunctionType.CAST && ifst.getHeadexprent().getAllExprents(true, false).stream().anyMatch(e -> {
                        FunctionExprent f;
                        return e instanceof FunctionExprent && (f = (FunctionExprent)e).getFuncType() == FunctionExprent.FunctionType.INSTANCEOF;
                    })) {
                        return false;
                    }
                    exit.replaceExprent(exitValue, assignment.getRight());
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isTrivialStackAssignment(Exprent first) {
        AssignmentExprent asf;
        if (first instanceof AssignmentExprent && SimplifyExprentsHelper.isStackVar((asf = (AssignmentExprent)first).getLeft()) && SimplifyExprentsHelper.isStackVar(asf.getRight())) {
            VarExprent left = (VarExprent)asf.getLeft();
            VarExprent right = (VarExprent)asf.getRight();
            return left.getIndex() == right.getIndex();
        }
        return false;
    }

    private static boolean isStackAssignment2(Exprent first, Exprent second) {
        if (first instanceof AssignmentExprent && second instanceof AssignmentExprent) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            if (SimplifyExprentsHelper.isStackVar(asf.getLeft()) && !SimplifyExprentsHelper.isStackVar(ass.getLeft()) && asf.getLeft().equals(ass.getRight())) {
                asf.setRight(new AssignmentExprent(ass.getLeft(), asf.getRight(), ass.bytecode));
                return true;
            }
        }
        return false;
    }

    private static boolean isStackVar(Exprent exprent) {
        return exprent instanceof VarExprent && ((VarExprent)exprent).isStack();
    }

    private static boolean isStackAssignment(Exprent first, Exprent second) {
        if (first instanceof AssignmentExprent && second instanceof AssignmentExprent) {
            AssignmentExprent asf = (AssignmentExprent)first;
            AssignmentExprent ass = (AssignmentExprent)second;
            while (true) {
                if (asf.getRight().equals(ass.getRight()) && SimplifyExprentsHelper.isStackVar(asf.getLeft()) && !SimplifyExprentsHelper.isStackVar(ass.getLeft()) && !ass.getLeft().containsExprent(asf.getLeft())) {
                    asf.setRight(ass);
                    return true;
                }
                if (!(asf.getRight() instanceof AssignmentExprent)) break;
                asf = (AssignmentExprent)asf.getRight();
            }
        }
        return false;
    }

    private static Exprent isPPIorMMI(Exprent first) {
        FunctionExprent func;
        AssignmentExprent as;
        if (first instanceof AssignmentExprent && (as = (AssignmentExprent)first).getRight() instanceof FunctionExprent && ((func = (FunctionExprent)as.getRight()).getFuncType() == FunctionExprent.FunctionType.ADD || func.getFuncType() == FunctionExprent.FunctionType.SUB)) {
            Exprent left;
            Exprent econd = func.getLstOperands().get(0);
            Exprent econst = func.getLstOperands().get(1);
            if (!(econst instanceof ConstExprent) && econd instanceof ConstExprent && func.getFuncType() == FunctionExprent.FunctionType.ADD) {
                econd = econst;
                econst = func.getLstOperands().get(0);
            }
            if (econst instanceof ConstExprent && ((ConstExprent)econst).hasValueOne() && !((left = as.getLeft()) instanceof VarExprent) && left.equals(econd)) {
                FunctionExprent.FunctionType type = func.getFuncType() == FunctionExprent.FunctionType.ADD ? FunctionExprent.FunctionType.PPI : FunctionExprent.FunctionType.MMI;
                FunctionExprent ret = new FunctionExprent(type, econd, func.bytecode);
                ret.setImplicitType(econd.getExprType());
                return ret;
            }
        }
        return null;
    }

    private static boolean isIPPorIMM(Exprent first, Exprent second) {
        if (first instanceof AssignmentExprent && second instanceof FunctionExprent) {
            AssignmentExprent as = (AssignmentExprent)first;
            FunctionExprent in = (FunctionExprent)second;
            if ((in.getFuncType() == FunctionExprent.FunctionType.MMI || in.getFuncType() == FunctionExprent.FunctionType.PPI) && in.getLstOperands().get(0).equals(as.getRight())) {
                if (in.getFuncType() == FunctionExprent.FunctionType.MMI) {
                    in.setFuncType(FunctionExprent.FunctionType.IMM);
                } else {
                    in.setFuncType(FunctionExprent.FunctionType.IPP);
                }
                as.setRight(in);
                return true;
            }
        }
        return false;
    }

    private static boolean isIPPorIMM2(Exprent first, Exprent second) {
        if (!(first instanceof AssignmentExprent) || !(second instanceof AssignmentExprent)) {
            return false;
        }
        AssignmentExprent af = (AssignmentExprent)first;
        AssignmentExprent as = (AssignmentExprent)second;
        if (!(as.getRight() instanceof FunctionExprent)) {
            return false;
        }
        FunctionExprent func = (FunctionExprent)as.getRight();
        if (func.getFuncType() != FunctionExprent.FunctionType.ADD && func.getFuncType() != FunctionExprent.FunctionType.SUB) {
            return false;
        }
        Exprent econd = func.getLstOperands().get(0);
        Exprent econst = func.getLstOperands().get(1);
        if (!(econst instanceof ConstExprent) && econd instanceof ConstExprent && func.getFuncType() == FunctionExprent.FunctionType.ADD) {
            econd = econst;
            econst = func.getLstOperands().get(0);
        }
        if (econst instanceof ConstExprent && ((ConstExprent)econst).hasValueOne() && af.getLeft().equals(econd) && af.getRight().equals(as.getLeft()) && (af.getLeft().getExprentUse() & 1) != 0) {
            FunctionExprent.FunctionType type = func.getFuncType() == FunctionExprent.FunctionType.ADD ? FunctionExprent.FunctionType.IPP : FunctionExprent.FunctionType.IMM;
            FunctionExprent ret = new FunctionExprent(type, af.getRight(), func.bytecode);
            ret.setImplicitType(VarType.VARTYPE_INT);
            af.setRight(ret);
            return true;
        }
        return false;
    }

    private static boolean inlinePPIAndMMI(Exprent expr, Exprent next) {
        FunctionExprent func;
        if (expr instanceof FunctionExprent && ((func = (FunctionExprent)expr).getFuncType() == FunctionExprent.FunctionType.PPI || func.getFuncType() == FunctionExprent.FunctionType.MMI) && func.getLstOperands().get(0) instanceof VarExprent) {
            VarExprent var = (VarExprent)func.getLstOperands().get(0);
            if (next instanceof FunctionExprent && SimplifyExprentsHelper.isPPMM((FunctionExprent)next)) {
                return false;
            }
            Pair<Exprent, VarExprent> usage = SimplifyExprentsHelper.findFirstValidUsage(var, next);
            if (usage != null) {
                ((Exprent)usage.a).replaceExprent((Exprent)usage.b, func);
                return true;
            }
        }
        return false;
    }

    private static Pair<Exprent, VarExprent> findFirstValidUsage(VarExprent match, Exprent next) {
        ArrayList<Exprent> stack = new ArrayList<Exprent>();
        ArrayList<Exprent> parent = new ArrayList<Exprent>();
        stack.add(next);
        parent.add(null);
        while (!stack.isEmpty()) {
            VarExprent ve;
            Exprent expr = (Exprent)stack.remove(stack.size() - 1);
            Exprent parentExpr = (Exprent)parent.remove(parent.size() - 1);
            List<Exprent> exprents = expr.getAllExprents();
            if (parentExpr != null && expr instanceof VarExprent && (ve = (VarExprent)expr).getIndex() == match.getIndex() && ve.getVersion() == match.getVersion()) {
                return Pair.of(parentExpr, ve);
            }
            if (expr instanceof FunctionExprent) {
                FunctionExprent func = (FunctionExprent)expr;
                if (SimplifyExprentsHelper.isPPMM(func)) {
                    return null;
                }
                if (func.getFuncType() == FunctionExprent.FunctionType.BOOLEAN_OR || func.getFuncType() == FunctionExprent.FunctionType.BOOLEAN_AND) {
                    return null;
                }
                if (func.getFuncType() == FunctionExprent.FunctionType.TERNARY) {
                    return null;
                }
                if (func.getFuncType() == FunctionExprent.FunctionType.SUB || func.getFuncType() == FunctionExprent.FunctionType.DIV) {
                    return null;
                }
            }
            for (int i = exprents.size() - 1; i >= 0; --i) {
                VarExprent innerEx;
                AssignmentExprent asExpr;
                Exprent ex = exprents.get(i);
                if (expr instanceof AssignmentExprent && ex == (asExpr = (AssignmentExprent)expr).getLeft() && ex instanceof VarExprent && (innerEx = (VarExprent)ex).getIndex() == match.getIndex()) continue;
                stack.add(ex);
                parent.add(expr);
            }
        }
        return null;
    }

    private static boolean isPPMM(FunctionExprent func) {
        return func.getFuncType() == FunctionExprent.FunctionType.PPI || func.getFuncType() == FunctionExprent.FunctionType.MMI || func.getFuncType() == FunctionExprent.FunctionType.IPP || func.getFuncType() == FunctionExprent.FunctionType.IMM;
    }

    private static boolean isMonitorExit(Exprent first) {
        if (first instanceof MonitorExprent) {
            MonitorExprent expr = (MonitorExprent)first;
            return expr.getMonType() == MonitorExprent.Type.EXIT && expr.getValue() instanceof VarExprent && !((VarExprent)expr.getValue()).isStack() && expr.isRemovable();
        }
        return false;
    }

    private static boolean hasQualifiedNewGetClass(Statement parent, Statement child) {
        if (child instanceof BasicBlockStatement && child.getExprents() != null && !child.getExprents().isEmpty()) {
            Exprent firstExpr = child.getExprents().get(child.getExprents().size() - 1);
            if (parent instanceof IfStatement && SimplifyExprentsHelper.isQualifiedNewGetClass(firstExpr, ((IfStatement)parent).getHeadexprent().getCondition())) {
                child.getExprents().remove(firstExpr);
                return true;
            }
        }
        return false;
    }

    private static boolean isQualifiedNewGetClass(Exprent first, Exprent second) {
        InvocationExprent invocation;
        if (first instanceof InvocationExprent && (!(invocation = (InvocationExprent)first).isStatic() && invocation.getName().equals("getClass") && invocation.getStringDescriptor().equals("()Ljava/lang/Class;") || invocation.isStatic() && invocation.getClassname().equals("java/util/Objects") && invocation.getName().equals("requireNonNull") && invocation.getStringDescriptor().equals("(Ljava/lang/Object;)Ljava/lang/Object;"))) {
            if (invocation.isSyntheticNullCheck()) {
                return true;
            }
            ArrayDeque<Exprent> lstExprents = new ArrayDeque<Exprent>();
            lstExprents.add(second);
            Exprent target = invocation.isStatic() ? invocation.getLstParameters().get(0) : invocation.getInstance();
            while (!lstExprents.isEmpty()) {
                NewExprent newExpr;
                Exprent expr = (Exprent)lstExprents.removeFirst();
                lstExprents.addAll(expr.getAllExprents());
                if (!(expr instanceof NewExprent) || (newExpr = (NewExprent)expr).getConstructor() == null || newExpr.getConstructor().getLstParameters().isEmpty() || !newExpr.getConstructor().getLstParameters().get(0).equals(target) && !SimplifyExprentsHelper.isUnambiguouslySameParam(invocation.isStatic(), target, newExpr.getConstructor().getLstParameters())) continue;
                String classname = newExpr.getNewType().value;
                ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(classname);
                if (node == null || node.type == ClassesProcessor.ClassNode.Type.ROOT) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUnambiguouslySameParam(boolean isStatic, Exprent target, List<Exprent> parameters) {
        boolean firstParamOfSameType = parameters.get(0).getExprType().equals(target.getExprType());
        if (!isStatic) {
            return firstParamOfSameType;
        }
        if (!firstParamOfSameType) {
            return false;
        }
        for (int i = 1; i < parameters.size(); ++i) {
            if (!parameters.get(i).getExprType().equals(target.getExprType())) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodArrayAssign(Exprent expr, Exprent next) {
        if (expr instanceof AssignmentExprent && next instanceof AssignmentExprent) {
            Exprent secondBase;
            Exprent firstLeft = ((AssignmentExprent)expr).getLeft();
            Exprent secondLeft = ((AssignmentExprent)next).getLeft();
            if (firstLeft instanceof VarExprent && secondLeft instanceof ArrayExprent && (secondBase = ((ArrayExprent)secondLeft).getArray()) instanceof VarExprent && ((VarExprent)firstLeft).getIndex() == ((VarExprent)secondBase).getIndex() && ((VarExprent)secondBase).isStack()) {
                boolean foundAssign = false;
                Exprent secondRight = ((AssignmentExprent)next).getRight();
                for (Exprent exprent : secondRight.getAllExprents()) {
                    if (!(exprent instanceof ArrayExprent) || !(((ArrayExprent)exprent).getArray() instanceof VarExprent) || ((VarExprent)((ArrayExprent)exprent).getArray()).getIndex() != ((VarExprent)firstLeft).getIndex()) continue;
                    exprent.replaceExprent(((ArrayExprent)exprent).getArray(), ((AssignmentExprent)expr).getRight().copy());
                    foundAssign = true;
                }
                if (foundAssign) {
                    secondLeft.replaceExprent(secondBase, ((AssignmentExprent)expr).getRight());
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConstructorInvocationRemote(List<Exprent> list, int index) {
        AssignmentExprent as;
        Exprent current = list.get(index);
        if (current instanceof AssignmentExprent && (as = (AssignmentExprent)current).getLeft() instanceof VarExprent && as.getRight() instanceof NewExprent) {
            NewExprent newExpr = (NewExprent)as.getRight();
            VarType newType = newExpr.getNewType();
            VarVersionPair leftPair = new VarVersionPair((VarExprent)as.getLeft());
            if (newType.type == CodeType.OBJECT && newType.arrayDim == 0 && newExpr.getConstructor() == null) {
                for (int i = index + 1; i < list.size(); ++i) {
                    InvocationExprent in;
                    Exprent remote = list.get(i);
                    if (remote instanceof InvocationExprent && (in = (InvocationExprent)remote).getFunctype() == InvocationExprent.Type.INIT && in.getInstance() instanceof VarExprent && as.getLeft().equals(in.getInstance())) {
                        newExpr.setConstructor(in);
                        in.setInstance(null);
                        list.set(i, as.copy());
                        return true;
                    }
                    Set<VarVersionPair> setVars = remote.getAllVariables();
                    if (!setVars.contains(leftPair)) continue;
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isSwapConstructorInvocation(Exprent last, Exprent expr, Exprent next) {
        if (last instanceof AssignmentExprent && expr instanceof AssignmentExprent && next instanceof InvocationExprent) {
            AssignmentExprent asLast = (AssignmentExprent)last;
            AssignmentExprent asExpr = (AssignmentExprent)expr;
            InvocationExprent inNext = (InvocationExprent)next;
            if (inNext.getFunctype() != InvocationExprent.Type.INIT) {
                return false;
            }
            if (asLast.getLeft() instanceof VarExprent && asExpr.getRight() instanceof VarExprent && inNext.getInstance() != null && inNext.getInstance() instanceof VarExprent) {
                VarExprent varLast = (VarExprent)asLast.getLeft();
                VarExprent varExpr = (VarExprent)asExpr.getRight();
                VarExprent varNext = (VarExprent)inNext.getInstance();
                if (varLast.getIndex() == varExpr.getIndex() && varExpr.getIndex() == varNext.getIndex() && asLast.getRight() instanceof NewExprent) {
                    inNext.setInstance(null);
                    NewExprent newExpr = (NewExprent)asLast.getRight();
                    newExpr.setConstructor(inNext);
                    asExpr.setRight(newExpr);
                    return true;
                }
            }
        }
        return false;
    }

    private static Exprent isLambda(Exprent exprent, StructClass cl) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isLambda(expr, cl);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent instanceof InvocationExprent && (in = (InvocationExprent)exprent).getInvocationType() == InvocationExprent.InvocationType.DYNAMIC) {
            String lambda_class_name = cl.qualifiedName + in.getInvokeDynamicClassSuffix();
            ClassesProcessor.ClassNode lambda_class = DecompilerContext.getClassProcessor().getMapRootClasses().get(lambda_class_name);
            if (lambda_class != null) {
                NewExprent newExpr = new NewExprent(new VarType(lambda_class_name, true), null, 0, in.bytecode);
                newExpr.setConstructor(in);
                return newExpr;
            }
        }
        return null;
    }

    private static Exprent isSimpleConstructorInvocation(Exprent exprent) {
        InvocationExprent in;
        List<Exprent> lst = exprent.getAllExprents();
        for (Exprent expr : lst) {
            Exprent ret = SimplifyExprentsHelper.isSimpleConstructorInvocation(expr);
            if (ret == null) continue;
            exprent.replaceExprent(expr, ret);
        }
        if (exprent instanceof InvocationExprent && (in = (InvocationExprent)exprent).getFunctype() == InvocationExprent.Type.INIT && in.getInstance() instanceof NewExprent) {
            NewExprent newExpr = (NewExprent)in.getInstance();
            newExpr.setConstructor(in);
            in.setInstance(null);
            return newExpr;
        }
        return null;
    }

    private static boolean buildIff(Statement stat, SSAConstructorSparseEx ssa) {
        if (stat instanceof IfStatement && stat.getExprents() == null) {
            BitSet ifHeadExprBytecode;
            IfStatement statement = (IfStatement)stat;
            IfExprent ifHeadExpr = statement.getHeadexprent();
            BitSet bitSet = ifHeadExprBytecode = ifHeadExpr == null ? null : ifHeadExpr.bytecode;
            if (statement.iftype == 1) {
                Statement ifStatement = statement.getIfstat();
                Statement elseStatement = statement.getElsestat();
                if (ifStatement.getExprents() != null && ifStatement.getExprents().size() == 1 && elseStatement.getExprents() != null && elseStatement.getExprents().size() == 1 && ifStatement.getAllSuccessorEdges().size() == 1 && elseStatement.getAllSuccessorEdges().size() == 1 && ifStatement.getAllSuccessorEdges().get(0).getDestination() == elseStatement.getAllSuccessorEdges().get(0).getDestination()) {
                    Exprent ifExpr = ifStatement.getExprents().get(0);
                    Exprent elseExpr = elseStatement.getExprents().get(0);
                    if (ifExpr instanceof AssignmentExprent && elseExpr instanceof AssignmentExprent) {
                        AssignmentExprent ifAssign = (AssignmentExprent)ifExpr;
                        AssignmentExprent elseAssign = (AssignmentExprent)elseExpr;
                        if (ifAssign.getLeft() instanceof VarExprent && elseAssign.getLeft() instanceof VarExprent) {
                            VarExprent ifVar = (VarExprent)ifAssign.getLeft();
                            VarExprent elseVar = (VarExprent)elseAssign.getLeft();
                            if (ifVar.getIndex() == elseVar.getIndex() && ifVar.isStack()) {
                                boolean found = false;
                                if (ssa == null) {
                                    throw new IllegalStateException("Trying to make ternary but have no SSA-Form! How is this possible?");
                                }
                                for (Map.Entry<VarVersionPair, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
                                    if (ent.getKey().var != ifVar.getIndex() || !ent.getValue().contains(ifVar.getVersion()) || !ent.getValue().contains(elseVar.getVersion())) continue;
                                    found = true;
                                    break;
                                }
                                if (found) {
                                    ArrayList<Exprent> data = new ArrayList<Exprent>(statement.getFirst().getExprents());
                                    List<Exprent> operands = Arrays.asList(statement.getHeadexprent().getCondition(), ifAssign.getRight(), elseAssign.getRight());
                                    data.add(new AssignmentExprent(ifVar, new FunctionExprent(FunctionExprent.FunctionType.TERNARY, operands, ifHeadExprBytecode), ifHeadExprBytecode));
                                    statement.setExprents(data);
                                    if (statement.getAllSuccessorEdges().isEmpty()) {
                                        StatEdge ifEdge = ifStatement.getAllSuccessorEdges().get(0);
                                        StatEdge edge = new StatEdge(ifEdge.getType(), (Statement)statement, ifEdge.getDestination());
                                        statement.addSuccessor(edge);
                                        if (ifEdge.closure != null) {
                                            ifEdge.closure.addLabeledEdge(edge);
                                        }
                                    }
                                    SequenceHelper.destroyAndFlattenStatement(statement);
                                    return true;
                                }
                            }
                        }
                    } else if (ifExpr instanceof ExitExprent && elseExpr instanceof ExitExprent) {
                        ExitExprent ifExit = (ExitExprent)ifExpr;
                        ExitExprent elseExit = (ExitExprent)elseExpr;
                        if (ifExit.getExitType() == elseExit.getExitType() && ifExit.getValue() != null && elseExit.getValue() != null && ifExit.getExitType() == ExitExprent.Type.RETURN) {
                            if (ifExit.getExitType() == ExitExprent.Type.THROW && !ifExit.getValue().getExprType().equals(elseExit.getValue().getExprType())) {
                                return false;
                            }
                            if (SimplifyExprentsHelper.isIff(ifExit.getValue()) || SimplifyExprentsHelper.isIff(elseExit.getValue())) {
                                return false;
                            }
                            ArrayList<Exprent> data = new ArrayList<Exprent>(statement.getFirst().getExprents());
                            data.add(new ExitExprent(ifExit.getExitType(), new FunctionExprent(FunctionExprent.FunctionType.TERNARY, Arrays.asList(statement.getHeadexprent().getCondition(), ifExit.getValue(), elseExit.getValue()), ifHeadExprBytecode), ifExit.getRetType(), ifHeadExprBytecode, ifExit.getMethodDescriptor()));
                            statement.setExprents(data);
                            StatEdge retEdge = ifStatement.getAllSuccessorEdges().get(0);
                            Statement closure = retEdge.closure == statement ? statement.getParent() : retEdge.closure;
                            statement.addSuccessor(new StatEdge(4, statement, retEdge.getDestination(), closure));
                            SequenceHelper.destroyAndFlattenStatement(statement);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean isIff(Exprent exp) {
        return exp instanceof FunctionExprent && ((FunctionExprent)exp).getFuncType() == FunctionExprent.FunctionType.TERNARY;
    }

    private static boolean collapseInlinedClass14(Statement stat) {
        boolean ret = class14Builder.match(stat);
        if (ret) {
            String class_name = (String)class14Builder.getVariableValue("$classname$");
            AssignmentExprent assignment = (AssignmentExprent)class14Builder.getVariableValue("$assignfield$");
            FieldExprent fieldExpr = (FieldExprent)class14Builder.getVariableValue("$field$");
            assignment.replaceExprent(assignment.getRight(), new ConstExprent(VarType.VARTYPE_CLASS, class_name, null));
            ArrayList<Exprent> data = new ArrayList<Exprent>(stat.getFirst().getExprents());
            stat.setExprents(data);
            SequenceHelper.destroyAndFlattenStatement(stat);
            ClassWrapper wrapper = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_WRAPPER);
            if (wrapper != null) {
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fieldExpr.getName(), fieldExpr.getDescriptor().descriptorString));
            }
        }
        return ret;
    }
}

