/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vineflower.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.vineflower.java.decompiler.modules.decompiler.MergeHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DoStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SynchronizedStatement;

public final class LabelHelper {
    public static void cleanUpEdges(RootStatement root) {
        LabelHelper.resetAllEdges(root);
        LabelHelper.removeNonImmediateEdges(root);
        LabelHelper.liftClosures(root);
        LabelHelper.lowContinueLabels(root, new LinkedHashSet<StatEdge>());
        LabelHelper.lowClosures(root);
    }

    public static void identifyLabels(RootStatement root) {
        LabelHelper.setExplicitEdges(root);
        LabelHelper.processStatementLabel(root);
        LabelHelper.setRetEdgesUnlabeled(root);
        LabelHelper.liftSequenceLabel(root);
    }

    private static void liftClosures(Statement stat) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            block0 : switch (edge.getType()) {
                case 8: {
                    if (edge.getDestination() == edge.closure) break;
                    edge.getDestination().addLabeledEdge(edge);
                    break;
                }
                case 4: {
                    Statement dest = edge.getDestination();
                    if (dest instanceof DummyExitStatement) break;
                    Statement parent = dest.getParent();
                    ArrayList<Statement> lst = new ArrayList<Statement>();
                    if (parent instanceof SequenceStatement) {
                        lst.addAll(parent.getStats());
                    } else if (parent instanceof SwitchStatement) {
                        lst.addAll(((SwitchStatement)parent).getCaseStatements());
                    }
                    for (int i = 1; i < lst.size(); ++i) {
                        Statement st;
                        if (lst.get(i) != dest || (st = (Statement)lst.get(i - 1)) instanceof BasicBlockStatement) continue;
                        st.addLabeledEdge(edge);
                        break block0;
                    }
                    break;
                }
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.liftClosures(st);
        }
    }

    private static void removeNonImmediateEdges(Statement stat) {
        for (Statement st : stat.getStats()) {
            LabelHelper.removeNonImmediateEdges(st);
        }
        if (!stat.hasBasicSuccEdge()) {
            for (StatEdge edge : stat.getSuccessorEdges(12)) {
                stat.removeSuccessor(edge);
            }
        }
    }

    public static void lowContinueLabels(Statement stat, HashSet<StatEdge> edges) {
        boolean ok;
        boolean bl = ok = !(stat instanceof DoStatement);
        if (!ok) {
            DoStatement dostat = (DoStatement)stat;
            boolean bl2 = ok = dostat.getLooptype() == DoStatement.Type.INFINITE || dostat.getLooptype() == DoStatement.Type.WHILE || dostat.getLooptype() == DoStatement.Type.FOR && dostat.getIncExprent() == null;
        }
        if (ok) {
            edges.addAll(stat.getPredecessorEdges(8));
        }
        if (ok && stat instanceof DoStatement) {
            for (StatEdge edge : edges) {
                if (!stat.containsStatementStrict(edge.getSource())) continue;
                edge.getDestination().removePredecessor(edge);
                edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, stat);
                stat.addPredecessor(edge);
                stat.addLabeledEdge(edge);
            }
        }
        for (Statement st : stat.getStats()) {
            if (st == stat.getFirst()) {
                LabelHelper.lowContinueLabels(st, edges);
                continue;
            }
            LabelHelper.lowContinueLabels(st, new LinkedHashSet<StatEdge>());
        }
    }

    public static void lowClosures(Statement stat) {
        for (StatEdge edge : new ArrayList<StatEdge>(stat.getLabelEdges())) {
            if (edge.getType() != 4) continue;
            for (Statement st : stat.getStats()) {
                if (!st.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(st, edge.getDestination())) continue;
                st.addLabeledEdge(edge);
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.lowClosures(st);
        }
    }

    private static void liftSequenceLabel(Statement stat) {
        IfStatement ifStat;
        if (stat.getParent() != null && stat.getParent() instanceof IfStatement && (ifStat = (IfStatement)stat.getParent()).getIfstat() == stat && stat instanceof SequenceStatement) {
            HashSet<StatEdge> edges = new HashSet<StatEdge>();
            for (StatEdge edge : stat.getLabelEdges()) {
                if (!MergeHelper.isDirectPath(ifStat, edge.getDestination())) continue;
                edges.add(edge);
            }
            if (edges.size() == stat.getLabelEdges().size()) {
                for (StatEdge edge : new HashSet<StatEdge>(stat.getLabelEdges())) {
                    ifStat.addLabeledEdge(edge);
                }
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.liftSequenceLabel(st);
        }
    }

    private static void resetAllEdges(Statement stat) {
        for (Statement st : stat.getStats()) {
            LabelHelper.resetAllEdges(st);
        }
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            edge.explicit = true;
            edge.labeled = true;
        }
    }

    private static void setRetEdgesUnlabeled(RootStatement root) {
        DummyExitStatement exit = root.getDummyExit();
        for (StatEdge edge : exit.getAllPredecessorEdges()) {
            List<Exprent> lst = edge.getSource().getExprents();
            if (edge.getType() != 32 && (lst == null || lst.isEmpty() || !(lst.get(lst.size() - 1) instanceof ExitExprent))) continue;
            edge.labeled = false;
        }
    }

    private static HashMap<Statement, List<StatEdge>> setExplicitEdges(Statement stat) {
        HashMap<Statement, List<StatEdge>> mapEdges = new HashMap<Statement, List<StatEdge>>();
        if (stat.getExprents() != null) {
            return mapEdges;
        }
        switch (stat.type) {
            case TRY_CATCH: 
            case CATCH_ALL: {
                for (Statement st : stat.getStats()) {
                    HashMap<Statement, List<StatEdge>> mapEdges1 = LabelHelper.setExplicitEdges(st);
                    LabelHelper.processEdgesWithNext(st, mapEdges1, null);
                    if (!(stat instanceof CatchStatement) && st != stat.getFirst() || mapEdges1 == null) continue;
                    for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges1.entrySet()) {
                        if (mapEdges.containsKey(entr.getKey())) {
                            mapEdges.get(entr.getKey()).addAll((Collection<StatEdge>)entr.getValue());
                            continue;
                        }
                        mapEdges.put(entr.getKey(), entr.getValue());
                    }
                }
                break;
            }
            case DO: {
                mapEdges = LabelHelper.setExplicitEdges(stat.getFirst());
                LabelHelper.processEdgesWithNext(stat.getFirst(), mapEdges, stat);
                break;
            }
            case IF: {
                IfStatement ifstat = (IfStatement)stat;
                if (ifstat.getIfstat() == null) {
                    LabelHelper.processEdgesWithNext(ifstat.getFirst(), mapEdges, null);
                    break;
                }
                mapEdges = LabelHelper.setExplicitEdges(ifstat.getIfstat());
                LabelHelper.processEdgesWithNext(ifstat.getIfstat(), mapEdges, null);
                HashMap<Statement, List<StatEdge>> mapEdges1 = null;
                if (ifstat.getElsestat() != null) {
                    mapEdges1 = LabelHelper.setExplicitEdges(ifstat.getElsestat());
                    LabelHelper.processEdgesWithNext(ifstat.getElsestat(), mapEdges1, null);
                }
                if (mapEdges1 == null) break;
                for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges1.entrySet()) {
                    if (mapEdges.containsKey(entr.getKey())) {
                        mapEdges.get(entr.getKey()).addAll((Collection<StatEdge>)entr.getValue());
                        continue;
                    }
                    mapEdges.put(entr.getKey(), entr.getValue());
                }
                break;
            }
            case ROOT: {
                mapEdges = LabelHelper.setExplicitEdges(stat.getFirst());
                LabelHelper.processEdgesWithNext(stat.getFirst(), mapEdges, ((RootStatement)stat).getDummyExit());
                break;
            }
            case SEQUENCE: {
                Statement st;
                int index;
                for (index = 0; index < stat.getStats().size() - 1; ++index) {
                    st = (Statement)stat.getStats().get(index);
                    LabelHelper.processEdgesWithNext(st, LabelHelper.setExplicitEdges(st), (Statement)stat.getStats().get(index + 1));
                }
                st = (Statement)stat.getStats().get(index);
                mapEdges = LabelHelper.setExplicitEdges(st);
                LabelHelper.processEdgesWithNext(st, mapEdges, null);
                break;
            }
            case SWITCH: {
                SwitchStatement swst = (SwitchStatement)stat;
                boolean isPatternSwitch = swst.isPattern();
                int last = swst.getCaseStatements().size() - 1;
                for (int i = 0; i < last; ++i) {
                    Statement stt = swst.getCaseStatements().get(i);
                    Statement stnext = swst.getCaseStatements().get(i + 1);
                    if (stnext.getExprents() != null && stnext.getExprents().isEmpty() && stnext.hasAnySuccessor() && !isPatternSwitch) {
                        stnext = stnext.getAllSuccessorEdges().get(0).getDestination();
                    }
                    LabelHelper.processEdgesWithNext(stt, LabelHelper.setExplicitEdges(stt), stnext);
                }
                if (last < 0) break;
                Statement stlast = swst.getCaseStatements().get(last);
                if (stlast.getExprents() != null && stlast.getExprents().isEmpty() && stlast.hasAnySuccessor()) {
                    StatEdge edge = stlast.getAllSuccessorEdges().get(0);
                    mapEdges.put(edge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(edge)));
                    break;
                }
                mapEdges = LabelHelper.setExplicitEdges(stlast);
                LabelHelper.processEdgesWithNext(stlast, mapEdges, null);
                break;
            }
            case SYNCHRONIZED: {
                SynchronizedStatement synstat = (SynchronizedStatement)stat;
                LabelHelper.processEdgesWithNext(synstat.getFirst(), LabelHelper.setExplicitEdges(stat.getFirst()), synstat.getBody());
                mapEdges = LabelHelper.setExplicitEdges(synstat.getBody());
                LabelHelper.processEdgesWithNext(synstat.getBody(), mapEdges, null);
            }
        }
        return mapEdges;
    }

    /*
     * WARNING - void declaration
     */
    private static void processEdgesWithNext(Statement stat, HashMap<Statement, List<StatEdge>> mapEdges, Statement next) {
        StatEdge statedge = null;
        if (stat.hasAnySuccessor()) {
            statedge = stat.getFirstSuccessor();
            if (statedge.getDestination() == next) {
                statedge.explicit = false;
                statedge = null;
            } else {
                next = statedge.getDestination();
            }
        }
        if (stat instanceof DoStatement && ((DoStatement)stat).getLooptype() == DoStatement.Type.INFINITE) {
            next = null;
        }
        if (stat instanceof SwitchStatement && ((SwitchStatement)stat).isPhantom()) {
            for (StatEdge edge : stat.getLabelEdges()) {
                edge.explicit = false;
                edge.labeled = false;
            }
        }
        if (next == null) {
            List<StatEdge> lstEdges;
            if (mapEdges.size() == 1 && (lstEdges = mapEdges.values().iterator().next()).size() > 1 && !(mapEdges.keySet().iterator().next() instanceof DummyExitStatement)) {
                StatEdge edge_example = lstEdges.get(0);
                Statement closure = stat.getParent();
                if (!closure.containsStatementStrict(edge_example.closure)) {
                    closure = edge_example.closure;
                }
                StatEdge statEdge = new StatEdge(edge_example.getType(), stat, edge_example.getDestination(), closure);
                stat.addSuccessor(statEdge);
                for (StatEdge edge : lstEdges) {
                    edge.explicit = false;
                }
                mapEdges.put(statEdge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(statEdge)));
            }
        } else {
            boolean implfound = false;
            for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges.entrySet()) {
                if (entr.getKey() != next) continue;
                for (StatEdge edge : entr.getValue()) {
                    if (stat instanceof DoStatement && edge.closure == stat || edge.closure instanceof DoStatement && stat instanceof IfStatement && edge.getDestination() instanceof DummyExitStatement) continue;
                    edge.explicit = false;
                }
                implfound = true;
                break;
            }
            if (!stat.hasAnySuccessor() && !implfound) {
                List lstEdges = null;
                for (Map.Entry entry : mapEdges.entrySet()) {
                    if (entry.getKey() instanceof DummyExitStatement || lstEdges != null && ((List)entry.getValue()).size() <= lstEdges.size()) continue;
                    lstEdges = (List)entry.getValue();
                }
                if (lstEdges != null && lstEdges.size() > 1) {
                    void var7_15;
                    StatEdge edge_example = (StatEdge)lstEdges.get(0);
                    Statement statement = stat.getParent();
                    if (!statement.containsStatementStrict(edge_example.closure)) {
                        Statement statement2 = edge_example.closure;
                    }
                    StatEdge newedge = new StatEdge(edge_example.getType(), stat, edge_example.getDestination(), (Statement)var7_15);
                    stat.addSuccessor(newedge);
                    for (StatEdge edge : lstEdges) {
                        edge.explicit = false;
                    }
                }
            }
            mapEdges.clear();
        }
        if (statedge != null) {
            mapEdges.put(statedge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(statedge)));
        }
    }

    public static boolean hideDefaultSwitchEdges(Statement stat) {
        SwitchStatement swst;
        int last;
        boolean res = false;
        if (stat instanceof SwitchStatement && (last = (swst = (SwitchStatement)stat).getCaseStatements().size() - 1) >= 0) {
            List<StatEdge> edges;
            Statement stlast = swst.getCaseStatements().get(last);
            boolean needsExhaustive = swst.getCaseValues().stream().flatMap(Collection::stream).filter(exp -> exp instanceof FunctionExprent).map(exp -> (FunctionExprent)exp).filter(exp -> exp.getFuncType() == FunctionExprent.FunctionType.INSTANCEOF).findAny().isPresent();
            if (stlast.getExprents() != null && stlast.getExprents().isEmpty() && !needsExhaustive && ((edges = stlast.getAllSuccessorEdges()).isEmpty() || !edges.get((int)0).explicit)) {
                List<StatEdge> lstEdges = swst.getCaseEdges().get(last);
                lstEdges.remove(swst.getDefaultEdge());
                if (lstEdges.isEmpty()) {
                    swst.getCaseStatements().remove(last);
                    swst.getCaseEdges().remove(last);
                }
                res = true;
            }
        }
        for (Statement st : stat.getStats()) {
            res |= LabelHelper.hideDefaultSwitchEdges(st);
        }
        return res;
    }

    private static LabelSets processStatementLabel(Statement stat) {
        LabelSets sets = new LabelSets();
        if (stat.getExprents() == null) {
            boolean shieldType;
            for (Statement st : stat.getStats()) {
                LabelSets nested = LabelHelper.processStatementLabel(st);
                sets.breaks.addAll(nested.breaks);
                sets.continues.addAll(nested.continues);
            }
            boolean bl = shieldType = stat instanceof DoStatement || stat instanceof SwitchStatement;
            if (shieldType) {
                for (StatEdge edge : stat.getLabelEdges()) {
                    if (!edge.explicit || (edge.getType() != 4 || !sets.breaks.contains(edge.getSource())) && (edge.getType() != 8 || !sets.continues.contains(edge.getSource()))) continue;
                    edge.labeled = false;
                }
            }
            switch (stat.type) {
                case DO: {
                    sets.continues.clear();
                }
                case SWITCH: {
                    sets.breaks.clear();
                }
            }
        }
        sets.breaks.add(stat);
        sets.continues.add(stat);
        return sets;
    }

    public static boolean replaceContinueWithBreak(Statement stat) {
        boolean res = false;
        if (stat instanceof DoStatement) {
            boolean changed;
            HashSet<StatEdge> seenEdges = new HashSet<StatEdge>();
            do {
                changed = false;
                List<StatEdge> continues = stat.getPredecessorEdges(8);
                for (StatEdge edge : continues) {
                    Statement enclosing;
                    if (seenEdges.contains(edge) || !edge.explicit) continue;
                    Statement minclosure = LabelHelper.getMinContinueClosure(edge);
                    if (minclosure != edge.closure && !InlineSingleBlockHelper.isBreakEdgeLabeled(edge.getSource(), minclosure)) {
                        edge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, edge, 4);
                        edge.labeled = false;
                        minclosure.addLabeledEdge(edge);
                        seenEdges.add(edge);
                        res = true;
                        changed = true;
                    }
                    if (!((enclosing = LabelHelper.findMaxJump(LabelHelper.getEnclosingShieldType(edge.getSource()))) instanceof DoStatement) || enclosing.getSuccessorEdges(4).isEmpty() || LabelHelper.getEnclosingShieldType(enclosing.getParent()) != minclosure) continue;
                    edge.getSource().changeEdgeType(Statement.EdgeDirection.FORWARD, edge, 4);
                    edge.labeled = false;
                    edge.phantomContinue = true;
                    enclosing.addLabeledEdge(edge);
                    seenEdges.add(edge);
                    res = true;
                    changed = true;
                }
            } while (changed);
        }
        for (Statement st : stat.getStats()) {
            res |= LabelHelper.replaceContinueWithBreak(st);
        }
        return res;
    }

    private static Statement findMaxJump(Statement enclosing) {
        Statement last = enclosing;
        while (enclosing instanceof DoStatement && !enclosing.getSuccessorEdges(4).isEmpty()) {
            last = enclosing;
            enclosing = LabelHelper.getEnclosingShieldType(enclosing.getParent());
        }
        return last;
    }

    private static Statement getEnclosingShieldType(Statement stat) {
        Statement parent;
        Statement res = stat;
        while (!(res instanceof SwitchStatement) && !(res instanceof DoStatement) && (parent = res.getParent()) != null) {
            res = parent;
        }
        return res;
    }

    private static Statement getMinContinueClosure(StatEdge edge) {
        boolean found;
        Statement closure = edge.closure;
        block0: do {
            found = false;
            for (Statement st : closure.getStats()) {
                if (!st.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(st, edge.getDestination())) continue;
                closure = st;
                found = true;
                continue block0;
            }
        } while (found);
        return closure;
    }

    private static class LabelSets {
        private final Set<Statement> breaks = new HashSet<Statement>();
        private final Set<Statement> continues = new HashSet<Statement>();

        private LabelSets() {
        }
    }
}

