/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.vineflower.java.decompiler.modules.decompiler.MergeHelper;
import org.vineflower.java.decompiler.modules.decompiler.SequenceHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DoStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SynchronizedStatement;

public final class InlineSingleBlockHelper {
    public static boolean inlineSingleBlocks(RootStatement root) {
        boolean res = false;
        boolean progress = true;
        while (progress) {
            progress = InlineSingleBlockHelper.inlineSingleBlocksRec(root);
            res |= progress;
        }
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static boolean inlineSingleBlocksRec(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= InlineSingleBlockHelper.inlineSingleBlocksRec(st);
        }
        if (stat instanceof SequenceStatement) {
            SequenceStatement seq = (SequenceStatement)stat;
            for (int i = 1; i < seq.getStats().size(); ++i) {
                if (!InlineSingleBlockHelper.isInlineable(seq, i)) continue;
                InlineSingleBlockHelper.inlineBlock(seq, i);
                return true;
            }
        }
        return res;
    }

    private static void inlineBlock(SequenceStatement seq, int index) {
        Statement first = (Statement)seq.getStats().get(index);
        Statement pre = (Statement)seq.getStats().get(index - 1);
        pre.removeSuccessor(pre.getFirstSuccessor());
        StatEdge edge = first.getPredecessorEdges(4).get(0);
        Statement source = edge.getSource();
        Statement parent = source.getParent();
        source.removeSuccessor(edge);
        ArrayList<Statement> lst = new ArrayList<Statement>();
        for (int i = seq.getStats().size() - 1; i >= index; --i) {
            lst.add(0, seq.getStats().remove(i));
        }
        if (parent instanceof IfStatement && ((IfStatement)parent).iftype == 0 && source == parent.getFirst()) {
            IfStatement ifparent = (IfStatement)parent;
            SequenceStatement block = new SequenceStatement(lst);
            block.setAllParent();
            StatEdge newedge = new StatEdge(1, source, block);
            source.addSuccessor(newedge);
            ifparent.setIfEdge(newedge);
            ifparent.setIfstat(block);
            ifparent.getStats().addWithKey(block, block.id);
            block.setParent(ifparent);
        } else {
            lst.add(0, source);
            SequenceStatement block = new SequenceStatement(lst);
            block.setAllParent();
            parent.replaceStatement(source, block);
            for (StatEdge prededge : block.getPredecessorEdges(8)) {
                block.removePredecessor(prededge);
                prededge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, prededge, source);
                source.addPredecessor(prededge);
                source.addLabeledEdge(prededge);
            }
            if (parent instanceof SwitchStatement) {
                ((SwitchStatement)parent).sortEdgesAndNodes();
            }
            source.addSuccessor(new StatEdge(1, source, first));
            Statement last = (Statement)block.getStats().get(block.getStats().size() - 1);
            if (!last.hasAnySuccessor()) {
                Iterator<StatEdge> iterator = last.getLabelEdges().iterator();
                while (iterator.hasNext()) {
                    StatEdge labelEdge = iterator.next();
                    if (labelEdge.getType() != 4 || !MergeHelper.isDirectPath(last, labelEdge.getDestination())) continue;
                    Statement closure = parent;
                    while (!MergeHelper.isDirectPath(closure, labelEdge.getDestination())) {
                        if ((closure = closure.getParent()) != null) continue;
                        throw new IllegalStateException("Where have we been inlined to?");
                    }
                    labelEdge.closure = closure;
                    iterator.remove();
                }
            }
        }
    }

    private static boolean isInlineable(SequenceStatement seq, int index) {
        StatEdge edge;
        Statement first = (Statement)seq.getStats().get(index);
        Statement pre = (Statement)seq.getStats().get(index - 1);
        if (pre.hasBasicSuccEdge()) {
            return false;
        }
        List<StatEdge> lst = first.getPredecessorEdges(4);
        if (lst.size() == 1 && InlineSingleBlockHelper.sameCatchRanges(edge = lst.get(0))) {
            boolean noPreSuccessors;
            SwitchStatement swst;
            if (!edge.canInline) {
                return false;
            }
            if (!edge.explicit) {
                for (int i = index; i < seq.getStats().size(); ++i) {
                    if (InlineSingleBlockHelper.noExitLabels((Statement)seq.getStats().get(i), seq)) continue;
                    return false;
                }
            }
            if (edge.getSource().getParent() instanceof SwitchStatement && (swst = (SwitchStatement)edge.getSource().getParent()).getCaseStatements().isEmpty()) {
                return false;
            }
            boolean bl = noPreSuccessors = !pre.hasAnySuccessor();
            return !noPreSuccessors;
        }
        return false;
    }

    private static boolean sameCatchRanges(StatEdge edge) {
        Statement parent;
        Statement from = edge.getSource();
        Statement to = edge.getDestination();
        while (!(parent = from.getParent()).containsStatementStrict(to)) {
            if (parent instanceof CatchStatement || parent instanceof CatchAllStatement ? parent.getFirst() == from : parent instanceof SynchronizedStatement && parent.getStats().get(1) == from) {
                return false;
            }
            from = parent;
        }
        return true;
    }

    private static boolean noExitLabels(Statement block, Statement sequence) {
        for (StatEdge edge : block.getAllSuccessorEdges()) {
            if (edge.getType() == 1 || edge.getDestination() instanceof DummyExitStatement || sequence.containsStatementStrict(edge.getDestination())) continue;
            return false;
        }
        for (Statement st : block.getStats()) {
            if (InlineSingleBlockHelper.noExitLabels(st, sequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBreakEdgeLabeled(Statement source, Statement closure) {
        if (closure instanceof DoStatement || closure instanceof SwitchStatement) {
            Statement parent = source.getParent();
            return parent != closure && (parent instanceof DoStatement || parent instanceof SwitchStatement || InlineSingleBlockHelper.isBreakEdgeLabeled(parent, closure));
        }
        return true;
    }
}

