/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.modules.decompiler.IfNode;
import org.vineflower.java.decompiler.modules.decompiler.MergeHelper;
import org.vineflower.java.decompiler.modules.decompiler.SequenceHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.IfExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;

public final class IfHelper {
    public static boolean mergeAllIfs(RootStatement root) {
        boolean res = IfHelper.mergeAllIfsRec(root, new HashSet());
        if (res) {
            SequenceHelper.condenseSequences(root);
        }
        return res;
    }

    private static boolean mergeAllIfsRec(Statement stat, Set<? super Integer> setReorderedIfs) {
        boolean res;
        block2: {
            boolean changed;
            res = false;
            if (stat.getExprents() != null) break block2;
            do {
                changed = false;
                for (Statement st : stat.getStats()) {
                    res |= IfHelper.mergeAllIfsRec(st, setReorderedIfs);
                    if (!IfHelper.mergeIfs(st, setReorderedIfs)) continue;
                    changed = true;
                    break;
                }
                res |= changed;
            } while (changed);
        }
        return res;
    }

    public static boolean mergeIfs(Statement statement, Set<? super Integer> setReorderedIfs) {
        if (!(statement instanceof IfStatement) && !(statement instanceof SequenceStatement)) {
            return false;
        }
        boolean res = false;
        block0: while (true) {
            ArrayList<Statement> lst = new ArrayList<Statement>();
            if (statement instanceof IfStatement) {
                lst.add(statement);
            } else {
                lst.addAll(statement.getStats());
            }
            boolean stsingle = lst.size() == 1;
            for (Statement stat : lst) {
                if (!(stat instanceof IfStatement)) continue;
                IfNode rtnode = IfNode.build((IfStatement)stat, stsingle);
                if (IfHelper.collapseIfIf(rtnode)) {
                    res = true;
                    ValidationHelper.validateStatement(stat.getTopParent());
                    continue block0;
                }
                if (!setReorderedIfs.contains(stat.id)) {
                    if (IfHelper.collapseIfElse(rtnode)) {
                        res = true;
                        ValidationHelper.validateStatement(stat.getTopParent());
                        continue block0;
                    }
                    if (IfHelper.collapseElse(rtnode)) {
                        res = true;
                        ValidationHelper.validateStatement(stat.getTopParent());
                        continue block0;
                    }
                    if (DecompilerContext.getOption("ternary-in-if") && IfHelper.collapseTernary(rtnode)) {
                        res = true;
                        ValidationHelper.validateStatement(stat.getTopParent());
                        continue block0;
                    }
                    if (IfHelper.ifElseChainDenesting(rtnode)) {
                        res = true;
                        ValidationHelper.validateStatement(stat.getTopParent());
                        continue block0;
                    }
                }
                if (!IfHelper.reorderIf((IfStatement)stat)) continue;
                res = true;
                ValidationHelper.validateStatement(stat.getTopParent());
                setReorderedIfs.add((Integer)stat.id);
                continue block0;
            }
            break;
        }
        return res;
    }

    private static boolean collapseIfIf(IfNode rtnode) {
        if (rtnode.innerType == IfNode.EdgeType.DIRECT) {
            IfNode ifbranch = rtnode.innerNode;
            if (ifbranch.innerNode != null && rtnode.successorNode.value == ifbranch.successorNode.value) {
                IfStatement ifparent = (IfStatement)rtnode.value;
                IfStatement ifchild = (IfStatement)ifbranch.value;
                Statement ifinner = ifbranch.innerNode.value;
                if (ifchild.getFirst().getExprents().isEmpty() && !ifchild.hasPPMM()) {
                    ifparent.getIfEdge().remove();
                    ifchild.getFirstSuccessor().remove();
                    ifparent.getStats().removeWithKey(ifchild.id);
                    if (ifbranch.innerType == IfNode.EdgeType.INDIRECT) {
                        ifparent.setIfstat(null);
                        ifedge = ifchild.getIfEdge();
                        ifedge.changeSource(ifparent.getFirst());
                        if (ifedge.closure == ifchild) {
                            ifedge.closure = null;
                        }
                        ifparent.setIfEdge(ifedge);
                    } else {
                        ifchild.getIfEdge().remove();
                        ifedge = new StatEdge(1, ifparent.getFirst(), ifinner);
                        ifparent.getFirst().addSuccessor(ifedge);
                        ifparent.setIfEdge(ifedge);
                        ifparent.setIfstat(ifinner);
                        ifparent.getStats().addWithKey(ifinner, ifinner.id);
                        ifinner.setParent(ifparent);
                        if (ifinner.hasAnySuccessor()) {
                            StatEdge edge = ifinner.getFirstSuccessor();
                            if (edge.closure == ifchild) {
                                edge.closure = ifparent;
                            }
                        }
                    }
                    IfExprent statexpr = ifparent.getHeadexprent();
                    ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
                    lstOperands.add(statexpr.getCondition());
                    lstOperands.add(ifchild.getHeadexprent().getCondition());
                    statexpr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_AND, lstOperands, null));
                    statexpr.addBytecodeOffsets(ifchild.getHeadexprent().bytecode);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean collapseIfElse(IfNode rtnode) {
        if (rtnode.innerType == IfNode.EdgeType.DIRECT) {
            IfNode ifbranch = rtnode.innerNode;
            if (ifbranch.innerNode != null && rtnode.successorNode.value == ifbranch.innerNode.value) {
                IfStatement ifparent = (IfStatement)rtnode.value;
                IfStatement ifchild = (IfStatement)ifbranch.value;
                if (ifchild.getFirst().getExprents().isEmpty()) {
                    ifparent.getIfEdge().remove();
                    ifchild.getIfEdge().remove();
                    ifparent.getStats().removeWithKey(ifchild.id);
                    ifparent.setIfstat(null);
                    StatEdge ifedge = ifchild.getFirstSuccessor();
                    ifedge.changeSource(ifparent.getFirst());
                    ifparent.setIfEdge(ifedge);
                    IfExprent statexpr = ifparent.getHeadexprent();
                    ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
                    lstOperands.add(statexpr.getCondition());
                    lstOperands.add(new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, ifchild.getHeadexprent().getCondition(), null));
                    statexpr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOLEAN_AND, lstOperands, null));
                    statexpr.addBytecodeOffsets(ifchild.getHeadexprent().bytecode);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean collapseElse(IfNode rtnode) {
        if (rtnode.successorType == IfNode.EdgeType.DIRECT) {
            IfNode elsebranch = rtnode.successorNode;
            if (elsebranch.innerNode != null) {
                int path;
                int n = elsebranch.successorNode.value == rtnode.innerNode.value ? 2 : (path = elsebranch.innerNode.value == rtnode.innerNode.value ? 1 : 0);
                if (path > 0) {
                    IfStatement firstif = (IfStatement)rtnode.value;
                    IfStatement secondif = (IfStatement)elsebranch.value;
                    Statement parent = firstif.getParent();
                    if (secondif.getFirst().getExprents().isEmpty()) {
                        firstif.getIfEdge().remove();
                        firstif.removeAllSuccessors(secondif);
                        for (StatEdge edge : firstif.getAllPredecessorEdges()) {
                            if (firstif.containsStatementStrict(edge.getSource())) continue;
                            edge.changeDestination(secondif);
                        }
                        parent.getStats().removeWithKey(firstif.id);
                        if (parent.getFirst() == firstif) {
                            parent.setFirst(secondif);
                        }
                        IfExprent statexpr = secondif.getHeadexprent();
                        ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
                        lstOperands.add(firstif.getHeadexprent().getCondition());
                        if (path == 2) {
                            lstOperands.set(0, new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, (Exprent)lstOperands.get(0), null));
                        }
                        lstOperands.add(statexpr.getCondition());
                        statexpr.setCondition(new FunctionExprent(path == 1 ? FunctionExprent.FunctionType.BOOLEAN_OR : FunctionExprent.FunctionType.BOOLEAN_AND, lstOperands, null));
                        if (secondif.getFirst().getExprents().isEmpty() && !firstif.getFirst().getExprents().isEmpty()) {
                            secondif.replaceStatement(secondif.getFirst(), firstif.getFirst());
                        }
                        return true;
                    }
                }
            } else if (elsebranch.successorNode != null && elsebranch.successorNode.value == rtnode.innerNode.value) {
                IfStatement firstif = (IfStatement)rtnode.value;
                Statement second = elsebranch.value;
                firstif.removeAllSuccessors(second);
                for (StatEdge edge : second.getAllSuccessorEdges()) {
                    edge.changeSource(firstif);
                }
                StatEdge ifedge = firstif.getIfEdge();
                ifedge.remove();
                second.addSuccessor(new StatEdge(ifedge.getType(), second, ifedge.getDestination(), ifedge.closure));
                StatEdge newifedge = new StatEdge(1, firstif.getFirst(), second);
                firstif.getFirst().addSuccessor(newifedge);
                firstif.setIfEdge(newifedge);
                firstif.setIfstat(second);
                firstif.getStats().addWithKey(second, second.id);
                second.setParent(firstif);
                firstif.getParent().getStats().removeWithKey(second.id);
                IfExprent statexpr = firstif.getHeadexprent();
                statexpr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, statexpr.getCondition(), null));
                return true;
            }
        }
        return false;
    }

    private static boolean collapseTernary(IfNode rtnode) {
        if (rtnode.innerType == IfNode.EdgeType.DIRECT && rtnode.successorType == IfNode.EdgeType.ELSE) {
            IfNode ifBranch = rtnode.innerNode;
            IfNode elseBranch = rtnode.successorNode;
            if (ifBranch.innerType == IfNode.EdgeType.INDIRECT && ifBranch.successorType == IfNode.EdgeType.INDIRECT && elseBranch.innerType == IfNode.EdgeType.INDIRECT && elseBranch.successorType == IfNode.EdgeType.INDIRECT && ifBranch.value.getFirst().getExprents().isEmpty() && elseBranch.value.getFirst().getExprents().isEmpty()) {
                boolean inverted;
                if (ifBranch.innerNode.value == elseBranch.innerNode.value && ifBranch.successorNode.value == elseBranch.successorNode.value) {
                    inverted = false;
                } else if (ifBranch.innerNode.value == elseBranch.successorNode.value && ifBranch.successorNode.value == elseBranch.innerNode.value) {
                    inverted = true;
                } else {
                    return false;
                }
                IfStatement mainIf = (IfStatement)rtnode.value;
                IfStatement firstIf = (IfStatement)ifBranch.value;
                IfStatement secondIf = (IfStatement)elseBranch.value;
                mainIf.getStats().removeWithKey(firstIf.id);
                mainIf.getIfEdge().remove();
                mainIf.setIfstat(null);
                mainIf.getStats().removeWithKey(secondIf.id);
                mainIf.getElseEdge().remove();
                mainIf.setElsestat(null);
                firstIf.getIfEdge().remove();
                firstIf.getFirstSuccessor().remove();
                mainIf.setIfEdge(secondIf.getIfEdge());
                mainIf.getIfEdge().changeSource(mainIf.getFirst());
                if (mainIf.hasAnySuccessor()) {
                    mainIf.getFirstSuccessor().remove();
                }
                secondIf.getFirstSuccessor().changeSource(mainIf);
                if (mainIf.getFirstSuccessor().closure == mainIf) {
                    if (mainIf.getFirstSuccessor().getSource() != mainIf) {
                        mainIf.getFirstSuccessor().removeClosure();
                    }
                    mainIf.getFirstSuccessor().changeType(1);
                }
                mainIf.iftype = 0;
                mainIf.setElseEdge(null);
                IfExprent statexpr = mainIf.getHeadexprent();
                ArrayList<Exprent> lstOperands = new ArrayList<Exprent>();
                lstOperands.add(mainIf.getHeadexprent().getCondition());
                lstOperands.add(firstIf.getHeadexprent().getCondition());
                if (inverted) {
                    lstOperands.set(1, new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, (Exprent)lstOperands.get(1), null));
                }
                lstOperands.add(secondIf.getHeadexprent().getCondition());
                statexpr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.TERNARY, lstOperands, null));
                return true;
            }
        }
        return false;
    }

    private static boolean ifElseChainDenesting(IfNode rtnode) {
        IfStatement outerIf;
        if (rtnode.innerType == IfNode.EdgeType.DIRECT && rtnode.successorType != IfNode.EdgeType.ELSE && (outerIf = (IfStatement)rtnode.value).getParent() instanceof SequenceStatement) {
            SequenceStatement parent = (SequenceStatement)outerIf.getParent();
            Statement nestedStat = rtnode.innerNode.value;
            boolean ifdirect = IfHelper.hasDirectEndEdge(nestedStat, parent);
            boolean elsedirect = IfHelper.hasDirectEndEdge(parent.getStats().getLast(), parent);
            if (ifdirect && elsedirect) {
                IfStatement nestedIf;
                IfStatement ifStatement = nestedStat instanceof IfStatement ? (IfStatement)nestedStat : (nestedIf = nestedStat instanceof SequenceStatement && nestedStat.getFirst() instanceof IfStatement ? (IfStatement)nestedStat.getFirst() : null);
                if (nestedIf != null && nestedIf.getFirst().getExprents().isEmpty() && nestedIf.getIfstat() != null && IfHelper.hasDirectEndEdge(nestedIf.getIfstat(), parent)) {
                    IfStatement nextIfStat;
                    Statement nextStat;
                    List<StatEdge> successors = outerIf.getAllSuccessorEdges();
                    Statement statement = nextStat = !successors.isEmpty() && successors.get(0).getType() == 1 ? successors.get(0).getDestination() : null;
                    IfStatement ifStatement2 = nextStat == null ? null : (nextStat instanceof IfStatement ? (IfStatement)nextStat : (nextIfStat = nextStat instanceof SequenceStatement && nextStat.getFirst() instanceof IfStatement ? (IfStatement)nextStat.getFirst() : null));
                    if (!(nextStat == null || nextIfStat != null && nextIfStat.getFirst().getExprents().isEmpty())) {
                        IfExprent conditionExprent = outerIf.getHeadexprent();
                        conditionExprent.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, conditionExprent.getCondition(), null));
                        IfHelper.swapBranches(outerIf, false, parent);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean reorderIf(IfStatement ifstat) {
        SequenceStatement sequence;
        boolean ifdirect;
        if (ifstat.iftype == 1) {
            return false;
        }
        boolean noifstat = false;
        boolean ifdirectpath = false;
        boolean elsedirectpath = false;
        Statement parent = ifstat.getParent();
        Statement from = parent instanceof SequenceStatement ? parent : ifstat;
        Statement next = IfHelper.getNextStatement(from);
        if (ifstat.getIfstat() == null) {
            noifstat = true;
            ifdirect = ifstat.getIfEdge().getType() == 32 || MergeHelper.isDirectPath(from, ifstat.getIfEdge().getDestination());
        } else {
            List<StatEdge> lstSuccs = ifstat.getIfstat().getAllSuccessorEdges();
            ifdirect = !lstSuccs.isEmpty() && lstSuccs.get(0).getType() == 32 || IfHelper.hasDirectEndEdge(ifstat.getIfstat(), from);
        }
        IfStatement last = parent instanceof SequenceStatement ? parent.getStats().getLast() : ifstat;
        boolean noelsestat = last == ifstat;
        boolean elsedirect = !last.getAllSuccessorEdges().isEmpty() && last.getAllSuccessorEdges().get(0).getType() == 32 || IfHelper.hasDirectEndEdge(last, from);
        List<StatEdge> successors = ifstat.getAllSuccessorEdges();
        if (successors.isEmpty()) {
            throw new IllegalStateException("If statement " + String.valueOf(ifstat) + " has no successors!");
        }
        if (!noelsestat && IfHelper.existsPath(ifstat, successors.get(0).getDestination())) {
            return false;
        }
        if (!ifdirect && !noifstat) {
            ifdirectpath = IfHelper.existsPath(ifstat, next);
        }
        if (!elsedirect && !noelsestat) {
            Statement sttemp;
            sequence = (SequenceStatement)parent;
            for (int i = sequence.getStats().size() - 1; i >= 0 && (sttemp = (Statement)sequence.getStats().get(i)) != ifstat; --i) {
                if (!IfHelper.existsPath(sttemp, next)) continue;
                elsedirectpath = true;
                break;
            }
        }
        if ((ifdirect || ifdirectpath) && (elsedirect || elsedirectpath) && !noifstat && !noelsestat) {
            Statement stelse;
            Object sttemp;
            sequence = (SequenceStatement)parent;
            ArrayList<Statement> lst = new ArrayList<Statement>();
            for (int i = sequence.getStats().size() - 1; i >= 0 && (sttemp = (Statement)sequence.getStats().get(i)) != ifstat; --i) {
                lst.add(0, (Statement)sttemp);
            }
            if (lst.size() == 1) {
                stelse = (Statement)lst.get(0);
            } else {
                stelse = new SequenceStatement(lst);
                stelse.setAllParent();
            }
            ifstat.removeSuccessor(ifstat.getFirstSuccessor());
            for (Statement st : lst) {
                sequence.getStats().removeWithKey(st.id);
            }
            StatEdge elseedge = new StatEdge(1, ifstat.getFirst(), stelse);
            ifstat.getFirst().addSuccessor(elseedge);
            ifstat.setElsestat(stelse);
            ifstat.setElseEdge(elseedge);
            ifstat.getStats().addWithKey(stelse, stelse.id);
            stelse.setParent(ifstat);
            ifstat.iftype = 1;
        } else if (ifdirect && (!elsedirect || noifstat && !noelsestat) && !ifstat.getAllSuccessorEdges().isEmpty()) {
            IfExprent statexpr = ifstat.getHeadexprent();
            statexpr.setCondition(new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, statexpr.getCondition(), null));
            if (noelsestat) {
                StatEdge ifedge = ifstat.getIfEdge();
                StatEdge elseedge = ifstat.getFirstSuccessor();
                if (noifstat) {
                    ifstat.getFirst().removeSuccessor(ifedge);
                    ifstat.removeSuccessor(elseedge);
                    ifedge.setSource(ifstat);
                    elseedge.setSource(ifstat.getFirst());
                    ifstat.addSuccessor(ifedge);
                    ifstat.getFirst().addSuccessor(elseedge);
                    ifstat.setIfEdge(elseedge);
                } else {
                    Statement ifbranch = ifstat.getIfstat();
                    SequenceStatement newseq = new SequenceStatement(Arrays.asList(ifstat, ifbranch));
                    ifstat.getFirst().removeSuccessor(ifedge);
                    ifstat.getStats().removeWithKey(ifbranch.id);
                    ifstat.setIfstat(null);
                    ifstat.removeSuccessor(elseedge);
                    elseedge.setSource(ifstat.getFirst());
                    ifstat.getFirst().addSuccessor(elseedge);
                    ifstat.setIfEdge(elseedge);
                    ifstat.getParent().replaceStatement(ifstat, newseq);
                    newseq.setAllParent();
                    ifstat.addSuccessor(new StatEdge(1, (Statement)ifstat, ifbranch));
                }
            } else {
                IfHelper.swapBranches(ifstat, noifstat, (SequenceStatement)parent);
            }
        } else {
            return false;
        }
        return true;
    }

    private static void swapBranches(IfStatement ifstat, boolean noifstat, SequenceStatement parent) {
        Statement stelse;
        Object sttemp;
        ValidationHelper.validateTrue(ifstat.iftype == 0, "This method is meant for swapping the branches of non if-else IfStatements");
        ArrayList<Statement> lst = new ArrayList<Statement>();
        for (int i = parent.getStats().size() - 1; i >= 0 && (sttemp = (Statement)parent.getStats().get(i)) != ifstat; --i) {
            lst.add(0, (Statement)sttemp);
        }
        if (lst.size() == 1) {
            stelse = (Statement)lst.get(0);
        } else {
            stelse = new SequenceStatement(lst);
            stelse.setAllParent();
        }
        ifstat.removeSuccessor(ifstat.getFirstSuccessor());
        for (Statement st : lst) {
            parent.getStats().removeWithKey(st.id);
        }
        if (noifstat) {
            StatEdge ifedge = ifstat.getIfEdge();
            ifstat.getFirst().removeSuccessor(ifedge);
            ifedge.setSource(ifstat);
            ifstat.addSuccessor(ifedge);
        } else {
            Statement ifbranch = ifstat.getIfstat();
            ifstat.getFirst().removeSuccessor(ifstat.getIfEdge());
            ifstat.getStats().removeWithKey(ifbranch.id);
            ifstat.addSuccessor(new StatEdge(1, (Statement)ifstat, ifbranch));
            parent.getStats().addWithKey(ifbranch, ifbranch.id);
            ifbranch.setParent(parent);
        }
        StatEdge newifedge = new StatEdge(1, ifstat.getFirst(), stelse);
        ifstat.getFirst().addSuccessor(newifedge);
        ifstat.setIfstat(stelse);
        ifstat.setIfEdge(newifedge);
        ifstat.getStats().addWithKey(stelse, stelse.id);
        stelse.setParent(ifstat);
    }

    private static boolean hasDirectEndEdge(Statement stat, Statement from) {
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (!MergeHelper.isDirectPath(from, edge.getDestination())) continue;
            return true;
        }
        if (stat.getExprents() == null) {
            switch (stat.type) {
                case SEQUENCE: {
                    return IfHelper.hasDirectEndEdge(stat.getStats().getLast(), from);
                }
                case CATCH_ALL: 
                case TRY_CATCH: {
                    for (Statement st : stat.getStats()) {
                        if (!IfHelper.hasDirectEndEdge(st, from)) continue;
                        return true;
                    }
                    break;
                }
                case IF: {
                    IfStatement ifstat = (IfStatement)stat;
                    if (ifstat.iftype != 1) break;
                    return IfHelper.hasDirectEndEdge(ifstat.getIfstat(), from) || IfHelper.hasDirectEndEdge(ifstat.getElsestat(), from);
                }
                case SYNCHRONIZED: {
                    return IfHelper.hasDirectEndEdge((Statement)stat.getStats().get(1), from);
                }
                case SWITCH: {
                    for (Statement st : stat.getStats()) {
                        if (!IfHelper.hasDirectEndEdge(st, from)) continue;
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    private static Statement getNextStatement(Statement stat) {
        Statement parent = stat.getParent();
        switch (parent.type) {
            case ROOT: {
                return ((RootStatement)parent).getDummyExit();
            }
            case DO: {
                return parent;
            }
            case SEQUENCE: {
                SequenceStatement sequence = (SequenceStatement)parent;
                if (sequence.getStats().getLast() == stat) break;
                for (int i = sequence.getStats().size() - 1; i >= 0; --i) {
                    if (sequence.getStats().get(i) != stat) continue;
                    return (Statement)sequence.getStats().get(i + 1);
                }
                break;
            }
        }
        return IfHelper.getNextStatement(parent);
    }

    private static boolean existsPath(Statement from, Statement to) {
        for (StatEdge edge : to.getAllPredecessorEdges()) {
            if (!from.containsStatementStrict(edge.getSource())) continue;
            return true;
        }
        return false;
    }
}

