/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.vineflower.java.decompiler.code.CodeConstants;
import org.vineflower.java.decompiler.code.Instruction;
import org.vineflower.java.decompiler.code.InstructionSequence;
import org.vineflower.java.decompiler.code.cfg.BasicBlock;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.collectors.ImportCollector;
import org.vineflower.java.decompiler.modules.decompiler.CondyHelper;
import org.vineflower.java.decompiler.modules.decompiler.PrimitiveExprsList;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.modules.decompiler.exps.ArrayExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.IfExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.MonitorExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.NewExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.SwitchHeadExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.vineflower.java.decompiler.modules.decompiler.flow.DirectNode;
import org.vineflower.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.struct.consts.LinkConstant;
import org.vineflower.java.decompiler.struct.consts.PooledConstant;
import org.vineflower.java.decompiler.struct.consts.PrimitiveConstant;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.struct.gen.generics.GenericType;
import org.vineflower.java.decompiler.util.TextBuffer;
import org.vineflower.java.decompiler.util.TextUtil;
import org.vineflower.java.decompiler.util.collections.ListStack;

public class ExprProcessor
implements CodeConstants {
    public static final String UNDEFINED_TYPE_STRING = "<undefinedtype>";
    public static final String UNREPRESENTABLE_TYPE_STRING = "<unrepresentable>";
    public static final String UNKNOWN_TYPE_STRING = "<unknown>";
    public static final String NULL_TYPE_STRING = "<null>";
    private static final Map<Integer, FunctionExprent.FunctionType> mapConsts = new HashMap<Integer, FunctionExprent.FunctionType>();
    private static final VarType[] consts;
    private static final VarType[] varTypes;
    private static final VarType[] arrTypes;
    private static final FunctionExprent.FunctionType[] func1;
    private static final FunctionExprent.FunctionType[] func2;
    private static final FunctionExprent.FunctionType[] func3;
    private static final FunctionExprent.FunctionType[] func4;
    private static final IfExprent.Type[] func5;
    private static final IfExprent.Type[] func6;
    private static final IfExprent.Type[] func7;
    private static final MonitorExprent.Type[] func8;
    private static final CodeType[] arrTypeIds;
    private static final String[] typeNames;
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProcessor;

    public ExprProcessor(MethodDescriptor md, VarProcessor varProc) {
        this.methodDescriptor = md;
        this.varProcessor = varProc;
    }

    public void processStatement(RootStatement root, StructClass cl) {
        FlattenStatementsHelper flatHelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatHelper.buildDirectGraph(root);
        ValidationHelper.validateDGraph(dgraph, root);
        HashMap<String, VarExprent> mapCatch = new HashMap<String, VarExprent>();
        ExprProcessor.collectCatchVars(root, flatHelper, mapCatch);
        HashMap<DirectNode, PrimitiveExprsList> mapData = new HashMap<DirectNode, PrimitiveExprsList>();
        ListStack<DirectNode> stack = new ListStack<DirectNode>();
        stack.push(dgraph.first);
        mapData.put(dgraph.first, new PrimitiveExprsList());
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.pop();
            PrimitiveExprsList data = mapCatch.containsKey(node.id) ? ExprProcessor.getExpressionData((VarExprent)mapCatch.get(node.id)) : (PrimitiveExprsList)mapData.get(node);
            BasicBlockStatement block = node.block;
            if (block != null) {
                this.processBlock(block, data, cl);
                block.setExprents(data.getLstExprents());
            }
            for (DirectEdge cd : node.getSuccessors(DirectEdgeType.REGULAR)) {
                DirectNode nd = cd.getDestination();
                if (mapData.containsKey(nd)) continue;
                mapData.put(nd, ExprProcessor.copyVarExprents(data.copyStack()));
                stack.add(nd);
            }
        }
        ExprProcessor.initStatementExprents(root);
    }

    private static PrimitiveExprsList copyVarExprents(PrimitiveExprsList data) {
        ListStack<Exprent> stack = data.getStack();
        ExprProcessor.copyEntries(stack);
        return data;
    }

    public static void copyEntries(List<Exprent> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            stack.set(i, stack.get(i).copy());
        }
    }

    private static void collectCatchVars(Statement stat, FlattenStatementsHelper flatthelper, Map<String, VarExprent> map) {
        List<VarExprent> lst = null;
        if (stat instanceof CatchAllStatement) {
            CatchAllStatement catchall = (CatchAllStatement)stat;
            if (!catchall.isFinally()) {
                lst = catchall.getVars();
            }
        } else if (stat instanceof CatchStatement) {
            lst = ((CatchStatement)stat).getVars();
        }
        if (lst != null) {
            for (int i = 1; i < stat.getStats().size(); ++i) {
                map.put(flatthelper.getDirectNode((Statement)((Statement)stat.getStats().get((int)i))).id, lst.get(i - 1));
            }
        }
        for (Statement st : stat.getStats()) {
            ExprProcessor.collectCatchVars(st, flatthelper, map);
        }
    }

    private static void initStatementExprents(Statement stat) {
        stat.initExprents();
        for (Statement st : stat.getStats()) {
            ExprProcessor.initStatementExprents(st);
        }
    }

    public void processBlock(BasicBlockStatement stat, PrimitiveExprsList data, StructClass cl) {
        ConstantPool pool = cl.getPool();
        StructBootstrapMethodsAttribute bootstrap = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS);
        BasicBlock block = stat.getBlock();
        ListStack<Exprent> stack = data.getStack();
        List<Exprent> exprlist = data.getLstExprents();
        InstructionSequence seq = block.getSeq();
        block44: for (int i = 0; i < seq.length(); ++i) {
            Instruction instr = seq.getInstr(i);
            Integer bytecode_offset = block.getOldOffset(i);
            BitSet bytecode_offsets = null;
            if (bytecode_offset >= 0) {
                bytecode_offsets = new BitSet();
                bytecode_offsets.set((int)bytecode_offset, bytecode_offset + instr.length);
            }
            switch (instr.opcode) {
                case 1: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_NULL, null, bytecode_offsets));
                    continue block44;
                }
                case 16: 
                case 17: {
                    this.pushEx(stack, exprlist, new ConstExprent(instr.operand(0), true, bytecode_offsets));
                    continue block44;
                }
                case 9: 
                case 10: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_LONG, instr.opcode - 9, bytecode_offsets));
                    continue block44;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(instr.opcode - 11), bytecode_offsets));
                    continue block44;
                }
                case 14: 
                case 15: {
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_DOUBLE, instr.opcode - 14, bytecode_offsets));
                    continue block44;
                }
                case 18: 
                case 19: 
                case 20: {
                    PooledConstant cn = pool.getConstant(instr.operand(0));
                    if (cn instanceof PrimitiveConstant) {
                        this.pushEx(stack, exprlist, new ConstExprent(consts[cn.type - 3], ((PrimitiveConstant)cn).value, bytecode_offsets));
                        continue block44;
                    }
                    if (cn instanceof LinkConstant && cn.type == 17) {
                        LinkConstant invoke_constant = (LinkConstant)cn;
                        LinkConstant bootstrapMethod = null;
                        List<PooledConstant> bootstrap_arguments = null;
                        if (bootstrap != null) {
                            bootstrapMethod = bootstrap.getMethodReference(invoke_constant.index1);
                            bootstrap_arguments = bootstrap.getMethodArguments(invoke_constant.index1);
                        }
                        InvocationExprent exprinv = new InvocationExprent(instr.opcode, invoke_constant, bootstrapMethod, bootstrap_arguments, stack, bytecode_offsets);
                        if (exprinv.getDescriptor().ret.type == CodeType.VOID) {
                            exprlist.add(exprinv);
                            continue block44;
                        }
                        this.pushEx(stack, exprlist, CondyHelper.simplifyCondy(exprinv));
                        continue block44;
                    }
                    if (!(cn instanceof LinkConstant)) continue block44;
                    this.pushEx(stack, exprlist, new ConstExprent(VarType.VARTYPE_STRING, ((LinkConstant)cn).elementname, bytecode_offsets));
                    continue block44;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    VarExprent varExprent = new VarExprent(instr.operand(0), varTypes[instr.opcode - 21], this.varProcessor, bytecode_offsets);
                    varExprent.setBackingInstr(instr);
                    this.varProcessor.findLVT(varExprent, bytecode_offset + instr.length);
                    this.pushEx(stack, exprlist, varExprent);
                    continue block44;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Exprent index = stack.pop();
                    Exprent arr = stack.pop();
                    VarType vartype = null;
                    switch (instr.opcode) {
                        case 47: {
                            vartype = VarType.VARTYPE_LONG;
                            break;
                        }
                        case 49: {
                            vartype = VarType.VARTYPE_DOUBLE;
                        }
                    }
                    this.pushEx(stack, exprlist, new ArrayExprent(arr, index, arrTypes[instr.opcode - 46], bytecode_offsets), vartype);
                    continue block44;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    Exprent expr = stack.pop();
                    int varindex = instr.operand(0);
                    if (bytecode_offsets != null) {
                        bytecode_offsets.set((int)bytecode_offset, bytecode_offset + instr.length);
                    }
                    VarExprent varExprent = new VarExprent(varindex, varTypes[instr.opcode - 54], this.varProcessor, bytecode_offsets);
                    varExprent.setBackingInstr(instr);
                    this.varProcessor.findLVT(varExprent, bytecode_offset + instr.length);
                    AssignmentExprent assign = new AssignmentExprent(varExprent, expr, bytecode_offsets);
                    exprlist.add(assign);
                    continue block44;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    Exprent value = stack.pop();
                    Exprent index_store = stack.pop();
                    Exprent arr_store = stack.pop();
                    AssignmentExprent arrassign = new AssignmentExprent(new ArrayExprent(arr_store, index_store, arrTypes[instr.opcode - 79], bytecode_offsets), value, bytecode_offsets);
                    exprlist.add(arrassign);
                    continue block44;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func1[(instr.opcode - 96) / 4], stack, bytecode_offsets));
                    continue block44;
                }
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func2[(instr.opcode - 120) / 2], stack, bytecode_offsets));
                    continue block44;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.pushEx(stack, exprlist, new FunctionExprent(FunctionExprent.FunctionType.NEG, stack, bytecode_offsets));
                    continue block44;
                }
                case 132: {
                    VarExprent vevar = new VarExprent(instr.operand(0), VarType.VARTYPE_INT, this.varProcessor, bytecode_offsets);
                    vevar.setBackingInstr(instr);
                    this.varProcessor.findLVT(vevar, bytecode_offset + instr.length);
                    exprlist.add(new AssignmentExprent(vevar, new FunctionExprent(instr.operand(1) < 0 ? FunctionExprent.FunctionType.SUB : FunctionExprent.FunctionType.ADD, Arrays.asList(vevar.copy(), new ConstExprent(VarType.VARTYPE_INT, Math.abs(instr.operand(1)), null)), bytecode_offsets), bytecode_offsets));
                    continue block44;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func3[instr.opcode - 133], stack, bytecode_offsets));
                    continue block44;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.pushEx(stack, exprlist, new FunctionExprent(func4[instr.opcode - 148], stack, bytecode_offsets));
                    continue block44;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    exprlist.add(new IfExprent(func5[instr.opcode - 153].getNegative(), stack, bytecode_offsets));
                    continue block44;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    exprlist.add(new IfExprent(func6[instr.opcode - 159].getNegative(), stack, bytecode_offsets));
                    continue block44;
                }
                case 198: 
                case 199: {
                    exprlist.add(new IfExprent(func7[instr.opcode - 198].getNegative(), stack, bytecode_offsets));
                    continue block44;
                }
                case 170: 
                case 171: {
                    exprlist.add(new SwitchHeadExprent(stack.pop(), bytecode_offsets));
                    continue block44;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    exprlist.add(new ExitExprent(instr.opcode == 191 ? ExitExprent.Type.THROW : ExitExprent.Type.RETURN, instr.opcode == 177 ? null : stack.pop(), instr.opcode == 191 ? null : this.methodDescriptor.ret, bytecode_offsets, this.methodDescriptor));
                    continue block44;
                }
                case 194: 
                case 195: {
                    MonitorExprent monitor = new MonitorExprent(func8[instr.opcode - 194], stack.pop(), bytecode_offsets);
                    if (instr.opcode == 195 && stat.isRemovableMonitorexit()) {
                        monitor.setRemove(true);
                    }
                    exprlist.add(monitor);
                    continue block44;
                }
                case 192: 
                case 193: {
                    stack.push(new ConstExprent(new VarType(pool.getPrimitiveConstant(instr.operand(0)).getString(), true), null, null));
                }
                case 190: {
                    this.pushEx(stack, exprlist, new FunctionExprent(mapConsts.get(instr.opcode), stack, bytecode_offsets));
                    continue block44;
                }
                case 178: 
                case 180: {
                    this.pushEx(stack, exprlist, new FieldExprent(pool.getLinkConstant(instr.operand(0)), instr.opcode == 178 ? null : stack.pop(), bytecode_offsets));
                    continue block44;
                }
                case 179: 
                case 181: {
                    Exprent valfield = stack.pop();
                    FieldExprent exprfield = new FieldExprent(pool.getLinkConstant(instr.operand(0)), instr.opcode == 179 ? null : stack.pop(), bytecode_offsets);
                    exprlist.add(new AssignmentExprent(exprfield, valfield, bytecode_offsets));
                    continue block44;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: {
                    if (instr.opcode == 186 && !instr.bytecodeVersion.hasInvokeDynamic()) continue block44;
                    LinkConstant invoke_constant = pool.getLinkConstant(instr.operand(0));
                    LinkConstant bootstrapMethod = null;
                    List<PooledConstant> bootstrap_arguments = null;
                    if (instr.opcode == 186 && bootstrap != null) {
                        bootstrapMethod = bootstrap.getMethodReference(invoke_constant.index1);
                        bootstrap_arguments = bootstrap.getMethodArguments(invoke_constant.index1);
                    }
                    InvocationExprent exprinv = new InvocationExprent(instr.opcode, invoke_constant, bootstrapMethod, bootstrap_arguments, stack, bytecode_offsets);
                    if (exprinv.getDescriptor().ret.type == CodeType.VOID) {
                        exprlist.add(exprinv);
                        continue block44;
                    }
                    this.pushEx(stack, exprlist, exprinv);
                    continue block44;
                }
                case 187: 
                case 189: 
                case 197: {
                    int dimensions = instr.opcode == 187 ? 0 : (instr.opcode == 189 ? 1 : instr.operand(1));
                    VarType arrType = new VarType(pool.getPrimitiveConstant(instr.operand(0)).getString(), true);
                    if (instr.opcode != 197) {
                        arrType = arrType.resizeArrayDim(arrType.arrayDim + dimensions);
                    }
                    this.pushEx(stack, exprlist, new NewExprent(arrType, stack, dimensions, bytecode_offsets));
                    continue block44;
                }
                case 188: {
                    this.pushEx(stack, exprlist, new NewExprent(new VarType(arrTypeIds[instr.operand(0) - 4], 1), stack, 1, bytecode_offsets));
                    continue block44;
                }
                case 89: {
                    this.pushEx(stack, exprlist, stack.getByOffset(-1).copy());
                    continue block44;
                }
                case 90: {
                    this.insertByOffsetEx(-2, stack, exprlist, -1);
                    continue block44;
                }
                case 91: {
                    if (stack.getByOffset((int)-2).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-2, stack, exprlist, -1);
                        continue block44;
                    }
                    this.insertByOffsetEx(-3, stack, exprlist, -1);
                    continue block44;
                }
                case 92: {
                    if (stack.getByOffset((int)-1).getExprType().stackSize == 2) {
                        this.pushEx(stack, exprlist, stack.getByOffset(-1).copy());
                        continue block44;
                    }
                    this.pushEx(stack, exprlist, stack.getByOffset(-2).copy());
                    this.pushEx(stack, exprlist, stack.getByOffset(-2).copy());
                    continue block44;
                }
                case 93: {
                    if (stack.getByOffset((int)-1).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-2, stack, exprlist, -1);
                        continue block44;
                    }
                    this.insertByOffsetEx(-3, stack, exprlist, -2);
                    this.insertByOffsetEx(-3, stack, exprlist, -1);
                    continue block44;
                }
                case 94: {
                    if (stack.getByOffset((int)-1).getExprType().stackSize == 2) {
                        if (stack.getByOffset((int)-2).getExprType().stackSize == 2) {
                            this.insertByOffsetEx(-2, stack, exprlist, -1);
                            continue block44;
                        }
                        this.insertByOffsetEx(-3, stack, exprlist, -1);
                        continue block44;
                    }
                    if (stack.getByOffset((int)-3).getExprType().stackSize == 2) {
                        this.insertByOffsetEx(-3, stack, exprlist, -2);
                        this.insertByOffsetEx(-3, stack, exprlist, -1);
                        continue block44;
                    }
                    this.insertByOffsetEx(-4, stack, exprlist, -2);
                    this.insertByOffsetEx(-4, stack, exprlist, -1);
                    continue block44;
                }
                case 95: {
                    this.insertByOffsetEx(-2, stack, exprlist, -1);
                    stack.pop();
                    continue block44;
                }
                case 87: {
                    int nextOpc;
                    Exprent last;
                    stack.pop();
                    if (exprlist.isEmpty() || !((last = exprlist.get(exprlist.size() - 1)) instanceof AssignmentExprent) || !(((AssignmentExprent)last).getRight() instanceof InvocationExprent)) continue block44;
                    InvocationExprent invocation = (InvocationExprent)((AssignmentExprent)last).getRight();
                    if (i + 1 >= seq.length() || (invocation.isStatic() || !invocation.getName().equals("getClass") || !invocation.getStringDescriptor().equals("()Ljava/lang/Class;")) && (!invocation.isStatic() || !invocation.getClassname().equals("java/util/Objects") || !invocation.getName().equals("requireNonNull") || !invocation.getStringDescriptor().equals("(Ljava/lang/Object;)Ljava/lang/Object;")) || (nextOpc = seq.getInstr((int)(i + 1)).opcode) < 1 || nextOpc > 20) continue block44;
                    invocation.setSyntheticNullCheck();
                    continue block44;
                }
                case 88: {
                    if (stack.getByOffset((int)-1).getExprType().stackSize == 1) {
                        stack.pop();
                    }
                    stack.pop();
                }
            }
        }
    }

    private void pushEx(ListStack<Exprent> stack, List<Exprent> exprlist, Exprent exprent) {
        this.pushEx(stack, exprlist, exprent, null);
    }

    private void pushEx(ListStack<Exprent> stack, List<Exprent> exprlist, Exprent exprent, VarType vartype) {
        ValidationHelper.notNull(exprent);
        int varindex = 10000 + stack.size();
        VarExprent var = new VarExprent(varindex, vartype == null ? exprent.getExprType() : vartype, this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        stack.push(var.copy());
    }

    private void insertByOffsetEx(int offset, ListStack<Exprent> stack, List<Exprent> exprlist, int copyoffset) {
        int base = 10000 + stack.size();
        LinkedList<VarExprent> lst = new LinkedList<VarExprent>();
        for (int i = -1; i >= offset; --i) {
            Exprent varex = stack.pop();
            VarExprent varnew = new VarExprent(base + i + 1, varex.getExprType(), this.varProcessor);
            varnew.setStack(true);
            exprlist.add(new AssignmentExprent(varnew, varex, null));
            lst.add(0, (VarExprent)varnew.copy());
        }
        Exprent exprent = ((VarExprent)lst.get(lst.size() + copyoffset)).copy();
        VarExprent var = new VarExprent(base + offset, exprent.getExprType(), this.varProcessor);
        var.setStack(true);
        exprlist.add(new AssignmentExprent(var, exprent, null));
        lst.add(0, (VarExprent)var.copy());
        for (VarExprent expr : lst) {
            stack.push(expr);
        }
    }

    public static boolean canonicalizeCasts(RootStatement stat) {
        boolean res = false;
        while (ExprProcessor.canonicalizeCasts((Statement)stat)) {
            res = true;
        }
        return res;
    }

    private static boolean canonicalizeCasts(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= ExprProcessor.canonicalizeCasts(st);
        }
        if (stat instanceof BasicBlockStatement) {
            for (Exprent exprent : stat.getExprents()) {
                for (Exprent ex : exprent.getAllExprents(true, true)) {
                    if (!(ex instanceof FunctionExprent) || ((FunctionExprent)ex).getFuncType() != FunctionExprent.FunctionType.CAST) continue;
                    FunctionExprent func = (FunctionExprent)ex;
                    Exprent inner = func.getLstOperands().get(0);
                    Exprent cast = func.getLstOperands().get(1);
                    if (!(inner instanceof FunctionExprent) || ((FunctionExprent)inner).getFuncType() != FunctionExprent.FunctionType.CAST) continue;
                    FunctionExprent func2 = (FunctionExprent)inner;
                    Exprent inner2 = func2.getLstOperands().get(0);
                    Exprent cast2 = func2.getLstOperands().get(1);
                    if (!cast.getExprType().equals(cast2.getExprType())) continue;
                    ex.replaceExprent(inner, inner2);
                    ex.addBytecodeOffsets(inner2.bytecode);
                    ex.addBytecodeOffsets(inner.bytecode);
                    res = true;
                }
            }
        }
        return res;
    }

    public static void markExprOddities(RootStatement root) {
        try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
            ExprProcessor.markExprOddities(root, root);
        }
    }

    private static void markExprOddities(RootStatement root, Statement stat) {
        for (Statement st : stat.getStats()) {
            ExprProcessor.markExprOddities(root, st);
        }
        for (Exprent ex : stat.getVarDefinitions()) {
            ExprProcessor.markExprOddity(root, ex);
        }
        if (stat instanceof BasicBlockStatement) {
            if (stat.isLabeled()) {
                root.addComment("$VF: Made invalid labels!", true);
            }
            for (Exprent ex : stat.getExprents()) {
                ExprProcessor.markExprOddity(root, ex);
            }
        }
    }

    private static void markExprOddity(RootStatement root, Exprent ex) {
        if (ex instanceof MonitorExprent) {
            root.addComment("$VF: Could not create synchronized statement, marking monitor enters and exits", true);
        }
        if (ex instanceof IfExprent) {
            root.addComment("$VF: Accidentally destroyed if statement, the decompiled code is not correct!", true);
        }
        for (Exprent e : ex.getAllExprents(true, true)) {
            List<Exprent> operands;
            FunctionExprent func;
            if (e instanceof VarExprent) {
                VarExprent var = (VarExprent)e;
                if ((!var.isDefinition() || !ExprProcessor.isInvalidTypeName(var.getDefinitionType())) && var.getExprType() != VarType.VARTYPE_UNKNOWN) continue;
                root.addComment("$VF: Could not properly define all variable types!", true);
                continue;
            }
            if (!(e instanceof FunctionExprent) || (func = (FunctionExprent)e).getFuncType() != FunctionExprent.FunctionType.CAST || !func.doesCast() || !ExprProcessor.isInvalidTypeName((operands = func.getLstOperands()).get(1).toString())) continue;
            root.addComment("$VF: Could not properly define all variable types!", true);
        }
    }

    public static String getTypeName(VarType type) {
        return ExprProcessor.getTypeName(type, true);
    }

    public static String getTypeName(VarType type, boolean getShort) {
        CodeType tp = type.type;
        if (tp.ordinal() <= CodeType.BOOLEAN.ordinal()) {
            return typeNames[tp.ordinal()];
        }
        if (tp == CodeType.UNKNOWN) {
            return UNKNOWN_TYPE_STRING;
        }
        if (tp == CodeType.NULL) {
            return NULL_TYPE_STRING;
        }
        if (tp == CodeType.VOID) {
            return "void";
        }
        if (tp == CodeType.GENVAR && type.isGeneric()) {
            return type.value;
        }
        if (tp == CodeType.OBJECT) {
            if (type.isGeneric()) {
                return ((GenericType)type).getCastName();
            }
            String ret = ExprProcessor.buildJavaClassName(type.value);
            if (getShort) {
                ret = DecompilerContext.getImportCollector().getShortName(ret);
            }
            if (ret == null) {
                ret = UNDEFINED_TYPE_STRING;
            }
            return ret;
        }
        throw new RuntimeException("invalid type: " + String.valueOf((Object)tp));
    }

    public static boolean isInvalidTypeName(String name) {
        return UNDEFINED_TYPE_STRING.equals(name) || NULL_TYPE_STRING.equals(name) || UNKNOWN_TYPE_STRING.equals(name);
    }

    public static String getCastTypeName(VarType type) {
        return ExprProcessor.getCastTypeName(type, true);
    }

    public static String getCastTypeName(VarType type, boolean getShort) {
        StringBuilder s = new StringBuilder(ExprProcessor.getTypeName(type, getShort));
        TextUtil.append(s, "[]", type.arrayDim);
        return s.toString();
    }

    public static PrimitiveExprsList getExpressionData(VarExprent var) {
        PrimitiveExprsList prlst = new PrimitiveExprsList();
        VarExprent vartmp = new VarExprent(10000, var.getExprType(), var.getProcessor());
        vartmp.setStack(true);
        prlst.getLstExprents().add(new AssignmentExprent(vartmp, var.copy(), null));
        prlst.getStack().push(vartmp.copy());
        return prlst;
    }

    public static boolean endsWithSemicolon(Exprent expr) {
        return !(expr instanceof SwitchHeadExprent) && !(expr instanceof MonitorExprent) && !(expr instanceof IfExprent) && (!(expr instanceof VarExprent) || !((VarExprent)expr).isClassDef());
    }

    private static void addDeletedGotoInstructionMapping(Statement stat, TextBuffer buffer) {
        BasicBlock block;
        List<Integer> offsets;
        if (stat instanceof BasicBlockStatement && !(offsets = (block = ((BasicBlockStatement)stat).getBlock()).getInstrOldOffsets()).isEmpty() && offsets.size() > block.getSeq().length()) {
            buffer.addBytecodeMapping(offsets.get(offsets.size() - 1));
        }
    }

    public static TextBuffer jmpWrapper(Statement stat, int indent, boolean semicolon) {
        StatEdge edge;
        TextBuffer buf = stat.toJava(indent);
        List<StatEdge> lstSuccs = stat.getSuccessorEdges(0x40000000);
        if (lstSuccs.size() == 1 && (edge = lstSuccs.get(0)).getType() != 1 && edge.explicit && !(edge.getDestination() instanceof DummyExitStatement)) {
            buf.appendIndent(indent);
            switch (edge.getType()) {
                case 4: {
                    ExprProcessor.addDeletedGotoInstructionMapping(stat, buf);
                    buf.append("break");
                    break;
                }
                case 8: {
                    ExprProcessor.addDeletedGotoInstructionMapping(stat, buf);
                    buf.append("continue");
                }
            }
            if (edge.labeled) {
                buf.append(" label").append(edge.closure.id);
            }
            buf.append(";").appendLineSeparator();
        }
        if (buf.length() == 0 && semicolon) {
            buf.appendIndent(indent).append(";").appendLineSeparator();
        }
        return buf;
    }

    public static String buildJavaClassName(String name) {
        StructClass cl;
        String res = name.replace('/', '.');
        if (res.contains("$") && ((cl = DecompilerContext.getStructContext().getClass(name)) == null || !cl.isOwn())) {
            res = res.replace('$', '.');
        }
        return res;
    }

    public static TextBuffer listToJava(List<? extends Exprent> lst, int indent) {
        if (lst == null || lst.isEmpty()) {
            return new TextBuffer();
        }
        TextBuffer buf = new TextBuffer();
        lst = Exprent.sortIndexed(lst);
        for (Exprent exprent : lst) {
            if (buf.length() > 0 && exprent instanceof VarExprent && ((VarExprent)exprent).isClassDef()) {
                buf.appendLineSeparator();
            }
            exprent.getInferredExprType(null);
            TextBuffer content = exprent.toJava(indent);
            if (content.length() <= 0) continue;
            if (!(exprent instanceof VarExprent) || !((VarExprent)exprent).isClassDef()) {
                buf.appendIndent(indent);
            }
            buf.append(content);
            if (exprent instanceof MonitorExprent && ((MonitorExprent)exprent).getMonType() == MonitorExprent.Type.ENTER) {
                buf.append("{} // $VF: monitorenter ");
            }
            if (ExprProcessor.endsWithSemicolon(exprent)) {
                buf.append(";");
            }
            buf.appendLineSeparator();
        }
        return buf;
    }

    public static ConstExprent getDefaultArrayValue(VarType arrType) {
        ConstExprent defaultVal = arrType.type == CodeType.OBJECT || arrType.arrayDim > 0 ? new ConstExprent(VarType.VARTYPE_NULL, null, null) : (arrType.type == CodeType.FLOAT ? new ConstExprent(VarType.VARTYPE_FLOAT, Float.valueOf(0.0f), null) : (arrType.type == CodeType.LONG ? new ConstExprent(VarType.VARTYPE_LONG, 0L, null) : (arrType.type == CodeType.DOUBLE ? new ConstExprent(VarType.VARTYPE_DOUBLE, 0.0, null) : new ConstExprent(0, true, null))));
        return defaultVal;
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, boolean castNull) {
        return ExprProcessor.getCastedExprent(exprent, leftType, buffer, indent, castNull ? NullCastType.CAST : NullCastType.DONT_CAST, false, false, false);
    }

    public static boolean getCastedExprent(Exprent exprent, VarType leftType, TextBuffer buffer, int indent, NullCastType castNull, boolean castAlways, boolean castNarrowing, boolean unbox) {
        boolean quote;
        boolean cast;
        InvocationExprent invocationExprent;
        if (unbox && exprent instanceof InvocationExprent && (invocationExprent = (InvocationExprent)exprent).isBoxingCall() && !invocationExprent.shouldForceBoxing()) {
            exprent = invocationExprent.getLstParameters().get(0);
            CodeType paramType = invocationExprent.getDescriptor().params[0].type;
            if (exprent instanceof ConstExprent && ((ConstExprent)exprent).getConstType().type != paramType) {
                leftType = new VarType(paramType);
            }
        }
        VarType rightType = exprent.getInferredExprType(leftType);
        exprent = ExprProcessor.narrowGenericCastType(exprent, leftType);
        boolean doCast = !leftType.isSuperset(rightType) && (rightType.equals(VarType.VARTYPE_OBJECT) || leftType.type != CodeType.OBJECT);
        boolean doCastNull = castNull.cast && rightType.type == CodeType.NULL && !UNDEFINED_TYPE_STRING.equals(ExprProcessor.getTypeName(leftType));
        boolean doCastNarrowing = castNarrowing && ExprProcessor.isIntConstant(exprent) && ExprProcessor.isNarrowedIntType(leftType);
        boolean doCastGenerics = ExprProcessor.doGenericTypesCast(exprent, leftType, rightType);
        boolean bl = cast = castAlways || doCast || doCastNull || doCastNarrowing || doCastGenerics;
        if (castNull == NullCastType.DONT_CAST_AT_ALL && rightType.type == CodeType.NULL) {
            cast = castAlways;
        }
        boolean castLambda = !cast && exprent instanceof NewExprent && !leftType.equals(rightType) && ExprProcessor.lambdaNeedsCast(leftType, (NewExprent)exprent);
        boolean bl2 = quote = cast && exprent.getPrecedence() >= FunctionExprent.FunctionType.CAST.precedence;
        if (castNarrowing && exprent instanceof ConstExprent && !((ConstExprent)exprent).isNull()) {
            if (leftType.equals(VarType.VARTYPE_BYTE_OBJ)) {
                leftType = VarType.VARTYPE_BYTE;
            } else if (leftType.equals(VarType.VARTYPE_SHORT_OBJ)) {
                leftType = VarType.VARTYPE_SHORT;
            }
        }
        if (cast) {
            buffer.append('(').appendCastTypeName(leftType).append(')');
        }
        if (castLambda) {
            buffer.append('(').appendCastTypeName(rightType).append(')');
        }
        if (quote) {
            buffer.append('(');
        }
        if (exprent instanceof ConstExprent) {
            ((ConstExprent)exprent).adjustConstType(leftType);
        }
        if (cast && exprent instanceof NewExprent && ((NewExprent)exprent).isVarArgParam()) {
            ((NewExprent)exprent).setVarArgParam(false);
        }
        buffer.append(exprent.toJava(indent));
        if (quote) {
            buffer.append(')');
        }
        return cast;
    }

    public static Exprent narrowGenericCastType(Exprent expr, VarType type) {
        if (type.isGeneric() && expr instanceof FunctionExprent && ((FunctionExprent)expr).getFuncType() == FunctionExprent.FunctionType.CAST) {
            FunctionExprent func = (FunctionExprent)expr;
            VarType funcType = func.getExprType();
            GenericType genType = (GenericType)type;
            if (funcType.value.equals(type.value) && !genType.getArguments().isEmpty()) {
                if (!funcType.isGeneric()) {
                    ConstExprent cast = (ConstExprent)func.getLstOperands().get(1);
                    cast.setConstType(type);
                } else if (genType.equalsExact(funcType) && !func.doesCast()) {
                    func.setNeedsCast(true);
                }
            }
        }
        return expr;
    }

    private static boolean doGenericTypesCast(Exprent ex, VarType left, VarType right) {
        Map<VarType, List<VarType>> named = ex.getNamedGenerics();
        if (left == null || right == null) {
            return false;
        }
        if (left.isGeneric() && right.isGeneric()) {
            if (ExprProcessor.shouldGenericTypesCast(named, left, right)) {
                return true;
            }
            GenericType leftGeneric = (GenericType)left;
            GenericType rightGeneric = (GenericType)right;
            if (leftGeneric.getArguments().size() != rightGeneric.getArguments().size()) {
                return false;
            }
            for (int i = 0; i < leftGeneric.getArguments().size(); ++i) {
                VarType leftType = leftGeneric.getArguments().get(i);
                VarType rightType = rightGeneric.getArguments().get(i);
                if (rightType == null && leftType != null) {
                    return true;
                }
                if (leftType == null || !ExprProcessor.shouldGenericTypesCast(named, leftType, rightType)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldGenericTypesCast(Map<VarType, List<VarType>> named, VarType leftType, VarType rightType) {
        if (leftType.isGeneric()) {
            GenericType genLeft = (GenericType)leftType;
            if (rightType.isGeneric()) {
                GenericType genRight = (GenericType)rightType;
                if (leftType.isSuperset(rightType)) {
                    if ((genLeft.getWildcard() == 4 || genLeft.getWildcard() == 1) && genRight.getWildcard() == 2) {
                        boolean ok = true;
                        if (genLeft.getWildcard() == 1 && !genLeft.getArguments().isEmpty() && !genRight.getArguments().isEmpty() && leftType.equals(rightType)) {
                            ok = false;
                        }
                        if (ok) {
                            return true;
                        }
                    }
                } else {
                    if (genLeft.getWildcard() == 1 && genRight.getWildcard() == 2) {
                        return true;
                    }
                    if (leftType.type == CodeType.GENVAR && rightType.type == CodeType.GENVAR && genLeft.getWildcard() == 4 && genLeft.getWildcard() == 4 && named.containsKey(leftType) && named.containsKey(rightType) && named.get(leftType).contains(VarType.VARTYPE_OBJECT) && named.get(rightType).contains(VarType.VARTYPE_OBJECT)) {
                        return true;
                    }
                }
                if ((genLeft.getWildcard() == 4 || genLeft.getWildcard() == 2) && genRight.getWildcard() == 1) {
                    return true;
                }
                if (genLeft.getArguments().size() != genRight.getArguments().size()) {
                    return false;
                }
                if (genLeft.getWildcard() == genRight.getWildcard()) {
                    for (int i = 0; i < genLeft.getArguments().size(); ++i) {
                        VarType lt = genLeft.getArguments().get(i);
                        VarType rt = genRight.getArguments().get(i);
                        if (rt == null && lt != null && lt.type == CodeType.GENVAR) {
                            return true;
                        }
                        if (lt == null || rt == null || !ExprProcessor.shouldGenericTypesCast(named, lt, rt)) continue;
                        return true;
                    }
                }
            } else if (genLeft.getWildcard() == 4 && genLeft.getArguments().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isIntConstant(Exprent exprent) {
        if (exprent instanceof ConstExprent) {
            switch (((ConstExprent)exprent).getConstType().type) {
                case BYTE: 
                case BYTECHAR: 
                case SHORT: 
                case SHORTCHAR: 
                case INT: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isNarrowedIntType(VarType type) {
        return VarType.VARTYPE_INT.isStrictSuperset(type) || type.equals(VarType.VARTYPE_BYTE_OBJ) || type.equals(VarType.VARTYPE_SHORT_OBJ);
    }

    private static boolean lambdaNeedsCast(VarType left, NewExprent exprent) {
        if (exprent.isLambda() && !exprent.isMethodReference()) {
            StructClass cls = DecompilerContext.getStructContext().getClass(left.value);
            return cls == null || cls.getMethod(exprent.getLambdaMethodKey()) == null;
        }
        return false;
    }

    static {
        mapConsts.put(190, FunctionExprent.FunctionType.ARRAY_LENGTH);
        mapConsts.put(192, FunctionExprent.FunctionType.CAST);
        mapConsts.put(193, FunctionExprent.FunctionType.INSTANCEOF);
        consts = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_FLOAT, VarType.VARTYPE_LONG, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_CLASS, VarType.VARTYPE_STRING};
        varTypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT};
        arrTypes = new VarType[]{VarType.VARTYPE_INT, VarType.VARTYPE_LONG, VarType.VARTYPE_FLOAT, VarType.VARTYPE_DOUBLE, VarType.VARTYPE_OBJECT, VarType.VARTYPE_BOOLEAN, VarType.VARTYPE_CHAR, VarType.VARTYPE_SHORT};
        func1 = new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.ADD, FunctionExprent.FunctionType.SUB, FunctionExprent.FunctionType.MUL, FunctionExprent.FunctionType.DIV, FunctionExprent.FunctionType.REM};
        func2 = new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.SHL, FunctionExprent.FunctionType.SHR, FunctionExprent.FunctionType.USHR, FunctionExprent.FunctionType.AND, FunctionExprent.FunctionType.OR, FunctionExprent.FunctionType.XOR};
        func3 = new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.I2L, FunctionExprent.FunctionType.I2F, FunctionExprent.FunctionType.I2D, FunctionExprent.FunctionType.L2I, FunctionExprent.FunctionType.L2F, FunctionExprent.FunctionType.L2D, FunctionExprent.FunctionType.F2I, FunctionExprent.FunctionType.F2L, FunctionExprent.FunctionType.F2D, FunctionExprent.FunctionType.D2I, FunctionExprent.FunctionType.D2L, FunctionExprent.FunctionType.D2F, FunctionExprent.FunctionType.I2B, FunctionExprent.FunctionType.I2C, FunctionExprent.FunctionType.I2S};
        func4 = new FunctionExprent.FunctionType[]{FunctionExprent.FunctionType.LCMP, FunctionExprent.FunctionType.FCMPL, FunctionExprent.FunctionType.FCMPG, FunctionExprent.FunctionType.DCMPL, FunctionExprent.FunctionType.DCMPG};
        func5 = new IfExprent.Type[]{IfExprent.Type.EQ, IfExprent.Type.NE, IfExprent.Type.LT, IfExprent.Type.GE, IfExprent.Type.GT, IfExprent.Type.LE};
        func6 = new IfExprent.Type[]{IfExprent.Type.ICMPEQ, IfExprent.Type.ICMPNE, IfExprent.Type.ICMPLT, IfExprent.Type.ICMPGE, IfExprent.Type.ICMPGT, IfExprent.Type.ICMPLE, IfExprent.Type.ACMPEQ, IfExprent.Type.ACMPNE};
        func7 = new IfExprent.Type[]{IfExprent.Type.NULL, IfExprent.Type.NONNULL};
        func8 = new MonitorExprent.Type[]{MonitorExprent.Type.ENTER, MonitorExprent.Type.EXIT};
        arrTypeIds = new CodeType[]{CodeType.BOOLEAN, CodeType.CHAR, CodeType.FLOAT, CodeType.DOUBLE, CodeType.BYTE, CodeType.SHORT, CodeType.INT, CodeType.LONG};
        typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};
    }

    public static enum NullCastType {
        CAST(true),
        DONT_CAST(false),
        DONT_CAST_AT_ALL(false);

        private final boolean cast;

        private NullCastType(boolean cast) {
            this.cast = cast;
        }
    }
}

