/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.modules.decompiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.modules.decompiler.ExprProcessor;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.vineflower.java.decompiler.struct.attr.StructGeneralAttribute;
import org.vineflower.java.decompiler.struct.consts.LinkConstant;
import org.vineflower.java.decompiler.struct.consts.PooledConstant;
import org.vineflower.java.decompiler.struct.consts.PrimitiveConstant;
import org.vineflower.java.decompiler.struct.gen.FieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;

public class CondyHelper {
    private static final String CONSTANT_BOOTSTRAPS_CLASS = "java/lang/invoke/ConstantBootstraps";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Exprent simplifyCondy(InvocationExprent condyExpr) {
        if (condyExpr.getInvocationType() != InvocationExprent.InvocationType.CONSTANT_DYNAMIC) {
            return condyExpr;
        }
        LinkConstant method = condyExpr.getBootstrapMethod();
        if (!CONSTANT_BOOTSTRAPS_CLASS.equals(method.classname)) {
            return condyExpr;
        }
        switch (method.elementname) {
            case "nullConstant": {
                return new ConstExprent(VarType.VARTYPE_NULL, null, null).setWasCondy(true);
            }
            case "primitiveClass": {
                String desc = condyExpr.getName();
                if (desc.length() != 1 || !"ZCBSIJFDV".contains(desc)) return condyExpr;
                VarType type = new VarType(desc, false);
                return new ConstExprent(VarType.VARTYPE_CLASS, ExprProcessor.getCastTypeName(type), null).setWasCondy(true);
            }
            case "enumConstant": {
                String typeName = condyExpr.getExprType().value;
                return new FieldExprent(condyExpr.getName(), typeName, true, null, FieldDescriptor.parseDescriptor("L" + typeName + ";"), null, false, true);
            }
            case "getStaticFinal": {
                String ownerClass;
                List<PooledConstant> constArgs = condyExpr.getBootstrapArguments();
                String fieldType = condyExpr.getExprType().value;
                if (constArgs.size() == 1) {
                    PooledConstant ownerName = constArgs.get(0);
                    if (!(ownerName instanceof PrimitiveConstant)) return condyExpr;
                    ownerClass = ((PrimitiveConstant)ownerName).value.toString();
                    return new FieldExprent(condyExpr.getName(), ownerClass, true, null, FieldDescriptor.parseDescriptor(fieldType), null, false, true);
                } else {
                    if (condyExpr.getExprType().type != VarType.VARTYPE_OBJECT.type) {
                        return condyExpr;
                    }
                    ownerClass = fieldType;
                }
                return new FieldExprent(condyExpr.getName(), ownerClass, true, null, FieldDescriptor.parseDescriptor(fieldType), null, false, true);
            }
            case "fieldVarHandle": 
            case "staticFieldVarHandle": {
                if (!DecompilerContext.getOption("decompile-complex-constant-dynamic")) {
                    return condyExpr;
                }
                boolean isStatic = method.elementname.startsWith("static");
                List<PooledConstant> constArgs = condyExpr.getBootstrapArguments();
                String fieldName = condyExpr.getName();
                if (constArgs.size() != 2 || !(constArgs.get(0) instanceof PrimitiveConstant)) {
                    return condyExpr;
                }
                String ownerClass = ((PrimitiveConstant)constArgs.get(0)).getString();
                return CondyHelper.constructVarHandle(fieldName, ownerClass, constArgs.get(1), isStatic);
            }
            case "arrayVarHandle": {
                if (!DecompilerContext.getOption("decompile-complex-constant-dynamic")) {
                    return condyExpr;
                }
                List<PooledConstant> constArgs = condyExpr.getBootstrapArguments();
                if (constArgs.size() == 1) return CondyHelper.constructArrayVarHandleExprent(constArgs.get(0));
                return condyExpr;
            }
        }
        return condyExpr;
    }

    private static Exprent constructVarHandle(String fieldName, String fieldOwner, PooledConstant fieldType, boolean isStatic) {
        InvocationExprent lookupExprent = CondyHelper.constructLookupExprent();
        VarType ownerClassClass = new VarType(fieldOwner, false);
        ConstExprent ownerClassConst = new ConstExprent(VarType.VARTYPE_CLASS, ExprProcessor.getCastTypeName(ownerClassClass), null);
        ConstExprent fieldNameConst = new ConstExprent(VarType.VARTYPE_STRING, fieldName, null);
        Exprent fieldTypeConst = CondyHelper.toClassExprent(fieldType);
        return CondyHelper.constructFindVarHandleExprent(isStatic, lookupExprent, ownerClassConst, fieldNameConst, fieldTypeConst);
    }

    private static Exprent toClassExprent(PooledConstant constant) {
        Exprent constExpr;
        if (constant instanceof PrimitiveConstant) {
            VarType fieldTypeClass = new VarType(((PrimitiveConstant)constant).getString(), false);
            constExpr = new ConstExprent(VarType.VARTYPE_CLASS, ExprProcessor.getCastTypeName(fieldTypeClass), null);
        } else {
            constExpr = CondyHelper.toCondyExprent((LinkConstant)constant);
        }
        return constExpr;
    }

    private static Exprent toCondyExprent(LinkConstant fieldType) {
        InvocationExprent arg;
        Exprent fieldTypeConst;
        StructClass cl = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS);
        StructBootstrapMethodsAttribute bootstrap = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS);
        LinkConstant bootstrapMethod = null;
        List<PooledConstant> constArgs = null;
        if (bootstrap != null) {
            bootstrapMethod = bootstrap.getMethodReference(fieldType.index1);
            constArgs = bootstrap.getMethodArguments(fieldType.index1);
        }
        if ((fieldTypeConst = CondyHelper.simplifyCondy(arg = new InvocationExprent(18, fieldType, bootstrapMethod, constArgs, null, null))) instanceof ConstExprent) {
            ((ConstExprent)fieldTypeConst).setWasCondy(false);
        }
        return fieldTypeConst;
    }

    private static InvocationExprent constructLookupExprent() {
        InvocationExprent exprent = new InvocationExprent();
        exprent.setName("lookup");
        exprent.setClassname("java/lang/invoke/MethodHandles");
        String desc = "()Ljava/lang/invoke/MethodHandles$Lookup;";
        exprent.setStringDescriptor(desc);
        exprent.setDescriptor(MethodDescriptor.parseDescriptor(desc));
        exprent.setFunctype(InvocationExprent.Type.GENERAL);
        exprent.setStatic(true);
        return exprent;
    }

    private static InvocationExprent constructFindVarHandleExprent(boolean isStatic, Exprent lookup, Exprent ownerClass, Exprent fieldName, Exprent fieldClass) {
        InvocationExprent exprent = new InvocationExprent();
        exprent.setName(isStatic ? "findStaticVarHandle" : "findVarHandle");
        exprent.setClassname("java/lang/invoke/MethodHandles$Lookup");
        String desc = "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;";
        exprent.setStringDescriptor(desc);
        exprent.setDescriptor(MethodDescriptor.parseDescriptor(desc));
        exprent.setFunctype(InvocationExprent.Type.GENERAL);
        exprent.setStatic(false);
        exprent.setInstance(lookup);
        exprent.setLstParameters(Arrays.asList(ownerClass, fieldName, fieldClass));
        return exprent.markWasLazyCondy();
    }

    private static InvocationExprent constructArrayVarHandleExprent(PooledConstant classConst) {
        InvocationExprent exprent = new InvocationExprent();
        exprent.setName("arrayElementVarHandle");
        exprent.setClassname("java/lang/invoke/MethodHandles");
        String desc = "(Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;";
        exprent.setStringDescriptor(desc);
        exprent.setDescriptor(MethodDescriptor.parseDescriptor(desc));
        exprent.setFunctype(InvocationExprent.Type.GENERAL);
        exprent.setStatic(true);
        Exprent classExpr = CondyHelper.toClassExprent(classConst);
        exprent.setLstParameters(Collections.singletonList(classExpr));
        return exprent.markWasLazyCondy();
    }
}

