/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.rels;

import java.util.ArrayList;
import java.util.List;
import org.vineflower.java.decompiler.modules.decompiler.ValidationHelper;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.struct.StructMethod;
import org.vineflower.java.decompiler.util.DotExporter;

public final class DecompileRecord {
    private final List<String> names = new ArrayList<String>();
    private final StructMethod mt;
    private int mainLoopIteration = 0;
    private int mergeLoopIteration = 0;

    public DecompileRecord(StructMethod mt) {
        this.mt = mt;
    }

    public void add(String name, RootStatement root) {
        Object exportName = "";
        if (this.mainLoopIteration > 0) {
            exportName = (String)exportName + "Loop_" + this.mainLoopIteration + "_";
        }
        if (this.mergeLoopIteration > 0) {
            exportName = (String)exportName + "Merge_" + this.mergeLoopIteration + "_";
        }
        exportName = (String)exportName + name;
        this.add((String)exportName);
        DotExporter.toDotFile(root, this.mt, "debug", (String)exportName);
        ValidationHelper.validateStatement(root);
    }

    public void add(String name) {
        this.names.add(name);
    }

    public void incrementMainLoop() {
        ++this.mainLoopIteration;
    }

    public void incrementMergeLoop() {
        ++this.mergeLoopIteration;
    }

    public void resetMainLoop() {
        this.mainLoopIteration = 0;
    }

    public void resetMergeLoop() {
        this.mergeLoopIteration = 0;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void print() {
        for (int i = 0; i < this.names.size(); ++i) {
            System.out.println(i + " " + this.names.get(i));
        }
    }
}

