/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.rels;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.vineflower.java.decompiler.api.plugin.LanguageSpec;
import org.vineflower.java.decompiler.code.cfg.ControlFlowGraph;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.collectors.CounterContainer;
import org.vineflower.java.decompiler.main.collectors.VarNamesCollector;
import org.vineflower.java.decompiler.main.decompiler.CancelationManager;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.rels.DecompileRecord;
import org.vineflower.java.decompiler.main.rels.MethodProcessor;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructMethod;
import org.vineflower.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.util.DotExporter;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.collections.VBStyleCollection;

public class ClassWrapper {
    private static final String DEBUG_METHOD_FILTER = null;
    private final StructClass classStruct;
    private final Set<String> hiddenMembers = new HashSet<String>();
    private final VBStyleCollection<Exprent, String> staticFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<Exprent, String> dynamicFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<MethodWrapper, String> methods = new VBStyleCollection();

    public ClassWrapper(StructClass classStruct) {
        this.classStruct = classStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(LanguageSpec spec) {
        DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS, this.classStruct);
        DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS_WRAPPER, this);
        DecompilerContext.getLogger().startClass(this.classStruct.qualifiedName);
        int maxSec = Integer.parseInt(DecompilerContext.getProperty("max-time-per-method").toString());
        boolean testMode = DecompilerContext.getOption("__unit_test_mode__");
        for (StructMethod mt : this.classStruct.getMethods()) {
            MethodWrapper methodWrapper;
            Throwable error;
            RootStatement root;
            CounterContainer counter;
            VarProcessor varProc;
            block24: {
                DecompilerContext.getLogger().startMethod(mt.getName() + " " + mt.getDescriptor());
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt, null);
                varProc = new VarProcessor(mt, md);
                DecompilerContext.startMethod(varProc);
                VarNamesCollector vc = varProc.getVarNamesCollector();
                counter = DecompilerContext.getCounterContainer();
                root = null;
                error = null;
                if (DEBUG_METHOD_FILTER != null && !DEBUG_METHOD_FILTER.equals(mt.getName())) {
                    methodWrapper = new MethodWrapper(null, varProc, mt, this.classStruct, counter);
                    this.methods.addWithKey(methodWrapper, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                    DecompilerContext.getLogger().endMethod();
                    continue;
                }
                try {
                    if (mt.containsCode()) {
                        if (maxSec == 0 || testMode) {
                            root = MethodProcessor.codeToJava(this.classStruct, mt, md, varProc, spec);
                            break block24;
                        }
                        MethodProcessor mtProc = new MethodProcessor(this.classStruct, mt, md, varProc, spec, DecompilerContext.getCurrentContext());
                        Thread mtThread = new Thread((Runnable)mtProc, "Java decompiler");
                        long stopAt = System.currentTimeMillis() + (long)maxSec * 1000L;
                        mtThread.start();
                        while (!mtProc.isFinished()) {
                            try {
                                Object object = mtProc.lock;
                                synchronized (object) {
                                    mtProc.lock.wait(200L);
                                }
                            }
                            catch (InterruptedException e) {
                                ClassWrapper.killThread(mtThread);
                                throw e;
                            }
                            if (System.currentTimeMillis() < stopAt) continue;
                            String message = "Processing time limit exceeded for method " + mt.getName() + ", execution interrupted.";
                            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR);
                            ClassWrapper.killThread(mtThread);
                            error = new TimeoutException();
                            break;
                        }
                        if (error == null) {
                            root = mtProc.getResult();
                        }
                        break block24;
                    }
                    boolean thisVar = !mt.hasModifier(8);
                    int paramCount = 0;
                    if (thisVar) {
                        varProc.getThisVars().put(new VarVersionPair(0, 0), this.classStruct.qualifiedName);
                        paramCount = 1;
                    }
                    paramCount += md.params.length;
                    int varIndex = 0;
                    for (int i = 0; i < paramCount; ++i) {
                        varProc.setVarName(new VarVersionPair(varIndex, 0), vc.getFreeName(varIndex));
                        varProc.markParam(new VarVersionPair(varIndex, 0));
                        if (thisVar) {
                            if (i == 0) {
                                ++varIndex;
                                continue;
                            }
                            varIndex += md.params[i - 1].stackSize;
                            continue;
                        }
                        varIndex += md.params[i].stackSize;
                    }
                }
                catch (CancelationManager.CanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    DecompileRecord decompileRecord;
                    ControlFlowGraph graph;
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + this.classStruct.qualifiedName + " couldn't be decompiled.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    error = t;
                    RootStatement rootStat = MethodProcessor.debugCurrentlyDecompiling.get();
                    if (rootStat != null) {
                        DotExporter.errorToDotFile(rootStat, mt, "fail");
                        try {
                            DotExporter.errorToDotFile(new FlattenStatementsHelper().buildDirectGraph(rootStat), mt, "failDGraph");
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                    }
                    if ((graph = MethodProcessor.debugCurrentCFG.get()) != null) {
                        DotExporter.errorToDotFile(graph, mt, "failCFG");
                    }
                    if ((decompileRecord = MethodProcessor.debugCurrentDecompileRecord.get()) == null) break block24;
                    DotExporter.toDotFile(decompileRecord, mt, "failRecord", true);
                }
            }
            methodWrapper = new MethodWrapper(root, varProc, mt, this.classStruct, counter);
            methodWrapper.decompileError = error;
            this.methods.addWithKey(methodWrapper, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
            if (error == null) {
                StructLocalVariableTableAttribute attr;
                VarNamesCollector namesCollector = new VarNamesCollector();
                this.classStruct.getFields().forEach(f -> namesCollector.addName(f.getName()));
                varProc.refreshVarNames(namesCollector);
                if (DecompilerContext.getOption("use-lvt-names") && (attr = mt.getLocalVariableAttr()) != null) {
                    varProc.setDebugVarNames(root, attr.getMapNames());
                }
            }
            DecompilerContext.getLogger().endMethod();
        }
        DecompilerContext.getLogger().endClass();
    }

    private static void killThread(Thread thread) {
        thread.stop();
    }

    public MethodWrapper getMethodWrapper(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public MethodWrapper getMethodWrapper(int index) {
        return (MethodWrapper)this.methods.get(index);
    }

    public StructClass getClassStruct() {
        return this.classStruct;
    }

    public VBStyleCollection<MethodWrapper, String> getMethods() {
        return this.methods;
    }

    public Set<String> getHiddenMembers() {
        return this.hiddenMembers;
    }

    public VBStyleCollection<Exprent, String> getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public VBStyleCollection<Exprent, String> getDynamicFieldInitializers() {
        return this.dynamicFieldInitializers;
    }

    public String toString() {
        return this.classStruct.qualifiedName;
    }
}

