/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.vineflower.java.decompiler.api.java.JavaPassLocation;
import org.vineflower.java.decompiler.api.java.JavaPassRegistrar;
import org.vineflower.java.decompiler.api.plugin.LanguageSpec;
import org.vineflower.java.decompiler.api.plugin.Plugin;
import org.vineflower.java.decompiler.api.plugin.PluginOptions;
import org.vineflower.java.decompiler.api.plugin.PluginSource;
import org.vineflower.java.decompiler.api.plugin.pass.NamedPass;
import org.vineflower.java.decompiler.api.plugin.pass.PassContext;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.decompiler.CancelationManager;
import org.vineflower.java.decompiler.main.extern.IVariableNamingFactory;
import org.vineflower.java.decompiler.main.plugins.PluginSources;
import org.vineflower.java.decompiler.struct.StructClass;

public class PluginContext {
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Map<Plugin, PluginSource> bySource = new HashMap<Plugin, PluginSource>();
    private boolean initialized = false;
    private Map<JavaPassLocation, List<NamedPass>> passes = new HashMap<JavaPassLocation, List<NamedPass>>();
    private final Map<Plugin, LanguageSpec> languageSpecs = new HashMap<Plugin, LanguageSpec>();
    private final Set<String> ids = new HashSet<String>();

    public static PluginContext getCurrentContext() {
        return DecompilerContext.getCurrentContext().structContext.getPluginContext();
    }

    private void registerPlugin(Plugin plugin, PluginSource source) {
        this.plugins.add(plugin);
        this.bySource.put(plugin, source);
    }

    public int findPlugins() {
        int pluginCount = 0;
        for (PluginSource source : PluginSources.PLUGIN_SOURCES) {
            for (Plugin plugin : source.findPlugins()) {
                this.registerPlugin(plugin, source);
                ++pluginCount;
            }
        }
        return pluginCount;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        JavaPassRegistrar registrar = new JavaPassRegistrar();
        for (Plugin plugin : this.plugins) {
            String id = plugin.id();
            if (!this.ids.add(id)) {
                throw new IllegalStateException("Duplicate plugin " + plugin.getClass().getName() + " with id " + id);
            }
            plugin.registerJavaPasses(registrar);
            LanguageSpec spec = plugin.getLanguageSpec();
            if (spec != null) {
                this.languageSpecs.put(plugin, spec);
            }
            Map<String, Object> props = DecompilerContext.getCurrentContext().properties;
            PluginOptions opt = plugin.getPluginOptions();
            if (opt == null) continue;
            ((Consumer)opt.provideOptions().b).accept(props::putIfAbsent);
        }
        this.passes = registrar.getPasses();
    }

    public boolean runPasses(JavaPassLocation location, PassContext ctx) {
        List passes = this.passes.getOrDefault((Object)location, Collections.emptyList());
        for (NamedPass pass : passes) {
            CancelationManager.checkCanceled();
            if (!pass.run(ctx) || !location.isLoop()) continue;
            return true;
        }
        return false;
    }

    public LanguageSpec getLanguageSpec(StructClass cl) {
        for (Plugin plugin : this.plugins) {
            LanguageSpec spec = this.languageSpecs.get(plugin);
            if (spec == null || !spec.chooser.isLanguage(cl)) continue;
            return spec;
        }
        return null;
    }

    public IVariableNamingFactory getVariableRenamer() {
        for (Plugin plugin : this.plugins) {
            IVariableNamingFactory factory = plugin.getRenamingFactory();
            if (factory == null) continue;
            return factory;
        }
        return null;
    }

    public PluginSource getSource(Plugin plugin) {
        return this.bySource.get(plugin);
    }

    public List<Plugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }
}

