/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.extern;

import java.util.ArrayList;
import java.util.List;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.struct.gen.FieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.util.token.TextRange;

public abstract class TextTokenVisitor {
    private static final String PROPERTY_NAME = "text_token_visitor";
    public static final TextTokenVisitor EMPTY = new TextTokenVisitor(){};
    private final TextTokenVisitor next;

    public TextTokenVisitor(TextTokenVisitor next) {
        this.next = next;
    }

    private TextTokenVisitor() {
        this.next = null;
    }

    private static List<Factory> getFactories() {
        ArrayList property = (ArrayList)DecompilerContext.getProperty(PROPERTY_NAME);
        if (property == null) {
            property = new ArrayList();
            DecompilerContext.setProperty(PROPERTY_NAME, property);
        }
        return property;
    }

    public static void addVisitor(Factory factory) {
        TextTokenVisitor.getFactories().add(factory);
    }

    private static Factory chainFactories() {
        return TextTokenVisitor.getFactories().stream().reduce(Factory::andThen).orElse(v -> v);
    }

    public static TextTokenVisitor createVisitor() {
        return TextTokenVisitor.chainFactories().create(EMPTY);
    }

    public static TextTokenVisitor createVisitor(Factory factory) {
        return TextTokenVisitor.chainFactories().andThen(factory).create(EMPTY);
    }

    public void start(String content) {
        if (this.next != null) {
            this.next.start(content);
        }
    }

    public void visitClass(TextRange range, boolean declaration, String name) {
        if (this.next != null) {
            this.next.visitClass(range, declaration, name);
        }
    }

    public void visitField(TextRange range, boolean declaration, String className, String name, FieldDescriptor descriptor) {
        if (this.next != null) {
            this.next.visitField(range, declaration, className, name, descriptor);
        }
    }

    public void visitMethod(TextRange range, boolean declaration, String className, String name, MethodDescriptor descriptor) {
        if (this.next != null) {
            this.next.visitMethod(range, declaration, className, name, descriptor);
        }
    }

    public void visitParameter(TextRange range, boolean declaration, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        if (this.next != null) {
            this.next.visitParameter(range, declaration, className, methodName, methodDescriptor, index, name);
        }
    }

    public void visitLocal(TextRange range, boolean declaration, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        if (this.next != null) {
            this.next.visitLocal(range, declaration, className, methodName, methodDescriptor, index, name);
        }
    }

    public void end() {
        if (this.next != null) {
            this.next.end();
        }
    }

    public static interface Factory {
        public TextTokenVisitor create(TextTokenVisitor var1);

        default public Factory andThen(Factory after) {
            return next -> after.create(this.create(next));
        }
    }
}

