/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.extern;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.vineflower.java.decompiler.main.extern.IResultSaver;

public interface IContextSource {
    public static final String CLASS_SUFFIX = ".class";

    public String getName();

    public Entries getEntries();

    default public boolean isLazy() {
        return false;
    }

    default public boolean hasClass(String className) throws IOException {
        return this.getClassBytes(className) != null;
    }

    default public byte[] getClassBytes(String className) throws IOException {
        InputStream is = this.getInputStream(className + CLASS_SUFFIX);
        if (is == null) {
            return null;
        }
        try (InputStream inputStream = is;){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    default public InputStream getInputStream(Entry resource) throws IOException {
        return this.getInputStream(resource.path());
    }

    public InputStream getInputStream(String var1) throws IOException;

    default public IOutputSink createOutputSink(IResultSaver saver) {
        return null;
    }

    public static final class Entry {
        public static final int BASE_VERSION = -1;
        private static final String MULTIRELEASE_PREFIX = "META-INF/versions/";
        private final String basePath;
        private final int multirelease;

        public static Entry parse(String path) {
            if (path.startsWith(MULTIRELEASE_PREFIX)) {
                int nextSlash = path.indexOf(47, MULTIRELEASE_PREFIX.length());
                if (nextSlash == -1) {
                    return new Entry(path, -1);
                }
                String version = path.substring(MULTIRELEASE_PREFIX.length(), nextSlash);
                try {
                    return new Entry(path.substring(nextSlash), Integer.parseInt(version));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new Entry(path, -1);
        }

        public static Entry atBase(String path) {
            return new Entry(path, -1);
        }

        public Entry(String basePath, int multirelease) {
            this.basePath = Objects.requireNonNull(basePath, "basePath");
            if (multirelease != -1 && multirelease < 9) {
                throw new IllegalArgumentException("A multirelease variant must target a Java runtime >= 9");
            }
            this.multirelease = multirelease;
        }

        public String basePath() {
            return this.basePath;
        }

        public int multirelease() {
            return this.multirelease;
        }

        public String path() {
            if (this.multirelease == -1) {
                return this.basePath();
            }
            return MULTIRELEASE_PREFIX + Integer.toString(this.multirelease) + "/" + this.basePath;
        }

        public String toString() {
            return "E[" + this.basePath + "]";
        }
    }

    public static final class Entries {
        public static final Entries EMPTY = new Entries(List.of(), List.of(), List.of(), List.of());
        private final List<Entry> classes;
        private final List<String> directories;
        private final List<Entry> others;
        private final List<IContextSource> childContexts;

        public Entries(List<Entry> classes, List<String> directories, List<Entry> others) {
            this(classes, directories, others, List.of());
        }

        public Entries(List<Entry> classes, List<String> directories, List<Entry> others, List<IContextSource> childContexts) {
            this.classes = List.copyOf(classes);
            this.directories = List.copyOf(directories);
            this.others = List.copyOf(others);
            this.childContexts = List.copyOf(childContexts);
        }

        public List<Entry> classes() {
            return this.classes;
        }

        public List<String> directories() {
            return this.directories;
        }

        public List<Entry> others() {
            return this.others;
        }

        public List<IContextSource> childContexts() {
            return this.childContexts;
        }
    }

    public static interface IOutputSink
    extends AutoCloseable {
        public void begin();

        public void acceptClass(String var1, String var2, String var3, int[] var4);

        public void acceptDirectory(String var1);

        public void acceptOther(String var1);

        @Override
        public void close() throws IOException;
    }
}

