/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.decompiler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.vineflower.java.decompiler.main.extern.IFernflowerPreferences;

public class OptionParser {
    private static final Map<String, String> SHORT_TO_LONG_NAME_MAP = new HashMap<String, String>();
    private static final String[] CUSTOM_CHECKS = new String[]{"-e=", "--add-external=", "-only=", "--only=", "-s", "--silent"};

    public static boolean parse(String arg, Map<String, Object> options) {
        for (String check : CUSTOM_CHECKS) {
            if (!arg.startsWith(check)) continue;
            return false;
        }
        if (!arg.startsWith("--")) {
            OptionParser.parseShort(arg, options);
            return true;
        }
        int index = (arg = arg.substring(2)).indexOf(61);
        if (index == -1) {
            if (arg.startsWith("no-")) {
                options.put(arg.substring(3), "0");
            } else {
                options.put(arg, "1");
            }
        } else {
            String key = arg.substring(0, index);
            String value = arg.substring(index + 1);
            if ("true".equalsIgnoreCase(value)) {
                value = "1";
            } else if ("false".equalsIgnoreCase(value)) {
                value = "0";
            }
            options.put(key, value);
        }
        return true;
    }

    public static void parseShort(String arg, Map<String, Object> options) {
        if (SHORT_TO_LONG_NAME_MAP.isEmpty()) {
            OptionParser.mapShortToLongNames();
        }
        String shortName = arg.substring(1, 4);
        String value = arg.substring(5);
        String longName = SHORT_TO_LONG_NAME_MAP.get(shortName);
        if (longName == null) {
            longName = shortName;
        }
        OptionParser.parse("--" + longName + "=" + value, options);
    }

    private static void mapShortToLongNames() {
        for (Field field : IFernflowerPreferences.class.getDeclaredFields()) {
            IFernflowerPreferences.ShortName shortName = field.getAnnotation(IFernflowerPreferences.ShortName.class);
            if (shortName == null) continue;
            try {
                SHORT_TO_LONG_NAME_MAP.put(shortName.value(), (String)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        SHORT_TO_LONG_NAME_MAP.put("jvn", "jad-style-variable-naming");
        SHORT_TO_LONG_NAME_MAP.put("jpr", "jad-style-parameter-naming");
    }
}

