/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.decompiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.Fernflower;
import org.vineflower.java.decompiler.main.decompiler.CancelationManager;
import org.vineflower.java.decompiler.main.decompiler.ConsoleFileSaver;
import org.vineflower.java.decompiler.main.decompiler.ConsoleHelp;
import org.vineflower.java.decompiler.main.decompiler.DirectoryResultSaver;
import org.vineflower.java.decompiler.main.decompiler.OptionParser;
import org.vineflower.java.decompiler.main.decompiler.PrintStreamLogger;
import org.vineflower.java.decompiler.main.decompiler.SingleFileSaver;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.extern.IResultSaver;
import org.vineflower.java.decompiler.util.InterpreterUtil;
import org.vineflower.java.decompiler.util.ZipFileCache;

public class ConsoleDecompiler
implements IResultSaver,
AutoCloseable {
    private static final Map<String, Object> CONSOLE_DEFAULT_OPTIONS = Map.of("include-runtime", "current");
    private final File root;
    private final Fernflower engine;
    private final Map<String, ZipOutputStream> mapArchiveStreams = new HashMap<String, ZipOutputStream>();
    private final Map<String, Set<String>> mapArchiveEntries = new HashMap<String, Set<String>>();
    private final ZipFileCache openZips = new ZipFileCache();

    public static void main(String[] args) {
        ArrayList<String> params = new ArrayList<String>();
        for (int x = 0; x < args.length; ++x) {
            if (args[x].startsWith("-cfg")) {
                String path = null;
                if (args[x].startsWith("-cfg=")) {
                    path = args[x].substring(5);
                } else if (args.length > x + 1) {
                    path = args[++x];
                } else {
                    System.out.println("Must specify a file when using -cfg argument.");
                    return;
                }
                Path file = Paths.get(path, new String[0]);
                if (!Files.exists(file, new LinkOption[0])) {
                    System.out.println("error: missing config '" + path + "'");
                    return;
                }
                try (Stream<String> stream = Files.lines(file);){
                    stream.forEach(params::add);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("error: Failed to read config file '" + path + "'");
                    throw new RuntimeException(e);
                }
            }
            params.add(args[x]);
        }
        args = params.toArray(new String[params.size()]);
        if (Arrays.stream(args).anyMatch(arg -> arg.equals("-h") || arg.equals("--help") || arg.equals("-help"))) {
            ConsoleHelp.printHelp();
            return;
        }
        if (Arrays.stream(args).anyMatch(arg -> arg.equals("--list-plugins"))) {
            ConsoleHelp.printPlugins();
            return;
        }
        if (args.length < 1) {
            System.out.println("=== Vineflower Decompiler " + ConsoleDecompiler.version() + " ===\n\nUsage: java -jar vineflower.jar --<option>=<value>... <source>... <destination>\nExample: java -jar vineflower.jar --decompile-generics ./MyJar.jar ./out_files\n\nUse -h or --help for more information.");
            return;
        }
        HashMap<String, Object> mapOptions = new HashMap<String, Object>(CONSOLE_DEFAULT_OPTIONS);
        ArrayList sources = new ArrayList();
        ArrayList libraries = new ArrayList();
        HashSet<String> whitelist = new HashSet<String>();
        SaveType userSaveType = null;
        boolean isOption = true;
        int nonOption = 0;
        block20: for (int i = 0; i < args.length; ++i) {
            String arg2;
            switch (arg2 = args[i]) {
                case "--file": {
                    if (userSaveType != null) {
                        throw new RuntimeException("Multiple save types specified");
                    }
                    userSaveType = SaveType.FILE;
                    continue block20;
                }
                case "--folder": {
                    if (userSaveType != null) {
                        throw new RuntimeException("Multiple save types specified");
                    }
                    userSaveType = SaveType.FOLDER;
                    continue block20;
                }
                case "--legacy-saving": {
                    if (userSaveType != null) {
                        throw new RuntimeException("Multiple save types specified");
                    }
                    userSaveType = SaveType.LEGACY_CONSOLEDECOMPILER;
                    continue block20;
                }
                default: {
                    boolean parsed = false;
                    if (isOption && arg2.length() > 5 && arg2.startsWith("-")) {
                        parsed = OptionParser.parse(arg2, mapOptions);
                    }
                    if (parsed) continue block20;
                    if (++nonOption > 1 && i == args.length - 1) break block20;
                    isOption = false;
                    if (arg2.equals("-s") || arg2.equals("--silent")) {
                        mapOptions.put("log-level", "error");
                        continue block20;
                    }
                    if (arg2.startsWith("-e=") || arg2.startsWith("--add-external=")) {
                        ConsoleDecompiler.addPath(libraries, arg2.substring(arg2.indexOf(61) + 1));
                        continue block20;
                    }
                    if (arg2.startsWith("-only=") || arg2.startsWith("--only=")) {
                        whitelist.add(arg2.substring(arg2.indexOf(61) + 1));
                        continue block20;
                    }
                    ConsoleDecompiler.addPath(sources, arg2);
                }
            }
        }
        if (sources.isEmpty()) {
            System.out.println("error: no sources given");
            return;
        }
        SaveType saveType = SaveType.CONSOLE;
        File destination = new File(".");
        if (nonOption > 1) {
            String name = args[args.length - 1];
            saveType = SaveType.FOLDER;
            destination = new File(name);
            if (userSaveType == null) {
                if (destination.getName().contains(".zip") || destination.getName().contains(".jar")) {
                    saveType = SaveType.FILE;
                    if (destination.getParentFile() != null) {
                        destination.getParentFile().mkdirs();
                    }
                } else {
                    destination.mkdirs();
                }
            } else {
                saveType = userSaveType;
            }
        }
        PrintStreamLogger logger = new PrintStreamLogger(System.out);
        ConsoleDecompiler decompiler = new ConsoleDecompiler(destination, mapOptions, logger, saveType);
        for (File library : libraries) {
            decompiler.addLibrary(library);
        }
        for (File source : sources) {
            decompiler.addSource(source);
        }
        for (String prefix : whitelist) {
            decompiler.addWhitelist(prefix);
        }
        try {
            decompiler.decompileContext();
        }
        catch (CancelationManager.CanceledException e) {
            System.out.println("Decompilation canceled");
        }
    }

    private static void addPath(List<? super File> list, String path) {
        File file = new File(path);
        if (file.exists()) {
            list.add(file);
        } else {
            System.out.println("warn: missing '" + path + "', ignored");
        }
    }

    protected ConsoleDecompiler(File destination, Map<String, Object> options, IFernflowerLogger logger) {
        this(destination, options, logger, destination.isDirectory() ? SaveType.LEGACY_CONSOLEDECOMPILER : SaveType.FILE);
    }

    protected ConsoleDecompiler(File destination, Map<String, Object> options, IFernflowerLogger logger, SaveType saveType) {
        this.root = destination;
        this.engine = new Fernflower(saveType == SaveType.LEGACY_CONSOLEDECOMPILER ? this : saveType.getSaver().apply(destination), options, logger);
    }

    public void addSource(File source) {
        this.engine.addSource(source);
    }

    public void addLibrary(File library) {
        this.engine.addLibrary(library);
    }

    public void addLibrary(IContextSource source) {
        this.engine.addLibrary(source);
    }

    public void addWhitelist(String prefix) {
        this.engine.addWhitelist(prefix);
    }

    public void decompileContext() {
        try {
            this.engine.decompileContext();
        }
        finally {
            this.engine.clearContext();
        }
    }

    @Deprecated
    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
        if (internalPath == null) {
            File file = new File(externalPath);
            return InterpreterUtil.getBytes(file);
        }
        ZipFile archive = this.openZips.get(externalPath);
        ZipEntry entry = archive.getEntry(internalPath);
        if (entry == null) {
            throw new IOException("Entry not found: " + internalPath);
        }
        return InterpreterUtil.getBytes(archive, entry);
    }

    private String getAbsolutePath(String path) {
        return new File(this.root, path).getAbsolutePath();
    }

    @Override
    public void saveFolder(String path) {
        File dir = new File(this.getAbsolutePath(path));
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new RuntimeException("Cannot create directory " + String.valueOf(dir));
        }
    }

    @Override
    public void copyFile(String source, String path, String entryName) {
        try {
            InterpreterUtil.copyFile(new File(source), new File(this.getAbsolutePath(path), entryName));
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot copy " + source + " to " + entryName, ex);
        }
    }

    @Override
    public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
        File file = new File(this.getAbsolutePath(path), entryName);
        if (content != null) {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                out.write(content);
            }
            catch (IOException ex) {
                DecompilerContext.getLogger().writeMessage("Cannot write class file " + String.valueOf(file), ex);
            }
        } else {
            DecompilerContext.getLogger().writeMessage("Attempted to write null class file to " + String.valueOf(file), IFernflowerLogger.Severity.WARN);
        }
    }

    @Override
    public void createArchive(String path, String archiveName, Manifest manifest) {
        File file = new File(this.getAbsolutePath(path), archiveName);
        try {
            if (!file.createNewFile() && !file.isFile()) {
                throw new IOException("Cannot create file " + String.valueOf(file));
            }
            FileOutputStream fileStream = new FileOutputStream(file);
            ZipOutputStream zipStream = manifest != null ? new JarOutputStream((OutputStream)fileStream, manifest) : new ZipOutputStream(fileStream);
            this.mapArchiveStreams.put(file.getPath(), zipStream);
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot create archive " + String.valueOf(file), ex);
        }
    }

    @Override
    public void saveDirEntry(String path, String archiveName, String entryName) {
        if (((String)entryName).lastIndexOf(47) != ((String)entryName).length() - 1) {
            entryName = (String)entryName + "/";
        }
        this.saveClassEntry(path, archiveName, null, (String)entryName, null);
    }

    @Override
    public void copyEntry(String source, String path, String archiveName, String entryName) {
        block9: {
            String file = new File(this.getAbsolutePath(path), archiveName).getPath();
            if (!this.checkEntry(entryName, file)) {
                return;
            }
            try {
                ZipFile srcArchive = this.openZips.get(source);
                ZipEntry entry = srcArchive.getEntry(entryName);
                if (entry == null) break block9;
                try (InputStream in = srcArchive.getInputStream(entry);){
                    ZipOutputStream out = this.mapArchiveStreams.get(file);
                    out.putNextEntry(new ZipEntry(entryName));
                    InterpreterUtil.copyStream(in, out);
                }
            }
            catch (IOException ex) {
                String message = "Cannot copy entry " + entryName + " from " + source + " to " + file;
                DecompilerContext.getLogger().writeMessage(message, ex);
            }
        }
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        this.saveClassEntry(path, archiveName, qualifiedName, entryName, content, null);
    }

    @Override
    public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content, int[] mapping) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        if (!this.checkEntry(entryName, file)) {
            return;
        }
        try {
            ZipOutputStream out = this.mapArchiveStreams.get(file);
            ZipEntry entry = new ZipEntry(entryName);
            if (mapping != null && DecompilerContext.getOption("dump-code-lines")) {
                entry.setExtra(this.getCodeLineData(mapping));
            }
            out.putNextEntry(entry);
            if (content != null) {
                out.write(content.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException ex) {
            String message = "Cannot write entry " + entryName + " to " + file;
            DecompilerContext.getLogger().writeMessage(message, ex);
        }
    }

    private boolean checkEntry(String entryName, String file) {
        Set set = this.mapArchiveEntries.computeIfAbsent(file, k -> new HashSet());
        boolean added = set.add(entryName);
        if (!added) {
            String message = "Zip entry " + entryName + " already exists in " + file;
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
        }
        return added;
    }

    @Override
    public void closeArchive(String path, String archiveName) {
        String file = new File(this.getAbsolutePath(path), archiveName).getPath();
        try {
            this.mapArchiveEntries.remove(file);
            ZipOutputStream removed = this.mapArchiveStreams.remove(file);
            if (removed != null) {
                removed.close();
            }
        }
        catch (IOException ex) {
            DecompilerContext.getLogger().writeMessage("Cannot close " + file, IFernflowerLogger.Severity.WARN);
        }
    }

    @Override
    public void close() throws IOException {
        this.openZips.close();
    }

    public static String version() {
        String ver = ConsoleDecompiler.class.getPackage().getImplementationVersion();
        return ver == null ? "<UNK>" : ver;
    }

    public static enum SaveType {
        LEGACY_CONSOLEDECOMPILER(null),
        FOLDER(DirectoryResultSaver::new),
        FILE(SingleFileSaver::new),
        CONSOLE(ConsoleFileSaver::new);

        private final Function<File, IResultSaver> saver;

        private SaveType(Function<File, IResultSaver> saver) {
            this.saver = saver;
        }

        public Function<File, IResultSaver> getSaver() {
            return this.saver;
        }
    }
}

