/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main.collectors;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vineflower.java.decompiler.struct.attr.StructLineNumberTableAttribute;

public class BytecodeMappingTracer {
    public static final BytecodeMappingTracer DUMMY = new BytecodeMappingTracer();
    private int currentSourceLine;
    private StructLineNumberTableAttribute lineNumberTable = null;
    private final Map<Integer, Integer> mapping = new HashMap<Integer, Integer>();
    private final Set<Integer> unmappedLines = new HashSet<Integer>();

    public BytecodeMappingTracer() {
    }

    public BytecodeMappingTracer(int initial_source_line) {
        this.currentSourceLine = initial_source_line;
    }

    public void incrementCurrentSourceLine() {
        ++this.currentSourceLine;
    }

    public void incrementCurrentSourceLine(int number_lines) {
        this.currentSourceLine += number_lines;
    }

    public void addMapping(int bytecode_offset) {
        this.mapping.putIfAbsent(bytecode_offset, this.currentSourceLine);
    }

    public void addMapping(BitSet bytecode_offsets) {
        if (bytecode_offsets != null) {
            int i = bytecode_offsets.nextSetBit(0);
            while (i >= 0) {
                this.addMapping(i);
                i = bytecode_offsets.nextSetBit(i + 1);
            }
        }
    }

    public void addTracer(BytecodeMappingTracer tracer) {
        if (tracer != null) {
            for (Map.Entry<Integer, Integer> entry : tracer.mapping.entrySet()) {
                this.mapping.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<Integer, Integer> getMapping() {
        return this.mapping;
    }

    public int getCurrentSourceLine() {
        return this.currentSourceLine;
    }

    public void setCurrentSourceLine(int currentSourceLine) {
        this.currentSourceLine = currentSourceLine;
    }

    public void setLineNumberTable(StructLineNumberTableAttribute lineNumberTable) {
        this.lineNumberTable = lineNumberTable;
    }

    public Set<Integer> getUnmappedLines() {
        return this.unmappedLines;
    }

    public Map<Integer, Integer> getOriginalLinesMapping() {
        int originalLine;
        if (this.lineNumberTable == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> res = new HashMap<Integer, Integer>();
        int[] data = this.lineNumberTable.getRawData();
        for (int i = 0; i < data.length; i += 2) {
            int originalOffset = data[i];
            originalLine = data[i + 1];
            Integer newLine = this.mapping.get(originalOffset);
            if (newLine != null) {
                res.put(originalLine, newLine);
                continue;
            }
            this.unmappedLines.add(originalLine);
        }
        for (Map.Entry<Integer, Integer> entry : this.mapping.entrySet()) {
            originalLine = this.lineNumberTable.findLineNumber(entry.getKey());
            if (originalLine <= -1 || res.containsKey(originalLine)) continue;
            res.put(originalLine, entry.getValue());
            this.unmappedLines.remove(originalLine);
        }
        return res;
    }
}

