/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.decompiler.CancelationManager;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.rels.ClassWrapper;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.NewExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.VarExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statements;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.StructMethod;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.util.InterpreterUtil;

public final class InitializerProcessor {
    public static void extractInitializers(ClassWrapper wrapper) {
        MethodWrapper method = wrapper.getMethodWrapper("<clinit>", "()V");
        try {
            if (method != null && method.root != null) {
                InitializerProcessor.extractStaticInitializers(wrapper, method);
            }
        }
        catch (CancelationManager.CanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            StructMethod mt = method.methodStruct;
            String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + wrapper.getClassStruct().qualifiedName + " couldn't be written.";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
            method.decompileError = t;
        }
        InitializerProcessor.extractDynamicInitializers(wrapper);
        InitializerProcessor.liftConstructor(wrapper);
        if (DecompilerContext.getOption("hide-empty-super")) {
            InitializerProcessor.hideEmptySuper(wrapper);
        }
    }

    private static void liftConstructor(ClassWrapper wrapper) {
        block0: for (MethodWrapper method : wrapper.getMethods()) {
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null) {
                return;
            }
            int index = 0;
            List<Exprent> lstExprents = firstData.getExprents();
            for (Exprent exprent : lstExprents) {
                int action = 0;
                if (exprent instanceof AssignmentExprent) {
                    StructField structField;
                    FieldExprent fExpr;
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft() instanceof FieldExprent && assignExpr.getRight() instanceof VarExprent && (fExpr = (FieldExprent)assignExpr.getLeft()).getClassname().equals(wrapper.getClassStruct().qualifiedName) && (structField = wrapper.getClassStruct().getField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) != null && structField.hasModifier(16)) {
                        action = 1;
                    }
                } else if (index > 0 && exprent instanceof InvocationExprent && Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, true)) {
                    lstExprents.add(0, lstExprents.remove(index));
                    action = 2;
                }
                if (action != 1) continue block0;
                ++index;
            }
        }
    }

    private static void hideEmptySuper(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invExpr;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null) continue;
            Statement firstData = Statements.findFirstData(method.root);
            if (firstData == null || firstData.getExprents().isEmpty()) {
                return;
            }
            Exprent exprent = firstData.getExprents().get(0);
            if (!(exprent instanceof InvocationExprent) || !Statements.isInvocationInitConstructor(invExpr = (InvocationExprent)exprent, method, wrapper, false)) continue;
            List<VarVersionPair> mask = ExprUtil.getSyntheticParametersMask(invExpr.getClassname(), invExpr.getStringDescriptor(), invExpr.getLstParameters().size());
            boolean hideSuper = true;
            for (int i = 0; i < invExpr.getDescriptor().params.length; ++i) {
                ClassesProcessor.ClassNode node;
                if (mask != null && mask.get(i) != null) continue;
                VarType type = invExpr.getDescriptor().params[i];
                if (type.type == CodeType.OBJECT && (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.value)) != null && (node.type == ClassesProcessor.ClassNode.Type.ANONYMOUS || (node.access & 0x1000) != 0)) break;
                hideSuper = false;
                break;
            }
            if (!hideSuper) continue;
            firstData.getExprents().remove(0);
        }
    }

    public static void hideInitalizers(ClassWrapper wrapper) {
        for (MethodWrapper method : wrapper.getMethods()) {
            ClassesProcessor.ClassNode node;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String desc = mt.getDescriptor();
            if (!mt.isSynthetic() || !"<init>".equals(name)) continue;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(desc);
            if (md.params.length <= 0) continue;
            VarType type = md.params[md.params.length - 1];
            if (type.type != CodeType.OBJECT || (node = DecompilerContext.getClassProcessor().getMapRootClasses().get(type.value)) == null || node.type != ClassesProcessor.ClassNode.Type.ANONYMOUS && (node.access & 0x1000) == 0) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, desc));
        }
    }

    private static void extractStaticInitializers(ClassWrapper wrapper, MethodWrapper method) {
        RootStatement root = method.root;
        StructClass cl = wrapper.getClassStruct();
        HashSet<String> whitelist = new HashSet<String>();
        Statement firstData = Statements.findFirstData(root);
        if (firstData != null) {
            boolean inlineInitializers = cl.hasModifier(512) || cl.hasModifier(16384);
            LinkedList<AssignmentExprent> exprentsToRemove = new LinkedList<AssignmentExprent>();
            HashMap<Integer, AssignmentExprent> nonFieldAssigns = new HashMap<Integer, AssignmentExprent>();
            ArrayList<String> seen = new ArrayList<String>();
            ArrayList<String> multiAssign = new ArrayList<String>();
            for (Exprent exprent : firstData.getExprents()) {
                AssignmentExprent assignExpr;
                if (!(exprent instanceof AssignmentExprent) || !((assignExpr = (AssignmentExprent)exprent).getLeft() instanceof FieldExprent)) continue;
                FieldExprent fExpr = (FieldExprent)assignExpr.getLeft();
                String name = fExpr.getName();
                if (seen.contains(name)) {
                    if (multiAssign.contains(name)) continue;
                    multiAssign.add(name);
                    continue;
                }
                seen.add(name);
            }
            ArrayList<FieldExprent> notInlined = new ArrayList<FieldExprent>();
            Iterator<Exprent> itr = firstData.getExprents().iterator();
            while (itr.hasNext()) {
                Exprent exprent = itr.next();
                if (exprent instanceof AssignmentExprent) {
                    AssignmentExprent assignExpr = (AssignmentExprent)exprent;
                    if (assignExpr.getLeft() instanceof FieldExprent) {
                        FieldExprent fExpr = (FieldExprent)assignExpr.getLeft();
                        if (!fExpr.isStatic() || !fExpr.getClassname().equals(cl.qualifiedName) || !cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) continue;
                        String keyField = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                        boolean exprentIndependent = InitializerProcessor.isExprentIndependent(fExpr, assignExpr.getRight(), method, cl, whitelist, multiAssign, notInlined, cl.getFields().getIndexByKey(keyField), true);
                        if (inlineInitializers || exprentIndependent) {
                            Exprent instance;
                            NewExprent newExprent;
                            if (wrapper.getStaticFieldInitializers().containsKey(keyField)) continue;
                            if (exprentIndependent) {
                                wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                                whitelist.add(keyField);
                                itr.remove();
                                continue;
                            }
                            if (!(assignExpr.getRight() instanceof NewExprent) || (newExprent = (NewExprent)assignExpr.getRight()).getConstructor() == null || !((instance = newExprent.getConstructor().getInstance()) instanceof VarExprent) || !nonFieldAssigns.containsKey(((VarExprent)instance).getIndex())) continue;
                            AssignmentExprent nonFieldAssignment = (AssignmentExprent)nonFieldAssigns.remove(((VarExprent)instance).getIndex());
                            newExprent.getConstructor().setInstance(nonFieldAssignment.getRight());
                            exprentsToRemove.add(nonFieldAssignment);
                            wrapper.getStaticFieldInitializers().addWithKey(assignExpr.getRight(), keyField);
                            whitelist.add(keyField);
                            itr.remove();
                            continue;
                        }
                        notInlined.add(fExpr);
                        continue;
                    }
                    if (!inlineInitializers || !(assignExpr.getLeft() instanceof VarExprent)) continue;
                    nonFieldAssigns.put(((VarExprent)assignExpr.getLeft()).getIndex(), assignExpr);
                    continue;
                }
                if (inlineInitializers && !cl.hasModifier(512)) continue;
            }
            if (exprentsToRemove.size() > 0) {
                firstData.getExprents().removeAll(exprentsToRemove);
            }
        }
        if (cl.hasModifier(16384)) {
            for (StructField fd : cl.getFields()) {
                if (!fd.hasModifier(16384) || wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) != null) continue;
                method.addComment("$VF: Failed to inline enum fields");
                method.addErrorComment = true;
                break;
            }
        }
    }

    private static void extractDynamicInitializers(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        boolean isAnonymous = DecompilerContext.getClassProcessor().getMapRootClasses().get((Object)cl.qualifiedName).type == ClassesProcessor.ClassNode.Type.ANONYMOUS;
        ArrayList<List<Exprent>> lstFirst = new ArrayList<List<Exprent>>();
        ArrayList<MethodWrapper> lstMethodWrappers = new ArrayList<MethodWrapper>();
        for (MethodWrapper method : wrapper.getMethods()) {
            Statement firstData;
            if (!"<init>".equals(method.methodStruct.getName()) || method.root == null || (firstData = Statements.findFirstData(method.root)) == null || firstData.getExprents().isEmpty()) continue;
            Exprent exprent = firstData.getExprents().get(0);
            if (!isAnonymous && (!(exprent instanceof InvocationExprent) || !Statements.isInvocationInitConstructor((InvocationExprent)exprent, method, wrapper, false))) continue;
            lstFirst.add(firstData.getExprents());
            lstMethodWrappers.add(method);
        }
        if (lstFirst.isEmpty()) {
            return;
        }
        HashSet<String> whitelist = new HashSet<String>(wrapper.getStaticFieldInitializers().getLstKeys());
        int prev_fidx = 0;
        block1: while (true) {
            List lst;
            String fieldWithDescr = null;
            Exprent value = null;
            for (int i = 0; i < lstFirst.size(); ++i) {
                FieldExprent fExpr;
                AssignmentExprent assignExpr;
                lst = (List)lstFirst.get(i);
                if (lst.size() < (isAnonymous ? 1 : 2)) {
                    return;
                }
                Exprent exprent = (Exprent)lst.get(isAnonymous ? 0 : 1);
                boolean found = false;
                if (exprent instanceof AssignmentExprent && (assignExpr = (AssignmentExprent)exprent).getLeft() instanceof FieldExprent && !(fExpr = (FieldExprent)assignExpr.getLeft()).isStatic() && fExpr.getClassname().equals(cl.qualifiedName) && cl.hasField(fExpr.getName(), fExpr.getDescriptor().descriptorString)) {
                    String fieldKey = InterpreterUtil.makeUniqueKey(fExpr.getName(), fExpr.getDescriptor().descriptorString);
                    int fidx = cl.getFields().getIndexByKey(fieldKey);
                    if (prev_fidx <= fidx && InitializerProcessor.isExprentIndependent(fExpr, assignExpr.getRight(), (MethodWrapper)lstMethodWrappers.get(i), cl, whitelist, new ArrayList<String>(), new ArrayList<FieldExprent>(), fidx, false)) {
                        prev_fidx = fidx;
                        if (fieldWithDescr == null) {
                            fieldWithDescr = fieldKey;
                            value = assignExpr.getRight();
                        } else if (!fieldWithDescr.equals(fieldKey) || !value.equals(assignExpr.getRight())) {
                            return;
                        }
                        found = true;
                    }
                }
                if (found) continue;
                return;
            }
            if (wrapper.getDynamicFieldInitializers().containsKey(fieldWithDescr)) break;
            value = InitializerProcessor.processDynamicInitializer(value);
            wrapper.getDynamicFieldInitializers().addWithKey(value, fieldWithDescr);
            whitelist.add(fieldWithDescr);
            Iterator iterator = lstFirst.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                lst = (List)iterator.next();
                lst.remove(isAnonymous ? 0 : 1);
            }
            break;
        }
    }

    private static Exprent processDynamicInitializer(Exprent expr) {
        if (expr instanceof FunctionExprent) {
            Exprent temp = expr;
            while (temp instanceof FunctionExprent && (((FunctionExprent)temp).getFuncType().castType != null || ((FunctionExprent)temp).getFuncType() == FunctionExprent.FunctionType.CAST)) {
                temp = ((FunctionExprent)temp).getLstOperands().get(0);
            }
            if (temp instanceof FunctionExprent) {
                FunctionExprent func = (FunctionExprent)temp;
                func.unwrapBox();
                expr = func;
            }
        } else {
            expr = InitializerProcessor.processBoxingCast(expr);
        }
        return expr;
    }

    private static Exprent processBoxingCast(Exprent expr) {
        Exprent inner;
        if (expr instanceof InvocationExprent && ((InvocationExprent)expr).isUnboxingCall() && (inner = ((InvocationExprent)expr).getInstance()) instanceof FunctionExprent && ((FunctionExprent)inner).getFuncType() == FunctionExprent.FunctionType.CAST) {
            inner.addBytecodeOffsets(expr.bytecode);
            expr = inner;
        }
        return expr;
    }

    private static boolean isExprentIndependent(FieldExprent field, Exprent exprent, MethodWrapper method, StructClass cl, Set<String> whitelist, List<String> multiAssign, List<FieldExprent> notInlined, int fidx, boolean isStatic) {
        String keyField = InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor().descriptorString);
        List<Exprent> lst = exprent.getAllExprents(true, true);
        block5: for (Exprent expr : lst) {
            switch (expr.type) {
                case VAR: {
                    VarVersionPair varPair = new VarVersionPair((VarExprent)expr);
                    if (method.varproc.getExternalVars().contains(varPair)) break;
                    String varName = method.varproc.getVarName(varPair);
                    if (varName != null && (varName.equals("this") || varName.endsWith(".this"))) continue block5;
                    return false;
                }
                case FIELD: {
                    FieldExprent fexpr = (FieldExprent)expr;
                    if (notInlined.contains(fexpr)) {
                        return false;
                    }
                    if (cl.hasField(fexpr.getName(), fexpr.getDescriptor().descriptorString)) {
                        String key = InterpreterUtil.makeUniqueKey(fexpr.getName(), fexpr.getDescriptor().descriptorString);
                        if (isStatic) {
                            if (multiAssign.contains(fexpr.getName())) {
                                return false;
                            }
                            if (!fexpr.isStatic()) {
                                return false;
                            }
                            if (cl.getFields().getIndexByKey(key) < fidx) continue block5;
                            fexpr.forceQualified(true);
                            break;
                        }
                        if (!whitelist.contains(key)) {
                            return false;
                        }
                        if (cl.getFields().getIndexByKey(key) <= fidx) continue block5;
                        return false;
                    }
                    if (fexpr.isStatic() || fexpr.getInstance() != null) break;
                    return false;
                }
                case NEW: {
                    InitializerProcessor.qualifyFieldReferences((NewExprent)expr, cl, fidx);
                }
            }
        }
        return true;
    }

    private static void qualifyFieldReferences(NewExprent nexpr, StructClass cl, int fidx) {
        boolean isStatic = ((StructField)cl.getFields().get(fidx)).hasModifier(8);
        if (isStatic && nexpr.isLambda() && !nexpr.isMethodReference()) {
            ClassesProcessor.ClassNode child = DecompilerContext.getClassProcessor().getMapRootClasses().get(nexpr.getNewType().value);
            MethodWrapper wrapper = child.parent.getWrapper().getMethods().getWithKey(child.lambdaInformation.content_method_key);
            HashSet s = new HashSet();
            wrapper.getOrBuildGraph().iterateExprentsDeep(e -> {
                if (e instanceof FieldExprent || e instanceof NewExprent) {
                    s.add(e);
                }
                return 0;
            });
            block4: for (Exprent e2 : s) {
                switch (e2.type) {
                    case FIELD: {
                        FieldExprent fe = (FieldExprent)e2;
                        if (!cl.qualifiedName.equals(fe.getClassname()) || !fe.isStatic() || !cl.hasField(fe.getName(), fe.getDescriptor().descriptorString)) break;
                        String key = InterpreterUtil.makeUniqueKey(fe.getName(), fe.getDescriptor().descriptorString);
                        if (fe.getInstance() != null || cl.getFields().getIndexByKey(key) <= fidx) continue block4;
                        fe.forceQualified(true);
                        break;
                    }
                    case NEW: {
                        InitializerProcessor.qualifyFieldReferences((NewExprent)e2, cl, fidx);
                    }
                }
            }
        }
    }
}

