/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main;

import org.vineflower.java.decompiler.main.rels.ClassWrapper;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statements;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.StructMethod;
import org.vineflower.java.decompiler.util.InterpreterUtil;

public final class EnumProcessor {
    public static void clearEnum(ClassWrapper wrapper) {
        StructClass cl = wrapper.getClassStruct();
        for (MethodWrapper method : wrapper.getMethods()) {
            InvocationExprent invExpr;
            Exprent exprent;
            Statement firstData;
            StructMethod mt = method.methodStruct;
            String name = mt.getName();
            String descriptor = mt.getDescriptor();
            if ("values".equals(name)) {
                if (!descriptor.equals("()[L" + cl.qualifiedName + ";")) continue;
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, descriptor));
                continue;
            }
            if ("valueOf".equals(name)) {
                if (!descriptor.equals("(Ljava/lang/String;)L" + cl.qualifiedName + ";")) continue;
                wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(name, descriptor));
                continue;
            }
            if (!"<init>".equals(name) || (firstData = Statements.findFirstData(method.root)) == null || firstData.getExprents().isEmpty() || !((exprent = firstData.getExprents().get(0)) instanceof InvocationExprent) || !Statements.isInvocationInitConstructor(invExpr = (InvocationExprent)exprent, method, wrapper, false)) continue;
            firstData.getExprents().remove(0);
        }
        for (StructField fd : cl.getFields()) {
            String descriptor = fd.getDescriptor();
            if (!fd.isSynthetic() || !descriptor.equals("[L" + cl.qualifiedName + ";")) continue;
            wrapper.getHiddenMembers().add(InterpreterUtil.makeUniqueKey(fd.getName(), descriptor));
        }
    }
}

