/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.vineflower.annotations.Nullable;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.vineflower.java.decompiler.main.collectors.CounterContainer;
import org.vineflower.java.decompiler.main.collectors.ImportCollector;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.extern.IVariableNamingFactory;
import org.vineflower.java.decompiler.main.rels.ClassWrapper;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.vineflower.java.decompiler.modules.renamer.PoolInterceptor;
import org.vineflower.java.decompiler.struct.StructClass;
import org.vineflower.java.decompiler.struct.StructContext;
import org.vineflower.java.decompiler.util.Key;

public class DecompilerContext {
    public static final Key<StructClass> CURRENT_CLASS = Key.of("CURRENT_CLASS");
    public static final Key<ClassWrapper> CURRENT_CLASS_WRAPPER = Key.of("CURRENT_CLASS_WRAPPER");
    public static final Key<ClassesProcessor.ClassNode> CURRENT_CLASS_NODE = Key.of("CURRENT_CLASS_NODE");
    public static final Key<MethodWrapper> CURRENT_METHOD_WRAPPER = Key.of("CURRENT_METHOD_WRAPPER");
    public static final Key<VarProcessor> CURRENT_VAR_PROCESSOR = Key.of("CURRENT_VAR_PROCESSOR");
    public final Map<Key<?>, Object> staticProps = new HashMap();
    public final Map<String, Object> properties;
    public final IFernflowerLogger logger;
    public final StructContext structContext;
    public final ClassesProcessor classProcessor;
    public final PoolInterceptor poolInterceptor;
    public IVariableNamingFactory renamerFactory;
    private ImportCollector importCollector;
    private VarProcessor varProcessor;
    private CounterContainer counterContainer;
    private BytecodeSourceMapper bytecodeSourceMapper;
    private static final ThreadLocal<DecompilerContext> currentContext = new ThreadLocal();

    public DecompilerContext(Map<String, Object> properties, IFernflowerLogger logger, StructContext structContext, ClassesProcessor classProcessor, PoolInterceptor interceptor) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(structContext);
        Objects.requireNonNull(classProcessor);
        this.properties = properties;
        this.logger = logger;
        this.structContext = structContext;
        this.classProcessor = classProcessor;
        this.poolInterceptor = interceptor;
        this.counterContainer = new CounterContainer();
    }

    public static DecompilerContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(DecompilerContext context) {
        if (context == null) {
            currentContext.remove();
        } else {
            currentContext.set(context);
        }
    }

    public static <T> void setProperty(Key<T> key, T value) {
        DecompilerContext.getCurrentContext().staticProps.put(key, value);
    }

    public static void setProperty(String key, Object value) {
        DecompilerContext.getCurrentContext().properties.put(key, value);
    }

    public static void startClass(ImportCollector importCollector) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.importCollector = importCollector;
        context.counterContainer = new CounterContainer();
        context.bytecodeSourceMapper = new BytecodeSourceMapper();
    }

    public static void startMethod(VarProcessor varProcessor) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.varProcessor = varProcessor;
        context.counterContainer = new CounterContainer();
    }

    public static void setImportCollector(ImportCollector importCollector) {
        DecompilerContext.getCurrentContext().importCollector = importCollector;
    }

    @Nullable
    public static <T> T getContextProperty(Key<T> key) {
        return (T)DecompilerContext.getCurrentContext().staticProps.get(key);
    }

    public static Object getProperty(String key) {
        return DecompilerContext.getCurrentContext().properties.get(key);
    }

    public static boolean getOption(String key) {
        return "1".equals(DecompilerContext.getProperty(key));
    }

    public static int getIntOption(String key) {
        try {
            return Integer.parseInt((String)DecompilerContext.getProperty(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String getNewLineSeparator() {
        return DecompilerContext.getOption("new-line-separator") ? "\n" : "\r\n";
    }

    public static IFernflowerLogger getLogger() {
        return DecompilerContext.getCurrentContext().logger;
    }

    public static StructContext getStructContext() {
        return DecompilerContext.getCurrentContext().structContext;
    }

    public static ClassesProcessor getClassProcessor() {
        return DecompilerContext.getCurrentContext().classProcessor;
    }

    public static PoolInterceptor getPoolInterceptor() {
        return DecompilerContext.getCurrentContext().poolInterceptor;
    }

    public static IVariableNamingFactory getNamingFactory() {
        return DecompilerContext.getCurrentContext().renamerFactory;
    }

    public static ImportCollector getImportCollector() {
        return DecompilerContext.getCurrentContext().importCollector;
    }

    public static VarProcessor getVarProcessor() {
        return DecompilerContext.getCurrentContext().varProcessor;
    }

    public static CounterContainer getCounterContainer() {
        return DecompilerContext.getCurrentContext().counterContainer;
    }

    public static BytecodeSourceMapper getBytecodeSourceMapper() {
        return DecompilerContext.getCurrentContext().bytecodeSourceMapper;
    }
}

