/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.vineflower.java.decompiler.main.ClassesProcessor;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.rels.ClassWrapper;
import org.vineflower.java.decompiler.main.rels.MethodWrapper;
import org.vineflower.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.vineflower.java.decompiler.modules.decompiler.StatEdge;
import org.vineflower.java.decompiler.modules.decompiler.exps.AssertExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.Exprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.vineflower.java.decompiler.modules.decompiler.exps.NewExprent;
import org.vineflower.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.IfStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.RootStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.vineflower.java.decompiler.modules.decompiler.stats.Statement;
import org.vineflower.java.decompiler.struct.StructField;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.FieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.util.InterpreterUtil;

public final class AssertProcessor {
    private static final VarType CLASS_ASSERTION_ERROR = new VarType(CodeType.OBJECT, 0, "java/lang/AssertionError");

    public static void buildAssertions(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        StructField field = AssertProcessor.findAssertionField(node);
        if (field != null) {
            String key = InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor());
            boolean res = false;
            for (MethodWrapper meth : wrapper.getMethods()) {
                RootStatement root = meth.root;
                if (root == null) continue;
                res |= AssertProcessor.replaceAssertions(root, wrapper.getClassStruct().qualifiedName, key);
            }
            if (res) {
                wrapper.getHiddenMembers().add(key);
            }
        }
    }

    private static StructField findAssertionField(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        boolean noSynthFlag = DecompilerContext.getOption("synthetic-not-set");
        for (StructField fd : wrapper.getClassStruct().getFields()) {
            ConstExprent cexpr;
            InvocationExprent invexpr;
            FunctionExprent fexpr;
            Exprent initializer;
            String keyField = InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor());
            if (!wrapper.getStaticFieldInitializers().containsKey(keyField) || !fd.hasModifier(8) || !fd.hasModifier(16) || !noSynthFlag && !fd.isSynthetic()) continue;
            FieldDescriptor fdescr = FieldDescriptor.parseDescriptor(fd.getDescriptor());
            if (!VarType.VARTYPE_BOOLEAN.equals(fdescr.type) || !((initializer = wrapper.getStaticFieldInitializers().getWithKey(keyField)) instanceof FunctionExprent) || (fexpr = (FunctionExprent)initializer).getFuncType() != FunctionExprent.FunctionType.BOOL_NOT || !(fexpr.getLstOperands().get(0) instanceof InvocationExprent) || (invexpr = (InvocationExprent)fexpr.getLstOperands().get(0)).getInstance() == null || !(invexpr.getInstance() instanceof ConstExprent) || !"desiredAssertionStatus".equals(invexpr.getName()) || !"java/lang/Class".equals(invexpr.getClassname()) || !invexpr.getLstParameters().isEmpty() || !VarType.VARTYPE_CLASS.equals((cexpr = (ConstExprent)invexpr.getInstance()).getConstType())) continue;
            ClassesProcessor.ClassNode nd = node;
            while (nd != null && !nd.getWrapper().getClassStruct().qualifiedName.equals(cexpr.getValue())) {
                nd = nd.parent;
            }
            if (nd == null) continue;
            return fd;
        }
        return null;
    }

    private static boolean replaceAssertions(Statement statement, String classname, String key) {
        boolean res = false;
        for (Statement st : new ArrayList(statement.getStats())) {
            res |= AssertProcessor.replaceAssertions(st, classname, key);
        }
        boolean replaced = true;
        while (replaced) {
            replaced = false;
            for (Statement st : new ArrayList(statement.getStats())) {
                if (!(st instanceof IfStatement) || !AssertProcessor.replaceAssertion(statement, (IfStatement)st, classname, key)) continue;
                replaced = true;
                break;
            }
            res |= replaced;
        }
        return res;
    }

    private static boolean replaceAssertion(Statement parent, IfStatement stat, String classname, String key) {
        Object[] exprres;
        boolean throwInIf = true;
        Statement ifstat = stat.getIfstat();
        InvocationExprent throwError = AssertProcessor.isAssertionError(ifstat);
        if (throwError == null) {
            Statement elsestat = stat.getElsestat();
            throwError = AssertProcessor.isAssertionError(elsestat);
            if (throwError == null) {
                return false;
            }
            throwInIf = false;
        }
        if (!((Boolean)(exprres = AssertProcessor.getAssertionExprent(stat, stat.getHeadexprent().getCondition().copy(), classname, key, throwInIf))[1]).booleanValue()) {
            return false;
        }
        ArrayList<Exprent> lstParams = new ArrayList<Exprent>();
        Exprent ascond = null;
        Exprent retcond = null;
        if (throwInIf) {
            if (exprres[0] != null) {
                ascond = new FunctionExprent(FunctionExprent.FunctionType.BOOL_NOT, (Exprent)exprres[0], throwError.bytecode);
                retcond = SecondaryFunctionsHelper.propagateBoolNot(ascond);
            }
        } else {
            retcond = ascond = (Exprent)exprres[0];
        }
        lstParams.add(retcond == null ? ascond : retcond);
        if (!throwError.getLstParameters().isEmpty()) {
            lstParams.add(throwError.getLstParameters().get(0));
        }
        AssertExprent asexpr = new AssertExprent(lstParams);
        Statement newstat = BasicBlockStatement.create();
        newstat.setExprents(Arrays.asList(asexpr));
        Statement first = stat.getFirst();
        if (stat.iftype == 1 || first.getExprents() != null && !first.getExprents().isEmpty()) {
            Statement stmts;
            List<StatEdge> lstSuccs;
            first.removeSuccessor(stat.getIfEdge());
            first.removeSuccessor(stat.getElseEdge());
            ArrayList<Statement> lstStatements = new ArrayList<Statement>();
            if (first.getExprents() != null && !first.getExprents().isEmpty()) {
                lstStatements.add(first);
            }
            lstStatements.add(newstat);
            if (stat.iftype == 1) {
                if (throwInIf) {
                    lstStatements.add(stat.getElsestat());
                } else {
                    lstStatements.add(stat.getIfstat());
                }
            }
            SequenceStatement sequence = new SequenceStatement(lstStatements);
            sequence.setAllParent();
            for (int i = 0; i < sequence.getStats().size() - 1; ++i) {
                ((Statement)sequence.getStats().get(i)).addSuccessor(new StatEdge(1, (Statement)sequence.getStats().get(i), (Statement)sequence.getStats().get(i + 1)));
            }
            if (!(stat.iftype != 1 && throwInIf || (lstSuccs = (stmts = throwInIf ? stat.getElsestat() : stat.getIfstat()).getAllSuccessorEdges()).isEmpty())) {
                StatEdge endedge = lstSuccs.get(0);
                if (endedge.closure == stat) {
                    sequence.addLabeledEdge(endedge);
                }
            }
            newstat = sequence;
        }
        newstat.getVarDefinitions().addAll(stat.getVarDefinitions());
        parent.replaceStatement(stat, newstat);
        if (exprres.length > 2 && ((Boolean)exprres[2]).booleanValue()) {
            parent.getParent().replaceWith(parent);
        }
        return true;
    }

    private static InvocationExprent isAssertionError(Statement stat) {
        NewExprent nexpr;
        ExitExprent exexpr;
        if (stat == null || stat.getExprents() == null || stat.getExprents().size() != 1) {
            return null;
        }
        Exprent expr = stat.getExprents().get(0);
        if (expr instanceof ExitExprent && (exexpr = (ExitExprent)expr).getExitType() == ExitExprent.Type.THROW && exexpr.getValue() instanceof NewExprent && CLASS_ASSERTION_ERROR.equals((nexpr = (NewExprent)exexpr.getValue()).getNewType()) && nexpr.getConstructor() != null) {
            return nexpr.getConstructor();
        }
        return null;
    }

    private static Object[] getAssertionExprent(Statement stat, Exprent exprent, String classname, String key, boolean throwInIf) {
        if (exprent instanceof FunctionExprent) {
            FunctionExprent fexpr;
            FunctionExprent.FunctionType desiredOperation = FunctionExprent.FunctionType.BOOLEAN_AND;
            if (!throwInIf) {
                desiredOperation = FunctionExprent.FunctionType.BOOLEAN_OR;
            }
            if ((fexpr = (FunctionExprent)exprent).getFuncType() == desiredOperation) {
                Exprent param;
                int i;
                for (i = 0; i < 2; ++i) {
                    param = fexpr.getLstOperands().get(i);
                    if (!AssertProcessor.isAssertionField(param, classname, key, throwInIf)) continue;
                    return new Object[]{fexpr.getLstOperands().get(1 - i), true};
                }
                for (i = 0; i < 2; ++i) {
                    param = fexpr.getLstOperands().get(i);
                    Object[] res = AssertProcessor.getAssertionExprent(stat, param, classname, key, throwInIf);
                    if (!((Boolean)res[1]).booleanValue()) continue;
                    if (param != res[0]) {
                        fexpr.getLstOperands().set(i, (Exprent)res[0]);
                    }
                    return new Object[]{fexpr, true};
                }
            } else {
                Statement parent;
                if (AssertProcessor.isAssertionField(fexpr, classname, key, throwInIf)) {
                    return new Object[]{null, true};
                }
                if (fexpr.getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && (parent = AssertProcessor.parentSkippingSequences(stat)) instanceof IfStatement) {
                    Exprent param = fexpr.getLstOperands().get(0);
                    if (AssertProcessor.isAssertionField(((IfStatement)parent).getHeadexprent().getCondition(), classname, key, throwInIf)) {
                        return new Object[]{fexpr, true, true};
                    }
                }
            }
        }
        return new Object[]{exprent, false};
    }

    private static Statement parentSkippingSequences(Statement stat) {
        stat = stat.getParent();
        while (stat instanceof SequenceStatement) {
            stat = stat.getParent();
        }
        return stat;
    }

    private static boolean isAssertionField(Exprent exprent, String classname, String key, boolean throwInIf) {
        if (throwInIf) {
            FunctionExprent fparam;
            if (exprent instanceof FunctionExprent && (fparam = (FunctionExprent)exprent).getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && fparam.getLstOperands().get(0) instanceof FieldExprent) {
                FieldExprent fdparam = (FieldExprent)fparam.getLstOperands().get(0);
                return classname.equals(fdparam.getClassname()) && key.equals(InterpreterUtil.makeUniqueKey(fdparam.getName(), fdparam.getDescriptor().descriptorString));
            }
        } else if (exprent instanceof FieldExprent) {
            FieldExprent fdparam = (FieldExprent)exprent;
            return classname.equals(fdparam.getClassname()) && key.equals(InterpreterUtil.makeUniqueKey(fdparam.getName(), fdparam.getDescriptor().descriptorString));
        }
        return false;
    }
}

