/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.code.interpreter;

import org.vineflower.java.decompiler.code.Instruction;
import org.vineflower.java.decompiler.struct.consts.ConstantPool;
import org.vineflower.java.decompiler.struct.consts.LinkConstant;
import org.vineflower.java.decompiler.struct.consts.PooledConstant;
import org.vineflower.java.decompiler.struct.consts.PrimitiveConstant;
import org.vineflower.java.decompiler.struct.gen.CodeType;
import org.vineflower.java.decompiler.struct.gen.DataPoint;
import org.vineflower.java.decompiler.struct.gen.FieldDescriptor;
import org.vineflower.java.decompiler.struct.gen.MethodDescriptor;
import org.vineflower.java.decompiler.struct.gen.VarType;
import org.vineflower.java.decompiler.util.collections.ListStack;

public final class InstructionImpact {
    private static final CodeType[][][] stack_impact = new CodeType[][][]{{null, null}, null, null, null, null, null, null, null, null, {null, {CodeType.LONG}}, {null, {CodeType.LONG}}, {null, {CodeType.FLOAT}}, {null, {CodeType.FLOAT}}, {null, {CodeType.FLOAT}}, {null, {CodeType.DOUBLE}}, {null, {CodeType.DOUBLE}}, {null, {CodeType.INT}}, {null, {CodeType.INT}}, null, null, null, {null, {CodeType.INT}}, {null, {CodeType.LONG}}, {null, {CodeType.FLOAT}}, {null, {CodeType.DOUBLE}}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {{CodeType.OBJECT, CodeType.INT}, {CodeType.INT}}, {{CodeType.OBJECT, CodeType.INT}, {CodeType.LONG}}, {{CodeType.OBJECT, CodeType.INT}, {CodeType.FLOAT}}, {{CodeType.OBJECT, CodeType.INT}, {CodeType.DOUBLE}}, null, {{CodeType.OBJECT, CodeType.INT}, {CodeType.INT}}, {{CodeType.OBJECT, CodeType.INT}, {CodeType.INT}}, {{CodeType.OBJECT, CodeType.INT}, {CodeType.INT}}, {{CodeType.INT}, null}, {{CodeType.LONG}, null}, {{CodeType.FLOAT}, null}, {{CodeType.DOUBLE}, null}, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, {{CodeType.OBJECT, CodeType.INT, CodeType.INT}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.LONG}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.FLOAT}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.DOUBLE}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.OBJECT}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.INT}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.INT}, null}, {{CodeType.OBJECT, CodeType.INT, CodeType.INT}, null}, {{CodeType.ANY}, null}, {{CodeType.ANY, CodeType.ANY}, null}, null, null, null, null, null, null, null, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG}, {CodeType.LONG}}, {{CodeType.FLOAT}, {CodeType.FLOAT}}, {{CodeType.DOUBLE}, {CodeType.DOUBLE}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.INT}, {CodeType.LONG}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.INT}, {CodeType.LONG}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.INT}, {CodeType.LONG}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {{CodeType.INT, CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.LONG}}, {null, null}, {{CodeType.INT}, {CodeType.LONG}}, {{CodeType.INT}, {CodeType.FLOAT}}, {{CodeType.INT}, {CodeType.DOUBLE}}, {{CodeType.LONG}, {CodeType.INT}}, {{CodeType.LONG}, {CodeType.FLOAT}}, {{CodeType.LONG}, {CodeType.DOUBLE}}, {{CodeType.FLOAT}, {CodeType.INT}}, {{CodeType.FLOAT}, {CodeType.LONG}}, {{CodeType.FLOAT}, {CodeType.DOUBLE}}, {{CodeType.DOUBLE}, {CodeType.INT}}, {{CodeType.DOUBLE}, {CodeType.LONG}}, {{CodeType.DOUBLE}, {CodeType.FLOAT}}, {{CodeType.INT}, {CodeType.INT}}, {{CodeType.INT}, {CodeType.INT}}, {{CodeType.INT}, {CodeType.INT}}, {{CodeType.LONG, CodeType.LONG}, {CodeType.INT}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.INT}}, {{CodeType.FLOAT, CodeType.FLOAT}, {CodeType.INT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.INT}}, {{CodeType.DOUBLE, CodeType.DOUBLE}, {CodeType.INT}}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.INT, CodeType.INT}, null}, {{CodeType.OBJECT, CodeType.OBJECT}, null}, {{CodeType.OBJECT, CodeType.OBJECT}, null}, {null, null}, {null, {CodeType.ADDRESS}}, {null, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.INT}, null}, {{CodeType.LONG}, null}, {{CodeType.FLOAT}, null}, {{CodeType.DOUBLE}, null}, {{CodeType.OBJECT}, null}, {null, null}, null, null, null, null, null, null, null, null, null, null, null, null, {{CodeType.OBJECT}, {CodeType.INT}}, null, null, null, {{CodeType.OBJECT}, null}, {{CodeType.OBJECT}, null}, null, null, {{CodeType.OBJECT}, null}, {{CodeType.OBJECT}, null}, {null, null}, {null, {CodeType.ADDRESS}}};
    private static final CodeType[] arr_type = new CodeType[]{CodeType.BOOLEAN, CodeType.CHAR, CodeType.FLOAT, CodeType.DOUBLE, CodeType.BYTE, CodeType.SHORT, CodeType.INT, CodeType.LONG};

    public static void stepTypes(DataPoint data, Instruction instr, ConstantPool pool) {
        ListStack<VarType> stack = data.getStack();
        CodeType[][] arr = stack_impact[instr.opcode];
        if (arr != null) {
            CodeType[] read = arr[0];
            CodeType[] write = arr[1];
            if (read != null) {
                int depth = 0;
                CodeType[] codeTypeArray = read;
                int n = codeTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    CodeType type = codeTypeArray[i];
                    ++depth;
                    if (type != CodeType.LONG && type != CodeType.DOUBLE) continue;
                    ++depth;
                }
                stack.removeMultiple(depth);
            }
            if (write != null) {
                for (CodeType type : write) {
                    stack.push(new VarType(type));
                    if (type != CodeType.LONG && type != CodeType.DOUBLE) continue;
                    stack.push(new VarType(CodeType.GROUP2EMPTY));
                }
            }
        } else {
            InstructionImpact.processSpecialInstructions(data, instr, pool);
        }
    }

    private static void processSpecialInstructions(DataPoint data, Instruction instr, ConstantPool pool) {
        ListStack<VarType> stack = data.getStack();
        switch (instr.opcode) {
            case 1: {
                stack.push(new VarType(CodeType.NULL, 0, null));
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                PooledConstant constant = pool.getConstant(instr.operand(0));
                switch (constant.type) {
                    case 3: {
                        stack.push(new VarType(CodeType.INT));
                        break;
                    }
                    case 4: {
                        stack.push(new VarType(CodeType.FLOAT));
                        break;
                    }
                    case 5: {
                        stack.push(new VarType(CodeType.LONG));
                        stack.push(new VarType(CodeType.GROUP2EMPTY));
                        break;
                    }
                    case 6: {
                        stack.push(new VarType(CodeType.DOUBLE));
                        stack.push(new VarType(CodeType.GROUP2EMPTY));
                        break;
                    }
                    case 8: {
                        stack.push(new VarType(CodeType.OBJECT, 0, "java/lang/String"));
                        break;
                    }
                    case 7: {
                        stack.push(new VarType(CodeType.OBJECT, 0, "java/lang/Class"));
                        break;
                    }
                    case 15: {
                        stack.push(new VarType(((LinkConstant)constant).descriptor));
                        break;
                    }
                    case 17: {
                        LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                        FieldDescriptor fd = FieldDescriptor.parseDescriptor(ck.descriptor);
                        if (fd.type.type == CodeType.VOID) break;
                        stack.push(fd.type);
                        if (fd.type.stackSize != 2) break;
                        stack.push(new VarType(CodeType.GROUP2EMPTY));
                    }
                }
                break;
            }
            case 25: {
                VarType var1 = data.getVariable(instr.operand(0));
                if (var1 != null) {
                    stack.push(var1);
                    break;
                }
                stack.push(new VarType(CodeType.OBJECT, 0, null));
                break;
            }
            case 50: {
                VarType var1 = stack.pop(2);
                stack.push(new VarType(var1.type, var1.arrayDim - 1, var1.value));
                break;
            }
            case 58: {
                data.setVariable(instr.operand(0), stack.pop());
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                int depth1 = 88 - instr.opcode;
                stack.insertByOffset(depth1, stack.getByOffset(-1));
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                int depth2 = 90 - instr.opcode;
                stack.insertByOffset(depth2, stack.getByOffset(-2));
                stack.insertByOffset(depth2, stack.getByOffset(-1));
                break;
            }
            case 95: {
                VarType var1 = stack.pop();
                stack.insertByOffset(-1, var1);
                break;
            }
            case 180: {
                stack.pop();
            }
            case 178: {
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                VarType var1 = new VarType(ck.descriptor);
                stack.push(var1);
                if (var1.stackSize != 2) break;
                stack.push(new VarType(CodeType.GROUP2EMPTY));
                break;
            }
            case 181: {
                stack.pop();
            }
            case 179: {
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                VarType var1 = new VarType(ck.descriptor);
                stack.pop(var1.stackSize);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                stack.pop();
            }
            case 184: 
            case 186: {
                if (instr.opcode == 186 && !instr.bytecodeVersion.hasInvokeDynamic()) break;
                LinkConstant ck = pool.getLinkConstant(instr.operand(0));
                MethodDescriptor md = MethodDescriptor.parseDescriptor(ck.descriptor);
                for (int i = 0; i < md.params.length; ++i) {
                    stack.pop(md.params[i].stackSize);
                }
                if (md.ret.type == CodeType.VOID) break;
                stack.push(md.ret);
                if (md.ret.stackSize != 2) break;
                stack.push(new VarType(CodeType.GROUP2EMPTY));
                break;
            }
            case 187: {
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                stack.push(new VarType(CodeType.OBJECT, 0, cn.getString()));
                break;
            }
            case 188: {
                stack.pop();
                stack.push(new VarType(arr_type[instr.operand(0) - 4], 1).resizeArrayDim(1));
                break;
            }
            case 191: {
                VarType var1 = stack.pop();
                stack.clear();
                stack.push(var1);
                break;
            }
            case 192: 
            case 193: {
                stack.pop();
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                stack.push(new VarType(CodeType.OBJECT, 0, cn.getString()));
                break;
            }
            case 189: 
            case 197: {
                int dimensions = instr.opcode == 189 ? 1 : instr.operand(1);
                stack.pop(dimensions);
                PrimitiveConstant cn = pool.getPrimitiveConstant(instr.operand(0));
                if (cn.isArray) {
                    VarType var1 = new VarType(CodeType.OBJECT, 0, cn.getString());
                    var1 = var1.resizeArrayDim(var1.arrayDim + dimensions);
                    stack.push(var1);
                    break;
                }
                stack.push(new VarType(CodeType.OBJECT, dimensions, cn.getString()));
            }
        }
    }
}

