/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.vineflower.java.decompiler.code.Instruction;
import org.vineflower.java.decompiler.code.InstructionSequence;
import org.vineflower.java.decompiler.code.SimpleInstructionSequence;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.modules.decompiler.decompose.IGraphNode;

public class BasicBlock
implements IGraphNode {
    public final int id;
    public int mark = 0;
    private InstructionSequence seq = new SimpleInstructionSequence();
    private final List<BasicBlock> preds = new ArrayList<BasicBlock>();
    private final List<BasicBlock> succs = new ArrayList<BasicBlock>();
    private final List<Integer> instrOldOffsets = new ArrayList<Integer>();
    private final List<BasicBlock> predExceptions = new ArrayList<BasicBlock>();
    private final List<BasicBlock> succExceptions = new ArrayList<BasicBlock>();

    public BasicBlock(int id) {
        this.id = id;
    }

    public Instruction getInstruction(int index) {
        return this.seq.getInstr(index);
    }

    public Instruction getLastInstruction() {
        if (this.seq.isEmpty()) {
            return null;
        }
        return this.seq.getLastInstr();
    }

    public Integer getOldOffset(int index) {
        if (index < this.instrOldOffsets.size()) {
            return this.instrOldOffsets.get(index);
        }
        return -1;
    }

    public int size() {
        return this.seq.length();
    }

    public void addPredecessor(BasicBlock block) {
        this.preds.add(block);
    }

    public void removePredecessor(BasicBlock block) {
        while (this.preds.remove(block)) {
        }
    }

    public void addSuccessor(BasicBlock block) {
        this.succs.add(block);
        block.addPredecessor(this);
    }

    public void removeSuccessor(BasicBlock block) {
        while (this.succs.remove(block)) {
        }
        block.removePredecessor(this);
    }

    public void replaceSuccessor(BasicBlock oldBlock, BasicBlock newBlock) {
        int i;
        if (oldBlock.equals(newBlock)) {
            return;
        }
        for (i = 0; i < this.succs.size(); ++i) {
            if (this.succs.get((int)i).id != oldBlock.id) continue;
            this.succs.set(i, newBlock);
            oldBlock.removePredecessor(this);
            newBlock.addPredecessor(this);
        }
        for (i = 0; i < this.succExceptions.size(); ++i) {
            if (this.succExceptions.get((int)i).id != oldBlock.id) continue;
            this.succExceptions.set(i, newBlock);
            oldBlock.removePredecessorException(this);
            newBlock.addPredecessorException(this);
        }
    }

    public void addPredecessorException(BasicBlock block) {
        this.predExceptions.add(block);
    }

    public void removePredecessorException(BasicBlock block) {
        while (this.predExceptions.remove(block)) {
        }
    }

    public void addSuccessorException(BasicBlock block) {
        if (!this.succExceptions.contains(block)) {
            this.succExceptions.add(block);
            block.addPredecessorException(this);
        }
    }

    public void removeSuccessorException(BasicBlock block) {
        while (this.succExceptions.remove(block)) {
        }
        block.removePredecessorException(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        return this.id + ":" + new_line_separator + this.seq.toString(indent);
    }

    public boolean isSuccessor(BasicBlock block) {
        for (BasicBlock succ : this.succs) {
            if (succ.id != block.id) continue;
            return true;
        }
        return false;
    }

    BasicBlock cloneBlock(int id) {
        BasicBlock block = new BasicBlock(id);
        block.setSeq(this.seq.clone());
        block.instrOldOffsets.addAll(this.instrOldOffsets);
        return block;
    }

    public List<Integer> getInstrOldOffsets() {
        return this.instrOldOffsets;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Collection<? extends IGraphNode> getPredecessors() {
        ArrayList<BasicBlock> lst = new ArrayList<BasicBlock>(this.preds);
        lst.addAll(this.predExceptions);
        return lst;
    }

    public List<BasicBlock> getPreds() {
        return this.preds;
    }

    public InstructionSequence getSeq() {
        return this.seq;
    }

    public void setSeq(InstructionSequence seq) {
        this.seq = seq;
    }

    public List<BasicBlock> getSuccs() {
        return this.succs;
    }

    public List<BasicBlock> getSuccExceptions() {
        return this.succExceptions;
    }

    public List<BasicBlock> getPredExceptions() {
        return this.predExceptions;
    }

    public int getStartInstruction() {
        if (this.seq.isEmpty()) {
            return 0;
        }
        return this.instrOldOffsets.get(0);
    }

    public int getEndInstruction() {
        if (this.seq.isEmpty()) {
            return 0;
        }
        int end = this.seq.getLastInstr().length;
        return end + this.instrOldOffsets.get(this.size() - 1);
    }
}

