/*
 * Decompiled with CFR 0.152.
 */
package org.vineflower.java.decompiler.api.plugin.pass;

import java.util.ArrayList;
import java.util.List;
import org.vineflower.java.decompiler.api.plugin.pass.NamedPass;
import org.vineflower.java.decompiler.api.plugin.pass.Pass;
import org.vineflower.java.decompiler.api.plugin.pass.PassContext;
import org.vineflower.java.decompiler.util.Pair;

public final class LoopingPassBuilder {
    private final List<Pair<Pass, Boolean>> passes = new ArrayList<Pair<Pass, Boolean>>();
    private final String name;

    public LoopingPassBuilder(String name) {
        this.name = name;
    }

    public LoopingPassBuilder addFallthroughPass(String name, Pass pass) {
        this.passes.add(Pair.of(new NamedPass(name, pass), false));
        return this;
    }

    public LoopingPassBuilder addLoopingPass(String name, Pass pass) {
        this.passes.add(Pair.of(new NamedPass(name, pass), true));
        return this;
    }

    public Pass build() {
        return new CompiledPass(this.name, this.passes);
    }

    private static final class CompiledPass
    implements Pass {
        private final List<Pair<Pass, Boolean>> passes;

        public CompiledPass(String name, List<Pair<Pass, Boolean>> passes) {
            this.passes = new ArrayList<Pair<Pass, Boolean>>(passes);
        }

        @Override
        public boolean run(PassContext ctx) {
            boolean loop;
            block0: do {
                loop = false;
                for (Pair<Pass, Boolean> pass : this.passes) {
                    if (!((Pass)pass.a).run(ctx) || !((Boolean)pass.b).booleanValue()) continue;
                    loop = true;
                    continue block0;
                }
            } while (loop);
            return true;
        }
    }
}

