/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.utils;

import io.github.skylot.raung.disasm.impl.RaungDisasmBuilder;
import io.github.skylot.raung.disasm.impl.utils.RaungDisasmException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDisasmArgs {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateDisasmArgs.class);

    public static void process(RaungDisasmBuilder args) {
        if (args.getInputs().isEmpty()) {
            throw new RaungDisasmException("Empty inputs");
        }
        for (Path input : args.getInputs()) {
            if (Files.exists(input, new LinkOption[0])) continue;
            throw new RaungDisasmException("Input not found: " + input.toAbsolutePath());
        }
        ValidateDisasmArgs.processOptions(args);
    }

    public static void processOptions(RaungDisasmBuilder args) {
        if (args.isAutoFrames()) {
            args.autoMax(true);
        }
        LOG.trace("Effective args: {}", (Object)args);
    }
}

