/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

public final class StringUtil {
    private StringUtil() {
    }

    private static void escapeChar(StringBuilder sb, char c) {
        switch (c) {
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                if (c < ' ') {
                    sb.append("\\0");
                    sb.append((char)(48 + (c >> 3)));
                    sb.append((char)(48 + (c & 7)));
                    break;
                }
                sb.append(c);
            }
        }
    }

    public static String escapeStringAndAppendQuotationMark(String s) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length * 2 + 2);
        sb.append('\"');
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (s.charAt(i) == '\"') {
                    sb.append("\\\"");
                } else {
                    StringUtil.escapeChar(sb, s.charAt(i));
                }
                ++i;
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String escapeCharAndAppendApostrophe(char c) {
        StringBuilder sb = new StringBuilder(10);
        sb.append('\'');
        if (c == '\'') {
            sb.append("\\'");
        } else {
            StringUtil.escapeChar(sb, c);
        }
        sb.append('\'');
        return sb.toString();
    }
}

