/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

public class StringToIndexMap {
    private static final int INITIAL_CAPACITY = 256;
    private final HashEntry[] entries = new HashEntry[256];

    public void put(String key, int value) {
        int hashCode = key.hashCode();
        int index = StringToIndexMap.hashCodeToIndex(hashCode, this.entries.length);
        HashEntry entry = this.entries[index];
        while (entry != null) {
            if (entry.hash == hashCode && key.equals(entry.key)) {
                entry.value = value;
                return;
            }
            entry = entry.next;
        }
        this.entries[index] = new HashEntry(key, hashCode, value, this.entries[index]);
    }

    public int get(String key) {
        int hashCode = key.hashCode();
        int index = StringToIndexMap.hashCodeToIndex(hashCode, this.entries.length);
        HashEntry entry = this.entries[index];
        while (entry != null) {
            if (entry.hash == hashCode && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    private static int hashCodeToIndex(int hash, int size) {
        return hash & size - 1;
    }

    private static class HashEntry {
        private final String key;
        private final int hash;
        private int value;
        private final HashEntry next;

        public HashEntry(String key, int hash, int value, HashEntry next) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }
}

