/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jd.core.util.CharArrayUtil;

public final class SignatureUtil {
    private static final char[] PRIMITIVE_SIGNATURES = new char[]{'B', 'C', 'D', 'F', 'I', 'J', 'S', 'Z'};
    private static final char[] INTEGER_SIGNATURES = new char[]{'B', 'C', 'I', 'S'};
    private static final char[] BYTE_SHORT_SIGNATURES = new char[]{'B', 'S'};
    private static final char[] OBJECT_TYPE_SIGNATURES = new char[]{'L', 'T'};
    private static final char[] OBJECT_SIGNATURE = new char[]{'L'};

    private SignatureUtil() {
    }

    public static int countDimensionOfArray(String signature) {
        int index = 0;
        int length = signature.length();
        if (signature.charAt(index) == '[') {
            while (++index < length) {
                if (signature.charAt(index) == 'L' && index + 1 < length && signature.charAt(index + 1) == '[') {
                    ++index;
                    --length;
                    continue;
                }
                if (signature.charAt(index) != '[') break;
            }
        }
        return index;
    }

    public static int skipSignature(char[] caSignature, int length, int index) {
        do {
            if (caSignature[index] == '[') {
                while (++index < length) {
                    if (caSignature[index] == 'L' && index + 1 < length && caSignature[index + 1] == '[') {
                        ++index;
                        --length;
                        continue;
                    }
                    if (caSignature[index] != '[') break;
                }
            }
            switch (caSignature[index]) {
                case '*': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    ++index;
                    break;
                }
                case '.': 
                case 'L': {
                    ++index;
                    int c = 46;
                    while (index < length) {
                        c = caSignature[index];
                        if (c == 59 || c == 60) break;
                        ++index;
                    }
                    if (c == 60) {
                        index = SignatureUtil.skipSignature(caSignature, length, index + 1);
                        while (caSignature[index] != '>') {
                            index = SignatureUtil.skipSignature(caSignature, length, index);
                        }
                        ++index;
                    }
                    if (caSignature[index] != ';') break;
                    ++index;
                    break;
                }
                case 'T': {
                    index = CharArrayUtil.indexOf(caSignature, ';', index + 1) + 1;
                    break;
                }
                case '+': 
                case '-': {
                    index = SignatureUtil.skipSignature(caSignature, length, index + 1);
                }
            }
        } while (index < length && caSignature[index] == '.');
        return index;
    }

    public static String getSignatureFromType(int type) {
        return switch (type) {
            case 4 -> "Z";
            case 5 -> "C";
            case 6 -> "F";
            case 7 -> "D";
            case 8 -> "B";
            case 9 -> "S";
            case 10 -> "I";
            case 11 -> "J";
            default -> null;
        };
    }

    public static boolean isGenericSignature(String signature) {
        return signature.charAt(0) == 'T';
    }

    public static boolean isPrimitiveSignature(String signature) {
        return SignatureUtil.isPrimitiveSignature(signature, PRIMITIVE_SIGNATURES);
    }

    public static boolean isIntegerSignature(String signature) {
        return SignatureUtil.isPrimitiveSignature(signature, INTEGER_SIGNATURES);
    }

    public static boolean isByteOrShortSignature(String signature) {
        return SignatureUtil.isPrimitiveSignature(signature, BYTE_SHORT_SIGNATURES);
    }

    private static boolean isPrimitiveSignature(String signature, char[] letters) {
        if (signature == null || signature.length() != 1) {
            return false;
        }
        return Arrays.binarySearch(letters, signature.charAt(0)) >= 0;
    }

    public static boolean isObjectTypeSignature(String signature) {
        return SignatureUtil.isObjectSignature(signature, OBJECT_TYPE_SIGNATURES);
    }

    public static boolean isObjectSignature(String signature) {
        return SignatureUtil.isObjectSignature(signature, OBJECT_SIGNATURE);
    }

    private static boolean isObjectSignature(String signature, char[] letters) {
        if (signature == null || signature.length() <= 2) {
            return false;
        }
        return Arrays.binarySearch(letters, signature.charAt(0)) >= 0;
    }

    public static String getInternalName(String signature) {
        char[] caSignature = signature.toCharArray();
        int length = signature.length();
        int beginIndex = 0;
        while (beginIndex < length && caSignature[beginIndex] == '[') {
            ++beginIndex;
        }
        if (beginIndex < length && caSignature[beginIndex] == 'L') {
            return CharArrayUtil.substring(caSignature, ++beginIndex, --length);
        }
        return beginIndex == 0 ? signature : CharArrayUtil.substring(caSignature, beginIndex, length);
    }

    public static String cutArrayDimensionPrefix(String signature) {
        int beginIndex = 0;
        while (signature.charAt(beginIndex) == '[') {
            ++beginIndex;
        }
        return signature.substring(beginIndex);
    }

    public static int getArrayDimensionCount(String signature) {
        int beginIndex = 0;
        while (signature.charAt(beginIndex) == '[') {
            ++beginIndex;
        }
        return beginIndex;
    }

    public static String getInnerName(String signature) {
        if (SignatureUtil.isObjectTypeSignature(signature = SignatureUtil.cutArrayDimensionPrefix(signature))) {
            return signature.substring(1, signature.length() - 1);
        }
        return signature;
    }

    public static List<String> getParameterSignatures(String methodSignature) {
        char[] caSignature = methodSignature.toCharArray();
        int length = caSignature.length;
        ArrayList<String> parameterTypes = new ArrayList<String>(1);
        int index = CharArrayUtil.indexOf(caSignature, '(', 0);
        if (index != -1) {
            ++index;
            while (caSignature[index] != ')') {
                int newIndex = SignatureUtil.skipSignature(caSignature, length, index);
                parameterTypes.add(methodSignature.substring(index, newIndex));
                index = newIndex;
            }
        }
        return parameterTypes;
    }

    public static String getMethodReturnedSignature(String signature) {
        int index = signature.indexOf(41);
        if (index == -1) {
            return null;
        }
        return signature.substring(index + 1);
    }

    public static int getParameterSignatureCount(String methodSignature) {
        char[] caSignature = methodSignature.toCharArray();
        int length = caSignature.length;
        int index = CharArrayUtil.indexOf(caSignature, '(', 0);
        int count = 0;
        if (index != -1) {
            ++index;
            while (caSignature[index] != ')') {
                int newIndex;
                index = newIndex = SignatureUtil.skipSignature(caSignature, length, index);
                ++count;
            }
        }
        return count;
    }

    public static int createTypesBitField(String signature) {
        return switch (signature.charAt(0)) {
            case 'I' -> 8;
            case 'S' -> 12;
            case 'B' -> 30;
            case 'C' -> 13;
            case 'X' -> 31;
            case 'Y' -> 15;
            case 'Z' -> 16;
            default -> 0;
        };
    }

    public static int createArgOrReturnBitFields(String signature) {
        return switch (signature.charAt(0)) {
            case 'I' -> 15;
            case 'S' -> 6;
            case 'B' -> 2;
            case 'C' -> 1;
            case 'X' -> 31;
            case 'Y' -> 15;
            case 'Z' -> 16;
            default -> 0;
        };
    }

    public static String getSignatureFromTypesBitField(int typesBitField) {
        if ((typesBitField & 8) != 0) {
            return "I";
        }
        if ((typesBitField & 4) != 0) {
            return "S";
        }
        if ((typesBitField & 1) != 0) {
            return "C";
        }
        if ((typesBitField & 2) != 0) {
            return "B";
        }
        if ((typesBitField & 0x10) != 0) {
            return "Z";
        }
        return "I";
    }

    public static String createTypeName(String signature) {
        if (signature.isEmpty()) {
            return signature;
        }
        switch (signature.charAt(0)) {
            case '[': {
                return signature;
            }
            case 'L': 
            case 'T': {
                if (signature.charAt(signature.length() - 1) != ';') break;
                return signature;
            }
        }
        return "L" + signature + ';';
    }
}

