/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

public class IntSet {
    private int[] values = null;
    private int capacity = 0;
    private int size = 0;
    private int min;
    private int max;

    public int size() {
        return this.size;
    }

    public void add(int newValue) {
        if (this.capacity == 0) {
            this.capacity = 5;
            this.values = new int[this.capacity];
            this.size = 1;
            this.max = this.values[0] = newValue;
            this.min = this.values[0];
        } else {
            if (this.capacity == this.size) {
                this.capacity *= 2;
                int[] tmp = new int[this.capacity];
                System.arraycopy(this.values, 0, tmp, 0, this.size);
                this.values = tmp;
            }
            if (this.max < newValue) {
                this.values[this.size++] = newValue;
                this.max = newValue;
            } else if (newValue < this.min) {
                System.arraycopy(this.values, 0, this.values, 1, this.size);
                this.min = this.values[0] = newValue;
                ++this.size;
            } else {
                int value;
                int medIndex;
                int firstIndex = 0;
                int lastIndex = this.size - 1;
                while (firstIndex < lastIndex) {
                    medIndex = (lastIndex + firstIndex) / 2;
                    value = this.values[medIndex];
                    if (value < newValue) {
                        firstIndex = medIndex + 1;
                        continue;
                    }
                    if (value <= newValue) break;
                    lastIndex = medIndex - 1;
                }
                if ((value = this.values[medIndex = (lastIndex + firstIndex) / 2]) < newValue) {
                    System.arraycopy(this.values, ++medIndex, this.values, medIndex + 1, this.size - medIndex);
                    this.values[medIndex] = newValue;
                    ++this.size;
                } else if (value > newValue) {
                    System.arraycopy(this.values, medIndex, this.values, medIndex + 1, this.size - medIndex);
                    this.values[medIndex] = newValue;
                    ++this.size;
                }
            }
        }
    }

    public int[] toArray() {
        if (this.values == null) {
            return null;
        }
        int[] tmp = new int[this.size];
        System.arraycopy(this.values, 0, tmp, 0, this.size);
        return tmp;
    }

    public int get(int index) {
        if (this.values == null || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.values[index];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

