/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

public class IndexToIndexMap {
    private static final int INITIAL_CAPACITY = 128;
    private final MapEntry[] entries = new MapEntry[128];

    public void put(int key, int value) {
        int index = IndexToIndexMap.hashCodeToIndex(key, this.entries.length);
        MapEntry entry = this.entries[index];
        while (entry != null) {
            if (entry.key == key) {
                entry.value = value;
                return;
            }
            entry = entry.next;
        }
        this.entries[index] = new MapEntry(key, value, this.entries[index]);
    }

    public int get(int key) {
        int index = IndexToIndexMap.hashCodeToIndex(key, this.entries.length);
        MapEntry entry = this.entries[index];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return -1;
    }

    private static int hashCodeToIndex(int hashCode, int size) {
        return hashCode & size - 1;
    }

    private static class MapEntry {
        private final int key;
        private int value;
        private final MapEntry next;

        public MapEntry(int key, int value, MapEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

