/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;

public final class ClassFileUtil {
    private ClassFileUtil() {
    }

    public static boolean containsMultipleConstructor(ClassFile classFile) {
        ConstantPool constants = classFile.getConstantPool();
        Method[] methods = classFile.getMethods();
        boolean flag = false;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if ((method.getAccessFlags() & 0x1040) == 0 && method.getNameIndex() == constants.getInstanceConstructorIndex()) {
                if (flag) {
                    return true;
                }
                flag = true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAMethodOfEnum(ClassFile classFile, Method method, String signature) {
        ConstantPool constants = classFile.getConstantPool();
        if ((method.getAccessFlags() & 9) == 9) {
            String s;
            String methodName = constants.getConstantUtf8(method.getNameIndex());
            if ("valueOf".equals(methodName) && (s = "(Ljava/lang/String;)" + classFile.getInternalClassName()).equals(signature)) {
                return true;
            }
            if ("values".equals(methodName) && (s = "()[" + classFile.getInternalClassName()).equals(signature)) {
                return true;
            }
        }
        return false;
    }
}

