/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer.visitor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConstInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Jsr;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.InstructionPrinter;
import jd.core.process.layouter.visitor.MinLineNumberVisitor;
import jd.core.process.writer.ConstantValueWriter;
import jd.core.process.writer.SignatureWriter;
import jd.core.process.writer.SourceWriteable;
import jd.core.util.SignatureUtil;
import jd.core.util.StringUtil;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.commons.lang3.Validate;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.javasyntax.type.AbstractTypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitable;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class SourceWriterVisitor
extends AbstractTypeArgumentVisitor
implements TypeVisitor {
    private static final String[] CMP_NAMES = new String[]{"==", "<", ">", "", "!", "<=", ">=", "!="};
    private static final char[] BIN_OPS = new char[]{'&', '^', '|'};
    private final Loader loader;
    private final InstructionPrinter printer;
    private final ReferenceMap referenceMap;
    private final Set<String> keywordSet;
    private ConstantPool constants;
    private LocalVariables localVariables;
    private ClassFile classFile;
    private int methodAccessFlags;
    private int firstOffset;
    private int lastOffset;
    private int previousOffset;
    private TypeMaker typeMaker;

    public SourceWriterVisitor(Loader loader, InstructionPrinter printer, ReferenceMap referenceMap, Set<String> keywordSet) {
        this.loader = loader;
        this.printer = printer;
        this.referenceMap = referenceMap;
        this.keywordSet = keywordSet;
        this.typeMaker = new TypeMaker(loader);
    }

    public void init(ClassFile classFile, Method method, int firstOffset, int lastOffset) {
        this.classFile = classFile;
        this.firstOffset = firstOffset;
        this.lastOffset = lastOffset;
        this.previousOffset = 0;
        if (classFile == null || method == null) {
            this.constants = null;
            this.methodAccessFlags = 0;
            this.localVariables = null;
        } else {
            this.constants = classFile.getConstantPool();
            this.methodAccessFlags = method.getAccessFlags();
            this.localVariables = method.getLocalVariables();
        }
    }

    public int visit(Instruction instruction) {
        int lineNumber = MinLineNumberVisitor.visit(instruction);
        if (instruction.getOffset() < this.firstOffset || this.previousOffset > this.lastOffset) {
            return lineNumber;
        }
        switch (instruction.getOpcode()) {
            case 190: {
                lineNumber = this.visit(instruction, ((ArrayLength)instruction).getArrayref());
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.print(lineNumber, '.');
                this.printer.printJavaWord("length");
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                lineNumber = this.writeArray(ali, ali.getArrayref(), ali.getIndexref());
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                lineNumber = this.writeArray(asi, asi.getArrayref(), asi.getIndexref());
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= nextOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, " = ");
                }
                lineNumber = this.visit(asi, asi.getValueref());
                break;
            }
            case 189: {
                ANewArray newArray = (ANewArray)instruction;
                Instruction dimension = newArray.getDimension();
                String signature = this.constants.getConstantClassName(newArray.getIndex());
                if (signature.charAt(0) != '[') {
                    signature = SignatureUtil.createTypeName(signature);
                }
                String signatureWithoutArray = SignatureUtil.cutArrayDimensionPrefix(signature);
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.printKeyword(lineNumber, "new");
                    this.printer.print(' ');
                    SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signatureWithoutArray);
                    this.printer.print(lineNumber, '[');
                }
                lineNumber = this.visit(dimension);
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.print(lineNumber, ']');
                int i = dimensionCount = signature.length() - signatureWithoutArray.length();
                while (i > 0) {
                    this.printer.print(lineNumber, "[]");
                    --i;
                }
                break;
            }
            case 1: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "null");
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.printKeyword(lineNumber, "assert");
                    this.printer.print(' ');
                }
                lineNumber = this.visit(ai, ai.getTest());
                if (ai.getMsg() == null) break;
                if (this.firstOffset <= this.previousOffset && ai.getMsg().getOffset() <= this.lastOffset) {
                    this.printer.print(lineNumber, " : ");
                }
                lineNumber = this.visit(ai, ai.getMsg());
                break;
            }
            case 265: {
                lineNumber = this.writeAssignmentInstruction((AssignmentInstruction)instruction);
                if (instruction.getNext() == null) break;
                this.printer.print(", ");
                lineNumber = this.visit(instruction.getNext());
                break;
            }
            case 191: {
                AThrow athrow = (AThrow)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.printKeyword(lineNumber, "throw");
                    this.printer.print(' ');
                }
                lineNumber = this.visit(athrow.getValueref());
                break;
            }
            case 266: {
                UnaryOperatorInstruction ioi = (UnaryOperatorInstruction)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, ioi.getOperator());
                }
                lineNumber = this.visit(ioi, ioi.getValue());
                break;
            }
            case 267: {
                lineNumber = this.writeBinaryOperatorInstruction((BinaryOperatorInstruction)instruction);
                break;
            }
            case 16: 
            case 17: 
            case 256: {
                lineNumber = this.writeBIPushSIPushIConst((IConst)instruction);
                break;
            }
            case 257: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printNumeric(lineNumber, String.valueOf(String.valueOf(((ConstInstruction)instruction).getValue())) + 'L');
                break;
            }
            case 258: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                String value = String.valueOf(((ConstInstruction)instruction).getValue());
                if (value.indexOf(46) == -1) {
                    value = String.valueOf(value) + ".0";
                }
                this.printer.printNumeric(lineNumber, String.valueOf(value) + 'F');
                break;
            }
            case 259: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                String value = String.valueOf(((ConstInstruction)instruction).getValue());
                if (value.indexOf(46) == -1) {
                    value = String.valueOf(value) + ".0";
                }
                this.printer.printNumeric(lineNumber, String.valueOf(value) + 'D');
                break;
            }
            case 275: {
                lineNumber = this.writeConvertInstruction((ConvertInstruction)instruction);
                break;
            }
            case 276: {
                lineNumber = this.visit(((ConvertInstruction)instruction).getValue());
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, '(');
                    String signature = checkCast.getReturnedSignature(this.classFile, this.localVariables);
                    SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
                    this.printer.print(')');
                }
                lineNumber = this.visit(checkCast, checkCast.getObjectref());
                break;
            }
            case 317: {
                lineNumber = this.writeDeclaration((FastDeclaration)instruction);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, "tmp");
                    this.printer.print(instruction.getOffset());
                    this.printer.print('_');
                    this.printer.print(((DupStore)instruction).getObjectref().getOffset());
                    this.printer.print(" = ");
                }
                lineNumber = this.visit(instruction, dupStore.getObjectref());
                break;
            }
            case 263: {
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset > this.previousOffset || nextOffset > this.lastOffset) break;
                this.printer.print(lineNumber, "tmp");
                this.printer.print(instruction.getOffset());
                this.printer.print('_');
                this.printer.print(((DupLoad)instruction).getDupStore().getObjectref().getOffset());
                break;
            }
            case 321: {
                lineNumber = this.writeEnumValueInstruction((InvokeNew)instruction);
                break;
            }
            case 180: {
                this.writeGetField((GetField)instruction);
                break;
            }
            case 178: {
                lineNumber = this.writeGetStatic((GetStatic)instruction);
                break;
            }
            case 285: {
                lineNumber = this.writeOuterThis((GetStatic)instruction);
                break;
            }
            case 167: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                Goto gotoInstruction = (Goto)instruction;
                this.printer.printKeyword(lineNumber, "goto");
                this.printer.print(' ');
                this.printer.print(lineNumber, gotoInstruction.getJumpOffset());
                break;
            }
            case 311: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "continue");
                break;
            }
            case 312: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "break");
                break;
            }
            case 260: {
                lineNumber = this.writeIfTest((IfInstruction)instruction);
                break;
            }
            case 261: {
                lineNumber = this.writeIfCmpTest((IfCmp)instruction);
                break;
            }
            case 262: {
                lineNumber = this.writeIfXNullTest((IfInstruction)instruction);
                break;
            }
            case 284: {
                lineNumber = this.writeComplexConditionalBranchInstructionTest((ComplexConditionalBranchInstruction)instruction);
                break;
            }
            case 132: {
                lineNumber = this.writeIInc((IInc)instruction);
                if (instruction.getNext() == null) break;
                this.printer.print(", ");
                lineNumber = this.visit(instruction.getNext());
                break;
            }
            case 277: {
                lineNumber = this.writePreInc((IncInstruction)instruction);
                break;
            }
            case 278: {
                lineNumber = this.writePostInc((IncInstruction)instruction);
                if (instruction.getNext() == null) break;
                this.printer.print(", ");
                lineNumber = this.visit(instruction.getNext());
                break;
            }
            case 274: {
                lineNumber = this.writeInvokeNewInstruction((InvokeNew)instruction);
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                lineNumber = this.visit(instanceOf, instanceOf.getObjectref());
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.print(lineNumber, ' ');
                this.printer.printKeyword("instanceof");
                this.printer.print(' ');
                String signature = this.constants.getConstantClassName(instanceOf.getIndex());
                if (signature.charAt(0) != '[') {
                    signature = SignatureUtil.createTypeName(signature);
                }
                SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
                break;
            }
            case 182: 
            case 185: {
                lineNumber = this.writeInvokeNoStaticInstruction((InvokeNoStaticInstruction)instruction);
                break;
            }
            case 183: {
                lineNumber = this.writeInvokespecial((InvokeNoStaticInstruction)instruction);
                break;
            }
            case 184: {
                lineNumber = this.writeInvokestatic((Invokestatic)instruction);
                break;
            }
            case 168: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "jsr");
                this.printer.print(' ');
                this.printer.print((short)((Jsr)instruction).getBranch());
                break;
            }
            case 18: 
            case 20: {
                lineNumber = this.writeLcdInstruction((IndexInstruction)instruction);
                break;
            }
            case 21: 
            case 25: 
            case 268: {
                lineNumber = this.writeLoadInstruction((LoadInstruction)instruction);
                break;
            }
            case 197: {
                lineNumber = this.writeMultiANewArray((MultiANewArray)instruction);
                break;
            }
            case 187: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "new");
                this.printer.print(' ');
                this.printer.print(lineNumber, this.constants.getConstantClassName(((IndexInstruction)instruction).getIndex()));
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.printKeyword(lineNumber, "new");
                    this.printer.print(' ');
                    SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.getSignatureFromType(newArray.getType()));
                    this.printer.print(lineNumber, '[');
                }
                lineNumber = this.visit(newArray.getDimension());
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.print(lineNumber, ']');
                break;
            }
            case 87: {
                lineNumber = this.visit(((Pop)instruction).getObjectref());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                ConstantFieldref cfr = this.constants.getConstantFieldref(putField.getIndex());
                ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                boolean displayPrefix = false;
                if (this.localVariables.containsLocalVariableWithNameIndex(cnat.getNameIndex())) {
                    if (putField.getObjectref().getOpcode() == 25) {
                        if (((ALoad)putField.getObjectref()).getIndex() == 0) {
                            displayPrefix = true;
                        }
                    } else if (putField.getObjectref().getOpcode() == 285 && !this.needAPrefixForThisField(cnat.getNameIndex(), cnat.getSignatureIndex(), (GetStatic)putField.getObjectref())) {
                        displayPrefix = true;
                    }
                }
                if (this.firstOffset <= this.previousOffset && putField.getObjectref().getOffset() <= this.lastOffset) {
                    if (!displayPrefix) {
                        this.printer.addNewLinesAndPrefix(lineNumber);
                        this.printer.startOfOptionalPrefix();
                    }
                    lineNumber = this.visit(putField, putField.getObjectref());
                    this.printer.print(lineNumber, '.');
                    if (!displayPrefix) {
                        this.printer.endOfOptionalPrefix();
                    }
                }
                if (this.keywordSet.contains(fieldName = this.constants.getConstantUtf8(cnat.getNameIndex()))) {
                    fieldName = "jdField_" + fieldName;
                }
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    String internalClassName = this.constants.getConstantClassName(cfr.getClassIndex());
                    String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                    this.printer.printField(lineNumber, internalClassName, fieldName, descriptor, this.classFile.getThisClassName());
                    this.printer.print(" = ");
                }
                lineNumber = this.visit(putField.getValueref());
                break;
            }
            case 179: {
                lineNumber = this.writePutStatic((PutStatic)instruction);
                break;
            }
            case 169: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.startOfError();
                this.printer.printKeyword(lineNumber, "ret");
                this.printer.endOfError();
                break;
            }
            case 177: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.printKeyword(lineNumber, "return");
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                if (!this.printer.toString().endsWith(" -> ") && !ri.isKeywordPrinted()) {
                    this.printer.printKeyword(ri.getLineNumber(), "return");
                    this.printer.print(' ');
                    ri.setKeywordPrinted(true);
                }
                lineNumber = this.visit(ri.getValueref());
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                lineNumber = this.writeStoreInstruction((StoreInstruction)instruction);
                if (instruction.getNext() == null) break;
                this.printer.print(", ");
                lineNumber = this.visit(instruction.getNext());
                break;
            }
            case 270: {
                lineNumber = this.writeExceptionLoad((ExceptionLoad)instruction);
                break;
            }
            case 279: {
                if (this.firstOffset > this.previousOffset || instruction.getOffset() > this.lastOffset) break;
                this.printer.startOfError();
                this.printer.printKeyword(lineNumber, "returnAddress");
                this.printer.endOfError();
                break;
            }
            case 280: {
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.startOfError();
                    this.printer.print(lineNumber, "tmpTernaryOp");
                    this.printer.print(lineNumber, " = ");
                    this.printer.endOfError();
                }
                lineNumber = this.visit(instruction, ((TernaryOpStore)instruction).getObjectref());
                break;
            }
            case 281: {
                TernaryOperator tp = (TernaryOperator)instruction;
                lineNumber = this.visit(tp.getTest());
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, " ? ");
                }
                lineNumber = this.visit(tp, tp.getValue1());
                nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, " : ");
                }
                lineNumber = this.visit(tp, tp.getValue2());
                break;
            }
            case 282: {
                lineNumber = this.writeInitArrayInstruction((InitArrayInstruction)instruction);
                break;
            }
            case 283: {
                lineNumber = this.writeNewAndInitArrayInstruction((InitArrayInstruction)instruction);
                break;
            }
            case 0: {
                break;
            }
            case 186: {
                if (!(instruction instanceof SourceWriteable tp)) break;
                sw.write(this.printer, this);
                break;
            }
            default: {
                System.err.println("Can not write code for " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
        this.previousOffset = instruction.getOffset();
        return lineNumber;
    }

    protected int visit(Instruction parent, Instruction child) {
        return this.visit(parent.getPriority(), child, false);
    }

    protected int visit(int parentPriority, Instruction child) {
        return this.visit(parentPriority, child, false);
    }

    protected int visit(Instruction parent, Instruction child, boolean alwaysWithParenthesis) {
        return this.visit(parent.getPriority(), child, alwaysWithParenthesis);
    }

    protected int visit(int parentPriority, Instruction child, boolean alwaysWithParenthesis) {
        if (parentPriority >= child.getPriority()) {
            return this.visit(child);
        }
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset || alwaysWithParenthesis) {
            this.printer.print(child.getLineNumber(), '(');
        }
        int lineNumber = this.visit(child);
        nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset || alwaysWithParenthesis) {
            this.printer.print(lineNumber, ')');
        }
        return lineNumber;
    }

    private boolean needAPrefixForThisField(int fieldNameIndex, int fieldDescriptorIndex, GetStatic getStatic) {
        if (this.classFile.getField(fieldNameIndex, fieldDescriptorIndex) != null) {
            return true;
        }
        ConstantFieldref cfr = this.constants.getConstantFieldref(getStatic.getIndex());
        String getStaticOuterClassName = this.constants.getConstantClassName(cfr.getClassIndex());
        String fieldName = this.constants.getConstantUtf8(fieldNameIndex);
        String fieldDescriptor = this.constants.getConstantUtf8(fieldDescriptorIndex);
        ClassFile outerClassFile = this.classFile.getOuterClass();
        while (outerClassFile != null) {
            String outerClassName = outerClassFile.getThisClassName();
            if (outerClassName.equals(getStaticOuterClassName)) break;
            if (outerClassFile.getField(fieldName, fieldDescriptor) != null) {
                return true;
            }
            outerClassFile = outerClassFile.getOuterClass();
        }
        return false;
    }

    private int writeBIPushSIPushIConst(IConst iconst) {
        int lineNumber;
        block20: {
            String signature;
            lineNumber = iconst.getLineNumber();
            if (this.firstOffset > this.previousOffset || iconst.getOffset() > this.lastOffset) break block20;
            int value = iconst.getValue();
            switch (signature = iconst.getSignature()) {
                case "S": {
                    if ((short)value == Short.MIN_VALUE) {
                        this.writeBIPushSIPushIConst(lineNumber, "java/lang/Short", "MIN_VALUE", "S");
                        break;
                    }
                    if ((short)value == Short.MAX_VALUE) {
                        this.writeBIPushSIPushIConst(lineNumber, "java/lang/Short", "MAX_VALUE", "S");
                        break;
                    }
                    this.printer.printNumeric(lineNumber, String.valueOf(value));
                    break;
                }
                case "B": {
                    if (value == -128) {
                        this.writeBIPushSIPushIConst(lineNumber, "java/lang/Byte", "MIN_VALUE", "B");
                        break;
                    }
                    if (value == 127) {
                        this.writeBIPushSIPushIConst(lineNumber, "java/lang/Byte", "MAX_VALUE", "B");
                        break;
                    }
                    this.printer.printNumeric(lineNumber, String.valueOf(value));
                    break;
                }
                case "C": {
                    String escapedString = StringUtil.escapeCharAndAppendApostrophe((char)value);
                    String scopeInternalName = this.classFile.getThisClassName();
                    this.printer.printString(lineNumber, escapedString, scopeInternalName);
                    break;
                }
                case "Z": {
                    this.printer.printKeyword(lineNumber, value == 0 ? "false" : "true");
                    break;
                }
                default: {
                    this.printer.printNumeric(lineNumber, String.valueOf(value));
                }
            }
        }
        return lineNumber;
    }

    private void writeBIPushSIPushIConst(int lineNumber, String internalTypeName, String name, String descriptor) {
        String className = SignatureWriter.internalClassNameToClassName(this.loader, this.referenceMap, this.classFile, internalTypeName);
        String scopeInternalName = this.classFile.getThisClassName();
        this.printer.printType(lineNumber, internalTypeName, className, scopeInternalName);
        this.printer.print(lineNumber, '.');
        this.printer.printStaticField(lineNumber, internalTypeName, name, descriptor, scopeInternalName);
    }

    private int writeArray(Instruction parent, Instruction arrayref, Instruction indexref) {
        int lineNumber = this.visit(parent, arrayref);
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, '[');
        }
        lineNumber = this.visit(parent, indexref);
        if (this.firstOffset <= this.previousOffset && parent.getOffset() <= this.lastOffset) {
            this.printer.print(lineNumber, ']');
        }
        return lineNumber;
    }

    private int writeBinaryOperatorInstruction(BinaryOperatorInstruction boi) {
        String op = boi.getOperator();
        if (op.length() == 1 && Arrays.binarySearch(BIN_OPS, op.charAt(0)) >= 0) {
            int lineNumber = this.writeBinaryOperatorParameterInHexaOrBoolean(boi, boi.getValue1());
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, ' ');
                this.printer.print(lineNumber, op);
                this.printer.print(lineNumber, ' ');
            }
            return this.writeBinaryOperatorParameterInHexaOrBoolean(boi, boi.getValue2());
        }
        int lineNumber = this.visit(boi, boi.getValue1());
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, ' ');
            this.printer.print(lineNumber, op);
            this.printer.print(lineNumber, ' ');
        }
        if (boi.getPriority() > boi.getValue2().getPriority()) {
            return this.visit(boi.getValue2());
        }
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, '(');
        }
        lineNumber = this.visit(boi.getValue2());
        if (this.firstOffset <= this.previousOffset && boi.getOffset() <= this.lastOffset) {
            this.printer.print(lineNumber, ')');
        }
        return lineNumber;
    }

    protected int writeBinaryOperatorParameterInHexaOrBoolean(Instruction parent, Instruction child) {
        if (parent.getPriority() >= child.getPriority()) {
            return this.writeBinaryOperatorParameterInHexaOrBoolean(child);
        }
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(child.getLineNumber(), '(');
        }
        int lineNumber = this.writeBinaryOperatorParameterInHexaOrBoolean(child);
        nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, ')');
        }
        return lineNumber;
    }

    private int writeBinaryOperatorParameterInHexaOrBoolean(Instruction value) {
        int lineNumber = value.getLineNumber();
        if (this.firstOffset <= this.previousOffset && value.getOffset() <= this.lastOffset) {
            switch (value.getOpcode()) {
                case 16: 
                case 17: 
                case 256: {
                    IConst iconst = (IConst)value;
                    if ("Z".equals(iconst.getSignature())) {
                        if (iconst.getValue() == 0) {
                            this.printer.printKeyword(lineNumber, "false");
                            break;
                        }
                        this.printer.printKeyword(lineNumber, "true");
                        break;
                    }
                    this.printer.printNumeric(lineNumber, "0x" + Integer.toHexString(iconst.getValue()).toUpperCase());
                    break;
                }
                case 18: 
                case 20: {
                    this.printer.addNewLinesAndPrefix(lineNumber);
                    Constant cst = this.constants.get(((IndexInstruction)value).getIndex());
                    ConstantValueWriter.writeHexa(this.loader, this.printer, this.referenceMap, this.classFile, cst);
                    break;
                }
                default: {
                    lineNumber = this.visit(value);
                }
            }
        }
        return lineNumber;
    }

    protected int writeIfTest(IfInstruction ifInstruction) {
        Instruction value = ifInstruction.getValue();
        String signature = value.getReturnedSignature(this.classFile, this.localVariables);
        if (signature != null && signature.charAt(0) == 'Z') {
            if (ifInstruction.getCmp() == 0 || ifInstruction.getCmp() == 5 || ifInstruction.getCmp() == 6) {
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(ifInstruction.getLineNumber(), "!");
                }
            }
            return this.visit(2, value);
        }
        int lineNumber = this.visit(6, value);
        if (this.firstOffset <= this.previousOffset && ifInstruction.getOffset() <= this.lastOffset) {
            this.printer.print(' ');
            this.printer.print(CMP_NAMES[ifInstruction.getCmp()]);
            this.printer.print(' ');
            this.printer.printNumeric("0");
        }
        return lineNumber;
    }

    protected int writeIfCmpTest(IfCmp ifCmpInstruction) {
        int lineNumber = this.visit(6, ifCmpInstruction.getValue1());
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, ' ');
            this.printer.print(CMP_NAMES[ifCmpInstruction.getCmp()]);
            this.printer.print(' ');
        }
        return this.visit(6, ifCmpInstruction.getValue2());
    }

    protected int writeIfXNullTest(IfInstruction ifXNull) {
        int lineNumber = this.visit(6, ifXNull.getValue());
        if (this.firstOffset <= this.previousOffset && ifXNull.getOffset() <= this.lastOffset) {
            this.printer.print(lineNumber, ' ');
            this.printer.print(CMP_NAMES[ifXNull.getCmp()]);
            this.printer.print(' ');
            this.printer.printKeyword("null");
        }
        return lineNumber;
    }

    protected int writeComplexConditionalBranchInstructionTest(ComplexConditionalBranchInstruction ccbi) {
        List<Instruction> branchList = ccbi.getInstructions();
        int length = branchList.size();
        if (length > 1) {
            String operator = ccbi.getCmp() == 0 ? " && " : " || ";
            Instruction instruction = branchList.get(0);
            int lineNumber = instruction.getLineNumber();
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, "");
            }
            lineNumber = this.visit(ccbi, instruction, true);
            nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, "");
            }
            int i = 1;
            while (i < length) {
                instruction = branchList.get(i);
                nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, operator);
                    this.printer.print(instruction.getLineNumber(), "");
                }
                lineNumber = this.visit(ccbi, instruction, true);
                if (this.firstOffset <= this.previousOffset && ccbi.getOffset() <= this.lastOffset) {
                    this.printer.print(lineNumber, "");
                }
                ++i;
            }
            return lineNumber;
        }
        if (length > 0) {
            return this.visit(branchList.get(0));
        }
        return 0;
    }

    private int writeIInc(IInc iinc) {
        int lineNumber = iinc.getLineNumber();
        if (this.firstOffset <= this.previousOffset && iinc.getOffset() <= this.lastOffset) {
            int lvNameIndex;
            String lvName = null;
            LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(iinc.getIndex(), iinc.getOffset());
            if (lv != null && (lvNameIndex = lv.getNameIndex()) > 0) {
                lvName = this.constants.getConstantUtf8(lvNameIndex);
            }
            if (lvName == null) {
                this.writeError(lineNumber);
            } else {
                this.printer.print(lineNumber, lvName);
            }
            switch (iinc.getCount()) {
                case -1: {
                    this.printer.print(lineNumber, "--");
                    break;
                }
                case 1: {
                    this.printer.print(lineNumber, "++");
                    break;
                }
                default: {
                    if (iinc.getCount() >= 0) {
                        this.printer.print(lineNumber, " += ");
                        this.printer.printNumeric(lineNumber, String.valueOf(iinc.getCount()));
                        break;
                    }
                    this.printer.print(lineNumber, " -= ");
                    this.printer.printNumeric(lineNumber, String.valueOf(-iinc.getCount()));
                }
            }
        }
        return lineNumber;
    }

    private void writeError(int lineNumber) {
        this.printer.startOfError();
        this.printer.print(lineNumber, "???");
        this.printer.endOfError();
    }

    private int writePreInc(IncInstruction ii) {
        int lineNumber = ii.getLineNumber();
        if (this.firstOffset <= this.previousOffset && ii.getOffset() <= this.lastOffset) {
            int count = ii.getCount();
            Validate.inclusiveBetween((long)-1L, (long)1L, (long)count, (String)("PreInc with value=" + count));
            this.printer.print(lineNumber, count == -1 ? "--" : "++");
            lineNumber = this.visit(ii.getValue());
        }
        return lineNumber;
    }

    private int writePostInc(IncInstruction ii) {
        int lineNumber = ii.getLineNumber();
        if (this.firstOffset <= this.previousOffset && ii.getOffset() <= this.lastOffset) {
            switch (ii.getCount()) {
                case -1: {
                    lineNumber = this.visit(ii.getValue());
                    this.printer.print(lineNumber, "--");
                    break;
                }
                case 1: {
                    lineNumber = this.visit(ii.getValue());
                    this.printer.print(lineNumber, "++");
                    break;
                }
                default: {
                    lineNumber = this.visit(ii.getValue());
                    if (ii.getCount() >= 0) {
                        this.printer.print(lineNumber, " += ");
                        this.printer.printNumeric(lineNumber, String.valueOf(ii.getCount()));
                        break;
                    }
                    this.printer.print(lineNumber, " -= ");
                    this.printer.printNumeric(lineNumber, String.valueOf(-ii.getCount()));
                }
            }
        }
        return lineNumber;
    }

    private int writeInvokeNewInstruction(InvokeNew in) {
        int firstIndex;
        ConstantCP cmr = this.constants.getConstantMethodref(in.getIndex());
        String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
        String prefix = String.valueOf(this.classFile.getThisClassName()) + '$';
        ClassFile innerClassFile = null;
        if (internalClassName.startsWith(prefix)) {
            innerClassFile = this.classFile.getInnerClassFile(internalClassName);
        }
        if (in.getPrefix() != null) {
            this.visit(in.getPrefix());
        }
        int lineNumber = in.getLineNumber();
        int length = in.getArgs().size();
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String constructorName = this.constants.getConstantUtf8(cnat.getNameIndex());
        String constructorDescriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalClassName, constructorName, constructorDescriptor);
        boolean varArgs = methodTypes.isVarArgs();
        if (innerClassFile == null) {
            firstIndex = 0;
        } else if (innerClassFile.getInternalAnonymousClassName() == null) {
            firstIndex = SourceWriterVisitor.computeFirstIndex(innerClassFile.getAccessFlags(), in);
        } else {
            firstIndex = SourceWriterVisitor.computeFirstIndex(this.methodAccessFlags, in);
            Method constructor = innerClassFile.getMethod(constructorName, constructorDescriptor);
            if (constructor != null) {
                length = firstIndex + constructor.getSuperConstructorParameterCount();
            }
        }
        if (this.firstOffset <= this.previousOffset && this.previousOffset < this.lastOffset) {
            if (in.getPrefix() != null) {
                this.printer.print('.');
            }
            this.printer.printKeyword(lineNumber, "new");
            this.printer.print(' ');
            if (innerClassFile == null || innerClassFile.getInternalAnonymousClassName() == null) {
                TypeMaker.TypeTypes newInvokeType;
                BaseTypeParameter typeParameters;
                String typeName;
                int lastIdxOfDollar;
                int idxOfDollar = internalClassName.indexOf(36);
                if (idxOfDollar != (lastIdxOfDollar = internalClassName.lastIndexOf(36)) && internalClassName.substring(idxOfDollar + 1, lastIdxOfDollar).matches("\\d+")) {
                    typeName = SignatureUtil.createTypeName(internalClassName.substring(lastIdxOfDollar + 1));
                } else {
                    typeName = SignatureUtil.createTypeName(internalClassName);
                    if (in.getPrefix() != null) {
                        String sig = SignatureUtil.getInternalName(in.getPrefix().getReturnedSignature(this.classFile, this.localVariables));
                        typeName = typeName.replace(String.valueOf(sig) + '$', "");
                    }
                }
                SignatureWriter.writeConstructor(this.loader, this.printer, this.referenceMap, this.classFile, typeName, constructorDescriptor);
                if (this.classFile.getMajorVersion() >= 51 && (typeParameters = (BaseTypeParameter)Optional.ofNullable(newInvokeType = this.typeMaker.makeTypeTypes(internalClassName)).map(TypeMaker.TypeTypes::getTypeParameters).orElse(null)) != null) {
                    this.printer.print("<>");
                }
            } else {
                SignatureWriter.writeConstructor(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.createTypeName(innerClassFile.getInternalAnonymousClassName()), constructorDescriptor);
                TypeMaker.TypeTypes newInvokeType = this.typeMaker.makeTypeTypes(internalClassName);
                BaseTypeArgument typeArguments = SourceWriterVisitor.searchTypeArguments(newInvokeType);
                this.visitTypeArgumentList(typeArguments);
            }
        }
        return this.writeArgs(in.getLineNumber(), firstIndex, length, in.getArgs(), varArgs);
    }

    /*
     * WARNING - void declaration
     */
    private static BaseTypeArgument searchTypeArguments(TypeMaker.TypeTypes newInvokeType) {
        ObjectType superType = newInvokeType.getSuperType();
        if (superType != null && superType.getTypeArguments() != null) {
            return superType.getTypeArguments();
        }
        BaseType interfaces = newInvokeType.getInterfaces();
        if (interfaces != null) {
            for (Type interf : interfaces) {
                void ot;
                ObjectType objectType;
                Type type = interf;
                if (!(type instanceof ObjectType) || (objectType = (ObjectType)type) != (ObjectType)type || ot.getTypeArguments() == null) continue;
                return ot.getTypeArguments();
            }
        }
        return null;
    }

    private static int computeFirstIndex(int accessFlags, InvokeNew in) {
        if ((accessFlags & 8) != 0 || in.getArgs().isEmpty()) {
            return 0;
        }
        Instruction arg0 = in.getArgs().get(0);
        if (arg0.getOpcode() == 25 && ((ALoad)arg0).getIndex() == 0) {
            return 1;
        }
        return 0;
    }

    private int writeEnumValueInstruction(InvokeNew in) {
        int lineNumber = in.getLineNumber();
        ConstantFieldref cfr = this.constants.getConstantFieldref(in.getEnumValueFieldRefIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String internalClassName = this.classFile.getThisClassName();
        String name = this.constants.getConstantUtf8(cnat.getNameIndex());
        String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        this.printer.addNewLinesAndPrefix(lineNumber);
        this.printer.printStaticFieldDeclaration(internalClassName, name, descriptor);
        if (in.getArgs().size() > 2) {
            lineNumber = this.writeArgs(lineNumber, 2, in.getArgs().size(), in.getArgs(), false);
        }
        return lineNumber;
    }

    private int writeGetField(GetField getField) {
        int lineNumber = getField.getLineNumber();
        ConstantFieldref cfr = this.constants.getConstantFieldref(getField.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        Field field = this.classFile.getField(cnat.getNameIndex(), cnat.getSignatureIndex());
        Instruction objectref = getField.getObjectref();
        ClassFile outerClass = this.classFile.getOuterClass();
        if (field == null && objectref instanceof GetStatic var8_9 && outerClass != null) {
            String returnedSignature = gs.getReturnedSignature(this.classFile, this.localVariables);
            String internalName = SignatureUtil.getInternalName(returnedSignature);
            String outerClassName = outerClass.getThisClassName();
            if (outerClassName.equals(internalName)) {
                String fieldName = this.constants.getConstantUtf8(cnat.getNameIndex());
                String fieldSignature = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                field = outerClass.getField(fieldName, fieldSignature);
            }
        }
        if (field != null && field.getOuterMethodLocalVariableNameIndex() != -1) {
            if (this.firstOffset <= this.previousOffset && getField.getOffset() <= this.lastOffset) {
                String internalClassName = this.constants.getConstantClassName(cfr.getClassIndex());
                fieldName = field.getConstantPool().getConstantUtf8(field.getOuterMethodLocalVariableNameIndex());
                if (this.keywordSet.contains(fieldName)) {
                    fieldName = "jdField_" + fieldName;
                }
                String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                this.printer.printField(lineNumber, internalClassName, fieldName, descriptor, this.classFile.getThisClassName());
            }
        } else {
            boolean displayPrefix = false;
            if (this.localVariables.containsLocalVariableWithNameIndex(cnat.getNameIndex())) {
                if (objectref.getOpcode() == 25) {
                    if (((ALoad)objectref).getIndex() == 0) {
                        displayPrefix = true;
                    }
                } else if (objectref.getOpcode() == 285 && !this.needAPrefixForThisField(cnat.getNameIndex(), cnat.getSignatureIndex(), (GetStatic)objectref)) {
                    displayPrefix = true;
                }
            }
            if ((fieldName = this.constants.getConstantUtf8(cnat.getNameIndex())).startsWith("val$") && field != null && (field.getAccessFlags() & 0x1000) != 0) {
                fieldName = fieldName.substring(4);
                field.setOuterLocalVariable(true);
            }
            if (this.firstOffset <= this.previousOffset && objectref.getOffset() <= this.lastOffset) {
                if (!displayPrefix) {
                    this.printer.addNewLinesAndPrefix(lineNumber);
                    this.printer.startOfOptionalPrefix();
                }
                if (field == null || !field.isOuterLocalVariable()) {
                    lineNumber = this.visit(getField, objectref);
                    this.printer.print(lineNumber, '.');
                }
                if (!displayPrefix) {
                    this.printer.endOfOptionalPrefix();
                }
            }
            if (this.firstOffset <= this.previousOffset && getField.getOffset() <= this.lastOffset) {
                String internalClassName = this.constants.getConstantClassName(cfr.getClassIndex());
                if (this.keywordSet.contains(fieldName)) {
                    fieldName = "jdField_" + fieldName;
                }
                String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                this.printer.printField(lineNumber, internalClassName, fieldName, descriptor, this.classFile.getThisClassName());
            }
        }
        return lineNumber;
    }

    private int writeInvokeNoStaticInstruction(InvokeNoStaticInstruction insi) {
        String name;
        ALoad aload;
        LocalVariable lv;
        ConstantCP cmr = this.constants.getConstantMethodref(insi.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        boolean thisInvoke = false;
        if (insi.getObjectref().getOpcode() == 25 && ((ALoad)insi.getObjectref()).getIndex() == 0 && (lv = this.localVariables.getLocalVariableWithIndexAndOffset((aload = (ALoad)insi.getObjectref()).getIndex(), aload.getOffset())) != null && lv.getNameIndex() != -1 && "this".equals(name = this.constants.getConstantUtf8(lv.getNameIndex()))) {
            thisInvoke = true;
        }
        boolean varArgs = false;
        if (thisInvoke) {
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
                String methodName = this.constants.getConstantUtf8(cnat.getNameIndex());
                if (this.keywordSet.contains(methodName)) {
                    methodName = "jdMethod_" + methodName;
                }
                String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                this.printer.printMethod(insi.getLineNumber(), internalClassName, methodName, descriptor, this.classFile.getThisClassName());
                TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalClassName, methodName, descriptor);
                varArgs = methodTypes.isVarArgs();
            }
        } else {
            boolean displayPrefix = insi.getObjectref().getOpcode() != 285 || this.needAPrefixForThisMethod(cnat.getNameIndex(), cnat.getSignatureIndex(), (GetStatic)insi.getObjectref());
            int lineNumber = insi.getObjectref().getLineNumber();
            if (!displayPrefix) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                this.printer.startOfOptionalPrefix();
            }
            this.visit(insi, insi.getObjectref());
            int nextOffset = this.previousOffset + 1;
            lineNumber = insi.getLineNumber();
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, '.');
            }
            if (!displayPrefix) {
                this.printer.endOfOptionalPrefix();
            }
            nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
                String methodName = this.constants.getConstantUtf8(cnat.getNameIndex());
                if (this.keywordSet.contains(methodName)) {
                    methodName = "jdMethod_" + methodName;
                }
                String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                this.printer.printMethod(lineNumber, internalClassName, methodName, descriptor, this.classFile.getThisClassName());
                TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalClassName, methodName, descriptor);
                varArgs = methodTypes.isVarArgs();
            }
        }
        return this.writeArgs(insi.getLineNumber(), 0, insi.getArgs().size(), insi.getArgs(), varArgs);
    }

    private boolean needAPrefixForThisMethod(int methodNameIndex, int methodDescriptorIndex, GetStatic getStatic) {
        String methodDescriptor;
        String methodName = this.constants.getConstantUtf8(methodNameIndex);
        if (this.classFile.getMethod(methodName, methodDescriptor = this.constants.getConstantUtf8(methodDescriptorIndex)) != null) {
            return true;
        }
        ConstantFieldref cfr = this.constants.getConstantFieldref(getStatic.getIndex());
        String getStaticOuterClassName = this.constants.getConstantClassName(cfr.getClassIndex());
        ClassFile outerClassFile = this.classFile.getOuterClass();
        while (outerClassFile != null) {
            String outerClassName = outerClassFile.getThisClassName();
            if (outerClassName.equals(getStaticOuterClassName)) break;
            if (outerClassFile.getMethod(methodName, methodDescriptor) != null) {
                return true;
            }
            outerClassFile = outerClassFile.getOuterClass();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private int writeInvokespecial(InvokeNoStaticInstruction insi) {
        InvokeNoStaticInstruction nameAndType;
        Instruction instruction;
        int firstIndex;
        ALoad aload;
        Object lv;
        ConstantCP cmr = this.constants.getConstantMethodref(insi.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        boolean thisInvoke = false;
        if (insi.getObjectref().getOpcode() == 25 && ((ALoad)insi.getObjectref()).getIndex() == 0 && (lv = this.localVariables.getLocalVariableWithIndexAndOffset((aload = (ALoad)insi.getObjectref()).getIndex(), aload.getOffset())) != null && ((LocalVariable)lv).getNameIndex() == this.constants.getThisLocalVariableNameIndex()) {
            thisInvoke = true;
        }
        if (thisInvoke && cnat.getNameIndex() == this.constants.getInstanceConstructorIndex()) {
            if (cmr.getClassIndex() == this.classFile.getThisClassIndex()) {
                firstIndex = (this.classFile.getAccessFlags() & 0x4000) == 0 ? (this.classFile.isAInnerClass() && (this.classFile.getAccessFlags() & 8) == 0 ? 1 : 0) : 2;
            } else if (this.classFile.isAInnerClass()) {
                Instruction instruction2;
                firstIndex = 0;
                if (!insi.getArgs().isEmpty() && (instruction = (instruction2 = insi.getArgs().get(0))) instanceof GetStatic && (lv = (GetStatic)instruction) == (GetStatic)instruction && instruction2.getOpcode() == 285) {
                    void getStatic;
                    ConstantFieldref fieldref = this.constants.getConstantFieldref(getStatic.getIndex());
                    nameAndType = this.constants.getConstantNameAndType(fieldref.getNameAndTypeIndex());
                    String name = this.constants.getConstantUtf8(nameAndType.getNameIndex());
                    String suffix = "$" + this.classFile.getClassName() + ";";
                    String internalName = this.classFile.getInternalClassName();
                    if ("this".equals(name) && internalName.endsWith(suffix)) {
                        firstIndex = 1;
                    }
                }
            } else {
                firstIndex = 0;
            }
        } else {
            firstIndex = 0;
        }
        boolean varArgs = false;
        if (thisInvoke) {
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                int lineNumber = insi.getLineNumber();
                if (cnat.getNameIndex() == this.constants.getInstanceConstructorIndex()) {
                    if (cmr.getClassIndex() == this.classFile.getThisClassIndex()) {
                        this.printer.printKeyword(lineNumber, "this");
                    } else {
                        void is;
                        nameAndType = insi;
                        if (nameAndType instanceof Invokespecial && (instruction = (Invokespecial)nameAndType) == (Invokespecial)nameAndType && is.getPrefix() != null) {
                            this.visit(is.getPrefix());
                            this.printer.print('.');
                        }
                        this.printer.printKeyword(lineNumber, "super");
                    }
                } else {
                    String descriptor;
                    String methodName = this.constants.getConstantUtf8(cnat.getNameIndex());
                    Method method = this.classFile.getMethod(methodName, descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex()));
                    if (method == null || (method.getAccessFlags() & 2) == 0) {
                        this.printer.printKeyword(lineNumber, "super");
                        this.printer.print(lineNumber, '.');
                    }
                    String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
                    if (this.keywordSet.contains(methodName)) {
                        methodName = "jdMethod_" + methodName;
                    }
                    this.printer.printMethod(lineNumber, internalClassName, methodName, descriptor, this.classFile.getThisClassName());
                }
            }
        } else {
            int lineNumber = insi.getLineNumber();
            this.visit(insi, insi.getObjectref());
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, '.');
                String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
                String methodName = this.constants.getConstantUtf8(cnat.getNameIndex());
                if (this.keywordSet.contains(methodName)) {
                    methodName = "jdMethod_" + methodName;
                }
                String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalClassName, methodName, descriptor);
                varArgs = methodTypes.isVarArgs();
                this.printer.printMethod(internalClassName, methodName, descriptor, this.classFile.getThisClassName());
            }
        }
        return this.writeArgs(insi.getLineNumber(), firstIndex, insi.getArgs().size(), insi.getArgs(), varArgs);
    }

    private int writeInvokestatic(Invokestatic invokestatic) {
        boolean varArgs = false;
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && (nextOffset <= this.lastOffset || this.lastOffset == 0)) {
            ConstantNameAndType cnat;
            String methodName;
            int lineNumber = invokestatic.getLineNumber();
            ConstantCP cmr = this.constants.getConstantMethodref(invokestatic.getIndex());
            String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
            if (this.classFile.getThisClassIndex() != cmr.getClassIndex()) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                int length = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.createTypeName(this.constants.getConstantClassName(cmr.getClassIndex())));
                if (length > 0) {
                    this.printer.print('.');
                }
            }
            if (this.keywordSet.contains(methodName = this.constants.getConstantUtf8((cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex())).getNameIndex()))) {
                methodName = "jdMethod_" + methodName;
            }
            String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
            TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalClassName, methodName, descriptor);
            varArgs = methodTypes.isVarArgs();
            this.printer.printStaticMethod(lineNumber, internalClassName, methodName, descriptor, this.classFile.getThisClassName());
        }
        return this.writeArgs(invokestatic.getLineNumber(), 0, invokestatic.getArgs().size(), invokestatic.getArgs(), varArgs);
    }

    /*
     * WARNING - void declaration
     */
    private int writeArgs(int lineNumber, int firstIndex, int length, List<Instruction> args, boolean varArgs) {
        if (length > firstIndex) {
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, '(');
            }
            if (firstIndex < args.size()) {
                lineNumber = this.visit(args.get(firstIndex));
            }
            int i = firstIndex + 1;
            while (i < length && i < args.size()) {
                InitArrayInstruction initArrayInstruction;
                Instruction instruction;
                void dimension;
                IConst iConst;
                void aNewArray;
                Instruction instruction2;
                ANewArray aNewArray2;
                Instruction instruction3;
                if (varArgs && i == args.size() - 1 && (instruction3 = args.get(i)) instanceof ANewArray && (aNewArray2 = (ANewArray)instruction3) == (ANewArray)instruction3 && (instruction2 = aNewArray.getDimension()) instanceof IConst && (iConst = (IConst)instruction2) == (IConst)instruction2 && dimension.getValue() == 0) break;
                nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, ", ");
                }
                if (varArgs && i == args.size() - 1 && (instruction = args.get(i)) instanceof InitArrayInstruction && (initArrayInstruction = (InitArrayInstruction)instruction) == (InitArrayInstruction)instruction) {
                    void iai;
                    Iterator<Instruction> it = iai.getValues().iterator();
                    while (it.hasNext()) {
                        Instruction varArg = it.next();
                        lineNumber = this.visit(varArg);
                        if (!it.hasNext()) continue;
                        this.printer.print(lineNumber, ", ");
                    }
                } else {
                    lineNumber = this.visit(args.get(i));
                }
                ++i;
            }
            nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, ')');
            }
        } else {
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && (nextOffset <= this.lastOffset || this.lastOffset == 0)) {
                this.printer.print(lineNumber, "()");
            }
        }
        return lineNumber;
    }

    private int writeGetStatic(GetStatic getStatic) {
        int lineNumber = getStatic.getLineNumber();
        if (this.firstOffset <= this.previousOffset && getStatic.getOffset() <= this.lastOffset) {
            ConstantFieldref cfr = this.constants.getConstantFieldref(getStatic.getIndex());
            String internalClassName = this.constants.getConstantClassName(cfr.getClassIndex());
            if (cfr.getClassIndex() != this.classFile.getThisClassIndex()) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                String className = SignatureUtil.createTypeName(internalClassName);
                int length = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, className);
                if (length > 0) {
                    this.printer.print(lineNumber, '.');
                }
            }
            ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
            String constName = this.constants.getConstantUtf8(cnat.getNameIndex());
            this.printer.printStaticField(lineNumber, internalClassName, constName, descriptor, this.classFile.getThisClassName());
        }
        return lineNumber;
    }

    private int writeOuterThis(GetStatic getStatic) {
        int lineNumber = getStatic.getLineNumber();
        if (this.firstOffset <= this.previousOffset && getStatic.getOffset() <= this.lastOffset) {
            ConstantFieldref cfr = this.constants.getConstantFieldref(getStatic.getIndex());
            if (cfr.getClassIndex() != this.classFile.getThisClassIndex()) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                int length = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.createTypeName(this.constants.getConstantClassName(cfr.getClassIndex())));
                if (length > 0) {
                    this.printer.print(lineNumber, '.');
                }
            }
            ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            this.printer.printKeyword(lineNumber, this.constants.getConstantUtf8(cnat.getNameIndex()));
        }
        return lineNumber;
    }

    private int writeLcdInstruction(IndexInstruction ii) {
        int lineNumber = ii.getLineNumber();
        if (this.firstOffset <= this.previousOffset && ii.getOffset() <= this.lastOffset) {
            Constant cst = this.constants.get(ii.getIndex());
            if (cst instanceof ConstantClass var4_5) {
                String signature = SignatureUtil.createTypeName(this.constants.getConstantUtf8(cc.getNameIndex()));
                this.printer.addNewLinesAndPrefix(lineNumber);
                SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
                this.printer.print('.');
                this.printer.printKeyword("class");
            } else {
                this.printer.addNewLinesAndPrefix(lineNumber);
                ConstantValueWriter.write(this.loader, this.printer, this.referenceMap, this.classFile, cst);
            }
        }
        return lineNumber;
    }

    private int writeLoadInstruction(LoadInstruction loadInstruction) {
        int lineNumber = loadInstruction.getLineNumber();
        if (this.firstOffset <= this.previousOffset && loadInstruction.getOffset() <= this.lastOffset) {
            LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(loadInstruction.getIndex(), loadInstruction.getOffset());
            if (lv == null || lv.getNameIndex() <= 0) {
                this.writeError(lineNumber);
            } else {
                int nameIndex = lv.getNameIndex();
                if (nameIndex == this.constants.getThisLocalVariableNameIndex()) {
                    this.printer.printKeyword(lineNumber, this.constants.getConstantUtf8(lv.getNameIndex()));
                } else {
                    this.printer.print(lineNumber, this.constants.getConstantUtf8(lv.getNameIndex()));
                }
            }
        }
        return lineNumber;
    }

    private int writeMultiANewArray(MultiANewArray multiANewArray) {
        int lineNumber = multiANewArray.getLineNumber();
        String signature = this.constants.getConstantClassName(multiANewArray.getIndex());
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.printKeyword(lineNumber, "new");
            this.printer.print(' ');
            SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.cutArrayDimensionPrefix(signature));
        }
        List<Instruction> dimensions = multiANewArray.getDimensions();
        int i = dimensions.size() - 1;
        while (i >= 0) {
            nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, '[');
            }
            lineNumber = this.visit(dimensions.get(i));
            nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.print(lineNumber, ']');
            }
            --i;
        }
        nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            int dimensionCount = SignatureUtil.getArrayDimensionCount(signature);
            int i2 = dimensions.size();
            while (i2 < dimensionCount) {
                this.printer.print(lineNumber, "[]");
                ++i2;
            }
        }
        return lineNumber;
    }

    private int writePutStatic(PutStatic putStatic) {
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            int lineNumber = putStatic.getLineNumber();
            ConstantFieldref cfr = this.constants.getConstantFieldref(putStatic.getIndex());
            if (cfr.getClassIndex() != this.classFile.getThisClassIndex()) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                String signature = SignatureUtil.createTypeName(this.constants.getConstantClassName(cfr.getClassIndex()));
                int length = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
                if (length > 0) {
                    this.printer.print(lineNumber, '.');
                }
            }
            ConstantNameAndType cnat = this.constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
            String internalClassName = SignatureUtil.getInternalName(descriptor);
            String constName = this.constants.getConstantUtf8(cnat.getNameIndex());
            this.printer.printStaticField(lineNumber, internalClassName, constName, descriptor, this.classFile.getThisClassName());
            this.printer.print(lineNumber, " = ");
        }
        return this.visit(putStatic.getValueref());
    }

    private int writeStoreInstruction(StoreInstruction storeInstruction) {
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            int lineNumber = storeInstruction.getLineNumber();
            LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(storeInstruction.getIndex(), storeInstruction.getOffset());
            if (lv == null || lv.getNameIndex() <= 0) {
                this.writeError(lineNumber);
            } else {
                this.printer.print(lineNumber, this.constants.getConstantUtf8(lv.getNameIndex()));
            }
            this.printer.print(lineNumber, " = ");
        }
        return this.visit(storeInstruction.getValueref());
    }

    private int writeExceptionLoad(ExceptionLoad exceptionLoad) {
        int lineNumber = exceptionLoad.getLineNumber();
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            if (exceptionLoad.getExceptionNameIndex() == 0) {
                this.printer.printKeyword(lineNumber, "finally");
            } else {
                LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(exceptionLoad.getIndex(), exceptionLoad.getOffset());
                if (lv == null || lv.getNameIndex() == 0) {
                    this.writeError(lineNumber);
                } else {
                    this.printer.print(lineNumber, this.constants.getConstantUtf8(lv.getNameIndex()));
                }
            }
        }
        return lineNumber;
    }

    private int writeAssignmentInstruction(AssignmentInstruction ai) {
        int lineNumber = ai.getLineNumber();
        int previousOffsetBackup = this.previousOffset;
        this.visit(ai.getValue1());
        this.previousOffset = previousOffsetBackup;
        int nextOffset = this.previousOffset + 1;
        String op = ai.getOperator();
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, ' ');
            this.printer.print(lineNumber, op);
            this.printer.print(lineNumber, ' ');
        }
        if (!op.isEmpty() && Arrays.binarySearch(BIN_OPS, op.charAt(0)) >= 0) {
            return this.writeBinaryOperatorParameterInHexaOrBoolean(ai, ai.getValue2());
        }
        return this.visit(ai, ai.getValue2());
    }

    private int writeConvertInstruction(ConvertInstruction instruction) {
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            int lineNumber = instruction.getLineNumber();
            switch (instruction.getSignature().charAt(0)) {
                case 'C': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("char");
                    this.printer.print(')');
                    break;
                }
                case 'B': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("byte");
                    this.printer.print(')');
                    break;
                }
                case 'S': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("short");
                    this.printer.print(')');
                    break;
                }
                case 'I': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("int");
                    this.printer.print(')');
                    break;
                }
                case 'J': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("long");
                    this.printer.print(')');
                    break;
                }
                case 'F': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("float");
                    this.printer.print(')');
                    break;
                }
                case 'D': {
                    this.printer.print(lineNumber, '(');
                    this.printer.printKeyword("double");
                    this.printer.print(')');
                }
            }
        }
        return this.visit(instruction, instruction.getValue());
    }

    private int writeDeclaration(FastDeclaration fd) {
        int lineNumber = fd.getLineNumber();
        LocalVariable lv = this.localVariables.getLocalVariableWithIndexAndOffset(fd.getLv().getIndex(), fd.getOffset());
        if (lv == null) {
            if (fd.getInstruction() == null) {
                int nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.writeError(lineNumber);
                }
            } else {
                lineNumber = this.visit(fd.getInstruction());
            }
        } else {
            int nextOffset = this.previousOffset + 1;
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                this.printer.addNewLinesAndPrefix(lineNumber);
                String signature = lv.getSignature(this.constants);
                String internalName = SignatureUtil.getInternalName(signature);
                ClassFile innerClassFile = this.classFile.getInnerClassFile(internalName);
                if (lv.hasFinalFlag()) {
                    this.printer.printKeyword("final");
                    this.printer.print(' ');
                }
                if (innerClassFile != null && innerClassFile.getInternalAnonymousClassName() != null) {
                    String internalAnonymousClassSignature = SignatureUtil.createTypeName(innerClassFile.getInternalAnonymousClassName());
                    SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, internalAnonymousClassSignature);
                } else {
                    SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
                }
                this.printer.print(' ');
            }
            if (fd.getInstruction() == null) {
                nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, this.constants.getConstantUtf8(lv.getNameIndex()));
                }
            } else {
                lineNumber = this.visit(fd.getInstruction());
            }
        }
        return lineNumber;
    }

    private int writeInitArrayInstruction(InitArrayInstruction iai) {
        List<Instruction> values;
        int length;
        int lineNumber = iai.getLineNumber();
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, "{");
        }
        if ((length = (values = iai.getValues()).size()) > 0) {
            Instruction instruction = values.get(0);
            if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset && lineNumber == instruction.getLineNumber()) {
                this.printer.print(" ");
            }
            lineNumber = this.visit(instruction);
            int i = 1;
            while (i < length) {
                nextOffset = this.previousOffset + 1;
                if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
                    this.printer.print(lineNumber, ", ");
                }
                lineNumber = this.visit(values.get(i));
                ++i;
            }
        }
        nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            this.printer.print(lineNumber, " }");
        }
        return lineNumber;
    }

    private int writeNewAndInitArrayInstruction(InitArrayInstruction iai) {
        int nextOffset = this.previousOffset + 1;
        if (this.firstOffset <= this.previousOffset && nextOffset <= this.lastOffset) {
            int lineNumber = iai.getLineNumber();
            this.printer.printKeyword(lineNumber, "new");
            this.printer.print(' ');
            if (iai.getNewArray().getOpcode() == 188) {
                NewArray na = (NewArray)iai.getNewArray();
                SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, SignatureUtil.getSignatureFromType(na.getType()));
            } else if (iai.getNewArray().getOpcode() == 189) {
                ANewArray ana = (ANewArray)iai.getNewArray();
                String signature = this.constants.getConstantClassName(ana.getIndex());
                if (signature.charAt(0) != '[') {
                    signature = SignatureUtil.createTypeName(signature);
                }
                SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, signature);
            }
            this.printer.print(lineNumber, "[] ");
        }
        return this.writeInitArrayInstruction(iai);
    }

    public void visit(TypeArguments arguments) {
        this.printTokensForList((List)arguments, ", ");
    }

    public void visit(WildcardExtendsTypeArgument argument) {
        this.printer.print("? extends ");
        Type type = argument.type();
        type.accept((TypeVisitor)this);
    }

    public void visit(ObjectType type) {
        BaseTypeArgument typeArguments;
        ObjectType zeroDimType = type.getDimension() == 0 ? type : type.createType(0);
        SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, this.classFile, zeroDimType.getDescriptor());
        if (this.classFile.getMajorVersion() >= 49 && (typeArguments = type.getTypeArguments()) != null) {
            this.visitTypeArgumentList(typeArguments);
        }
        this.visitDimension(type.getDimension());
    }

    public void visit(InnerObjectType type) {
        this.visit((ObjectType)type);
    }

    protected void visitTypeArgumentList(BaseTypeArgument arguments) {
        if (arguments != null) {
            this.printer.print('<');
            if (this.classFile.getMajorVersion() < 53) {
                arguments.accept((TypeArgumentVisitor)this);
            }
            this.printer.print('>');
        }
    }

    protected void visitDimension(int dimension) {
        int i = 0;
        while (i < dimension) {
            this.printer.print("[]");
            ++i;
        }
    }

    public void visit(WildcardSuperTypeArgument argument) {
        this.printer.print("? super ");
        Type type = argument.type();
        type.accept((TypeVisitor)this);
    }

    public void visit(GenericType type) {
        this.printer.print(type.getName());
        this.visitDimension(type.getDimension());
    }

    public void visit(WildcardTypeArgument type) {
        this.printer.print('?');
    }

    protected <T extends TypeArgumentVisitable> void printTokensForList(List<T> list, String separator) {
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            ((TypeArgumentVisitable)it.next()).accept((TypeArgumentVisitor)this);
            if (!it.hasNext()) continue;
            this.printer.print(separator);
        }
    }

    public void visit(Types types) {
    }
}

