/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.model.classfile.ClassFile;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.AnnotationWriter;
import jd.core.process.writer.ElementValuePrimitiveTypeWriter;
import jd.core.process.writer.SignatureWriter;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.AnnotationElementValue;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.SimpleElementValue;
import org.jd.core.v1.api.loader.Loader;

public final class ElementValueWriter {
    private ElementValueWriter() {
    }

    public static void writeElementValue(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, ElementValue ev) {
        if (ev instanceof SimpleElementValue var5_6) {
            ElementValuePrimitiveTypeWriter.write(loader, printer, referenceMap, classFile, (SimpleElementValue)evpt);
        }
        if (ev instanceof ClassElementValue var8_8) {
            signature = evci.getClassString();
            SignatureWriter.writeSignature(loader, printer, referenceMap, classFile, (String)signature);
            printer.print('.');
            printer.printKeyword("class");
        }
        if ((var13_10 = ev) instanceof AnnotationElementValue && (signature = (AnnotationElementValue)var13_10) == (AnnotationElementValue)var13_10) {
            AnnotationWriter.writeAnnotation(loader, printer, referenceMap, classFile, evav.getAnnotationEntry());
        }
        if (ev instanceof ArrayElementValue var14_12) {
            values = evarv.getElementValuesArray();
            printer.print('{');
            if (values.length > 0) {
                ElementValueWriter.writeElementValue(loader, printer, referenceMap, classFile, values[0]);
                int i = 1;
                while (i < values.length) {
                    printer.print(", ");
                    ElementValueWriter.writeElementValue(loader, printer, referenceMap, classFile, values[i]);
                    ++i;
                }
            }
            printer.print('}');
        }
        if ((var19_15 = ev) instanceof EnumElementValue && (values = (ElementValue[])var19_15) == (EnumElementValue)var19_15) {
            String signature = evecv.getEnumTypeString();
            String constName = evecv.getEnumValueString();
            String internalClassName = SignatureUtil.getInternalName(signature);
            SignatureWriter.writeSignature(loader, printer, referenceMap, classFile, signature);
            printer.print('.');
            printer.printStaticField(internalClassName, constName, signature, classFile.getThisClassName());
        }
    }
}

