/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.ConstantValueWriter;
import jd.core.util.StringUtil;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.SimpleElementValue;
import org.jd.core.v1.api.loader.Loader;

public final class ElementValuePrimitiveTypeWriter {
    private ElementValuePrimitiveTypeWriter() {
    }

    public static void write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, SimpleElementValue evpt) {
        ConstantPool constants = classFile.getConstantPool();
        if (evpt.getElementValueType() == 115) {
            String constValue = evpt.getValueString();
            String escapedString = StringUtil.escapeStringAndAppendQuotationMark(constValue);
            printer.printString(escapedString, classFile.getThisClassName());
        } else {
            Constant cv = constants.getConstantValue(evpt.getIndex());
            ConstantValueWriter.write(loader, printer, referenceMap, classFile, cv, evpt.getElementValueType());
        }
    }
}

