/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.SignatureWriter;
import jd.core.util.StringUtil;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.jd.core.v1.api.loader.Loader;

public final class ConstantValueWriter {
    private ConstantValueWriter() {
    }

    public static void write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Constant cv) {
        ConstantValueWriter.write(loader, printer, referenceMap, classFile, cv, 0);
    }

    public static void write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Constant cv, int constantIntegerType) {
        ConstantPool constants = classFile.getConstantPool();
        block0 : switch (cv.getTag()) {
            case 6: {
                double d = ((ConstantDouble)cv).getBytes();
                if (Double.compare(d, Double.POSITIVE_INFINITY) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Double", "POSITIVE_INFINITY", "D");
                    break;
                }
                if (Double.compare(d, Double.NEGATIVE_INFINITY) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Double", "NEGATIVE_INFINITY", "D");
                    break;
                }
                if (Double.isNaN(d)) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Double", "NaN", "D");
                    break;
                }
                if (Double.compare(d, Double.MAX_VALUE) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Double", "MAX_VALUE", "D");
                    break;
                }
                if (Double.compare(d, Double.MIN_VALUE) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Double", "MIN_VALUE", "D");
                    break;
                }
                String value = String.valueOf(d);
                if (value.indexOf(46) == -1) {
                    value = String.valueOf(value) + ".0";
                }
                printer.printNumeric(String.valueOf(value) + 'D');
                break;
            }
            case 4: {
                float value = ((ConstantFloat)cv).getBytes();
                if (Float.compare(value, Float.POSITIVE_INFINITY) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Float", "POSITIVE_INFINITY", "F");
                    break;
                }
                if (Float.compare(value, Float.NEGATIVE_INFINITY) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Float", "NEGATIVE_INFINITY", "F");
                    break;
                }
                if (Float.isNaN(value)) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Float", "NaN", "F");
                    break;
                }
                if (Float.compare(value, Float.MAX_VALUE) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Float", "MAX_VALUE", "F");
                    break;
                }
                if (Float.compare(value, Float.MIN_VALUE) == 0) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Float", "MIN_VALUE", "F");
                    break;
                }
                String s = String.valueOf(value);
                if (s.indexOf(46) == -1) {
                    s = String.valueOf(s) + ".0";
                }
                printer.printNumeric(String.valueOf(s) + 'F');
                break;
            }
            case 3: {
                int value = ((ConstantInteger)cv).getBytes();
                switch (constantIntegerType) {
                    case 90: {
                        printer.printKeyword(value == 0 ? "false" : "true");
                        break block0;
                    }
                    case 67: {
                        String escapedString = StringUtil.escapeCharAndAppendApostrophe((char)value);
                        String scopeInternalName = classFile.getThisClassName();
                        printer.printString(escapedString, scopeInternalName);
                        break block0;
                    }
                }
                if (value == Integer.MIN_VALUE) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Integer", "MIN_VALUE", "I");
                    break;
                }
                if (value == Integer.MAX_VALUE) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Integer", "MAX_VALUE", "I");
                    break;
                }
                printer.printNumeric(String.valueOf(value));
                break;
            }
            case 5: {
                long value = ((ConstantLong)cv).getBytes();
                if (value == Long.MIN_VALUE) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Long", "MIN_VALUE", "J");
                    break;
                }
                if (value == Long.MAX_VALUE) {
                    ConstantValueWriter.write(loader, printer, referenceMap, classFile, "java/lang/Long", "MAX_VALUE", "J");
                    break;
                }
                printer.printNumeric(String.valueOf(String.valueOf(value)) + 'L');
                break;
            }
            case 8: {
                String s = constants.getConstantUtf8(((ConstantString)cv).getStringIndex());
                String escapedString = StringUtil.escapeStringAndAppendQuotationMark(s);
                String scopeInternalName = classFile.getThisClassName();
                printer.printString(escapedString, scopeInternalName);
            }
        }
    }

    private static void write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, String internalTypeName, String name, String descriptor) {
        String className = SignatureWriter.internalClassNameToClassName(loader, referenceMap, classFile, internalTypeName);
        String scopeInternalName = classFile.getThisClassName();
        printer.printType(internalTypeName, className, scopeInternalName);
        printer.print('.');
        printer.printStaticField(internalTypeName, name, descriptor, scopeInternalName);
    }

    public static void writeHexa(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Constant cv) {
        switch (cv.getTag()) {
            case 3: {
                printer.printNumeric("0x" + Integer.toHexString(((ConstantInteger)cv).getBytes()).toUpperCase());
                break;
            }
            case 5: {
                printer.printNumeric("0x" + Long.toHexString(((ConstantLong)cv).getBytes()).toUpperCase() + "L");
                break;
            }
            default: {
                ConstantValueWriter.write(loader, printer, referenceMap, classFile, cv, 0);
            }
        }
    }
}

