/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.layout.block.AnnotationsLayoutBlock;
import jd.core.model.layout.block.BlockLayoutBlock;
import jd.core.model.layout.block.ByteCodeLayoutBlock;
import jd.core.model.layout.block.CaseBlockEndLayoutBlock;
import jd.core.model.layout.block.CaseBlockStartLayoutBlock;
import jd.core.model.layout.block.CaseEnumLayoutBlock;
import jd.core.model.layout.block.CaseLayoutBlock;
import jd.core.model.layout.block.DeclareLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.FastCatchLayoutBlock;
import jd.core.model.layout.block.FieldNameLayoutBlock;
import jd.core.model.layout.block.GenericExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.GenericImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericTypeNameLayoutBlock;
import jd.core.model.layout.block.ImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.ImportsLayoutBlock;
import jd.core.model.layout.block.InstructionLayoutBlock;
import jd.core.model.layout.block.InstructionsLayoutBlock;
import jd.core.model.layout.block.LambdaMethodLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.model.layout.block.MarkerLayoutBlock;
import jd.core.model.layout.block.MethodNameLayoutBlock;
import jd.core.model.layout.block.MethodStaticLayoutBlock;
import jd.core.model.layout.block.OffsetLayoutBlock;
import jd.core.model.layout.block.PackageLayoutBlock;
import jd.core.model.layout.block.ThrowsLayoutBlock;
import jd.core.model.layout.block.TypeNameLayoutBlock;
import jd.core.model.reference.Reference;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.InstructionPrinter;
import jd.core.printer.Printer;
import jd.core.process.writer.AnnotationWriter;
import jd.core.process.writer.ByteCodeWriter;
import jd.core.process.writer.ConstantValueWriter;
import jd.core.process.writer.ElementValueWriter;
import jd.core.process.writer.SignatureWriter;
import jd.core.process.writer.visitor.SourceWriterVisitor;
import jd.core.util.SignatureUtil;
import jd.core.util.StringUtil;
import jd.core.util.TypeNameUtil;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Signature;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public final class ClassFileWriter {
    private static final String BREAK = "break";
    private static final String DEFAULT = "default";
    private static final String EXTENDS = "extends";
    private static final String IMPLEMENTS = "implements";
    private static final String JAVADOC_DEPRECATED = "@deprecated";
    private static final String STRICTFP = "strictfp";
    private static final String ABSTRACT = "abstract";
    private static final String NATIVE = "native";
    private static final String SYNCHRONIZED = "synchronized";
    private static final String TRANSIENT = "transient";
    private static final String VOLATILE = "volatile";
    private static final String FINAL = "final";
    private static final String STATIC = "static";
    private static final String PROTECTED = "protected";
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";
    private static final Set<String> keywords;
    private static final String[] ACCESS_FIELD_NAMES;
    private static final String[] ACCESS_METHOD_NAMES;
    private static final String[] ACCESS_NESTED_CLASS_NAMES;
    private static final String[] ACCESS_NESTED_ENUM_NAMES;
    private final Loader loader;
    private final Printer printer;
    private final InstructionPrinter instructionPrinter;
    private final SourceWriterVisitor visitor;
    private final ReferenceMap referenceMap;
    private final List<LayoutBlock> layoutBlockList;
    private int index;
    private boolean addSpace;

    static {
        String[] stringArray = new String[8];
        stringArray[0] = PUBLIC;
        stringArray[1] = PRIVATE;
        stringArray[2] = PROTECTED;
        stringArray[3] = STATIC;
        stringArray[4] = FINAL;
        stringArray[6] = VOLATILE;
        stringArray[7] = TRANSIENT;
        ACCESS_FIELD_NAMES = stringArray;
        String[] stringArray2 = new String[12];
        stringArray2[0] = PUBLIC;
        stringArray2[1] = PRIVATE;
        stringArray2[2] = PROTECTED;
        stringArray2[3] = STATIC;
        stringArray2[4] = FINAL;
        stringArray2[5] = SYNCHRONIZED;
        stringArray2[8] = NATIVE;
        stringArray2[10] = ABSTRACT;
        stringArray2[11] = STRICTFP;
        ACCESS_METHOD_NAMES = stringArray2;
        ACCESS_NESTED_CLASS_NAMES = new String[]{PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL};
        ACCESS_NESTED_ENUM_NAMES = new String[]{PUBLIC, PRIVATE, PROTECTED, STATIC};
        keywords = new HashSet<String>();
        keywords.add("@interface");
        keywords.add(ABSTRACT);
        keywords.add("assert");
        keywords.add("boolean");
        keywords.add(BREAK);
        keywords.add("byte");
        keywords.add("case");
        keywords.add("catch");
        keywords.add("char");
        keywords.add("class");
        keywords.add("const");
        keywords.add("continue");
        keywords.add(DEFAULT);
        keywords.add("do");
        keywords.add("double");
        keywords.add("else");
        keywords.add("enum");
        keywords.add(EXTENDS);
        keywords.add("false");
        keywords.add(FINAL);
        keywords.add("finally");
        keywords.add("float");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add(IMPLEMENTS);
        keywords.add("import");
        keywords.add("instanceof");
        keywords.add("int");
        keywords.add("interface");
        keywords.add("long");
        keywords.add(NATIVE);
        keywords.add("new");
        keywords.add("null");
        keywords.add("package");
        keywords.add(PRIVATE);
        keywords.add(PROTECTED);
        keywords.add(PUBLIC);
        keywords.add("return");
        keywords.add("short");
        keywords.add(STATIC);
        keywords.add(STRICTFP);
        keywords.add("super");
        keywords.add("switch");
        keywords.add(SYNCHRONIZED);
        keywords.add("this");
        keywords.add("throw");
        keywords.add("throws");
        keywords.add(TRANSIENT);
        keywords.add("true");
        keywords.add("try");
        keywords.add("void");
        keywords.add(VOLATILE);
        keywords.add("while");
    }

    public static void write(Loader loader, Printer printer, ReferenceMap referenceMap, int maxLineNumber, int majorVersion, int minorVersion, List<LayoutBlock> layoutBlockList) {
        ClassFileWriter cfw = new ClassFileWriter(loader, printer, referenceMap, layoutBlockList);
        cfw.write(maxLineNumber, majorVersion, minorVersion);
    }

    private ClassFileWriter(Loader loader, Printer printer, ReferenceMap referenceMap, List<LayoutBlock> layoutBlockList) {
        this.loader = loader;
        this.printer = printer;
        this.instructionPrinter = new InstructionPrinter(printer);
        this.visitor = new SourceWriterVisitor(loader, this.instructionPrinter, referenceMap, keywords);
        this.referenceMap = referenceMap;
        this.layoutBlockList = layoutBlockList;
        this.index = 0;
    }

    public void write(int maxLineNumber, int majorVersion, int minorVersion) {
        int length = this.layoutBlockList.size();
        this.printer.start(maxLineNumber, majorVersion, minorVersion);
        this.printer.startOfLine(this.searchFirstLineNumber());
        while (this.index < length) {
            LayoutBlock lb = this.layoutBlockList.get(this.index++);
            switch (lb.getTag()) {
                case 1: {
                    this.writePackage((PackageLayoutBlock)lb);
                    break;
                }
                case 3: {
                    this.writeSeparatorAtBegining(lb);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.writeSeparator(lb);
                    break;
                }
                case 6: {
                    this.writeImports((ImportsLayoutBlock)lb);
                    break;
                }
                case 7: {
                    this.writeTypeMarkerStart((MarkerLayoutBlock)lb);
                    break;
                }
                case 8: {
                    this.writeTypeMarkerEnd();
                    break;
                }
                case 9: {
                    this.writeFieldMarkerStart((MarkerLayoutBlock)lb);
                    break;
                }
                case 10: {
                    this.writeFieldMarkerEnd();
                    break;
                }
                case 11: {
                    this.writeMethodMarkerStart((MarkerLayoutBlock)lb);
                    break;
                }
                case 12: {
                    this.writeMethodMarkerEnd();
                    break;
                }
                case 39: {
                    this.writeCommentDeprecated(lb);
                    break;
                }
                case 40: {
                    this.writeCommentError(lb);
                    break;
                }
                case 41: {
                    this.writeAnnotations((AnnotationsLayoutBlock)lb);
                    break;
                }
                case 42: {
                    this.writeType((TypeNameLayoutBlock)lb);
                    break;
                }
                case 43: {
                    this.writeExtendsSuperType((ExtendsSuperTypeLayoutBlock)lb);
                    break;
                }
                case 44: {
                    this.writeExtendsSuperInterfaces((ExtendsSuperInterfacesLayoutBlock)lb);
                    break;
                }
                case 45: {
                    this.writeImplementsInterfaces((ImplementsInterfacesLayoutBlock)lb);
                    break;
                }
                case 46: {
                    this.writeGenericType((GenericTypeNameLayoutBlock)lb);
                    break;
                }
                case 47: {
                    this.writeGenericExtendsSuperType((GenericExtendsSuperTypeLayoutBlock)lb);
                    break;
                }
                case 48: {
                    this.writeGenericExtendsSuperInterfaces((GenericExtendsSuperInterfacesLayoutBlock)lb);
                    break;
                }
                case 49: {
                    this.writeGenericImplementsInterfaces((GenericImplementsInterfacesLayoutBlock)lb);
                    break;
                }
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: {
                    this.writeStatementBlockStart(lb);
                    break;
                }
                case 14: 
                case 20: 
                case 23: 
                case 26: {
                    this.writeStatementsBlockEnd(lb);
                    break;
                }
                case 17: {
                    this.writeStatementsInnerBodyBlockEnd(lb);
                    break;
                }
                case 15: 
                case 18: 
                case 21: 
                case 27: {
                    this.writeStatementsBlockStartEnd(lb);
                    break;
                }
                case 31: {
                    this.writeSwitchBlockStart(lb);
                    break;
                }
                case 32: {
                    this.writeSwitchBlockEnd(lb);
                    break;
                }
                case 33: {
                    this.writeCaseBlockStart((CaseBlockStartLayoutBlock)lb);
                    break;
                }
                case 34: {
                    this.writeCaseBlockEnd((CaseBlockEndLayoutBlock)lb);
                    break;
                }
                case 37: {
                    this.writeForBlockStart(lb);
                    break;
                }
                case 38: {
                    this.writeForBlockEnd();
                    break;
                }
                case 28: {
                    this.writeSingleStatementsBlockStart(lb);
                    break;
                }
                case 29: {
                    this.writeSingleStatementsBlockEnd(lb);
                    break;
                }
                case 30: {
                    this.writeSingleStatementsBlockStartEnd(lb);
                    break;
                }
                case 50: {
                    this.writeField((FieldNameLayoutBlock)lb);
                    break;
                }
                case 51: {
                    this.writeMethodStatic((MethodStaticLayoutBlock)lb);
                    break;
                }
                case 52: {
                    this.writeMethod((MethodNameLayoutBlock)lb);
                    break;
                }
                case 53: {
                    this.writeThrows((ThrowsLayoutBlock)lb);
                    break;
                }
                case 54: {
                    this.writeInstruction((InstructionLayoutBlock)lb);
                    break;
                }
                case 55: {
                    this.writeInstructions((InstructionsLayoutBlock)lb);
                    break;
                }
                case 56: {
                    this.writeByteCode((ByteCodeLayoutBlock)lb);
                    break;
                }
                case 57: {
                    this.writeDeclaration((DeclareLayoutBlock)lb);
                    break;
                }
                case 63: {
                    this.writeIf();
                    break;
                }
                case 61: {
                    this.writeWhile();
                    break;
                }
                case 62: {
                    this.writeFor();
                    break;
                }
                case 64: {
                    this.writeSwitch();
                    break;
                }
                case 65: {
                    this.writeCase((CaseLayoutBlock)lb);
                    break;
                }
                case 66: {
                    this.writeCaseEnum((CaseEnumLayoutBlock)lb);
                    break;
                }
                case 67: {
                    this.writeCaseString((CaseLayoutBlock)lb);
                    break;
                }
                case 68: {
                    this.writeCatch((FastCatchLayoutBlock)lb);
                    break;
                }
                case 69: {
                    this.writeSynchronized();
                    break;
                }
                case 70: {
                    this.writeLabel((OffsetLayoutBlock)lb);
                    break;
                }
                case 71: {
                    this.writeElse();
                    break;
                }
                case 72: {
                    this.writeElseSpace();
                    break;
                }
                case 73: {
                    this.writeDo();
                    break;
                }
                case 74: {
                    this.writeInfiniteLoop();
                    break;
                }
                case 75: {
                    this.writeTry();
                    break;
                }
                case 87: {
                    this.writeTryWithResources();
                    break;
                }
                case 76: {
                    this.writeFinally();
                    break;
                }
                case 77: {
                    this.writeContinue();
                    break;
                }
                case 78: {
                    this.writeBreak();
                    break;
                }
                case 79: {
                    this.writeLabeledBreak((OffsetLayoutBlock)lb);
                    break;
                }
                case 80: {
                    this.writeRightRoundBracket();
                    break;
                }
                case 81: {
                    this.writeRightRoundBracketSemicolon();
                    break;
                }
                case 82: {
                    this.writeSemicolon();
                    break;
                }
                case 83: {
                    this.writeSemicolonSpace();
                    break;
                }
                case 84: {
                    this.writeSpaceColonSpace();
                    break;
                }
                case 85: {
                    this.writeComaSpace();
                    break;
                }
                case 86: {
                    this.writeArrow();
                }
            }
        }
        this.printer.endOfLine();
        this.printer.end();
    }

    private int searchFirstLineNumber() {
        int length = this.layoutBlockList.size();
        for (int i = this.index; i < length; ++i) {
            LayoutBlock lb = this.layoutBlockList.get(i);
            if (lb.getTag() != 54 && lb.getTag() != 55) continue;
            return lb.getFirstLineNumber();
        }
        return 0;
    }

    private void writePackage(PackageLayoutBlock plb) {
        this.printer.printKeyword("package");
        this.printer.print(' ');
        String internalPackageName = plb.getClassFile().getInternalPackageName();
        this.printer.print(internalPackageName.replace('/', '.'));
        this.printer.print(';');
    }

    private void writeSeparatorAtBegining(LayoutBlock slb) {
        int lineCount = slb.getLineCount();
        this.printer.debugStartOfSeparatorLayoutBlock();
        if (lineCount > 0) {
            this.endOfLine();
            if (lineCount > 1) {
                this.printer.extraLine(lineCount - 1);
            }
            this.printer.startOfLine(this.searchFirstLineNumber());
        }
        this.printer.debugEndOfSeparatorLayoutBlock(slb.getMinimalLineCount(), slb.getLineCount(), slb.getMaximalLineCount());
    }

    private void writeSeparator(LayoutBlock slb) {
        int lineCount = slb.getLineCount();
        this.printer.debugStartOfSeparatorLayoutBlock();
        if (lineCount > 0) {
            this.endOfLine();
            if (lineCount > 1) {
                this.printer.startOfLine(0);
                this.endOfLine();
                if (lineCount > 2) {
                    this.printer.extraLine(lineCount - 2);
                }
            }
            this.printer.startOfLine(this.searchFirstLineNumber());
        } else if (this.addSpace) {
            this.printer.print(' ');
            this.addSpace = false;
        }
        this.printer.debugEndOfSeparatorLayoutBlock(slb.getMinimalLineCount(), slb.getLineCount(), slb.getMaximalLineCount());
    }

    private void writeImports(ImportsLayoutBlock ilb) {
        Collection<Reference> collection = this.referenceMap.values();
        int length = collection.size();
        if (length > 0) {
            ClassFile classFile = ilb.getClassFile();
            String internalPackageName = classFile.getInternalPackageName();
            Iterator<Reference> iterator = collection.iterator();
            ArrayList<Reference> references = new ArrayList<Reference>(length);
            Set<String> typeArgumentInnerClasses = classFile.getTypeArgumentInnerClasses();
            while (iterator.hasNext()) {
                Reference reference = iterator.next();
                String refInternalName = reference.getInternalName();
                String internalReferencePackageName = TypeNameUtil.internalTypeNameToInternalPackageName(refInternalName);
                if ("java/lang".equals(internalReferencePackageName) || internalReferencePackageName.equals(internalPackageName) && !typeArgumentInnerClasses.contains(refInternalName)) continue;
                references.add(reference);
            }
            if (!references.isEmpty()) {
                int delta = ilb.getPreferedLineCount() - ilb.getLineCount();
                if (delta > 0) {
                    Collections.sort(references, Comparator.comparing(Reference::getCounter).reversed());
                    int idx = references.size();
                    while (delta-- > 0) {
                        Reference reference = (Reference)references.remove(--idx);
                        this.referenceMap.remove(reference.getInternalName());
                    }
                }
                if (!references.isEmpty()) {
                    Collections.sort(references, Comparator.comparing(Reference::getInternalName));
                    this.printer.debugStartOfLayoutBlock();
                    this.printer.startOfImportStatements();
                    iterator = references.iterator();
                    if (iterator.hasNext()) {
                        this.writeImport(iterator.next());
                        while (iterator.hasNext()) {
                            this.endOfLine();
                            this.printer.startOfLine(0);
                            this.writeImport(iterator.next());
                        }
                    }
                    this.printer.endOfImportStatements();
                    this.printer.debugEndOfLayoutBlock();
                }
            }
        }
    }

    private void writeImport(Reference reference) {
        this.printer.printKeyword("import");
        this.printer.print(' ');
        this.printer.printTypeImport(reference.getInternalName(), TypeNameUtil.internalTypeNameToQualifiedTypeName(reference.getInternalName()));
        this.printer.print(';');
    }

    private void writeTypeMarkerStart(MarkerLayoutBlock mlb) {
        String internalPath = String.valueOf(mlb.getClassFile().getThisClassName()) + ".class";
        this.printer.startOfTypeDeclaration(internalPath);
        this.printer.debugMarker("&lt;T&lt;");
    }

    private void writeTypeMarkerEnd() {
        this.printer.debugMarker("&gt;T&gt;");
        this.printer.endOfTypeDeclaration();
    }

    private void writeFieldMarkerStart(MarkerLayoutBlock mlb) {
        String internalPath = String.valueOf(mlb.getClassFile().getThisClassName()) + ".class";
        this.printer.startOfTypeDeclaration(internalPath);
        this.printer.debugMarker("&lt;F&lt;");
    }

    private void writeFieldMarkerEnd() {
        this.printer.debugMarker("&gt;F&gt;");
        this.printer.endOfTypeDeclaration();
        this.addSpace = true;
    }

    private void writeMethodMarkerStart(MarkerLayoutBlock mlb) {
        String internalPath = String.valueOf(mlb.getClassFile().getThisClassName()) + ".class";
        this.printer.startOfTypeDeclaration(internalPath);
        this.printer.debugMarker("&lt;M&lt;");
    }

    private void writeMethodMarkerEnd() {
        this.printer.debugMarker("&gt;M&gt;");
        this.printer.endOfTypeDeclaration();
    }

    private void writeCommentDeprecated(LayoutBlock lb) {
        this.printer.debugStartOfCommentDeprecatedLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.startOfJavadoc();
                this.printer.print("/** ");
                this.printer.startOfXdoclet();
                this.printer.print(JAVADOC_DEPRECATED);
                this.printer.endOfXdoclet();
                this.printer.print(" */");
                this.printer.endOfJavadoc();
                break;
            }
            case 1: {
                this.printer.startOfJavadoc();
                this.printer.print("/** ");
                this.printer.startOfXdoclet();
                this.printer.print(JAVADOC_DEPRECATED);
                this.printer.endOfXdoclet();
                this.printer.print(" */");
                this.printer.endOfJavadoc();
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                break;
            }
            case 2: {
                this.printer.startOfJavadoc();
                this.printer.print("/**");
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print(" * ");
                this.printer.startOfXdoclet();
                this.printer.print(JAVADOC_DEPRECATED);
                this.printer.endOfXdoclet();
                this.printer.print(" */");
                this.printer.endOfJavadoc();
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                break;
            }
            case 3: {
                this.printer.startOfJavadoc();
                this.printer.print("/**");
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print(" * ");
                this.printer.startOfXdoclet();
                this.printer.print(JAVADOC_DEPRECATED);
                this.printer.endOfXdoclet();
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print(" */");
                this.printer.endOfJavadoc();
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
        }
        this.printer.debugEndOfCommentDeprecatedLayoutBlock();
    }

    private void writeCommentError(LayoutBlock lb) {
        this.printer.debugStartOfCommentDeprecatedLayoutBlock();
        if (lb.getLineCount() == 0) {
            this.printer.startOfError();
            this.printer.print("/* Error */ ");
            this.printer.endOfError();
        } else if (lb.getLineCount() == 1) {
            this.printer.startOfError();
            this.printer.print("/* Error */");
            this.printer.endOfError();
            this.endOfLine();
            this.printer.startOfLine(this.searchFirstLineNumber());
        }
        this.printer.debugEndOfCommentDeprecatedLayoutBlock();
    }

    private void writeAnnotations(AnnotationsLayoutBlock alb) {
        List<AnnotationEntry> annotations = alb.getAnnotations();
        int length = annotations.size();
        if (length > 0) {
            this.printer.debugStartOfLayoutBlock();
            ClassFile classFile = alb.getClassFile();
            if (alb.getLineCount() == 0) {
                for (AnnotationEntry annotationEntry : annotations) {
                    AnnotationWriter.writeAnnotation(this.loader, this.printer, this.referenceMap, classFile, annotationEntry);
                }
            } else {
                int annotationsByLine = length / alb.getLineCount();
                if (annotationsByLine * alb.getLineCount() < length) {
                    ++annotationsByLine;
                }
                int j = annotationsByLine;
                int k = alb.getLineCount();
                for (AnnotationEntry annotationEntry : annotations) {
                    AnnotationWriter.writeAnnotation(this.loader, this.printer, this.referenceMap, classFile, annotationEntry);
                    if (--j > 0) {
                        this.printer.print(' ');
                        continue;
                    }
                    if (--k > 0) {
                        this.endOfLine();
                        this.printer.startOfLine(0);
                    }
                    j = annotationsByLine;
                }
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
            this.printer.debugEndOfLayoutBlock();
        }
    }

    private void writeType(TypeNameLayoutBlock tdlb) {
        this.printer.debugStartOfLayoutBlock();
        ClassFile classFile = tdlb.getClassFile();
        this.writeAccessAndType(classFile);
        this.printer.printTypeDeclaration(classFile.getThisClassName(), classFile.getClassName());
        if (tdlb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.startOfLine(this.searchFirstLineNumber());
        }
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeAccessAndType(ClassFile classFile) {
        if ((classFile.getAccessFlags() & 0x6200) != 0) {
            classFile.setAccessFlags(classFile.getAccessFlags() & 0xFFFFFBFF);
        }
        if ((classFile.getAccessFlags() & 0x4000) == 0) {
            if (classFile.isAInnerClass()) {
                this.writeAccessNestedClass(classFile.getAccessFlags());
            } else {
                this.writeAccessClass(classFile.getAccessFlags());
            }
        } else if (classFile.isAInnerClass()) {
            this.writeAccessNestedEnum(classFile.getAccessFlags());
        } else {
            this.writeAccessEnum(classFile.getAccessFlags());
        }
        this.writeType(classFile.getAccessFlags());
        this.printer.print(' ');
    }

    private void writeAccessNestedClass(int accessFlags) {
        int i = 0;
        while (i < ACCESS_NESTED_CLASS_NAMES.length) {
            int acc = 1 << i;
            if ((accessFlags & acc) != 0 && acc != 32 && acc != 512) {
                this.printer.printKeyword(ACCESS_NESTED_CLASS_NAMES[i]);
                this.printer.print(' ');
            }
            ++i;
        }
        if ((accessFlags & 0x400) != 0) {
            this.printer.printKeyword(ABSTRACT);
            this.printer.print(' ');
        }
    }

    private void writeAccessClass(int accessFlags) {
        if ((accessFlags & 1) != 0) {
            this.printer.printKeyword(PUBLIC);
            this.printer.print(' ');
        }
        if ((accessFlags & 0x10) != 0) {
            this.printer.printKeyword(FINAL);
            this.printer.print(' ');
        }
        if ((accessFlags & 0x400) != 0) {
            this.printer.printKeyword(ABSTRACT);
            this.printer.print(' ');
        }
    }

    private void writeAccessNestedEnum(int accessFlags) {
        int i = 0;
        while (i < ACCESS_NESTED_ENUM_NAMES.length) {
            int acc = 1 << i;
            if ((accessFlags & acc) != 0 && acc != 32 && acc != 512) {
                this.printer.printKeyword(ACCESS_NESTED_ENUM_NAMES[i]);
                this.printer.print(' ');
            }
            ++i;
        }
        if ((accessFlags & 0x400) != 0) {
            this.printer.printKeyword(ABSTRACT);
            this.printer.print(' ');
        }
    }

    private void writeAccessEnum(int accessFlags) {
        if ((accessFlags & 1) != 0) {
            this.printer.printKeyword(PUBLIC);
        }
        this.printer.print(' ');
    }

    private void writeType(int accessFlags) {
        if ((accessFlags & 0x2000) != 0) {
            this.printer.printKeyword("@interface");
        } else if ((accessFlags & 0x4000) != 0) {
            this.printer.printKeyword("enum");
        } else if ((accessFlags & 0x200) != 0) {
            this.printer.printKeyword("interface");
        } else {
            this.printer.printKeyword("class");
        }
    }

    private void writeExtendsSuperType(ExtendsSuperTypeLayoutBlock stelb) {
        this.printer.debugStartOfLayoutBlock();
        if (stelb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
            this.printer.desindent();
        } else {
            this.printer.print(' ');
        }
        ClassFile classFile = stelb.getClassFile();
        this.printer.printKeyword(EXTENDS);
        this.printer.print(' ');
        String signature = SignatureUtil.createTypeName(classFile.getSuperClassName());
        SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, signature);
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeExtendsSuperInterfaces(ExtendsSuperInterfacesLayoutBlock sielb) {
        this.writeInterfaces(sielb, sielb.getClassFile(), true);
    }

    private void writeImplementsInterfaces(ImplementsInterfacesLayoutBlock iilb) {
        this.writeInterfaces(iilb, iilb.getClassFile(), false);
    }

    private void writeInterfaces(LayoutBlock lb, ClassFile classFile, boolean extendsKeyword) {
        this.printer.debugStartOfLayoutBlock();
        if (lb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
            this.printer.desindent();
        } else {
            this.printer.print(' ');
        }
        int[] interfaceIndexes = classFile.getInterfaces();
        ConstantPool constants = classFile.getConstantPool();
        if (extendsKeyword) {
            this.printer.printKeyword(EXTENDS);
        } else {
            this.printer.printKeyword(IMPLEMENTS);
        }
        this.printer.print(' ');
        String signature = SignatureUtil.createTypeName(constants.getConstantClassName(interfaceIndexes[0]));
        SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, signature);
        int i = 1;
        while (i < interfaceIndexes.length) {
            this.printer.print(", ");
            signature = SignatureUtil.createTypeName(constants.getConstantClassName(interfaceIndexes[i]));
            SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, signature);
            ++i;
        }
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeGenericType(GenericTypeNameLayoutBlock gtdlb) {
        this.writeAccessAndType(gtdlb.getClassFile());
        SignatureWriter.writeTypeDeclaration(this.loader, this.printer, this.referenceMap, gtdlb.getClassFile(), gtdlb.getSignature());
    }

    private void writeGenericExtendsSuperType(GenericExtendsSuperTypeLayoutBlock gstelb) {
        this.printer.debugStartOfLayoutBlock();
        if (gstelb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
            this.printer.desindent();
        } else {
            this.printer.print(' ');
        }
        this.printer.printKeyword(EXTENDS);
        this.printer.print(' ');
        char[] caSignature = gstelb.getCaSignature();
        SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, gstelb.getClassFile(), caSignature, caSignature.length, gstelb.getSignatureIndex());
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeGenericExtendsSuperInterfaces(GenericExtendsSuperInterfacesLayoutBlock gsielb) {
        this.writeGenericInterfaces(gsielb, gsielb.getClassFile(), gsielb.getCaSignature(), gsielb.getSignatureIndex(), true);
    }

    private void writeGenericImplementsInterfaces(GenericImplementsInterfacesLayoutBlock giilb) {
        this.writeGenericInterfaces(giilb, giilb.getClassFile(), giilb.getCaSignature(), giilb.getSignatureIndex(), false);
    }

    private void writeGenericInterfaces(LayoutBlock lb, ClassFile classFile, char[] caSignature, int signatureIndex, boolean extendsKeyword) {
        this.printer.debugStartOfLayoutBlock();
        if (lb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
            this.printer.desindent();
        } else {
            this.printer.print(' ');
        }
        if (extendsKeyword) {
            this.printer.printKeyword(EXTENDS);
        } else {
            this.printer.printKeyword(IMPLEMENTS);
        }
        this.printer.print(' ');
        int signatureLength = caSignature.length;
        signatureIndex = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, caSignature, signatureLength, signatureIndex);
        while (signatureIndex < signatureLength) {
            this.printer.print(", ");
            signatureIndex = SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, caSignature, signatureLength, signatureIndex);
        }
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeStatementBlockStart(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print(" { ");
                this.printer.indent();
                break;
            }
            case 1: {
                this.printer.print(" {");
                this.endOfLine();
                this.printer.indent();
                this.printer.startOfLine(this.searchFirstLineNumber());
                break;
            }
            default: {
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print('{');
                this.endOfLine();
                this.printer.extraLine(lb.getLineCount() - 2);
                this.printer.indent();
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeSwitchBlockStart(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print(" {");
                break;
            }
            case 1: {
                this.printer.print(" {");
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                break;
            }
            default: {
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print('{');
                this.endOfLine();
                this.printer.extraLine(lb.getLineCount() - 2);
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeStatementsBlockEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print(" }");
                this.addSpace = true;
                this.printer.desindent();
                break;
            }
            case 1: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.printer.print('}');
                this.addSpace = true;
                break;
            }
            default: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.extraLine(lb.getLineCount() - 2);
                this.printer.startOfLine(0);
                this.printer.print('}');
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.addSpace = false;
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeStatementsInnerBodyBlockEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print(" }");
                this.printer.desindent();
                break;
            }
            case 1: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.startOfLine(0);
                this.printer.print('}');
                break;
            }
            default: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.extraLine(lb.getLineCount() - 1);
                this.printer.startOfLine(0);
                this.printer.print('}');
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
        this.addSpace = false;
    }

    private void writeSwitchBlockEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print('}');
                this.addSpace = true;
                break;
            }
            case 1: {
                this.printer.print('}');
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.addSpace = false;
                break;
            }
            default: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.extraLine(lb.getLineCount() - 1);
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.printer.print('}');
                this.addSpace = false;
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeCaseBlockStart(CaseBlockStartLayoutBlock lb) {
        int lineCount;
        this.printer.indent();
        this.printer.debugStartOfCaseBlockLayoutBlock();
        if (lb.isBracketNeeded()) {
            this.printer.print('{');
        }
        if ((lineCount = lb.getLineCount()) > 0) {
            this.endOfLine();
            if (lineCount > 1) {
                this.printer.startOfLine(0);
                this.endOfLine();
                if (lineCount > 2) {
                    this.printer.extraLine(lineCount - 2);
                }
            }
            this.printer.startOfLine(this.searchFirstLineNumber());
        } else {
            this.printer.print(' ');
        }
        this.printer.debugEndOfCaseBlockLayoutBlock();
    }

    private void writeCaseBlockEnd(CaseBlockEndLayoutBlock lb) {
        this.printer.desindent();
        this.printer.debugStartOfCaseBlockLayoutBlock();
        int lineCount = lb.getLineCount();
        if (lineCount > 0) {
            this.endOfLine();
            if (lineCount > 1) {
                this.printer.startOfLine(0);
                this.endOfLine();
                if (lineCount > 2) {
                    this.printer.extraLine(lineCount - 2);
                }
            }
            this.printer.startOfLine(this.searchFirstLineNumber());
        } else {
            this.printer.print(' ');
        }
        if (lb.isBracketNeeded()) {
            this.printer.print('}');
            this.addSpace = true;
        }
        this.printer.debugEndOfCaseBlockLayoutBlock();
    }

    private void writeForBlockStart(LayoutBlock lb) {
        this.printer.indent();
        this.printer.indent();
        this.printer.debugStartOfSeparatorLayoutBlock();
        int lineCount = lb.getLineCount();
        if (lineCount > 0) {
            this.endOfLine();
            if (lineCount > 1) {
                this.printer.startOfLine(0);
                this.endOfLine();
                if (lineCount > 2) {
                    this.printer.extraLine(lineCount - 2);
                }
            }
            this.printer.startOfLine(this.searchFirstLineNumber());
        }
        this.printer.debugEndOfSeparatorLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeForBlockEnd() {
        this.printer.desindent();
        this.printer.desindent();
    }

    private void writeStatementsBlockStartEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                this.printer.print(" {}");
                if (lb.getTag() != 27) break;
                this.addSpace = true;
                break;
            }
            case 1: {
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.printer.print("{}");
                break;
            }
            default: {
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print("{}");
                this.endOfLine();
                this.printer.extraLine(lb.getLineCount() - 1);
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeSingleStatementsBlockStart(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                if (((BlockLayoutBlock)lb).getOther().getLineCount() > 0) {
                    this.printer.print(" {");
                }
                this.printer.print(' ');
                this.printer.indent();
                break;
            }
            case 1: {
                if (((BlockLayoutBlock)lb).getOther().getLineCount() > 0) {
                    this.printer.print(" {");
                }
                this.endOfLine();
                this.printer.indent();
                this.printer.startOfLine(this.searchFirstLineNumber());
                break;
            }
            default: {
                this.endOfLine();
                this.printer.startOfLine(0);
                this.printer.print('{');
                this.endOfLine();
                this.printer.extraLine(lb.getLineCount() - 2);
                this.printer.indent();
                this.printer.startOfLine(this.searchFirstLineNumber());
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeSingleStatementsBlockEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        switch (lb.getLineCount()) {
            case 0: {
                if (((BlockLayoutBlock)lb).getOther().getLineCount() > 1) {
                    this.printer.print(" }");
                }
                this.addSpace = true;
                this.printer.desindent();
                break;
            }
            case 1: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.printer.print('}');
                this.addSpace = true;
                break;
            }
            default: {
                this.endOfLine();
                this.printer.desindent();
                this.printer.extraLine(lb.getLineCount() - 2);
                this.printer.startOfLine(0);
                this.printer.print('}');
                this.endOfLine();
                this.printer.startOfLine(this.searchFirstLineNumber());
                this.addSpace = false;
            }
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeSingleStatementsBlockStartEnd(LayoutBlock lb) {
        this.printer.debugStartOfStatementsBlockLayoutBlock();
        if (lb.getLineCount() == 0) {
            this.printer.print(" ;");
        } else {
            this.printer.print(" ;");
            this.endOfLine();
            this.printer.extraLine(lb.getLineCount() - 1);
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
        }
        this.printer.debugEndOfStatementsBlockLayoutBlock(lb.getMinimalLineCount(), lb.getLineCount(), lb.getMaximalLineCount());
    }

    private void writeField(FieldNameLayoutBlock flb) {
        ClassFile classFile = flb.getClassFile();
        Field field = flb.getField();
        this.writeAccessField(field.getAccessFlags());
        ConstantPool constants = classFile.getConstantPool();
        int signatureIndex = field.getSignatureIndex();
        String signature = constants.getConstantUtf8(signatureIndex);
        SignatureWriter.writeSignature(this.loader, this.printer, this.referenceMap, classFile, signature);
        this.printer.print(' ');
        String fieldName = constants.getConstantUtf8(field.getNameIndex());
        if (keywords.contains(fieldName)) {
            fieldName = "jdField_" + fieldName;
        }
        String internalClassName = classFile.getThisClassName();
        String descriptor = constants.getConstantUtf8(field.getDescriptorIndex());
        if ((field.getAccessFlags() & 8) != 0) {
            this.printer.printStaticFieldDeclaration(internalClassName, fieldName, descriptor);
        } else {
            this.printer.printFieldDeclaration(internalClassName, fieldName, descriptor);
        }
        if (field.getValueAndMethod() != null) {
            this.printer.print(" = ");
        } else {
            Constant cv = field.getConstantValue(constants);
            if (cv != null) {
                this.printer.print(" = ");
                ConstantValueWriter.write(this.loader, this.printer, this.referenceMap, classFile, cv, (byte)signature.charAt(0));
            }
            this.printer.print(';');
        }
    }

    private void writeAccessField(int accessFlags) {
        int i = 0;
        while (i < ACCESS_FIELD_NAMES.length) {
            int acc = 1 << i;
            if ((accessFlags & acc) != 0 && acc != 32 && acc != 512 && ACCESS_FIELD_NAMES[i] != null) {
                this.printer.printKeyword(ACCESS_FIELD_NAMES[i]);
                this.printer.print(' ');
            }
            ++i;
        }
    }

    private void writeMethodStatic(MethodStaticLayoutBlock mslb) {
        this.printer.printStaticConstructorDeclaration(mslb.getClassFile().getThisClassName(), STATIC);
    }

    private void writeMethod(MethodNameLayoutBlock mlb) {
        Method method = mlb.getMethod();
        if ((mlb.getClassFile().getAccessFlags() & 0x2000) == 0) {
            if (mlb instanceof LambdaMethodLayoutBlock var3_4) {
                List<String> lambdaParameterNames = lmlb.getParameterNames();
                switch (lambdaParameterNames.size()) {
                    case 0: {
                        this.printer.print("()");
                        break;
                    }
                    case 1: {
                        this.printer.print(lambdaParameterNames.get(0));
                        break;
                    }
                    default: {
                        this.printer.print('(');
                        Iterator<String> it = lambdaParameterNames.iterator();
                        while (it.hasNext()) {
                            this.printer.print(it.next());
                            if (!it.hasNext()) continue;
                            this.printer.print(", ");
                        }
                        this.printer.print(')');
                        break;
                    }
                }
            } else {
                if ((mlb.getClassFile().getAccessFlags() & 0x200) == 0) {
                    this.writeAccessMethod(method.getAccessFlags());
                } else {
                    if ((method.getAccessFlags() & 0x400) == 0) {
                        this.printer.printKeyword(DEFAULT);
                        this.printer.print(' ');
                    }
                    this.writeAccessMethod(method.getAccessFlags() & 0xFFFFFBF6);
                }
                SignatureWriter.writeMethodDeclaration(keywords, this.loader, this.printer, this.referenceMap, mlb.getClassFile(), method, mlb.getSignature(), mlb.hasDescriptorFlag(), mlb.isLambda());
            }
            if (mlb.hasNullCodeFlag()) {
                this.printer.print(';');
            }
        } else {
            this.writeAccessMethod(method.getAccessFlags() & 0xFFFFFBFE);
            SignatureWriter.writeMethodDeclaration(keywords, this.loader, this.printer, this.referenceMap, mlb.getClassFile(), method, mlb.getSignature(), mlb.hasDescriptorFlag(), mlb.isLambda());
            ElementValue defaultAnnotationValue = method.getDefaultAnnotationValue();
            if (defaultAnnotationValue != null) {
                this.printer.print(' ');
                this.printer.printKeyword(DEFAULT);
                this.printer.print(' ');
                ElementValueWriter.writeElementValue(this.loader, this.printer, this.referenceMap, mlb.getClassFile(), defaultAnnotationValue);
            }
            this.printer.print(';');
        }
    }

    private void writeAccessMethod(int accessFlags) {
        int i = 0;
        while (i < ACCESS_METHOD_NAMES.length) {
            int acc = 1 << i;
            if ((accessFlags & acc) != 0 && ACCESS_METHOD_NAMES[i] != null) {
                this.printer.printKeyword(ACCESS_METHOD_NAMES[i]);
                this.printer.print(' ');
            }
            ++i;
        }
    }

    private void writeThrows(ThrowsLayoutBlock tlb) {
        this.printer.debugStartOfLayoutBlock();
        if (tlb.getLineCount() > 0) {
            this.endOfLine();
            this.printer.indent();
            this.printer.startOfLine(this.searchFirstLineNumber());
            this.printer.desindent();
        } else {
            this.printer.print(' ');
        }
        this.printer.printKeyword("throws");
        this.printer.print(' ');
        ClassFile classFile = tlb.getClassFile();
        ConstantPool constants = classFile.getConstantPool();
        int[] exceptionIndexes = tlb.getMethod().getExceptionIndexes();
        int exceptionIndexesLength = exceptionIndexes.length;
        if (exceptionIndexesLength > 0) {
            String firstInternalClassName = constants.getConstantClassName(exceptionIndexes[0]);
            Signature genericSignature = tlb.getMethod().getAttributeSignature();
            if (genericSignature != null && genericSignature.getSignature().indexOf(94) != -1) {
                TypeMaker typeMaker = new TypeMaker(this.loader);
                TypeMaker.MethodTypes methodTypes = typeMaker.makeMethodTypes(classFile.getThisClassName(), tlb.getMethod().getName(constants), genericSignature.getSignature());
                Iterator it = methodTypes.getExceptionTypes().iterator();
                while (it.hasNext()) {
                    Type exceptionType = (Type)it.next();
                    if (exceptionType.isGenericType()) {
                        this.printer.print(exceptionType.getName());
                    } else {
                        this.printer.print(SignatureWriter.internalClassNameToShortClassName(this.referenceMap, classFile, exceptionType.getInternalName()));
                    }
                    if (!it.hasNext()) continue;
                    this.printer.print(", ");
                }
            } else {
                this.printer.print(SignatureWriter.internalClassNameToShortClassName(this.referenceMap, classFile, firstInternalClassName));
                int j = 1;
                while (j < exceptionIndexesLength) {
                    this.printer.print(", ");
                    String nextInternalClassName = constants.getConstantClassName(exceptionIndexes[j]);
                    this.printer.print(SignatureWriter.internalClassNameToShortClassName(this.referenceMap, classFile, nextInternalClassName));
                    ++j;
                }
            }
        }
        if (tlb.hasNullCodeFlag()) {
            this.printer.print(';');
        }
        this.printer.debugEndOfLayoutBlock();
    }

    private void writeInstruction(InstructionLayoutBlock ilb) {
        this.printer.debugStartOfInstructionBlockLayoutBlock();
        this.addSpaceIfNeeded();
        this.instructionPrinter.init(ilb.getFirstLineNumber());
        this.visitor.init(ilb.getClassFile(), ilb.getMethod(), ilb.getFirstOffset(), ilb.getLastOffset());
        this.instructionPrinter.startOfInstruction();
        this.visitor.visit(ilb.getInstruction());
        this.instructionPrinter.endOfInstruction();
        this.instructionPrinter.release();
        this.printer.debugEndOfInstructionBlockLayoutBlock();
    }

    private void writeInstructions(InstructionsLayoutBlock ilb) {
        this.printer.debugStartOfInstructionBlockLayoutBlock();
        this.addSpaceIfNeeded();
        this.instructionPrinter.init(ilb.getFirstLineNumber());
        this.visitor.init(ilb.getClassFile(), ilb.getMethod(), ilb.getFirstOffset(), ilb.getLastOffset());
        int idx = ilb.getFirstIndex();
        int lastIndex = ilb.getLastIndex();
        List<Instruction> instructions = ilb.getInstructions();
        while (idx <= lastIndex) {
            Instruction instruction = instructions.get(idx);
            if (idx > ilb.getFirstIndex() || ilb.getFirstOffset() == 0) {
                this.instructionPrinter.startOfInstruction();
            }
            boolean inlineLambda = this.printer.toString().endsWith(" -> ");
            this.visitor.visit(instruction);
            if (idx < lastIndex || ilb.getLastOffset() == instruction.getOffset()) {
                this.instructionPrinter.endOfInstruction();
                if (!inlineLambda) {
                    this.printer.print(';');
                    this.addSpace = true;
                }
            }
            ++idx;
        }
        this.instructionPrinter.release();
        this.printer.debugEndOfInstructionBlockLayoutBlock();
    }

    private void writeByteCode(ByteCodeLayoutBlock bclb) {
        ByteCodeWriter.write(this.loader, this.printer, this.referenceMap, bclb.getClassFile(), bclb.getMethod());
    }

    private void writeDeclaration(DeclareLayoutBlock dlb) {
        this.printer.debugStartOfInstructionBlockLayoutBlock();
        this.addSpaceIfNeeded();
        this.instructionPrinter.init(dlb.getFirstLineNumber());
        FastDeclaration fd = (FastDeclaration)dlb.getInstruction();
        this.visitor.init(dlb.getClassFile(), dlb.getMethod(), 0, fd.getOffset());
        this.instructionPrinter.startOfInstruction();
        this.visitor.visit(fd);
        this.instructionPrinter.endOfInstruction();
        this.printer.print(';');
        this.addSpace = true;
        this.instructionPrinter.release();
        this.printer.debugEndOfInstructionBlockLayoutBlock();
    }

    private void writeIf() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("if");
        this.printer.print(" (");
    }

    private void writeWhile() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("while");
        this.printer.print(" (");
    }

    private void writeFor() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("for");
        this.printer.print(" (");
    }

    private void writeLabeledBreak(OffsetLayoutBlock olb) {
        this.addSpaceIfNeeded();
        this.printer.printKeyword(BREAK);
        this.printer.print(' ');
        this.printer.print("label");
        this.printer.print(olb.getOffset());
        this.printer.print(';');
    }

    private void writeRightRoundBracket() {
        this.printer.print(')');
    }

    private void writeRightRoundBracketSemicolon() {
        this.printer.print(");");
    }

    private void writeSemicolon() {
        this.printer.print(';');
    }

    private void writeSemicolonSpace() {
        this.printer.print("; ");
    }

    private void writeSpaceColonSpace() {
        this.printer.print(" : ");
    }

    private void writeComaSpace() {
        this.printer.print(", ");
    }

    private void writeArrow() {
        this.printer.print(" -> ");
    }

    private void writeSwitch() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("switch");
        this.printer.print(" (");
    }

    private void writeCase(CaseLayoutBlock clb) {
        String escapedString;
        this.addSpaceIfNeeded();
        String signature = clb.getFs().getTest().getReturnedSignature(clb.getClassFile(), clb.getMethod().getLocalVariables());
        int type = signature == null ? 88 : (int)signature.charAt(0);
        FastSwitch.Pair[] pairs = clb.getFs().getPairs();
        int lineCount = clb.getLineCount() + 1;
        int lastIndex = clb.getLastIndex();
        int caseCount = lastIndex - clb.getFirstIndex() + 1;
        int caseByLine = caseCount / lineCount;
        int middleLineCount = caseCount - caseByLine * lineCount;
        int middleIndex = clb.getFirstIndex() + middleLineCount * (caseByLine + 1);
        int j = caseByLine + 1;
        int i = clb.getFirstIndex();
        while (i < middleIndex) {
            FastSwitch.Pair pair = pairs[i];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                if (type == 67) {
                    escapedString = StringUtil.escapeCharAndAppendApostrophe((char)pair.getKey());
                    this.printer.printString(escapedString, clb.getClassFile().getThisClassName());
                } else {
                    this.printer.printNumeric(String.valueOf(pair.getKey()));
                }
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine + 1;
                } else {
                    --j;
                }
            }
            ++i;
        }
        j = caseByLine;
        int i2 = middleIndex;
        while (i2 <= lastIndex) {
            FastSwitch.Pair pair = pairs[i2];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                if (type == 67) {
                    escapedString = StringUtil.escapeCharAndAppendApostrophe((char)pair.getKey());
                    this.printer.printString(escapedString, clb.getClassFile().getThisClassName());
                } else {
                    this.printer.printNumeric(String.valueOf(pair.getKey()));
                }
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i2 < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine;
                } else {
                    --j;
                }
            }
            ++i2;
        }
    }

    private void writeCaseEnum(CaseEnumLayoutBlock celb) {
        String value;
        int key;
        this.addSpaceIfNeeded();
        ClassFile classFile = celb.getClassFile();
        ConstantPool constants = classFile.getConstantPool();
        List<Integer> switchMap = classFile.getSwitchMaps().get(celb.getSwitchMapKey());
        ArrayLoadInstruction ali = (ArrayLoadInstruction)celb.getFs().getTest();
        Invokevirtual iv = (Invokevirtual)ali.getIndexref();
        ConstantCP cmr = constants.getConstantMethodref(iv.getIndex());
        String internalEnumName = constants.getConstantClassName(cmr.getClassIndex());
        if (switchMap == null) {
            constants = classFile.getOuterClass().getConstantPool();
            switchMap = classFile.getOuterClass().getSwitchMaps().get(celb.getSwitchMapKey());
        }
        String enumDescriptor = SignatureUtil.createTypeName(internalEnumName);
        FastSwitch.Pair[] pairs = celb.getFs().getPairs();
        int lineCount = celb.getLineCount() + 1;
        int lastIndex = celb.getLastIndex();
        int caseCount = lastIndex - celb.getFirstIndex() + 1;
        int caseByLine = caseCount / lineCount;
        int middleLineCount = caseCount - caseByLine * lineCount;
        int middleIndex = celb.getFirstIndex() + middleLineCount * (caseByLine + 1);
        int j = caseByLine + 1;
        int i = celb.getFirstIndex();
        while (i < middleIndex) {
            FastSwitch.Pair pair = pairs[i];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                key = pair.getKey();
                if (key > 0 && key <= switchMap.size()) {
                    value = constants.getConstantUtf8(switchMap.get(key - 1));
                    this.printer.printStaticField(internalEnumName, value, enumDescriptor, classFile.getThisClassName());
                } else {
                    this.printer.startOfError();
                    this.printer.print("???");
                    this.printer.endOfError();
                }
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine + 1;
                } else {
                    --j;
                }
            }
            ++i;
        }
        j = caseByLine;
        int i2 = middleIndex;
        while (i2 <= lastIndex) {
            FastSwitch.Pair pair = pairs[i2];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                key = pair.getKey();
                if (key > 0 && key <= switchMap.size()) {
                    value = constants.getConstantUtf8(switchMap.get(key - 1));
                    this.printer.printStaticField(internalEnumName, value, enumDescriptor, classFile.getThisClassName());
                } else {
                    this.printer.startOfError();
                    this.printer.print("???");
                    this.printer.endOfError();
                }
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i2 < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine;
                } else {
                    --j;
                }
            }
            ++i2;
        }
    }

    private void writeCaseString(CaseLayoutBlock clb) {
        Constant cv;
        this.addSpaceIfNeeded();
        ClassFile classFile = clb.getClassFile();
        ConstantPool constants = classFile.getConstantPool();
        FastSwitch.Pair[] pairs = clb.getFs().getPairs();
        int lineCount = clb.getLineCount() + 1;
        int lastIndex = clb.getLastIndex();
        int caseCount = lastIndex - clb.getFirstIndex() + 1;
        int caseByLine = caseCount / lineCount;
        int middleLineCount = caseCount - caseByLine * lineCount;
        int middleIndex = clb.getFirstIndex() + middleLineCount * (caseByLine + 1);
        int j = caseByLine + 1;
        int i = clb.getFirstIndex();
        while (i < middleIndex) {
            FastSwitch.Pair pair = pairs[i];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                cv = constants.getConstantValue(pair.getKey());
                ConstantValueWriter.write(this.loader, this.printer, this.referenceMap, classFile, cv);
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine + 1;
                } else {
                    --j;
                }
            }
            ++i;
        }
        j = caseByLine;
        int i2 = middleIndex;
        while (i2 <= lastIndex) {
            FastSwitch.Pair pair = pairs[i2];
            if (pair.isDefault()) {
                this.printer.printKeyword(DEFAULT);
            } else {
                this.printer.printKeyword("case");
                this.printer.print(' ');
                this.printer.debugStartOfInstructionBlockLayoutBlock();
                cv = constants.getConstantValue(pair.getKey());
                ConstantValueWriter.write(this.loader, this.printer, this.referenceMap, classFile, cv);
                this.printer.debugEndOfInstructionBlockLayoutBlock();
            }
            this.printer.print(": ");
            if (lineCount > 0) {
                if (j == 1 && i2 < lastIndex) {
                    this.endOfLine();
                    this.printer.startOfLine(0);
                    j = caseByLine;
                } else {
                    --j;
                }
            }
            ++i2;
        }
    }

    private void writeCatch(FastCatchLayoutBlock fslb) {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("catch");
        this.printer.print(" (");
        ClassFile classFile = fslb.getClassFile();
        ConstantPool constants = classFile.getConstantPool();
        Method method = fslb.getMethod();
        FastTry.FastCatch fc = fslb.getFc();
        this.writeCatchType(classFile, constants, fc.exceptionTypeIndex());
        if (fc.otherExceptionTypeIndexes() != null) {
            int[] nArray = fc.otherExceptionTypeIndexes();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int otherExceptionTypeIndex = nArray[n2];
                if (otherExceptionTypeIndex != 0) {
                    this.printer.print('|');
                    this.writeCatchType(classFile, constants, otherExceptionTypeIndex);
                }
                ++n2;
            }
        }
        this.printer.print(' ');
        LocalVariables localVariables = Optional.ofNullable(method).map(Method::getLocalVariables).orElseGet(LocalVariables::new);
        LocalVariable lv = localVariables.searchLocalVariableWithIndexAndOffset(fc.localVarIndex(), fc.exceptionOffset());
        if (lv == null) {
            this.printer.startOfError();
            this.printer.print("???");
            this.printer.endOfError();
        } else {
            this.printer.print(constants.getConstantUtf8(lv.getNameIndex()));
        }
        this.printer.print(')');
    }

    private void writeCatchType(ClassFile classFile, ConstantPool constants, int exceptionTypeIndex) {
        String internalClassName = constants.getConstantClassName(exceptionTypeIndex);
        String className = SignatureWriter.internalClassNameToClassName(this.loader, this.referenceMap, classFile, internalClassName);
        this.printer.printType(internalClassName, className, classFile.getThisClassName());
    }

    private void writeSynchronized() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword(SYNCHRONIZED);
        this.printer.print(" (");
    }

    private void writeLabel(OffsetLayoutBlock olb) {
        this.addSpaceIfNeeded();
        this.printer.print("label");
        this.printer.print(olb.getOffset());
        this.printer.print(':');
        this.addSpace = true;
    }

    private void writeElse() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("else");
    }

    private void writeElseSpace() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("else");
        this.printer.print(' ');
    }

    private void writeDo() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("do");
    }

    private void writeInfiniteLoop() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("for");
        this.printer.print(" (;;)");
    }

    private void writeTry() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("try");
    }

    private void writeTryWithResources() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("try (");
    }

    private void writeFinally() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("finally");
    }

    private void writeContinue() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword("continue");
        this.printer.print(';');
    }

    private void writeBreak() {
        this.addSpaceIfNeeded();
        this.printer.printKeyword(BREAK);
        this.printer.print(';');
    }

    private void addSpaceIfNeeded() {
        if (this.addSpace) {
            this.printer.print(" ");
            this.addSpace = false;
        }
    }

    private void endOfLine() {
        this.printer.endOfLine();
        this.addSpace = false;
    }
}

