/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.writer.SignatureWriter;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.commons.lang3.ArrayUtils;
import org.jd.core.v1.api.loader.Loader;

public final class ByteCodeWriter {
    public static final String BYTE_CODE = "// Byte code:";
    private static final String START_OF_COMMENT = "//   ";
    private static final String CORRUPTED_CONSTANT_POOL = "Corrupted_Constant_Pool";

    private ByteCodeWriter() {
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method) {
        byte[] code = method.getCode();
        if (ArrayUtils.isNotEmpty((byte[])code)) {
            int length = code.length;
            int ioperande = 0;
            short soperande = 0;
            printer.startOfComment();
            ConstantPool constants = classFile.getConstantPool();
            printer.print(BYTE_CODE);
            int index = 0;
            while (index < length) {
                int offset = index;
                int opcode = code[index] & 0xFF;
                printer.endOfLine();
                printer.startOfLine(0);
                printer.print(START_OF_COMMENT);
                printer.print(offset);
                printer.print(": ");
                printer.print(Const.getOpcodeName((int)opcode));
                block0 : switch (Const.getNoOfOperands((int)opcode)) {
                    case 1: {
                        printer.print(" ");
                        if (opcode == 188) {
                            printer.print(Const.getTypeName((int)(code[++index] & 0x10)));
                            break;
                        }
                        printer.print(code[++index]);
                        break;
                    }
                    case 2: {
                        printer.print(" ");
                        switch (opcode) {
                            case 132: {
                                printer.print(code[++index]);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 153: 
                            case 154: 
                            case 155: 
                            case 156: 
                            case 157: 
                            case 158: 
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: 
                            case 167: 
                            case 168: 
                            case 198: 
                            case 199: {
                                soperande = (short)((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                if (soperande >= 0) {
                                    printer.print('+');
                                }
                                printer.print(soperande);
                                printer.print(" -> ");
                                printer.print(index + soperande - 2);
                                break block0;
                            }
                            case 178: 
                            case 179: 
                            case 180: 
                            case 181: 
                            case 285: {
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                String fieldName = ByteCodeWriter.getConstantFieldName(constants, ioperande);
                                if (fieldName == null) {
                                    printer.startOfError();
                                    printer.print(CORRUPTED_CONSTANT_POOL);
                                    printer.endOfError();
                                    break block0;
                                }
                                printer.print(fieldName);
                                break block0;
                            }
                            case 182: 
                            case 183: 
                            case 184: {
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                String methodName = ByteCodeWriter.getConstantMethodName(constants, ioperande);
                                if (methodName == null) {
                                    printer.startOfError();
                                    printer.print(CORRUPTED_CONSTANT_POOL);
                                    printer.endOfError();
                                    break block0;
                                }
                                printer.print(methodName);
                                break block0;
                            }
                            case 187: 
                            case 189: 
                            case 192: {
                                Constant c;
                                ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(ioperande);
                                printer.print("\t");
                                Constant constant = c = constants.get(ioperande);
                                if (constant instanceof ConstantClass var16_20) {
                                    void cc;
                                    printer.print(constants.getConstantUtf8(cc.getNameIndex()));
                                    break block0;
                                }
                                printer.print(CORRUPTED_CONSTANT_POOL);
                                break block0;
                            }
                        }
                        ioperande = (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                        printer.print(ioperande);
                        break;
                    }
                    default: {
                        switch (opcode) {
                            case 197: {
                                printer.print(" ");
                                printer.print((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 185: {
                                printer.print(" ");
                                printer.print((code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                printer.print(" ");
                                printer.print(code[++index]);
                                printer.print(" ");
                                printer.print(code[++index]);
                                break block0;
                            }
                            case 170: {
                                index = (index + 4 & 0xFFFC) - 1;
                                printer.print("\tdefault:+");
                                int jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(jump);
                                printer.print("->");
                                printer.print(offset + jump);
                                int low = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int high = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int value = low;
                                while (value <= high) {
                                    printer.print(", ");
                                    printer.print(value);
                                    printer.print(":+");
                                    jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                    printer.print(jump);
                                    printer.print("->");
                                    printer.print(offset + jump);
                                    ++value;
                                }
                                break block0;
                            }
                            case 171: {
                                index = (index + 4 & 0xFFFC) - 1;
                                printer.print("\tdefault:+");
                                int jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                printer.print(jump);
                                printer.print("->");
                                printer.print(offset + jump);
                                int npairs = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                int i = 0;
                                while (i < npairs) {
                                    printer.print(", ");
                                    printer.print((code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF);
                                    printer.print(":+");
                                    jump = (code[++index] & 0xFF) << 24 | (code[++index] & 0xFF) << 16 | (code[++index] & 0xFF) << 8 | code[++index] & 0xFF;
                                    printer.print(jump);
                                    printer.print("->");
                                    printer.print(offset + jump);
                                    ++i;
                                }
                                break block0;
                            }
                            case 196: {
                                index = ByteCodeUtil.nextWideOffset((byte[])code, (int)index);
                                break block0;
                            }
                            default: {
                                int j = Const.getNoOfOperands((int)opcode);
                                while (j > 0) {
                                    printer.print(" ");
                                    printer.print(code[++index]);
                                    --j;
                                }
                                break block0;
                            }
                        }
                    }
                }
                ++index;
            }
            ByteCodeWriter.writeAttributeNumberTables(printer, method);
            ByteCodeWriter.writeAttributeLocalVariableTables(loader, printer, referenceMap, classFile, method);
            ByteCodeWriter.writeCodeExceptions(printer, classFile, method);
            printer.endOfComment();
        }
    }

    private static void writeAttributeNumberTables(Printer printer, Method method) {
        Object[] lineNumbers = method.getLineNumbers();
        if (ArrayUtils.isNotEmpty((Object[])lineNumbers)) {
            printer.endOfLine();
            printer.startOfLine(0);
            printer.print("// Line number table:");
            Object[] objectArray = lineNumbers;
            int n = lineNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                Object lineNumber = objectArray[n2];
                printer.endOfLine();
                printer.startOfLine(0);
                printer.print("//   Java source line #");
                printer.print(lineNumber.getLineNumber());
                printer.print("\t-> byte code offset #");
                printer.print(lineNumber.getStartPC());
                ++n2;
            }
        }
    }

    private static void writeAttributeLocalVariableTables(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, Method method) {
        LocalVariables localVariables = method.getLocalVariables();
        if (localVariables != null && localVariables.size() > 0) {
            int length = localVariables.size();
            printer.endOfLine();
            printer.startOfLine(0);
            printer.print("// Local variable table:");
            printer.endOfLine();
            printer.startOfLine(0);
            printer.print("//   start\tlength\tslot\tname\tsignature");
            ConstantPool constants = classFile.getConstantPool();
            int i = 0;
            while (i < length) {
                LocalVariable lv = localVariables.getLocalVariableAt(i);
                if (lv != null) {
                    printer.endOfLine();
                    printer.startOfLine(0);
                    printer.print(START_OF_COMMENT);
                    printer.print(lv.getStartPc());
                    printer.print("\t");
                    printer.print(lv.getLength());
                    printer.print("\t");
                    printer.print(lv.getIndex());
                    printer.print("\t");
                    if (lv.getNameIndex() > 0) {
                        printer.print(constants.getConstantUtf8(lv.getNameIndex()));
                    } else {
                        printer.print("???");
                    }
                    printer.print("\t");
                    if (lv.getSignatureIndex() > 0) {
                        SignatureWriter.writeSignature(loader, printer, referenceMap, classFile, lv.getSignature(constants));
                    } else {
                        printer.print("???");
                    }
                }
                ++i;
            }
        }
    }

    private static void writeCodeExceptions(Printer printer, ClassFile classFile, Method method) {
        Object[] codeExceptions = method.getCodeExceptions();
        if (ArrayUtils.isNotEmpty((Object[])codeExceptions)) {
            printer.endOfLine();
            printer.startOfLine(0);
            printer.print("// Exception table:");
            printer.endOfLine();
            printer.startOfLine(0);
            printer.print("//   from\tto\ttarget\ttype");
            Object[] objectArray = codeExceptions;
            int n = codeExceptions.length;
            int n2 = 0;
            while (n2 < n) {
                Object codeException = objectArray[n2];
                printer.endOfLine();
                printer.startOfLine(0);
                printer.print(START_OF_COMMENT);
                printer.print(codeException.getStartPC());
                printer.print("\t");
                printer.print(codeException.getEndPC());
                printer.print("\t");
                printer.print(codeException.getHandlerPC());
                printer.print("\t");
                if (codeException.getCatchType() == 0) {
                    printer.print("finally");
                } else {
                    printer.print(classFile.getConstantPool().getConstantClassName(codeException.getCatchType()));
                }
                ++n2;
            }
        }
    }

    private static String getConstantFieldName(ConstantPool constants, int index) {
        Constant c = constants.get(index);
        if (!(c instanceof ConstantFieldref)) {
            return null;
        }
        ConstantFieldref cfr = (ConstantFieldref)c;
        if (!((c = constants.get(cfr.getClassIndex())) instanceof ConstantClass)) {
            return null;
        }
        ConstantClass cc = (ConstantClass)c;
        String classPath = constants.getConstantUtf8(cc.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        return String.valueOf(classPath) + ':' + fieldName + "\t" + fieldDescriptor;
    }

    private static String getConstantMethodName(ConstantPool constants, int index) {
        Constant c = constants.get(index);
        if (!(c instanceof ConstantMethodref)) {
            return null;
        }
        ConstantMethodref cmr = (ConstantMethodref)c;
        if (!((c = constants.get(cmr.getClassIndex())) instanceof ConstantClass)) {
            return null;
        }
        ConstantClass cc = (ConstantClass)c;
        String classPath = constants.getConstantUtf8(cc.getNameIndex());
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        return String.valueOf(classPath) + ':' + fieldName + "\t" + fieldDescriptor;
    }
}

