/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.writer;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.reference.ReferenceMap;
import jd.core.printer.Printer;
import jd.core.process.writer.ElementValueWriter;
import jd.core.process.writer.SignatureWriter;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.jd.core.v1.api.loader.Loader;

public final class AnnotationWriter {
    private AnnotationWriter() {
    }

    public static void writeParameterAnnotation(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, ParameterAnnotationEntry parameterAnnotation) {
        if (parameterAnnotation == null) {
            return;
        }
        AnnotationEntry[] annotations = parameterAnnotation.getAnnotationEntries();
        if (annotations == null) {
            return;
        }
        AnnotationEntry[] annotationEntryArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry annotation = annotationEntryArray[n2];
            AnnotationWriter.writeAnnotation(loader, printer, referenceMap, classFile, annotation);
            printer.print(' ');
            ++n2;
        }
    }

    public static void writeAnnotation(Loader loader, Printer printer, ReferenceMap referenceMap, ClassFile classFile, AnnotationEntry annotationEntry) {
        printer.startOfAnnotationName();
        printer.print('@');
        String annotationName = classFile.getConstantPool().getConstantUtf8(annotationEntry.getTypeIndex());
        SignatureWriter.writeSignature(loader, printer, referenceMap, classFile, annotationName);
        printer.endOfAnnotationName();
        Object[] evps = annotationEntry.getElementValuePairs();
        if (ArrayUtils.isNotEmpty((Object[])evps)) {
            printer.print('(');
            ConstantPool constants = classFile.getConstantPool();
            String name = constants.getConstantUtf8(evps[0].getNameIndex());
            if (evps.length > 1 || !"value".equals(name)) {
                printer.print(name);
                printer.print('=');
            }
            ElementValueWriter.writeElementValue(loader, printer, referenceMap, classFile, evps[0].getValue());
            int j = 1;
            while (j < evps.length) {
                name = constants.getConstantUtf8(evps[j].getNameIndex());
                printer.print(", ");
                printer.print(name);
                printer.print('=');
                ElementValueWriter.writeElementValue(loader, printer, referenceMap, classFile, evps[j].getValue());
                ++j;
            }
            printer.print(')');
        }
    }
}

