/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import jd.core.process.layouter.visitor.MinLineNumberVisitor;

public final class MinMaxLineNumberVisitor {
    private MinMaxLineNumberVisitor() {
    }

    public static MinMaxLineNumber visit(List<Instruction> instructions) {
        int minLineNumber = Integer.MAX_VALUE;
        int maxLineNumber = Integer.MIN_VALUE;
        for (Instruction instruction : instructions) {
            minLineNumber = Math.min(minLineNumber, MinLineNumberVisitor.visit(instruction));
            maxLineNumber = Math.max(maxLineNumber, MaxLineNumberVisitor.visit(instruction));
        }
        return new MinMaxLineNumber(minLineNumber, maxLineNumber);
    }

    public record MinMaxLineNumber(int minLineNumber, int maxLineNumber) {
        public boolean isValid() {
            return this.minLineNumber != Integer.MAX_VALUE && this.maxLineNumber != Integer.MIN_VALUE;
        }
    }
}

