/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import jd.core.model.instruction.bytecode.instruction.ArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;

public final class MinLineNumberVisitor {
    private MinLineNumberVisitor() {
    }

    public static int visit(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 83: 
            case 271: 
            case 272: {
                return MinLineNumberVisitor.visit(((ArrayInstruction)instruction).getArrayref());
            }
            case 265: {
                return MinLineNumberVisitor.visit(((AssignmentInstruction)instruction).getValue1());
            }
            case 267: {
                return MinLineNumberVisitor.visit(((BinaryOperatorInstruction)instruction).getValue1());
            }
            case 277: {
                IncInstruction ii = (IncInstruction)instruction;
                if (ii.isSingleStep()) {
                    return instruction.getLineNumber();
                }
                return MinLineNumberVisitor.visit(ii.getValue());
            }
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                if (ii.isSingleStep()) {
                    return MinLineNumberVisitor.visit(ii.getValue());
                }
                return instruction.getLineNumber();
            }
            case 87: 
            case 181: 
            case 182: 
            case 183: 
            case 185: 
            case 192: 
            case 193: {
                return MinLineNumberVisitor.visit(((ObjectrefAttribute)((Object)instruction)).getObjectref());
            }
            case 281: {
                return MinLineNumberVisitor.visit(((TernaryOperator)instruction).getTest());
            }
        }
        return instruction.getLineNumber();
    }
}

