/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;

public final class MaxLineNumberVisitor {
    private MaxLineNumberVisitor() {
    }

    public static int visit(Instruction instruction) {
        int maxLineNumber = instruction.getLineNumber();
        switch (instruction.getOpcode()) {
            case 271: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ArrayLoadInstruction)instruction).getIndexref());
                break;
            }
            case 54: 
            case 58: 
            case 83: 
            case 179: 
            case 181: 
            case 269: 
            case 272: 
            case 273: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ValuerefAttribute)((Object)instruction)).getValueref());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                maxLineNumber = MaxLineNumberVisitor.visit(ai.getMsg() == null ? ai.getTest() : ai.getMsg());
                break;
            }
            case 191: {
                maxLineNumber = MaxLineNumberVisitor.visit(((AThrow)instruction).getValue());
                break;
            }
            case 266: {
                maxLineNumber = MaxLineNumberVisitor.visit(((UnaryOperatorInstruction)instruction).getValue());
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                maxLineNumber = Math.max(MaxLineNumberVisitor.visit(boi.getValue1()), MaxLineNumberVisitor.visit(boi.getValue2()));
                break;
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ObjectrefAttribute)((Object)instruction)).getObjectref());
                break;
            }
            case 275: 
            case 276: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ConvertInstruction)instruction).getValue());
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.getInstruction() == null) break;
                maxLineNumber = MaxLineNumberVisitor.visit(fd.getInstruction());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                maxLineNumber = Math.max(MaxLineNumberVisitor.visit(ifCmp.getValue1()), MaxLineNumberVisitor.visit(ifCmp.getValue2()));
                break;
            }
            case 260: 
            case 262: {
                maxLineNumber = MaxLineNumberVisitor.visit(((IfInstruction)instruction).getValue());
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).getInstructions();
                maxLineNumber = MaxLineNumberVisitor.visit(branchList.get(branchList.size() - 1));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                List<Instruction> list = ((InvokeInstruction)instruction).getArgs();
                int length = list.size();
                if (length == 0) {
                    if (instruction instanceof InvokeNoStaticInstruction var6_14) {
                        maxLineNumber = MaxLineNumberVisitor.visit(insi.getObjectref());
                        break;
                    }
                    maxLineNumber = instruction.getLineNumber();
                    break;
                }
                maxLineNumber = MaxLineNumberVisitor.computeMaxLineNumber(list);
                break;
            }
            case 274: 
            case 321: {
                List<Instruction> list = ((InvokeNew)instruction).getArgs();
                if (list.isEmpty()) {
                    maxLineNumber = instruction.getLineNumber();
                    break;
                }
                maxLineNumber = MaxLineNumberVisitor.computeMaxLineNumber(list);
                break;
            }
            case 170: 
            case 171: {
                maxLineNumber = MaxLineNumberVisitor.visit(((Switch)instruction).getKey());
                break;
            }
            case 197: {
                List<Instruction> dimensions = ((MultiANewArray)instruction).getDimensions();
                if (dimensions.isEmpty()) break;
                maxLineNumber = MaxLineNumberVisitor.visit(dimensions.get(dimensions.size() - 1));
                break;
            }
            case 188: {
                maxLineNumber = MaxLineNumberVisitor.visit(((NewArray)instruction).getDimension());
                break;
            }
            case 189: {
                maxLineNumber = MaxLineNumberVisitor.visit(((ANewArray)instruction).getDimension());
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                maxLineNumber = MaxLineNumberVisitor.visit(ii.getValue());
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                int length = iai.getValues().size();
                if (length <= 0) break;
                maxLineNumber = MaxLineNumberVisitor.visit(iai.getValues().get(length - 1));
                break;
            }
            case 281: {
                maxLineNumber = MaxLineNumberVisitor.visit(((TernaryOperator)instruction).getValue2());
            }
        }
        if (maxLineNumber < instruction.getLineNumber()) {
            return instruction.getLineNumber();
        }
        return maxLineNumber;
    }

    private static int computeMaxLineNumber(List<Instruction> instructions) {
        int maxLineNumber = MaxLineNumberVisitor.visit(instructions.get(0));
        for (Instruction instruction : instructions) {
            int lineNumber = MaxLineNumberVisitor.visit(instruction);
            if (maxLineNumber >= lineNumber) continue;
            maxLineNumber = lineNumber;
        }
        return maxLineNumber;
    }
}

