/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.LambdaInstruction;
import jd.core.model.layout.block.FragmentLayoutBlock;
import jd.core.model.layout.block.InstructionsLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.preferences.Preferences;
import jd.core.process.layouter.ClassFileLayouter;
import jd.core.process.layouter.visitor.BaseInstructionSplitterVisitor;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import jd.core.process.layouter.visitor.MinLineNumberVisitor;

public class InstructionsSplitterVisitor
extends BaseInstructionSplitterVisitor {
    private Preferences preferences;
    private List<LayoutBlock> layoutBlockList;
    private Method method;
    private List<Instruction> list;
    private int firstLineNumber;
    private int maxLineNumber;
    private int initialIndex1;
    private int index1;
    private int index2;
    private int offset1;

    public void start(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, List<Instruction> list, int index1) {
        super.start(classFile);
        this.preferences = preferences;
        this.layoutBlockList = layoutBlockList;
        this.method = method;
        this.list = list;
        this.maxLineNumber = 0;
        this.firstLineNumber = 0;
        this.initialIndex1 = this.index1 = index1;
        this.offset1 = 0;
    }

    public void end() {
        int lastOffset = this.list.get(this.index2).getOffset();
        if (this.index1 != this.index2 || this.offset1 != lastOffset || lastOffset == 0) {
            int lastLineNumber = 0;
            int j = this.index2;
            while (j >= this.index1) {
                Instruction instruction = this.list.get(j);
                if (instruction.getLineNumber() != 0) {
                    lastLineNumber = MaxLineNumberVisitor.visit(instruction);
                    break;
                }
                --j;
            }
            if (lastOffset == 0) {
                this.addInstructionsLayoutBlock(lastLineNumber, 1);
                this.layoutBlockList.add(new FragmentLayoutBlock(82));
            } else {
                this.addInstructionsLayoutBlock(lastLineNumber, lastOffset);
            }
        }
    }

    public void setIndex2(int index2) {
        this.index2 = index2;
    }

    @Override
    public void visit(Instruction instruction) {
        int initialFirstLineNumber;
        if (this.firstLineNumber == 0 && (initialFirstLineNumber = this.list.get(this.initialIndex1).getLineNumber()) != 0) {
            int minLineNumber = instruction.getLineNumber();
            if (instruction.getOpcode() != 181) {
                minLineNumber = MinLineNumberVisitor.visit(instruction);
            }
            this.firstLineNumber = initialFirstLineNumber < instruction.getLineNumber() ? minLineNumber - 1 : minLineNumber;
        }
        super.visit(null, instruction);
    }

    @Override
    protected void visit(Instruction parent, Instruction instruction) {
        if (instruction.getLineNumber() == 0) {
            instruction.setLineNumber(this.maxLineNumber);
        } else if (this.maxLineNumber == 0) {
            this.maxLineNumber = instruction.getLineNumber();
        } else if (this.firstLineNumber == 0) {
            if (instruction.getLineNumber() < this.maxLineNumber) {
                instruction.setLineNumber(this.maxLineNumber);
            }
            this.firstLineNumber = instruction.getLineNumber();
        }
        super.visit(parent, instruction);
    }

    @Override
    public void visitAnonymousNewInvoke(Instruction parent, InvokeNew in, ClassFile innerClassFile) {
        this.addInstructionsLayoutBlock(in.getLineNumber(), in.getOffset());
        this.maxLineNumber = ClassFileLayouter.createBlocksForBodyOfAnonymousClass(this.preferences, innerClassFile, this.layoutBlockList);
        this.firstLineNumber = 0;
        this.index1 = this.index2;
        this.offset1 = in.getOffset();
    }

    @Override
    public void visitAnonymousLambda(Instruction parent, LambdaInstruction in) {
        this.addInstructionsLayoutBlock(in.getLineNumber(), in.getOffset());
        this.maxLineNumber = ClassFileLayouter.createBlocksForBodyOfLambda(this.preferences, in, this.layoutBlockList);
        this.firstLineNumber = 0;
        this.index1 = this.index2;
        this.offset1 = in.getOffset();
    }

    protected void addInstructionsLayoutBlock(int lastLineNumber, int lastOffset) {
        int preferedLineCount;
        if (this.firstLineNumber != 0 && lastLineNumber != 0) {
            if (lastLineNumber < this.firstLineNumber) {
                lastLineNumber = this.firstLineNumber;
            }
            preferedLineCount = lastLineNumber - this.firstLineNumber;
        } else {
            preferedLineCount = Integer.MAX_VALUE;
        }
        this.layoutBlockList.add(new InstructionsLayoutBlock(this.firstLineNumber, lastLineNumber, preferedLineCount, preferedLineCount, preferedLineCount, this.classFile, this.method, this.list, this.index1, this.index2, this.offset1, lastOffset));
    }
}

