/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.LambdaInstruction;
import jd.core.model.layout.block.InstructionLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.preferences.Preferences;
import jd.core.process.layouter.ClassFileLayouter;
import jd.core.process.layouter.visitor.BaseInstructionSplitterVisitor;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import jd.core.process.layouter.visitor.MinLineNumberVisitor;

public class InstructionSplitterVisitor
extends BaseInstructionSplitterVisitor {
    private Preferences preferences;
    private List<LayoutBlock> layoutBlockList;
    private Method method;
    private Instruction instruction;
    private int firstLineNumber;
    private int offset1;

    public void start(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, Instruction instruction) {
        super.start(classFile);
        this.preferences = preferences;
        this.layoutBlockList = layoutBlockList;
        this.method = method;
        this.instruction = instruction;
        this.firstLineNumber = MinLineNumberVisitor.visit(instruction);
        this.offset1 = 0;
    }

    public void end() {
        if (this.offset1 == 0 || this.offset1 != this.instruction.getOffset()) {
            int lastLineNumber = MaxLineNumberVisitor.visit(this.instruction);
            int preferedLineNumber = this.firstLineNumber != 0 && lastLineNumber != 0 ? lastLineNumber - this.firstLineNumber : Integer.MAX_VALUE;
            this.layoutBlockList.add(new InstructionLayoutBlock(54, this.firstLineNumber, lastLineNumber, preferedLineNumber, preferedLineNumber, preferedLineNumber, this.classFile, this.method, this.instruction, this.offset1, this.instruction.getLastOffset()));
        }
    }

    @Override
    public void visitAnonymousNewInvoke(Instruction parent, InvokeNew in, ClassFile innerClassFile) {
        int lastLineNumber = MaxLineNumberVisitor.visit(in);
        int preferedLineNumber = this.firstLineNumber != 0 && lastLineNumber != 0 ? lastLineNumber - this.firstLineNumber : Integer.MAX_VALUE;
        this.layoutBlockList.add(new InstructionLayoutBlock(54, this.firstLineNumber, lastLineNumber, preferedLineNumber, preferedLineNumber, preferedLineNumber, this.classFile, this.method, this.instruction, this.offset1, in.getOffset()));
        this.firstLineNumber = parent.getLineNumber();
        this.offset1 = in.getOffset();
        ClassFileLayouter.createBlocksForBodyOfAnonymousClass(this.preferences, innerClassFile, this.layoutBlockList);
    }

    @Override
    public void visitAnonymousLambda(Instruction parent, LambdaInstruction in) {
        int lastLineNumber = MaxLineNumberVisitor.visit(in);
        int preferedLineNumber = this.firstLineNumber != 0 && lastLineNumber != 0 ? lastLineNumber - this.firstLineNumber : Integer.MAX_VALUE;
        this.layoutBlockList.add(new InstructionLayoutBlock(54, this.firstLineNumber, lastLineNumber, preferedLineNumber, preferedLineNumber, preferedLineNumber, this.classFile, this.method, this.instruction, this.offset1, in.getOffset()));
        this.firstLineNumber = parent.getLineNumber();
        this.offset1 = in.getOffset();
        ClassFileLayouter.createBlocksForBodyOfLambda(this.preferences, in, this.layoutBlockList);
    }
}

