/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter.visitor;

import java.util.List;
import java.util.Optional;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LambdaInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import org.apache.bcel.classfile.ConstantCP;

public abstract class BaseInstructionSplitterVisitor {
    protected ClassFile classFile;
    private ConstantPool constants;

    protected BaseInstructionSplitterVisitor() {
    }

    public void start(ClassFile classFile) {
        this.classFile = classFile;
        this.constants = Optional.ofNullable(classFile).map(ClassFile::getConstantPool).orElse(null);
    }

    public void visit(Instruction instruction) {
        this.visit(null, instruction);
    }

    protected void visit(Instruction parent, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 190: {
                this.visit(instruction, ((ArrayLength)instruction).getArrayref());
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                this.visit(instruction, ali.getArrayref());
                this.visit(instruction, ali.getIndexref());
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(instruction, asi.getArrayref());
                this.visit(instruction, asi.getIndexref());
                this.visit(instruction, asi.getValueref());
                break;
            }
            case 189: {
                this.visit(instruction, ((ANewArray)instruction).getDimension());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(instruction, ai.getTest());
                if (ai.getMsg() == null) break;
                this.visit(instruction, ai.getMsg());
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(instruction, boi.getValue1());
                this.visit(instruction, boi.getValue2());
                break;
            }
            case 191: {
                this.visit(instruction, ((AThrow)instruction).getValue());
                break;
            }
            case 266: {
                this.visit(instruction, ((UnaryOperatorInstruction)instruction).getValue());
                break;
            }
            case 275: 
            case 276: {
                this.visit(instruction, ((ConvertInstruction)instruction).getValue());
                break;
            }
            case 192: {
                this.visit(instruction, ((CheckCast)instruction).getObjectref());
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.getInstruction() == null) break;
                this.visit(instruction, fd.getInstruction());
                break;
            }
            case 180: {
                this.visit(instruction, ((GetField)instruction).getObjectref());
                break;
            }
            case 260: 
            case 262: {
                this.visit(instruction, ((IfInstruction)instruction).getValue());
                break;
            }
            case 261: {
                IfCmp ic = (IfCmp)instruction;
                this.visit(instruction, ic.getValue1());
                this.visit(instruction, ic.getValue2());
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).getInstructions();
                for (Instruction i : branchList) {
                    this.visit(instruction, i);
                }
                break;
            }
            case 277: 
            case 278: {
                this.visit(instruction, ((IncInstruction)instruction).getValue());
                break;
            }
            case 274: {
                ClassFile innerClassFile;
                String prefix;
                InvokeNew in = (InvokeNew)instruction;
                if (in.getPrefix() != null) {
                    this.visit(in.getPrefix());
                }
                for (Instruction i : in.getArgs()) {
                    this.visit(instruction, i);
                }
                ConstantCP cmr = this.constants.getConstantMethodref(in.getIndex());
                String internalClassName = this.constants.getConstantClassName(cmr.getClassIndex());
                if (!internalClassName.startsWith(prefix = String.valueOf(this.classFile.getThisClassName()) + '$') || (innerClassFile = this.classFile.getInnerClassFile(internalClassName)) == null || innerClassFile.getInternalAnonymousClassName() == null) break;
                this.visitAnonymousNewInvoke(Optional.ofNullable(parent).orElse(in), in, innerClassFile);
                break;
            }
            case 186: {
                LambdaInstruction in;
                Instruction instruction2 = instruction;
                if (!(instruction2 instanceof LambdaInstruction) || (in = (LambdaInstruction)instruction2) != (LambdaInstruction)instruction2) break;
                this.visitAnonymousLambda(Optional.ofNullable(parent).orElse(in), in);
                break;
            }
            case 193: {
                this.visit(instruction, ((InstanceOf)instruction).getObjectref());
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                this.visit(instruction, ((InvokeNoStaticInstruction)instruction).getObjectref());
            }
            case 184: {
                List<Instruction> args = ((InvokeInstruction)instruction).getArgs();
                for (Instruction i : args) {
                    this.visit(instruction, i);
                }
                break;
            }
            case 170: 
            case 171: {
                this.visit(instruction, ((Switch)instruction).getKey());
                break;
            }
            case 197: {
                List<Instruction> dimensions = ((MultiANewArray)instruction).getDimensions();
                for (Instruction i : dimensions) {
                    this.visit(instruction, i);
                }
                break;
            }
            case 188: {
                this.visit(instruction, ((NewArray)instruction).getDimension());
                break;
            }
            case 87: {
                this.visit(instruction, ((Pop)instruction).getObjectref());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(instruction, putField.getObjectref());
                this.visit(instruction, putField.getValueref());
                break;
            }
            case 179: {
                this.visit(instruction, ((PutStatic)instruction).getValueref());
                break;
            }
            case 273: {
                this.visit(instruction, ((ReturnInstruction)instruction).getValueref());
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                this.visit(instruction, ((StoreInstruction)instruction).getValueref());
                break;
            }
            case 280: {
                this.visit(instruction, ((TernaryOpStore)instruction).getObjectref());
                break;
            }
            case 281: {
                TernaryOperator tp = (TernaryOperator)instruction;
                this.visit(instruction, tp.getTest());
                this.visit(instruction, tp.getValue1());
                this.visit(instruction, tp.getValue2());
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(instruction, iai.getNewArray());
                for (Instruction value : iai.getValues()) {
                    this.visit(instruction, value);
                }
                break;
            }
        }
    }

    public abstract void visitAnonymousNewInvoke(Instruction var1, InvokeNew var2, ClassFile var3);

    public abstract void visitAnonymousLambda(Instruction var1, LambdaInstruction var2);
}

