/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.layout.block.GenericExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.GenericImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericTypeNameLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.util.CharArrayUtil;
import jd.core.util.SignatureUtil;

public final class SignatureLayouter {
    private SignatureLayouter() {
    }

    public static boolean createLayoutBlocksForClassSignature(ClassFile classFile, String signature, List<LayoutBlock> layoutBlockList) {
        boolean displayExtendsOrImplementsFlag = false;
        char[] caSignature = signature.toCharArray();
        int length = caSignature.length;
        int index = 0;
        layoutBlockList.add(new GenericTypeNameLayoutBlock(classFile, signature));
        index = SignatureLayouter.skipGenerics(caSignature, length, index);
        int newIndex = SignatureUtil.skipSignature(caSignature, length, index);
        if ((classFile.getAccessFlags() & 0x4200) == 0 && !SignatureLayouter.isObjectClass(caSignature, index, newIndex)) {
            displayExtendsOrImplementsFlag = true;
            layoutBlockList.add(new GenericExtendsSuperTypeLayoutBlock(classFile, caSignature, index));
        }
        if (newIndex < length) {
            displayExtendsOrImplementsFlag = true;
            if ((classFile.getAccessFlags() & 0x200) != 0) {
                layoutBlockList.add(new GenericExtendsSuperInterfacesLayoutBlock(classFile, caSignature, newIndex));
            } else {
                layoutBlockList.add(new GenericImplementsInterfacesLayoutBlock(classFile, caSignature, newIndex));
            }
        }
        return displayExtendsOrImplementsFlag;
    }

    private static int skipGenerics(char[] caSignature, int length, int index) {
        if (caSignature[index] == '<') {
            int depth = 1;
            while (index < length) {
                char c;
                if ((c = caSignature[++index]) == '<') {
                    ++depth;
                    continue;
                }
                if (c != '>') continue;
                if (depth <= 1) {
                    ++index;
                    break;
                }
                --depth;
            }
        }
        return index;
    }

    private static boolean isObjectClass(char[] caSignature, int beginIndex, int endIndex) {
        return "Ljava/lang/Object;".equals(CharArrayUtil.substring(caSignature, beginIndex, endIndex));
    }
}

