/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.layout.block.BlockLayoutBlock;
import jd.core.model.layout.block.CaseBlockEndLayoutBlock;
import jd.core.model.layout.block.CaseBlockStartLayoutBlock;
import jd.core.model.layout.block.CaseEnumLayoutBlock;
import jd.core.model.layout.block.CaseLayoutBlock;
import jd.core.model.layout.block.DeclareLayoutBlock;
import jd.core.model.layout.block.FastCatchLayoutBlock;
import jd.core.model.layout.block.FragmentLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.model.layout.block.OffsetLayoutBlock;
import jd.core.model.layout.block.SeparatorLayoutBlock;
import jd.core.model.layout.block.SingleStatementBlockEndLayoutBlock;
import jd.core.model.layout.block.SingleStatementBlockStartLayoutBlock;
import jd.core.model.layout.block.StatementsBlockEndLayoutBlock;
import jd.core.model.layout.block.StatementsBlockStartLayoutBlock;
import jd.core.model.layout.block.SwitchBlockEndLayoutBlock;
import jd.core.model.layout.block.SwitchBlockStartLayoutBlock;
import jd.core.preferences.Preferences;
import jd.core.process.layouter.visitor.InstructionSplitterVisitor;
import jd.core.process.layouter.visitor.InstructionsSplitterVisitor;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class JavaSourceLayouter {
    private final InstructionSplitterVisitor instructionSplitterVisitor = new InstructionSplitterVisitor();
    private final InstructionsSplitterVisitor instructionsSplitterVisitor = new InstructionsSplitterVisitor();

    public boolean createBlocks(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, List<Instruction> list) {
        int length = list.size();
        boolean singleLine = false;
        int index = 0;
        while (index < length) {
            Instruction instruction = list.get(index);
            if (index > 0) {
                layoutBlockList.add(new SeparatorLayoutBlock(5, 1));
            }
            switch (instruction.getOpcode()) {
                case 301: {
                    this.createBlockForFastTestList(preferences, (byte)61, layoutBlockList, classFile, method, (FastTestList)instruction, true);
                    break;
                }
                case 302: {
                    this.createBlocksForDoWhileLoop(preferences, layoutBlockList, classFile, method, (FastTestList)instruction);
                    break;
                }
                case 303: {
                    this.createBlocksForInfiniteLoop(preferences, layoutBlockList, classFile, method, (FastList)instruction);
                    break;
                }
                case 304: {
                    this.createBlocksForForLoop(preferences, layoutBlockList, classFile, method, (FastFor)instruction);
                    break;
                }
                case 305: {
                    this.createBlockForFastForEach(preferences, layoutBlockList, classFile, method, (FastForEach)instruction);
                    break;
                }
                case 306: {
                    this.createBlockForFastTestList(preferences, (byte)63, layoutBlockList, classFile, method, (FastTestList)instruction, true);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    this.createBlocksForIfElse(preferences, layoutBlockList, classFile, method, ft2l, JavaSourceLayouter.showSingleInstructionBlock(ft2l));
                    break;
                }
                case 308: 
                case 309: {
                    this.createBlocksForIfContinueOrBreak(preferences, layoutBlockList, classFile, method, (FastInstruction)instruction);
                    break;
                }
                case 310: {
                    this.createBlocksForIfLabeledBreak(preferences, layoutBlockList, classFile, method, (FastInstruction)instruction);
                    break;
                }
                case 313: {
                    JavaSourceLayouter.createBlocksForGotoLabeledBreak(layoutBlockList, (FastInstruction)instruction);
                    break;
                }
                case 314: {
                    this.createBlocksForSwitch(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction, (byte)65);
                    break;
                }
                case 315: {
                    this.createBlocksForSwitchEnum(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction);
                    break;
                }
                case 316: {
                    this.createBlocksForSwitch(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction, (byte)67);
                    break;
                }
                case 318: {
                    this.createBlocksForTry(preferences, layoutBlockList, classFile, method, (FastTry)instruction);
                    break;
                }
                case 319: {
                    this.createBlocksForSynchronized(preferences, layoutBlockList, classFile, method, (FastSynchronized)instruction);
                    break;
                }
                case 320: {
                    this.createBlocksForLabel(preferences, layoutBlockList, classFile, method, (FastLabel)instruction);
                    break;
                }
                case 317: {
                    if (((FastDeclaration)instruction).getInstruction() == null) {
                        layoutBlockList.add(new DeclareLayoutBlock(classFile, method, instruction));
                        break;
                    }
                }
                default: {
                    int min;
                    if (length == 1 && (min = instruction.getLineNumber()) != 0) {
                        int max = MaxLineNumberVisitor.visit(instruction);
                        singleLine = min == max;
                    }
                    index = this.createBlockForInstructions(preferences, layoutBlockList, classFile, method, list, index);
                }
            }
            ++index;
        }
        return singleLine;
    }

    private void createBlockForFastTestList(Preferences preferences, byte tag, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastTestList ftl, boolean showSingleInstructionBlock) {
        layoutBlockList.add(new FragmentLayoutBlock(tag));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ftl.getTest());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ftl.getInstructions(), showSingleInstructionBlock, 1);
    }

    private void createBlocksForIfElse(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastTest2Lists ft2l, boolean showSingleInstructionBlock) {
        layoutBlockList.add(new FragmentLayoutBlock(63));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ft2l.getTest());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        List<Instruction> instructions = ft2l.getInstructions();
        if (instructions.size() == 1 && (instructions.get(0).getOpcode() == 306 || instructions.get(0).getOpcode() == 307)) {
            this.createBlockForSubList(preferences, layoutBlockList, classFile, method, instructions, false, 2);
        } else {
            this.createBlockForSubList(preferences, layoutBlockList, classFile, method, instructions, showSingleInstructionBlock, 2);
        }
        List<Instruction> instructions2 = ft2l.getInstructions2();
        if (instructions2.size() == 1) {
            Instruction instruction = instructions2.get(0);
            if (instruction.getOpcode() == 306) {
                layoutBlockList.add(new FragmentLayoutBlock(72));
                this.createBlockForFastTestList(preferences, (byte)63, layoutBlockList, classFile, method, (FastTestList)instruction, showSingleInstructionBlock);
                return;
            }
            if (instruction.getOpcode() == 307) {
                layoutBlockList.add(new FragmentLayoutBlock(72));
                this.createBlocksForIfElse(preferences, layoutBlockList, classFile, method, (FastTest2Lists)instruction, showSingleInstructionBlock);
                return;
            }
        }
        layoutBlockList.add(new FragmentLayoutBlock(71));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, instructions2, showSingleInstructionBlock, 1);
    }

    private static boolean showSingleInstructionBlock(FastTest2Lists ifElse) {
        List<Instruction> instructions;
        while ((instructions = ifElse.getInstructions()) == null || instructions.size() < 2) {
            int instructions2Size = ifElse.getInstructions2().size();
            if (instructions2Size == 0) {
                return true;
            }
            if (instructions2Size >= 2) {
                return false;
            }
            if (instructions2Size != 1) continue;
            Instruction instruction = ifElse.getInstructions2().get(0);
            if (instruction.getOpcode() == 306) {
                instructions = ((FastTestList)instruction).getInstructions();
                return instructions == null || instructions.size() < 2;
            }
            if (instruction.getOpcode() != 307) {
                return true;
            }
            ifElse = (FastTest2Lists)instruction;
        }
        return false;
    }

    private void createBlocksForDoWhileLoop(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastTestList ftl) {
        layoutBlockList.add(new FragmentLayoutBlock(73));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ftl.getInstructions(), false, 1);
        layoutBlockList.add(new FragmentLayoutBlock(61));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ftl.getTest());
        layoutBlockList.add(new FragmentLayoutBlock(81));
    }

    private void createBlocksForInfiniteLoop(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastList fl) {
        layoutBlockList.add(new FragmentLayoutBlock(74));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, fl.getInstructions(), false, 1);
    }

    private void createBlocksForForLoop(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastFor ff) {
        BlockLayoutBlock eblb;
        BlockLayoutBlock sblb;
        layoutBlockList.add(new FragmentLayoutBlock(62));
        if (ff.getInit() != null) {
            sblb = new BlockLayoutBlock(37, 0);
            layoutBlockList.add(sblb);
            this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ff.getInit());
            eblb = new BlockLayoutBlock(38, 0);
            sblb.setOther(eblb);
            eblb.setOther(sblb);
            layoutBlockList.add(eblb);
        }
        if (ff.getTest() == null) {
            layoutBlockList.add(new FragmentLayoutBlock(82));
        } else {
            layoutBlockList.add(new FragmentLayoutBlock(83));
            sblb = new BlockLayoutBlock(37, 0, Integer.MAX_VALUE, 0);
            layoutBlockList.add(sblb);
            this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ff.getTest());
            eblb = new BlockLayoutBlock(38, 0);
            sblb.setOther(eblb);
            eblb.setOther(sblb);
            layoutBlockList.add(eblb);
        }
        if (ff.getInc() == null) {
            layoutBlockList.add(new FragmentLayoutBlock(82));
        } else {
            layoutBlockList.add(new FragmentLayoutBlock(83));
            sblb = new BlockLayoutBlock(37, 0, Integer.MAX_VALUE, 0);
            layoutBlockList.add(sblb);
            this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ff.getInc());
            eblb = new BlockLayoutBlock(38, 0);
            sblb.setOther(eblb);
            eblb.setOther(sblb);
            layoutBlockList.add(eblb);
        }
        layoutBlockList.add(new FragmentLayoutBlock(80));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ff.getInstructions(), true, 1);
    }

    private void createBlockForFastForEach(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastForEach ffe) {
        layoutBlockList.add(new FragmentLayoutBlock(62));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ffe.getVariable());
        layoutBlockList.add(new FragmentLayoutBlock(84));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, ffe.getValues());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ffe.getInstructions(), true, 1);
    }

    private void createBlocksForIfContinueOrBreak(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastInstruction fi) {
        layoutBlockList.add(new FragmentLayoutBlock(63));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, fi.getInstruction());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        SingleStatementBlockStartLayoutBlock ssbslb = new SingleStatementBlockStartLayoutBlock();
        layoutBlockList.add(ssbslb);
        if (fi.getOpcode() == 308) {
            layoutBlockList.add(new FragmentLayoutBlock(77));
        } else {
            layoutBlockList.add(new FragmentLayoutBlock(78));
        }
        SingleStatementBlockEndLayoutBlock ssbelb = new SingleStatementBlockEndLayoutBlock(1);
        ssbslb.setOther(ssbelb);
        ssbelb.setOther(ssbslb);
        layoutBlockList.add(ssbelb);
    }

    private void createBlocksForIfLabeledBreak(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastInstruction fi) {
        layoutBlockList.add(new FragmentLayoutBlock(63));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, fi.getInstruction());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        SingleStatementBlockStartLayoutBlock ssbslb = new SingleStatementBlockStartLayoutBlock();
        layoutBlockList.add(ssbslb);
        BranchInstruction bi = (BranchInstruction)fi.getInstruction();
        layoutBlockList.add(new OffsetLayoutBlock(79, 0, 0, 0, 0, 0, bi.getJumpOffset()));
        SingleStatementBlockEndLayoutBlock ssbelb = new SingleStatementBlockEndLayoutBlock(1);
        ssbslb.setOther(ssbelb);
        ssbelb.setOther(ssbslb);
        layoutBlockList.add(ssbelb);
    }

    private static void createBlocksForGotoLabeledBreak(List<LayoutBlock> layoutBlockList, FastInstruction fi) {
        BranchInstruction bi = (BranchInstruction)fi.getInstruction();
        layoutBlockList.add(new OffsetLayoutBlock(79, 0, 0, 0, 0, 0, bi.getJumpOffset()));
    }

    private void createBlocksForSwitch(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastSwitch fs, byte tagCase) {
        layoutBlockList.add(new FragmentLayoutBlock(64));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, fs.getTest());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        SwitchBlockStartLayoutBlock sbslb = new SwitchBlockStartLayoutBlock();
        layoutBlockList.add(sbslb);
        FastSwitch.Pair[] pairs = fs.getPairs();
        int length = pairs.length;
        int firstIndex = 0;
        int i = 0;
        while (i < length) {
            boolean last = i == length - 1;
            FastSwitch.Pair pair = pairs[i];
            List<Instruction> instructions = pair.getInstructions();
            if (pair.isDefault() && last && (instructions == null || instructions.isEmpty() || instructions.size() == 1 && instructions.get(0).getOpcode() == 312)) break;
            if (instructions != null) {
                layoutBlockList.add(new CaseLayoutBlock(tagCase, classFile, method, fs, firstIndex, i));
                firstIndex = i + 1;
                boolean needBrackets = pair.hasDeclaration();
                layoutBlockList.add(new CaseBlockStartLayoutBlock(needBrackets));
                this.createBlocks(preferences, layoutBlockList, classFile, method, instructions);
                layoutBlockList.add(new CaseBlockEndLayoutBlock(needBrackets));
            }
            ++i;
        }
        SwitchBlockEndLayoutBlock sbelb = new SwitchBlockEndLayoutBlock();
        sbslb.setOther(sbelb);
        sbelb.setOther(sbslb);
        layoutBlockList.add(sbelb);
    }

    private void createBlocksForSwitchEnum(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastSwitch fs) {
        layoutBlockList.add(new FragmentLayoutBlock(64));
        Instruction test = fs.getTest();
        ConstantPool constants = classFile.getConstantPool();
        String switchMapKey = null;
        if (test.getOpcode() == 271) {
            ConstantNameAndType cnat;
            ArrayLoadInstruction ali = (ArrayLoadInstruction)test;
            if (ali.getArrayref().getOpcode() == 184) {
                Invokestatic is = (Invokestatic)ali.getArrayref();
                ConstantCP cmr = constants.getConstantMethodref(is.getIndex());
                cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
            } else if (ali.getArrayref().getOpcode() == 178) {
                GetStatic gs = (GetStatic)ali.getArrayref();
                ConstantFieldref cfr = constants.getConstantFieldref(gs.getIndex());
                cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
            } else {
                throw new IllegalStateException();
            }
            switchMapKey = constants.getConstantUtf8(cnat.getNameIndex());
            Invokevirtual iv = (Invokevirtual)ali.getIndexref();
            this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, iv.getObjectref());
        }
        Objects.requireNonNull(switchMapKey, "Null switchMapKey");
        layoutBlockList.add(new FragmentLayoutBlock(80));
        SwitchBlockStartLayoutBlock sbslb = new SwitchBlockStartLayoutBlock();
        layoutBlockList.add(sbslb);
        FastSwitch.Pair[] pairs = fs.getPairs();
        int length = pairs.length;
        int firstIndex = 0;
        int i = 0;
        while (i < length) {
            boolean last = i == length - 1;
            FastSwitch.Pair pair = pairs[i];
            List<Instruction> instructions = pair.getInstructions();
            if (pair.isDefault() && last && (instructions == null || instructions.isEmpty() || instructions.size() == 1 && instructions.get(0).getOpcode() == 312)) break;
            if (instructions != null) {
                layoutBlockList.add(new CaseEnumLayoutBlock(classFile, method, fs, firstIndex, i, switchMapKey));
                firstIndex = i + 1;
                boolean needBrackets = pair.hasDeclaration();
                layoutBlockList.add(new CaseBlockStartLayoutBlock(needBrackets));
                this.createBlocks(preferences, layoutBlockList, classFile, method, instructions);
                layoutBlockList.add(new CaseBlockEndLayoutBlock(needBrackets));
            }
            ++i;
        }
        SwitchBlockEndLayoutBlock sbelb = new SwitchBlockEndLayoutBlock();
        sbslb.setOther(sbelb);
        sbelb.setOther(sbslb);
        layoutBlockList.add(sbelb);
    }

    private void createBlocksForTry(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastTry ft) {
        int length;
        List<Instruction> resources = ft.getResources();
        Collections.sort(resources, Comparator.comparing(Instruction::getOffset));
        if (resources.isEmpty()) {
            layoutBlockList.add(new FragmentLayoutBlock(75));
        } else {
            layoutBlockList.add(new FragmentLayoutBlock(87));
            if (resources.size() == 1) {
                Instruction resource = resources.get(0);
                this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, resource);
            } else {
                this.createBlockForInstructions(preferences, layoutBlockList, classFile, method, resources, 0);
            }
            layoutBlockList.add(new FragmentLayoutBlock(80));
        }
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ft.getInstructions(), false, 2);
        if (ft.getCatches() != null && (length = ft.getCatches().size()) > 0) {
            --length;
            int i = 0;
            while (i < length) {
                FastTry.FastCatch fc = ft.getCatches().get(i);
                layoutBlockList.add(new FastCatchLayoutBlock(classFile, method, fc));
                this.createBlockForSubList(preferences, layoutBlockList, classFile, method, fc.instructions(), false, 2);
                ++i;
            }
            FastTry.FastCatch fc = ft.getCatches().get(length);
            layoutBlockList.add(new FastCatchLayoutBlock(classFile, method, fc));
            int blockEndPreferedLineCount = ft.getFinallyInstructions() == null ? 1 : 2;
            this.createBlockForSubList(preferences, layoutBlockList, classFile, method, fc.instructions(), false, blockEndPreferedLineCount);
        }
        if (ft.hasFinally() || !ft.hasCatch() && !ft.hasResource()) {
            layoutBlockList.add(new FragmentLayoutBlock(76));
            this.createBlockForSubList(preferences, layoutBlockList, classFile, method, ft.getFinallyInstructions(), false, 1);
        }
    }

    private void createBlocksForSynchronized(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastSynchronized fs) {
        layoutBlockList.add(new FragmentLayoutBlock(69));
        this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, fs.getMonitor());
        layoutBlockList.add(new FragmentLayoutBlock(80));
        this.createBlockForSubList(preferences, layoutBlockList, classFile, method, fs.getInstructions(), false, 1);
    }

    private void createBlocksForLabel(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, FastLabel fl) {
        layoutBlockList.add(new OffsetLayoutBlock(70, 0, 0, 0, 0, 0, fl.getOffset()));
        Instruction instruction = fl.getInstruction();
        if (instruction != null) {
            layoutBlockList.add(new SeparatorLayoutBlock(5, 1));
            switch (instruction.getOpcode()) {
                case 301: {
                    this.createBlockForFastTestList(preferences, (byte)61, layoutBlockList, classFile, method, (FastTestList)instruction, true);
                    break;
                }
                case 302: {
                    this.createBlocksForDoWhileLoop(preferences, layoutBlockList, classFile, method, (FastTestList)instruction);
                    break;
                }
                case 303: {
                    this.createBlocksForInfiniteLoop(preferences, layoutBlockList, classFile, method, (FastList)instruction);
                    break;
                }
                case 304: {
                    this.createBlocksForForLoop(preferences, layoutBlockList, classFile, method, (FastFor)instruction);
                    break;
                }
                case 305: {
                    this.createBlockForFastForEach(preferences, layoutBlockList, classFile, method, (FastForEach)instruction);
                    break;
                }
                case 306: {
                    this.createBlockForFastTestList(preferences, (byte)63, layoutBlockList, classFile, method, (FastTestList)instruction, true);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    this.createBlocksForIfElse(preferences, layoutBlockList, classFile, method, ft2l, JavaSourceLayouter.showSingleInstructionBlock(ft2l));
                    break;
                }
                case 308: 
                case 309: {
                    this.createBlocksForIfContinueOrBreak(preferences, layoutBlockList, classFile, method, (FastInstruction)instruction);
                    break;
                }
                case 310: {
                    this.createBlocksForIfLabeledBreak(preferences, layoutBlockList, classFile, method, (FastInstruction)instruction);
                    break;
                }
                case 313: {
                    JavaSourceLayouter.createBlocksForGotoLabeledBreak(layoutBlockList, (FastInstruction)instruction);
                    break;
                }
                case 314: {
                    this.createBlocksForSwitch(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction, (byte)65);
                    break;
                }
                case 315: {
                    this.createBlocksForSwitchEnum(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction);
                    break;
                }
                case 316: {
                    this.createBlocksForSwitch(preferences, layoutBlockList, classFile, method, (FastSwitch)instruction, (byte)67);
                    break;
                }
                case 318: {
                    this.createBlocksForTry(preferences, layoutBlockList, classFile, method, (FastTry)instruction);
                    break;
                }
                case 319: {
                    this.createBlocksForSynchronized(preferences, layoutBlockList, classFile, method, (FastSynchronized)instruction);
                    break;
                }
                case 320: {
                    this.createBlocksForLabel(preferences, layoutBlockList, classFile, method, (FastLabel)instruction);
                    break;
                }
                case 317: {
                    if (((FastDeclaration)instruction).getInstruction() == null) {
                        layoutBlockList.add(new DeclareLayoutBlock(classFile, method, instruction));
                        break;
                    }
                }
                default: {
                    this.createBlockForInstruction(preferences, layoutBlockList, classFile, method, instruction);
                    layoutBlockList.add(new FragmentLayoutBlock(82));
                }
            }
        }
    }

    private void createBlockForSubList(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, List<Instruction> instructions, boolean showSingleInstructionBlock, int blockEndPreferedLineCount) {
        if (instructions == null || instructions.isEmpty()) {
            StatementsBlockStartLayoutBlock sbslb = new StatementsBlockStartLayoutBlock();
            sbslb.transformToStartEndBlock(0);
            layoutBlockList.add(sbslb);
        } else {
            if (instructions.size() > 1) {
                showSingleInstructionBlock = false;
            }
            BlockLayoutBlock sbslb = showSingleInstructionBlock ? new SingleStatementBlockStartLayoutBlock() : new StatementsBlockStartLayoutBlock();
            layoutBlockList.add(sbslb);
            this.createBlocks(preferences, layoutBlockList, classFile, method, instructions);
            BlockLayoutBlock sbelb = showSingleInstructionBlock ? new SingleStatementBlockEndLayoutBlock(1) : new StatementsBlockEndLayoutBlock(blockEndPreferedLineCount);
            sbslb.setOther(sbelb);
            sbelb.setOther(sbslb);
            layoutBlockList.add(sbelb);
        }
    }

    private void createBlockForInstruction(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, Instruction instruction) {
        this.instructionSplitterVisitor.start(preferences, layoutBlockList, classFile, method, instruction);
        this.instructionSplitterVisitor.visit(instruction);
        this.instructionSplitterVisitor.end();
    }

    private int createBlockForInstructions(Preferences preferences, List<LayoutBlock> layoutBlockList, ClassFile classFile, Method method, List<Instruction> list, int index1) {
        int index2 = JavaSourceLayouter.skipInstructions(list, index1);
        this.instructionsSplitterVisitor.start(preferences, layoutBlockList, classFile, method, list, index1);
        int index = index1;
        while (index <= index2) {
            this.instructionsSplitterVisitor.setIndex2(index);
            this.instructionsSplitterVisitor.visit(list.get(index));
            ++index;
        }
        this.instructionsSplitterVisitor.end();
        return index2;
    }

    private static int skipInstructions(List<Instruction> list, int index) {
        int length = list.size();
        while (++index < length) {
            Instruction instruction = list.get(index);
            if (instruction.getOpcode() != 301 && instruction.getOpcode() != 302 && instruction.getOpcode() != 303 && instruction.getOpcode() != 304 && instruction.getOpcode() != 305 && instruction.getOpcode() != 306 && instruction.getOpcode() != 307 && instruction.getOpcode() != 308 && instruction.getOpcode() != 309 && instruction.getOpcode() != 310 && instruction.getOpcode() != 313 && instruction.getOpcode() != 314 && instruction.getOpcode() != 315 && instruction.getOpcode() != 316 && instruction.getOpcode() != 318 && instruction.getOpcode() != 319 && instruction.getOpcode() != 320 && (instruction.getOpcode() != 317 || ((FastDeclaration)instruction).getInstruction() != null)) continue;
            return index - 1;
        }
        return length - 1;
    }
}

