/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.LambdaInstruction;
import jd.core.model.layout.block.BlockLayoutBlock;
import jd.core.model.layout.block.ByteCodeLayoutBlock;
import jd.core.model.layout.block.CommentDeprecatedLayoutBlock;
import jd.core.model.layout.block.CommentErrorLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.ExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.FieldNameLayoutBlock;
import jd.core.model.layout.block.FragmentLayoutBlock;
import jd.core.model.layout.block.ImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.ImportsLayoutBlock;
import jd.core.model.layout.block.InnerTypeBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.InnerTypeBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.LambdaArrowLayoutBlock;
import jd.core.model.layout.block.LambdaMethodLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.model.layout.block.MarkerLayoutBlock;
import jd.core.model.layout.block.MethodBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.MethodBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.MethodBodySingleLineBlockEndLayoutBlock;
import jd.core.model.layout.block.MethodNameLayoutBlock;
import jd.core.model.layout.block.MethodStaticLayoutBlock;
import jd.core.model.layout.block.PackageLayoutBlock;
import jd.core.model.layout.block.SeparatorLayoutBlock;
import jd.core.model.layout.block.SubListLayoutBlock;
import jd.core.model.layout.block.ThrowsLayoutBlock;
import jd.core.model.layout.block.TypeBodyBlockEndLayoutBlock;
import jd.core.model.layout.block.TypeBodyBlockStartLayoutBlock;
import jd.core.model.layout.block.TypeNameLayoutBlock;
import jd.core.model.layout.section.LayoutSection;
import jd.core.model.reference.Reference;
import jd.core.model.reference.ReferenceMap;
import jd.core.preferences.Preferences;
import jd.core.process.layouter.AnnotationLayouter;
import jd.core.process.layouter.JavaSourceLayouter;
import jd.core.process.layouter.LayoutBlockComparator;
import jd.core.process.layouter.SignatureLayouter;
import jd.core.process.layouter.visitor.InstructionSplitterVisitor;
import jd.core.process.layouter.visitor.MaxLineNumberVisitor;
import jd.core.util.ClassFileUtil;
import jd.core.util.TypeNameUtil;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Signature;
import org.apache.commons.lang3.ArrayUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class ClassFileLayouter {
    private ClassFileLayouter() {
    }

    public static int layout(Preferences preferences, ReferenceMap referenceMap, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int maxLineNumber = ClassFileLayouter.createBlocks(preferences, referenceMap, classFile, layoutBlockList);
        if (maxLineNumber != 0 && preferences.getRealignmentLineNumber()) {
            ClassFileLayouter.layoutBlocks(layoutBlockList);
        }
        return maxLineNumber;
    }

    private static int createBlocks(Preferences preferences, ReferenceMap referenceMap, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int importCount;
        boolean separator = true;
        String internalPackageName = classFile.getInternalPackageName();
        if (internalPackageName != null && !internalPackageName.isEmpty()) {
            layoutBlockList.add(new PackageLayoutBlock(classFile));
            layoutBlockList.add(new SeparatorLayoutBlock(2, 2));
            separator = false;
        }
        if ((importCount = ClassFileLayouter.getImportCount(referenceMap, classFile)) > 0) {
            layoutBlockList.add(new ImportsLayoutBlock(classFile, importCount - 1));
            layoutBlockList.add(new SeparatorLayoutBlock(4, 2));
            separator = false;
        }
        if (separator) {
            layoutBlockList.add(new SeparatorLayoutBlock(3, 0));
        }
        return ClassFileLayouter.createBlocksForClass(preferences, classFile, layoutBlockList);
    }

    private static int getImportCount(ReferenceMap referenceMap, ClassFile classFile) {
        Collection<Reference> collection = referenceMap.values();
        if (collection.isEmpty()) {
            return 0;
        }
        int importCount = 0;
        String internalPackageName = classFile.getInternalPackageName();
        Set<String> typeArgumentInnerClasses = classFile.getTypeArgumentInnerClasses();
        for (Reference reference : collection) {
            String refInternalName = reference.getInternalName();
            String internalReferencePackageName = TypeNameUtil.internalTypeNameToInternalPackageName(refInternalName);
            if ("java/lang".equals(internalReferencePackageName) || internalReferencePackageName.equals(internalPackageName) && !typeArgumentInnerClasses.contains(refInternalName)) continue;
            ++importCount;
        }
        return importCount;
    }

    private static int createBlocksForClass(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        MarkerLayoutBlock tmslb = new MarkerLayoutBlock(7, classFile);
        layoutBlockList.add(tmslb);
        boolean displayExtendsOrImplementsFlag = ClassFileLayouter.createBlocksForHeader(classFile, layoutBlockList);
        TypeBodyBlockStartLayoutBlock bbslb = new TypeBodyBlockStartLayoutBlock();
        layoutBlockList.add(bbslb);
        int layoutBlockListLength = layoutBlockList.size();
        int maxLineNumber = ClassFileLayouter.createBlocksForBody(preferences, classFile, layoutBlockList);
        if (layoutBlockListLength == layoutBlockList.size()) {
            if (displayExtendsOrImplementsFlag) {
                bbslb.transformToStartEndBlock(1);
            } else {
                bbslb.transformToStartEndBlock(0);
            }
        } else {
            TypeBodyBlockEndLayoutBlock bbelb = new TypeBodyBlockEndLayoutBlock();
            bbslb.setOther(bbelb);
            bbelb.setOther(bbslb);
            layoutBlockList.add(bbelb);
        }
        MarkerLayoutBlock tmelb = new MarkerLayoutBlock(8, classFile);
        tmslb.setOther(tmelb);
        tmelb.setOther(tmslb);
        layoutBlockList.add(tmelb);
        return maxLineNumber;
    }

    private static boolean createBlocksForHeader(ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        boolean displayExtendsOrImplementsFlag = false;
        if (classFile.containsAttributeDeprecated() && !classFile.containsAnnotationDeprecated(classFile)) {
            layoutBlockList.add(new CommentDeprecatedLayoutBlock());
        }
        AnnotationLayouter.createBlocksForAnnotations(classFile, classFile.getAttributes(), layoutBlockList);
        Signature as = classFile.getAttributeSignature();
        if (as == null) {
            layoutBlockList.add(new TypeNameLayoutBlock(classFile));
            if ((classFile.getAccessFlags() & 0x2000) == 0) {
                if ((classFile.getAccessFlags() & 0x4000) != 0) {
                    displayExtendsOrImplementsFlag = ClassFileLayouter.createBlocksForInterfacesImplements(classFile, layoutBlockList);
                } else if ((classFile.getAccessFlags() & 0x200) != 0) {
                    int[] interfaceIndexes = classFile.getInterfaces();
                    if (ArrayUtils.isNotEmpty((int[])interfaceIndexes)) {
                        displayExtendsOrImplementsFlag = true;
                        layoutBlockList.add(new ExtendsSuperInterfacesLayoutBlock(classFile));
                    }
                } else {
                    String internalSuperClassName = classFile.getSuperClassName();
                    if (internalSuperClassName != null && !"java/lang/Object".equals(internalSuperClassName)) {
                        displayExtendsOrImplementsFlag = true;
                        layoutBlockList.add(new ExtendsSuperTypeLayoutBlock(classFile));
                    }
                    displayExtendsOrImplementsFlag |= ClassFileLayouter.createBlocksForInterfacesImplements(classFile, layoutBlockList);
                }
            }
        } else {
            ConstantPool constants = classFile.getConstantPool();
            String signature = constants.getConstantUtf8(as.getSignatureIndex());
            displayExtendsOrImplementsFlag = SignatureLayouter.createLayoutBlocksForClassSignature(classFile, signature, layoutBlockList);
        }
        return displayExtendsOrImplementsFlag;
    }

    private static boolean createBlocksForInterfacesImplements(ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int[] interfaceIndexes = classFile.getInterfaces();
        if (ArrayUtils.isNotEmpty((int[])interfaceIndexes)) {
            layoutBlockList.add(new ImplementsInterfacesLayoutBlock(classFile));
            return true;
        }
        return false;
    }

    public static int createBlocksForBodyOfAnonymousClass(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        InnerTypeBodyBlockStartLayoutBlock ibbslb = new InnerTypeBodyBlockStartLayoutBlock();
        layoutBlockList.add(ibbslb);
        int layoutBlockListLength = layoutBlockList.size();
        int maxLineNumber = ClassFileLayouter.createBlocksForBody(preferences, classFile, layoutBlockList);
        if (layoutBlockListLength == layoutBlockList.size()) {
            ibbslb.transformToStartEndBlock();
        } else {
            InnerTypeBodyBlockEndLayoutBlock ibbelb = new InnerTypeBodyBlockEndLayoutBlock();
            ibbslb.setOther(ibbelb);
            ibbelb.setOther(ibbslb);
            layoutBlockList.add(ibbelb);
        }
        return maxLineNumber;
    }

    public static int createBlocksForBodyOfLambda(Preferences preferences, LambdaInstruction lambdaInstruction, List<LayoutBlock> layoutBlockList) {
        List<SubListLayoutBlock> sortedFieldBlockList = Collections.emptyList();
        List<SubListLayoutBlock> sortedMethodBlockList = ClassFileLayouter.createSortedBlocksForLambda(preferences, lambdaInstruction);
        List<SubListLayoutBlock> sortedInnerClassBlockList = Collections.emptyList();
        return ClassFileLayouter.mergeBlocks(layoutBlockList, sortedFieldBlockList, sortedMethodBlockList, sortedInnerClassBlockList);
    }

    private static int createBlocksForBody(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        ClassFileLayouter.createBlockForEnumValues(preferences, classFile, layoutBlockList);
        List<SubListLayoutBlock> sortedFieldBlockList = ClassFileLayouter.createSortedBlocksForFields(preferences, classFile);
        List<SubListLayoutBlock> sortedMethodBlockList = ClassFileLayouter.createSortedBlocksForMethods(preferences, classFile);
        List<SubListLayoutBlock> sortedInnerClassBlockList = ClassFileLayouter.createSortedBlocksForInnerClasses(preferences, classFile);
        return ClassFileLayouter.mergeBlocks(layoutBlockList, sortedFieldBlockList, sortedMethodBlockList, sortedInnerClassBlockList);
    }

    private static void createBlockForEnumValues(Preferences preferences, ClassFile classFile, List<LayoutBlock> layoutBlockList) {
        int valuesLength;
        List<Instruction> values = classFile.getEnumValues();
        if (values != null && (valuesLength = values.size()) > 0) {
            ConstantPool constants = classFile.getConstantPool();
            Field[] fields = classFile.getFields();
            int fieldsLength = fields.length;
            ArrayList<InvokeNew> enumValues = new ArrayList<InvokeNew>(fieldsLength);
            InstructionSplitterVisitor visitor = new InstructionSplitterVisitor();
            int i = 0;
            while (i < valuesLength) {
                GetStatic getStatic = (GetStatic)values.get(i);
                ConstantFieldref cfr = constants.getConstantFieldref(getStatic.getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                int j = fields.length;
                while (j-- > 0) {
                    Field field = fields[j];
                    if (field.getNameIndex() != cnat.getNameIndex() || field.getDescriptorIndex() != cnat.getSignatureIndex()) continue;
                    Field.ValueAndMethod vam = field.getValueAndMethod();
                    InvokeNew invokeNew = (InvokeNew)vam.value();
                    invokeNew.transformToEnumValue(getStatic);
                    enumValues.add(invokeNew);
                    break;
                }
                ++i;
            }
            int length = enumValues.size();
            if (length > 0) {
                InvokeNew enumValue = (InvokeNew)enumValues.get(0);
                visitor.start(preferences, layoutBlockList, classFile, classFile.getStaticMethod(), enumValue);
                visitor.visit(enumValue);
                visitor.end();
                ClassFile innerClassFile = classFile.getInnerClassFile(String.valueOf(classFile.getThisClassName()) + "$1");
                if (innerClassFile != null) {
                    ClassFileLayouter.createBlocksForBodyOfAnonymousClass(preferences, innerClassFile, layoutBlockList);
                }
                int i2 = 1;
                while (i2 < length) {
                    layoutBlockList.add(new FragmentLayoutBlock(85));
                    layoutBlockList.add(new SeparatorLayoutBlock(2, 0));
                    enumValue = (InvokeNew)enumValues.get(i2);
                    visitor.start(preferences, layoutBlockList, classFile, classFile.getStaticMethod(), enumValue);
                    visitor.visit(enumValue);
                    visitor.end();
                    innerClassFile = classFile.getInnerClassFile(String.valueOf(classFile.getThisClassName()) + "$" + (i2 + 1));
                    if (innerClassFile != null) {
                        ClassFileLayouter.createBlocksForBodyOfAnonymousClass(preferences, innerClassFile, layoutBlockList);
                    }
                    ++i2;
                }
                layoutBlockList.add(new FragmentLayoutBlock(82));
            }
        }
    }

    private static List<SubListLayoutBlock> createSortedBlocksForFields(Preferences preferences, ClassFile classFile) {
        Field[] fields = classFile.getFields();
        int length = fields.length;
        ArrayList<SubListLayoutBlock> sortedFieldBlockList = new ArrayList<SubListLayoutBlock>(length);
        InstructionSplitterVisitor visitor = new InstructionSplitterVisitor();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getAccessFlags() & 0x5000) == 0) {
                ArrayList<LayoutBlock> subLayoutBlockList = new ArrayList<LayoutBlock>(6);
                MarkerLayoutBlock fmslb = new MarkerLayoutBlock(9, classFile);
                subLayoutBlockList.add(fmslb);
                if (field.containsAttributeDeprecated() && !field.containsAnnotationDeprecated(classFile)) {
                    subLayoutBlockList.add(new CommentDeprecatedLayoutBlock());
                }
                AnnotationLayouter.createBlocksForAnnotations(classFile, field.getAttributes(), subLayoutBlockList);
                subLayoutBlockList.add(new FieldNameLayoutBlock(classFile, field));
                int firstLineNumber = 0;
                int lastLineNumber = 0;
                int preferedLineNumber = Integer.MAX_VALUE;
                if (field.getValueAndMethod() != null) {
                    Field.ValueAndMethod valueAndMethod = field.getValueAndMethod();
                    Instruction value = valueAndMethod.value();
                    Method method = valueAndMethod.method();
                    firstLineNumber = value.getLineNumber();
                    lastLineNumber = MaxLineNumberVisitor.visit(value);
                    preferedLineNumber = lastLineNumber - firstLineNumber;
                    visitor.start(preferences, subLayoutBlockList, classFile, method, value);
                    visitor.visit(value);
                    visitor.end();
                    subLayoutBlockList.add(new FragmentLayoutBlock(82));
                }
                MarkerLayoutBlock fmelb = new MarkerLayoutBlock(10, classFile);
                fmslb.setOther(fmelb);
                fmelb.setOther(fmslb);
                subLayoutBlockList.add(fmelb);
                sortedFieldBlockList.add(new SubListLayoutBlock(58, subLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineNumber));
            }
            ++n2;
        }
        return ClassFileLayouter.sortBlocks(sortedFieldBlockList, true);
    }

    /*
     * Unable to fully structure code
     */
    private static List<SubListLayoutBlock> createSortedBlocksForMethods(Preferences preferences, ClassFile classFile) {
        methods = classFile.getMethods();
        constants = classFile.getConstantPool();
        multipleConstructorFlag = ClassFileUtil.containsMultipleConstructor(classFile);
        length = methods.length;
        sortedMethodBlockList = new ArrayList<SubListLayoutBlock>(length);
        showDefaultConstructor = preferences.getShowDefaultConstructor();
        javaSourceLayouter = new JavaSourceLayouter();
        var23_9 = methods;
        var22_10 = methods.length;
        var21_11 = 0;
        while (var21_11 < var22_10) {
            method = var23_9[var21_11];
            if ((method.getAccessFlags() & 4160) == 0) {
                as = method.getAttributeSignature();
                signatureIndex = method.getSignatureIndex();
                signature = constants.getConstantUtf8(signatureIndex);
                if (!((classFile.getAccessFlags() & 16384) != 0 && ClassFileUtil.isAMethodOfEnum(classFile, method, signature) || method.getNameIndex() == constants.getInstanceConstructorIndex() && (classFile.getInternalAnonymousClassName() != null || !(multipleConstructorFlag != false || method.getFastNodes() != null && method.getFastNodes().isEmpty() == false || (exceptionIndexes = method.getExceptionIndexes()) != null && exceptionIndexes.length != 0) && ((classFile.getAccessFlags() & 16384) == 0 ? showDefaultConstructor == false && ("()V".equals(signature) != false || (outerClass = classFile.getOuterClass()) != null && ("(" + (outerClassName = outerClass.getInternalClassName()) + ")V").equals(signature) != false) : "()V".equals(signature) != false || "(Ljava/lang/String;I)V".equals(signature) != false)))) {
                    if (method.getNameIndex() != constants.getClassConstructorIndex() || method.getFastNodes() != null && !method.getFastNodes().isEmpty()) {
                        subLayoutBlockList = new ArrayList<LayoutBlock>(30);
                        mmslb = new MarkerLayoutBlock(11, classFile);
                        subLayoutBlockList.add(mmslb);
                        if (method.containsError()) {
                            subLayoutBlockList.add(new CommentErrorLayoutBlock());
                        }
                        if (method.containsAttributeDeprecated() && !method.containsAnnotationDeprecated(classFile)) {
                            subLayoutBlockList.add(new CommentDeprecatedLayoutBlock());
                        }
                        AnnotationLayouter.createBlocksForAnnotations(classFile, method.getAttributes(), subLayoutBlockList, method.isOverride(classFile));
                        nullCodeFlag = method.getCode() == null;
                        displayThrowsFlag = false;
                        if (method.getNameIndex() == constants.getClassConstructorIndex()) {
                            subLayoutBlockList.add(new MethodStaticLayoutBlock(classFile));
                        } else if (method.getExceptionIndexes() == null) {
                            subLayoutBlockList.add(new MethodNameLayoutBlock(classFile, method, signature, as == null, nullCodeFlag));
                        } else {
                            subLayoutBlockList.add(new MethodNameLayoutBlock(classFile, method, signature, as == null, false));
                            subLayoutBlockList.add(new ThrowsLayoutBlock(classFile, method, nullCodeFlag));
                            displayThrowsFlag = true;
                        }
                        firstLineNumber = 0;
                        lastLineNumber = 0;
                        preferedLineNumber = 0x7FFFFFFF;
                        if (!nullCodeFlag) {
                            if (method.containsError()) {
                                mbbslb = new MethodBodyBlockStartLayoutBlock();
                                subLayoutBlockList.add(mbbslb);
                                subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                                mbbelb = new MethodBodyBlockEndLayoutBlock();
                                subLayoutBlockList.add(mbbelb);
                                mbbslb.setOther(mbbelb);
                                mbbelb.setOther(mbbslb);
                            } else {
                                block24: {
                                    list = method.getFastNodes();
                                    mbbslb = new MethodBodyBlockStartLayoutBlock();
                                    subLayoutBlockList.add(mbbslb);
                                    subLayoutBlockListLength = subLayoutBlockList.size();
                                    singleLine = false;
                                    if (!list.isEmpty()) {
                                        try {
                                            beforeIndex = subLayoutBlockList.size();
                                            singleLine = javaSourceLayouter.createBlocks(preferences, subLayoutBlockList, classFile, method, list);
                                            afterIndex = subLayoutBlockList.size();
                                            firstLineNumber = ClassFileLayouter.searchFirstLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                                            lastLineNumber = ClassFileLayouter.searchLastLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                                            break block24;
                                        }
                                        catch (Exception e) {
                                            if (!ClassFileLayouter.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                                                throw new AssertionError();
                                            }
                                            currentLength = subLayoutBlockList.size();
                                            ** while (currentLength > subLayoutBlockListLength)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            subLayoutBlockList.remove(--currentLength);
                                            continue;
                                        }
lbl83:
                                        // 1 sources

                                        subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                                    }
                                }
                                if (subLayoutBlockListLength == subLayoutBlockList.size()) {
                                    if (displayThrowsFlag) {
                                        mbbslb.transformToStartEndBlock(1);
                                    } else {
                                        mbbslb.transformToStartEndBlock(0);
                                    }
                                } else if (singleLine) {
                                    mbbslb.transformToSingleLineBlock();
                                    mbssbelb = new MethodBodySingleLineBlockEndLayoutBlock();
                                    mbbslb.setOther(mbssbelb);
                                    mbssbelb.setOther(mbbslb);
                                    subLayoutBlockList.add(mbssbelb);
                                } else {
                                    mbbelb = new MethodBodyBlockEndLayoutBlock();
                                    mbbslb.setOther(mbbelb);
                                    mbbelb.setOther(mbbslb);
                                    subLayoutBlockList.add(mbbelb);
                                }
                            }
                        }
                        mmelb = new MarkerLayoutBlock(12, classFile);
                        mmslb.setOther(mmelb);
                        mmelb.setOther(mmslb);
                        subLayoutBlockList.add(mmelb);
                        sortedMethodBlockList.add(new SubListLayoutBlock(59, subLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineNumber));
                    }
                }
            }
            ++var21_11;
        }
        return ClassFileLayouter.sortBlocks(sortedMethodBlockList, false);
    }

    private static List<SubListLayoutBlock> createSortedBlocksForInnerClasses(Preferences preferences, ClassFile classFile) {
        List<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles == null) {
            return Collections.emptyList();
        }
        int length = innerClassFiles.size();
        ArrayList<SubListLayoutBlock> sortedInnerClassBlockList = new ArrayList<SubListLayoutBlock>(length);
        for (ClassFile innerClassFile : innerClassFiles) {
            if ((innerClassFile.getAccessFlags() & 0x1000) != 0 || innerClassFile.getInternalAnonymousClassName() != null) continue;
            ArrayList<LayoutBlock> innerClassLayoutBlockList = new ArrayList<LayoutBlock>(100);
            ClassFileLayouter.createBlocksForClass(preferences, innerClassFile, innerClassLayoutBlockList);
            int afterIndex = innerClassLayoutBlockList.size();
            int firstLineNumber = ClassFileLayouter.searchFirstLineNumber(innerClassLayoutBlockList, 0, afterIndex);
            int lastLineNumber = ClassFileLayouter.searchLastLineNumber(innerClassLayoutBlockList, 0, afterIndex);
            int preferedLineCount = Integer.MAX_VALUE;
            if (firstLineNumber != 0 && lastLineNumber != 0) {
                preferedLineCount = lastLineNumber - firstLineNumber;
            }
            sortedInnerClassBlockList.add(new SubListLayoutBlock(60, innerClassLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineCount));
        }
        return ClassFileLayouter.sortBlocks(sortedInnerClassBlockList, false);
    }

    private static int searchFirstLineNumber(List<LayoutBlock> layoutBlockList, int firstIndex, int afterIndex) {
        int index = firstIndex;
        while (index < afterIndex) {
            int firstLineNumber = layoutBlockList.get(index).getFirstLineNumber();
            if (firstLineNumber != 0) {
                return firstLineNumber;
            }
            ++index;
        }
        return 0;
    }

    private static int searchLastLineNumber(List<LayoutBlock> layoutBlockList, int firstIndex, int afterIndex) {
        while (afterIndex-- > firstIndex) {
            int lastLineNumber = layoutBlockList.get(afterIndex).getLastLineNumber();
            if (lastLineNumber == 0) continue;
            return lastLineNumber;
        }
        return 0;
    }

    private static List<SubListLayoutBlock> sortBlocks(List<SubListLayoutBlock> blockList, boolean fields) {
        int lineNumber = 0;
        int order = 0;
        for (SubListLayoutBlock layoutBlock : blockList) {
            int newLineNumber = layoutBlock.getLastLineNumber();
            if (newLineNumber == 0) continue;
            if (lineNumber != 0) {
                if (order == 0) {
                    order = lineNumber < newLineNumber ? 1 : 2;
                } else if (order == 1) {
                    if (lineNumber > newLineNumber) {
                        order = 3;
                        break;
                    }
                } else if (order == 2 && lineNumber < newLineNumber) {
                    order = 3;
                    break;
                }
            }
            lineNumber = newLineNumber;
        }
        if (order == 2) {
            Collections.reverse(blockList);
        } else if (order == 3 || fields) {
            int i = 0;
            while (i < blockList.size()) {
                blockList.get(i).setIndex(i);
                ++i;
            }
            Collections.sort(blockList, new LayoutBlockComparator(fields));
        }
        return blockList;
    }

    private static int mergeBlocks(List<LayoutBlock> layoutBlockList, List<SubListLayoutBlock> sortedFieldBlockList, List<SubListLayoutBlock> sortedMethodBlockList, List<SubListLayoutBlock> sortedInnerClassBlockList) {
        int maxLineNumber = 0;
        Collections.reverse(sortedFieldBlockList);
        Collections.reverse(sortedMethodBlockList);
        Collections.reverse(sortedInnerClassBlockList);
        int minLineNumberMethod = ClassFileLayouter.searchMinimalLineNumber(sortedMethodBlockList);
        int minLineNumberInnerClass = ClassFileLayouter.searchMinimalLineNumber(sortedInnerClassBlockList);
        while (!sortedFieldBlockList.isEmpty()) {
            if (minLineNumberMethod == 0) {
                if (minLineNumberInnerClass == 0) {
                    maxLineNumber = ClassFileLayouter.mergeFieldBlockList(layoutBlockList, sortedFieldBlockList, maxLineNumber);
                    break;
                }
                maxLineNumber = ClassFileLayouter.exclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberInnerClass, maxLineNumber);
                maxLineNumber = ClassFileLayouter.mergeBlockList(layoutBlockList, sortedMethodBlockList, maxLineNumber);
                maxLineNumber = ClassFileLayouter.inclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
                minLineNumberInnerClass = ClassFileLayouter.searchMinimalLineNumber(sortedInnerClassBlockList);
                continue;
            }
            if (minLineNumberInnerClass == 0 || minLineNumberMethod < minLineNumberInnerClass) {
                maxLineNumber = ClassFileLayouter.exclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberMethod, maxLineNumber);
                maxLineNumber = ClassFileLayouter.inclusiveMergeBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberMethod, maxLineNumber);
                minLineNumberMethod = ClassFileLayouter.searchMinimalLineNumber(sortedMethodBlockList);
                continue;
            }
            maxLineNumber = ClassFileLayouter.exclusiveMergeFieldBlockList(layoutBlockList, sortedFieldBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.exclusiveMergeMethodOrInnerClassBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.inclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
            minLineNumberInnerClass = ClassFileLayouter.searchMinimalLineNumber(sortedInnerClassBlockList);
        }
        while (!sortedMethodBlockList.isEmpty()) {
            if (minLineNumberInnerClass == 0) {
                maxLineNumber = ClassFileLayouter.mergeBlockList(layoutBlockList, sortedMethodBlockList, maxLineNumber);
                break;
            }
            maxLineNumber = ClassFileLayouter.exclusiveMergeMethodOrInnerClassBlockList(layoutBlockList, sortedMethodBlockList, minLineNumberInnerClass, maxLineNumber);
            maxLineNumber = ClassFileLayouter.inclusiveMergeBlockList(layoutBlockList, sortedInnerClassBlockList, minLineNumberInnerClass, maxLineNumber);
            minLineNumberInnerClass = ClassFileLayouter.searchMinimalLineNumber(sortedInnerClassBlockList);
        }
        return ClassFileLayouter.mergeBlockList(layoutBlockList, sortedInnerClassBlockList, maxLineNumber);
    }

    private static int exclusiveMergeMethodOrInnerClassBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        byte lastTag = destination.get(destination.size() - 1).getTag();
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.getLastLineNumber();
            if (lineNumber != 0 && lineNumber >= minLineNumber) break;
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            destination.addAll(sllb.getSubList());
            int lastLineNumber = sllb.getLastLineNumber();
            if (lastLineNumber != 0 && (maxLineNumber == 0 || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            source.remove(--index);
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int exclusiveMergeFieldBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        int lastTag = destination.get(destination.size() - 1).getTag();
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.getLastLineNumber();
            if (lineNumber != 0 && lineNumber >= minLineNumber) break;
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            source.remove(--index);
            destination.addAll(sllb.getSubList());
            int lastLineNumber = sllb.getLastLineNumber();
            if (lastLineNumber != 0 && (maxLineNumber == 0 || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 10;
        }
        return maxLineNumber;
    }

    private static int inclusiveMergeBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int minLineNumber, int maxLineNumber) {
        byte lastTag = destination.get(destination.size() - 1).getTag();
        int index = source.size();
        while (index > 0) {
            SubListLayoutBlock sllb = source.get(index - 1);
            int lineNumber = sllb.getLastLineNumber();
            if (lineNumber != 0 && lineNumber > minLineNumber) break;
            if (lastTag != 13 && lastTag != 16 && lastTag != 19 && lastTag != 22 && lastTag != 25 && lastTag != 31 && lastTag != 2) {
                destination.add(new SeparatorLayoutBlock(2, 2));
            }
            destination.addAll(sllb.getSubList());
            int lastLineNumber = sllb.getLastLineNumber();
            if (lastLineNumber != 0 && (maxLineNumber == 0 || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            source.remove(--index);
            if (lineNumber == minLineNumber) break;
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int mergeBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int maxLineNumber) {
        byte lastTag = destination.get(destination.size() - 1).getTag();
        int index = source.size();
        while (index-- > 0) {
            if (lastTag != 13 && lastTag != 16 && lastTag != 19 && lastTag != 22 && lastTag != 25 && lastTag != 31 && lastTag != 2) {
                destination.add(new SeparatorLayoutBlock(2, 2));
            }
            SubListLayoutBlock sllb = source.remove(index);
            destination.addAll(sllb.getSubList());
            int lastLineNumber = sllb.getLastLineNumber();
            if (lastLineNumber != 0 && (maxLineNumber == 0 || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 0;
        }
        return maxLineNumber;
    }

    private static int mergeFieldBlockList(List<LayoutBlock> destination, List<SubListLayoutBlock> source, int maxLineNumber) {
        int lastTag = destination.get(destination.size() - 1).getTag();
        int index = source.size();
        while (index-- > 0) {
            switch (lastTag) {
                case 10: {
                    destination.add(new SeparatorLayoutBlock(2, 1));
                    break;
                }
                case 2: 
                case 13: 
                case 16: 
                case 19: 
                case 22: 
                case 25: 
                case 31: {
                    break;
                }
                default: {
                    destination.add(new SeparatorLayoutBlock(2, 2));
                }
            }
            SubListLayoutBlock sllb = source.remove(index);
            destination.addAll(sllb.getSubList());
            int lastLineNumber = sllb.getLastLineNumber();
            if (lastLineNumber != 0 && (maxLineNumber == 0 || maxLineNumber < lastLineNumber)) {
                maxLineNumber = lastLineNumber;
            }
            lastTag = 10;
        }
        return maxLineNumber;
    }

    private static int searchMinimalLineNumber(List<? extends LayoutBlock> list) {
        int index = list.size();
        while (index-- > 0) {
            int lineNumber = list.get(index).getLastLineNumber();
            if (lineNumber == 0) continue;
            return lineNumber;
        }
        return 0;
    }

    private static void layoutBlocks(List<LayoutBlock> layoutBlockList) {
        ArrayList<LayoutSection> layoutSectionList = new ArrayList<LayoutSection>();
        ClassFileLayouter.createSections(layoutBlockList, layoutSectionList);
        ClassFileLayouter.initializeBlocks(layoutBlockList, layoutSectionList);
        int layoutCount = 20;
        do {
            ClassFileLayouter.layoutSections(layoutBlockList, layoutSectionList);
            ClassFileLayouter.scoreSections(layoutBlockList, layoutSectionList);
            if (!ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList)) break;
            ClassFileLayouter.resetLineCounts(layoutBlockList, layoutSectionList);
        } while (layoutCount-- > 0);
        layoutCount = 20;
        do {
            ClassFileLayouter.layoutSections(layoutBlockList, layoutSectionList);
            ClassFileLayouter.scoreSections(layoutBlockList, layoutSectionList);
            if (!ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList)) break;
            ClassFileLayouter.resetLineCounts(layoutBlockList, layoutSectionList);
        } while (layoutCount-- > 0);
    }

    private static void createSections(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int blockLength = layoutBlockList.size();
        int layoutSectionListSize = 0;
        int firstBlockIndex = 0;
        int firstLineNumber = 1;
        boolean containsError = false;
        int blockIndex = 1;
        while (blockIndex < blockLength) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            if (lb.getTag() == 56) {
                containsError = true;
            }
            if (lb.getFirstLineNumber() != 0) {
                if (firstLineNumber > lb.getFirstLineNumber()) {
                    containsError = true;
                }
                layoutSectionList.add(new LayoutSection(layoutSectionListSize, firstBlockIndex, blockIndex - 1, firstLineNumber, lb.getFirstLineNumber(), containsError));
                ++layoutSectionListSize;
                firstBlockIndex = blockIndex + 1;
                firstLineNumber = lb.getLastLineNumber();
                containsError = false;
            }
            ++blockIndex;
        }
        if (firstBlockIndex < blockLength - 1) {
            layoutSectionList.add(new LayoutSection(layoutSectionListSize, firstBlockIndex, blockLength - 1, firstLineNumber, 0, containsError));
        }
    }

    private static void initializeBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int blockIndex = 0;
        int sectionLength = layoutSectionList.size();
        int sectionIndex = 0;
        while (sectionIndex < sectionLength) {
            LayoutSection section = layoutSectionList.get(sectionIndex);
            int lastBlockIndex = section.getLastBlockIndex();
            blockIndex = section.getFirstBlockIndex();
            while (blockIndex <= lastBlockIndex) {
                LayoutBlock lb = layoutBlockList.get(blockIndex);
                lb.setIndex(blockIndex);
                lb.setSection(section);
                ++blockIndex;
            }
            ++sectionIndex;
        }
    }

    private static void resetLineCounts(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        int sectionIndex = 0;
        while (sectionIndex < sectionLength) {
            LayoutSection section = layoutSectionList.get(sectionIndex);
            if (section.isRelayout()) {
                int lastBlockIndex = section.getLastBlockIndex();
                int blockIndex = section.getFirstBlockIndex();
                while (blockIndex <= lastBlockIndex) {
                    LayoutBlock lb = layoutBlockList.get(blockIndex);
                    lb.setLineCount(lb.getPreferedLineCount());
                    ++blockIndex;
                }
            }
            ++sectionIndex;
        }
    }

    private static void layoutSections(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        if (sectionLength > 0) {
            int currentLineCount;
            int originalLineCount;
            LayoutSection section;
            int sectionIndex;
            boolean redo;
            --sectionLength;
            int layoutCount = 5;
            do {
                redo = false;
                sectionIndex = 0;
                while (sectionIndex < sectionLength) {
                    section = layoutSectionList.get(sectionIndex);
                    if (section.isRelayout() && !section.containsError()) {
                        section.setRelayout(false);
                        originalLineCount = section.getOriginalLineCount();
                        currentLineCount = ClassFileLayouter.getLineCount(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex());
                        if (originalLineCount > currentLineCount) {
                            ClassFileLayouter.expandBlocksWithHeuristics(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex(), originalLineCount - currentLineCount);
                            redo = true;
                        } else if (currentLineCount > originalLineCount) {
                            ClassFileLayouter.compactBlocksWithHeuristics(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex(), currentLineCount - originalLineCount);
                            redo = true;
                        }
                    }
                    ++sectionIndex;
                }
                layoutSectionList.get(sectionLength).setRelayout(false);
            } while (redo && layoutCount-- > 0);
            if (redo) {
                sectionIndex = 0;
                while (sectionIndex < sectionLength) {
                    section = layoutSectionList.get(sectionIndex);
                    if (section.isRelayout() && !section.containsError()) {
                        section.setRelayout(false);
                        originalLineCount = section.getOriginalLineCount();
                        currentLineCount = ClassFileLayouter.getLineCount(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex());
                        if (originalLineCount > currentLineCount) {
                            ClassFileLayouter.expandBlocks(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex(), originalLineCount - currentLineCount);
                        } else if (currentLineCount > originalLineCount) {
                            ClassFileLayouter.compactBlocks(layoutBlockList, section.getFirstBlockIndex(), section.getLastBlockIndex(), currentLineCount - originalLineCount);
                        }
                    }
                    ++sectionIndex;
                }
                layoutSectionList.get(sectionLength).setRelayout(false);
            }
        }
    }

    private static int getLineCount(List<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex) {
        int sum = 0;
        int index = firstIndex;
        while (index <= lastIndex) {
            int lineCount = layoutBlockList.get(index).getLineCount();
            if (lineCount != Integer.MAX_VALUE) {
                sum += lineCount;
            }
            ++index;
        }
        return sum;
    }

    private static void compactBlocksWithHeuristics(List<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        BlockLayoutBlock blb;
        int i;
        int i2;
        int oldDelta;
        do {
            oldDelta = delta;
            i2 = lastIndex;
            while (i2 >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i2);
                if ((lb.getTag() == 2 || lb.getTag() == 5) && lb.getLineCount() > 2) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i2;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            int i3 = lastIndex;
            while (i3 >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i3);
                if ((lb.getTag() == 45 || lb.getTag() == 49 || lb.getTag() == 53) && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i3;
            }
            i2 = lastIndex;
            while (i2 >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i2);
                if ((lb.getTag() == 43 || lb.getTag() == 44 || lb.getTag() == 47 || lb.getTag() == 48) && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i2;
            }
        } while (delta > 0 && oldDelta > delta);
        int i4 = lastIndex;
        while (i4 >= firstIndex && delta > 0) {
            LayoutBlock lb = layoutBlockList.get(i4);
            if (lb.getTag() == 6 && lb.getLineCount() > 0) {
                if (lb.getLineCount() >= delta) {
                    lb.setLineCount(lb.getLineCount() - delta);
                    delta = 0;
                } else {
                    delta -= lb.getLineCount();
                    lb.setLineCount(0);
                }
            }
            --i4;
        }
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 25 || lb.getTag() == 28 || lb.getTag() == 31 || lb.getTag() == 19 || lb.getTag() == 22 || lb.getTag() == 16 || lb.getTag() == 13) && lb.getLineCount() > 1 && lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 5 && lb.getLineCount() > 1) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 26 || lb.getTag() == 29 || lb.getTag() == 32 || lb.getTag() == 20 || lb.getTag() == 23 || lb.getTag() == 17 || lb.getTag() == 14) && lb.getLineCount() > 1 && lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 65 || lb.getTag() == 66 || lb.getTag() == 67) && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 29 && lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 33 || lb.getTag() == 34) && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 22 || lb.getTag() == 23) && lb.getLineCount() > lb.getMinimalLineCount()) {
                    blb = (BlockLayoutBlock)lb;
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                    if (lb.getLineCount() <= 1) {
                        if (blb.getSection() == blb.getOther().getSection()) {
                            if (blb.getOther().getLineCount() > delta) {
                                blb.getOther().setLineCount(blb.getOther().getLineCount() - delta);
                                delta = 0;
                            } else {
                                delta -= blb.getOther().getLineCount();
                                blb.getOther().setLineCount(0);
                            }
                        } else {
                            blb.getOther().getSection().setRelayout(true);
                            blb.getOther().setLineCount(0);
                        }
                    }
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 25 || lb.getTag() == 31 || lb.getTag() == 19 || lb.getTag() == 16 || lb.getTag() == 13) {
                    if (lb.getLineCount() > lb.getMinimalLineCount()) {
                        lb.setLineCount(lb.getLineCount() - 1);
                        --delta;
                    }
                } else if (lb.getTag() == 28 && lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                    if (lb.getLineCount() == 0) {
                        blb = (BlockLayoutBlock)lb;
                        if (blb.getSection() == blb.getOther().getSection()) {
                            if (blb.getOther().getLineCount() > delta) {
                                blb.getOther().setLineCount(blb.getOther().getLineCount() - delta);
                                delta = 0;
                            } else {
                                delta -= blb.getOther().getLineCount();
                                blb.getOther().setLineCount(0);
                            }
                        } else {
                            blb.getOther().getSection().setRelayout(true);
                            blb.getOther().setLineCount(0);
                        }
                    }
                }
                --i;
            }
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 26 || lb.getTag() == 32 || lb.getTag() == 20 || lb.getTag() == 17 || lb.getTag() == 14) && lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 2 || lb.getTag() == 5) && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 40 && lb.getLineCount() > 0) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void expandBlocksWithHeuristics(List<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        BlockLayoutBlock blb;
        int i;
        int oldDelta;
        do {
            LayoutBlock lb;
            oldDelta = delta;
            int i2 = firstIndex;
            while (i2 <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i2);
                if ((lb.getTag() == 45 || lb.getTag() == 44 || lb.getTag() == 49 || lb.getTag() == 48) && lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i2;
            }
            i2 = firstIndex;
            while (i2 <= lastIndex && delta > 0) {
                lb = layoutBlockList.get(i2);
                if ((lb.getTag() == 43 || lb.getTag() == 47) && lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i2;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb2 = layoutBlockList.get(i);
                if (lb2.getTag() == 3 || lb2.getTag() == 4) {
                    lb2.setLineCount(lb2.getLineCount() + delta);
                    delta = 0;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 37 && lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 34 && lb.getLineCount() == 0) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            int i3 = firstIndex;
            while (i3 <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i3);
                if ((lb.getTag() == 17 || lb.getTag() == 14 || lb.getTag() == 20 || lb.getTag() == 26 || lb.getTag() == 29 || lb.getTag() == 32) && lb.getLineCount() == 0) {
                    blb = (BlockLayoutBlock)lb;
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                    if (blb.getOther().getLineCount() == 0) {
                        if (blb.getSection() == blb.getOther().getSection()) {
                            if (delta > 0) {
                                blb.getOther().setLineCount(blb.getOther().getLineCount() + 1);
                                --delta;
                            }
                        } else {
                            blb.getOther().getSection().setRelayout(true);
                            blb.getOther().setLineCount(1);
                        }
                    }
                }
                ++i3;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 16 || lb.getTag() == 13 || lb.getTag() == 19 || lb.getTag() == 25 || lb.getTag() == 31) && lb.getLineCount() == 0) {
                    blb = (BlockLayoutBlock)lb;
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                    if (blb.getSection() == blb.getOther().getSection()) {
                        int d = 2 - blb.getOther().getLineCount();
                        if (d > delta) {
                            blb.getOther().setLineCount(blb.getOther().getLineCount() + delta);
                            delta = 0;
                        } else {
                            delta -= d;
                            blb.getOther().setLineCount(2);
                        }
                    } else {
                        blb.getOther().getSection().setRelayout(true);
                        blb.getOther().setLineCount(2);
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 2 || lb.getTag() == 5) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getTag() == 34 && lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
        do {
            oldDelta = delta;
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 17 || lb.getTag() == 14 || lb.getTag() == 23 || lb.getTag() == 20 || lb.getTag() == 26 || lb.getTag() == 29 || lb.getTag() == 32) && lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i;
            }
            i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if ((lb.getTag() == 16 || lb.getTag() == 13 || lb.getTag() == 22 || lb.getTag() == 19 || lb.getTag() == 25 || lb.getTag() == 28 || lb.getTag() == 31) && lb.getLineCount() < lb.getMaximalLineCount()) {
                    blb = (BlockLayoutBlock)lb;
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                    if (lb.getLineCount() > 1 && blb.getOther().getLineCount() == 0) {
                        if (blb.getSection() == blb.getOther().getSection()) {
                            if (delta > 0) {
                                blb.getOther().setLineCount(1);
                                --delta;
                            }
                        } else {
                            blb.getOther().getSection().setRelayout(true);
                            blb.getOther().setLineCount(1);
                        }
                    }
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void compactBlocks(List<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        int oldDelta;
        do {
            oldDelta = delta;
            int i = lastIndex;
            while (i >= firstIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getLineCount() > lb.getMinimalLineCount()) {
                    lb.setLineCount(lb.getLineCount() - 1);
                    --delta;
                }
                --i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void expandBlocks(List<LayoutBlock> layoutBlockList, int firstIndex, int lastIndex, int delta) {
        int oldDelta;
        do {
            oldDelta = delta;
            int i = firstIndex;
            while (i <= lastIndex && delta > 0) {
                LayoutBlock lb = layoutBlockList.get(i);
                if (lb.getLineCount() < lb.getMaximalLineCount()) {
                    lb.setLineCount(lb.getLineCount() + 1);
                    --delta;
                }
                ++i;
            }
        } while (delta > 0 && oldDelta > delta);
    }

    private static void scoreSections(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        if (sectionLength > 0) {
            --sectionLength;
            int sectionIndex = 0;
            while (sectionIndex < sectionLength) {
                LayoutSection section = layoutSectionList.get(sectionIndex);
                int lastBlockIndex = section.getLastBlockIndex();
                int score = 0;
                int sumScore = 0;
                int blockIndex = section.getFirstBlockIndex();
                while (blockIndex <= lastBlockIndex) {
                    LayoutBlock lb = layoutBlockList.get(blockIndex);
                    if (lb.getTag() == 2) {
                        if (lb.getLineCount() < lb.getPreferedLineCount()) {
                            sumScore += lb.getPreferedLineCount() - lb.getLineCount();
                            if (lb.getLineCount() > 0) {
                                score += sumScore * sumScore;
                                sumScore = 0;
                            }
                        } else if (lb.getLineCount() > lb.getPreferedLineCount()) {
                            int delta = lb.getLineCount() - lb.getPreferedLineCount();
                            score -= delta * delta;
                        }
                    }
                    ++blockIndex;
                }
                section.setScore(score += sumScore * sumScore);
                ++sectionIndex;
            }
        }
    }

    private static boolean sliceDownBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        ArrayList<LayoutSection> sortedLayoutSectionList = new ArrayList<LayoutSection>(sectionLength);
        sortedLayoutSectionList.addAll(layoutSectionList);
        Collections.sort(sortedLayoutSectionList);
        int sectionSourceIndex = 0;
        while (sectionSourceIndex < sectionLength) {
            LayoutSection lsSource = (LayoutSection)sortedLayoutSectionList.get(sectionSourceIndex);
            if (lsSource.getScore() <= 0) break;
            if (ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, lsSource)) {
                return true;
            }
            ++sectionSourceIndex;
        }
        return false;
    }

    private static boolean sliceUpBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList) {
        int sectionLength = layoutSectionList.size();
        ArrayList<LayoutSection> sortedLayoutSectionList = new ArrayList<LayoutSection>(sectionLength);
        sortedLayoutSectionList.addAll(layoutSectionList);
        Collections.sort(sortedLayoutSectionList);
        int sectionSourceIndex = 0;
        while (sectionSourceIndex < sectionLength) {
            LayoutSection lsSource = (LayoutSection)sortedLayoutSectionList.get(sectionSourceIndex);
            if (lsSource.getScore() <= 0) break;
            if (ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, lsSource)) {
                return true;
            }
            ++sectionSourceIndex;
        }
        return false;
    }

    private static boolean sliceDownBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList, LayoutSection lsSource) {
        int firstBlockIndex = lsSource.getFirstBlockIndex();
        int blockIndex = lsSource.getLastBlockIndex();
        while (blockIndex >= firstBlockIndex) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            switch (lb.getTag()) {
                case 7: {
                    if (!ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 11, 12) && !ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 9, 10)) break;
                    return true;
                }
                case 9: {
                    if (!ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 7, 8) && !ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 11, 12)) break;
                    return true;
                }
                case 11: {
                    if (!ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 7, 8) && !ClassFileLayouter.sliceDownBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 9, 10)) break;
                    return true;
                }
            }
            --blockIndex;
        }
        return false;
    }

    private static boolean sliceDownBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList, int blockIndex, LayoutSection lsSource, int markerStartTag, int markerEndTag) {
        int firstBlockIndex = lsSource.getFirstBlockIndex();
        while (firstBlockIndex < blockIndex) {
            LayoutBlock lb;
            if ((lb = layoutBlockList.get(--blockIndex)).getTag() == markerEndTag) {
                LayoutSection ls;
                int preferedLineCount;
                MarkerLayoutBlock mlb = (MarkerLayoutBlock)lb;
                if (mlb.getSection() != mlb.getOther().getSection() || mlb.getOther().getIndex() <= firstBlockIndex) {
                    return false;
                }
                int lastEndTagBlockIndex = blockIndex;
                int counter = 1;
                blockIndex = mlb.getOther().getIndex();
                while (firstBlockIndex < blockIndex) {
                    if ((lb = layoutBlockList.get(--blockIndex)).getTag() == 13) break;
                    if (lb.getTag() == markerEndTag) {
                        mlb = (MarkerLayoutBlock)lb;
                        if (mlb.getSection() != mlb.getOther().getSection() || mlb.getOther().getIndex() <= firstBlockIndex) break;
                        ++counter;
                        blockIndex = mlb.getOther().getIndex();
                        continue;
                    }
                    if (lb.getTag() == 10 || lb.getTag() == 12 || lb.getTag() == 8) break;
                }
                int blockLength = layoutBlockList.size();
                blockIndex = lastEndTagBlockIndex;
                int lowerScore = lsSource.getScore();
                int lowerScoreBlockIndex = blockIndex;
                while (++blockIndex < blockLength) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.getTag() == 14 || lb.getTag() == markerStartTag) {
                        if (lowerScore <= lb.getSection().getScore()) break;
                        lowerScore = lb.getSection().getScore();
                        lowerScoreBlockIndex = blockIndex;
                        break;
                    }
                    if (lb.getTag() != 9 && lb.getTag() != 11 && lb.getTag() != 7) continue;
                    if (lb.getSection() != null && lowerScore > lb.getSection().getScore()) {
                        lowerScore = lb.getSection().getScore();
                        lowerScoreBlockIndex = blockIndex;
                    }
                    blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                }
                if (lowerScore == lsSource.getScore()) break;
                counter = (counter + 1) / 2;
                int firstStartTagBlockIndex = blockIndex = lastEndTagBlockIndex;
                while (firstBlockIndex < blockIndex) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.getTag() == 13) break;
                    if (lb.getTag() == markerEndTag) {
                        firstStartTagBlockIndex = blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                        if (--counter == 0) break;
                    }
                    --blockIndex;
                }
                LayoutBlock insertionLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex);
                LayoutSection lsTarget = insertionLayoutBlock.getSection();
                int sourceDeltaIndex = lastEndTagBlockIndex - firstStartTagBlockIndex + 1;
                ArrayList<LayoutBlock> layoutBlockListToMove = new ArrayList<LayoutBlock>(sourceDeltaIndex);
                blockIndex = lastEndTagBlockIndex;
                while (blockIndex >= firstStartTagBlockIndex) {
                    lb = layoutBlockList.remove(blockIndex);
                    lb.setSection(lsTarget);
                    layoutBlockListToMove.add(lb);
                    --blockIndex;
                }
                Collections.reverse(layoutBlockListToMove);
                if (layoutBlockList.get(blockIndex + 1).getTag() == 2) {
                    layoutBlockList.remove(blockIndex + 1);
                    ++sourceDeltaIndex;
                }
                if (layoutBlockList.get(blockIndex).getTag() == 2) {
                    layoutBlockList.get(blockIndex).setPreferedLineCount(2);
                }
                lowerScoreBlockIndex -= sourceDeltaIndex;
                int targetDeltaIndex = 0;
                if (insertionLayoutBlock.getTag() == 14) {
                    int preferedLineCount2 = 2;
                    if (markerEndTag == 10 && layoutBlockList.get(lowerScoreBlockIndex - 1).getTag() == 10) {
                        preferedLineCount2 = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex, new SeparatorLayoutBlock(2, preferedLineCount2));
                    ++targetDeltaIndex;
                } else {
                    LayoutBlock beforeLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex - 1);
                    preferedLineCount = 2;
                    if (markerEndTag == 10 && layoutBlockList.get(lowerScoreBlockIndex - 2).getTag() == 10) {
                        preferedLineCount = 1;
                    }
                    beforeLayoutBlock.setPreferedLineCount(preferedLineCount);
                }
                int layoutBlockListToMoveSize = layoutBlockListToMove.size();
                layoutBlockList.addAll(lowerScoreBlockIndex + targetDeltaIndex, layoutBlockListToMove);
                targetDeltaIndex += layoutBlockListToMoveSize;
                if (insertionLayoutBlock.getTag() != 14) {
                    preferedLineCount = 2;
                    if (markerStartTag == 9) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex + targetDeltaIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                }
                lsSource.setLastBlockIndex(lsSource.getLastBlockIndex() - sourceDeltaIndex);
                int sectionIndex = lsSource.getIndex() + 1;
                while (sectionIndex <= lsTarget.getIndex() - 1) {
                    ls = layoutSectionList.get(sectionIndex);
                    ls.setFirstBlockIndex(ls.getFirstBlockIndex() - sourceDeltaIndex);
                    ls.setLastBlockIndex(ls.getLastBlockIndex() - sourceDeltaIndex);
                    ++sectionIndex;
                }
                lsTarget.setFirstBlockIndex(lsTarget.getFirstBlockIndex() - sourceDeltaIndex);
                int delta = sourceDeltaIndex - targetDeltaIndex;
                if (delta != 0) {
                    lsTarget.setLastBlockIndex(lsTarget.getLastBlockIndex() - delta);
                    int sectionIndex2 = layoutSectionList.size() - 1;
                    while (sectionIndex2 > lsTarget.getIndex()) {
                        ls = layoutSectionList.get(sectionIndex2);
                        ls.setFirstBlockIndex(ls.getFirstBlockIndex() - delta);
                        ls.setLastBlockIndex(ls.getLastBlockIndex() - delta);
                        --sectionIndex2;
                    }
                }
                blockLength = layoutBlockList.size();
                blockIndex = firstStartTagBlockIndex;
                while (blockIndex < blockLength) {
                    layoutBlockList.get(blockIndex).setIndex(blockIndex);
                    ++blockIndex;
                }
                ClassFileLayouter.updateRelayoutFlag(layoutBlockList, lsSource);
                ClassFileLayouter.updateRelayoutFlag(layoutBlockList, lsTarget);
                return true;
            }
            if (lb.getTag() == 10 || lb.getTag() == 12 || lb.getTag() == 8) {
                blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                continue;
            }
            if (lb.getTag() == 13) break;
        }
        return false;
    }

    private static boolean sliceUpBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList, LayoutSection lsSource) {
        int lastBlockIndex = lsSource.getLastBlockIndex();
        int blockIndex = lsSource.getFirstBlockIndex();
        while (blockIndex <= lastBlockIndex) {
            LayoutBlock lb = layoutBlockList.get(blockIndex);
            switch (lb.getTag()) {
                case 8: {
                    return ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 9, 10) || ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 11, 12);
                }
                case 10: {
                    return ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 11, 12) || ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 7, 8);
                }
                case 12: {
                    return ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 9, 10) || ClassFileLayouter.sliceUpBlocks(layoutBlockList, layoutSectionList, blockIndex, lsSource, 7, 8);
                }
            }
            ++blockIndex;
        }
        return false;
    }

    private static boolean sliceUpBlocks(List<LayoutBlock> layoutBlockList, List<LayoutSection> layoutSectionList, int blockIndex, LayoutSection lsSource, int markerStartTag, int markerEndTag) {
        int lastBlockIndex = lsSource.getLastBlockIndex();
        while (blockIndex < lastBlockIndex) {
            LayoutBlock lb;
            if ((lb = layoutBlockList.get(++blockIndex)).getTag() == markerStartTag) {
                MarkerLayoutBlock mlb = (MarkerLayoutBlock)lb;
                if (mlb.getSection() != mlb.getOther().getSection() || mlb.getOther().getIndex() >= lastBlockIndex) {
                    return false;
                }
                int firstStartTagBlockIndex = blockIndex;
                int counter = 1;
                blockIndex = mlb.getOther().getIndex();
                while (blockIndex < lastBlockIndex) {
                    if ((lb = layoutBlockList.get(++blockIndex)).getTag() == 14) break;
                    if (lb.getTag() == markerStartTag) {
                        mlb = (MarkerLayoutBlock)lb;
                        if (mlb.getSection() != mlb.getOther().getSection() || mlb.getOther().getIndex() >= lastBlockIndex) break;
                        ++counter;
                        blockIndex = mlb.getOther().getIndex();
                        continue;
                    }
                    if (lb.getTag() == 9 || lb.getTag() == 11 || lb.getTag() == 7) break;
                }
                blockIndex = firstStartTagBlockIndex;
                int lowerScore = lsSource.getScore();
                int lowerScoreBlockIndex = blockIndex;
                while (blockIndex-- > 0) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.getTag() == 13 || lb.getTag() == markerEndTag) {
                        if (lowerScore <= lb.getSection().getScore()) break;
                        lowerScore = lb.getSection().getScore();
                        lowerScoreBlockIndex = blockIndex;
                        break;
                    }
                    if (lb.getTag() != 10 && lb.getTag() != 12 && lb.getTag() != 8) continue;
                    if (lb.getSection() != null && lowerScore > lb.getSection().getScore()) {
                        lowerScore = lb.getSection().getScore();
                        lowerScoreBlockIndex = blockIndex;
                    }
                    blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                }
                if (lowerScore == lsSource.getScore()) break;
                counter = (counter + 1) / 2;
                int lastEndTagBlockIndex = blockIndex = firstStartTagBlockIndex;
                while (blockIndex > 0) {
                    lb = layoutBlockList.get(blockIndex);
                    if (lb.getTag() == 14) break;
                    if (lb.getTag() == markerStartTag) {
                        lastEndTagBlockIndex = blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                        if (--counter == 0) break;
                    }
                    ++blockIndex;
                }
                LayoutBlock insertionLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex);
                LayoutSection lsTarget = insertionLayoutBlock.getSection();
                int sourceDeltaIndex = lastEndTagBlockIndex - firstStartTagBlockIndex + 1;
                ArrayList<LayoutBlock> layoutBlockListToMove = new ArrayList<LayoutBlock>(sourceDeltaIndex);
                blockIndex = lastEndTagBlockIndex;
                while (blockIndex >= firstStartTagBlockIndex) {
                    lb = layoutBlockList.remove(blockIndex);
                    lb.setSection(lsTarget);
                    layoutBlockListToMove.add(lb);
                    --blockIndex;
                }
                Collections.reverse(layoutBlockListToMove);
                if (layoutBlockList.get(blockIndex + 1).getTag() == 2) {
                    layoutBlockList.remove(blockIndex + 1);
                    ++sourceDeltaIndex;
                }
                if (layoutBlockList.get(blockIndex).getTag() == 2) {
                    layoutBlockList.get(blockIndex).setPreferedLineCount(2);
                }
                ++lowerScoreBlockIndex;
                int targetDeltaIndex = 0;
                if (insertionLayoutBlock.getTag() != 13) {
                    int preferedLineCount = 2;
                    if (markerEndTag == 10) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                }
                int layoutBlockListToMoveSize = layoutBlockListToMove.size();
                layoutBlockList.addAll(lowerScoreBlockIndex + targetDeltaIndex, layoutBlockListToMove);
                targetDeltaIndex += layoutBlockListToMoveSize;
                if (insertionLayoutBlock.getTag() == 13) {
                    int preferedLineCount = 2;
                    if (markerEndTag == 10 && layoutBlockList.get(lowerScoreBlockIndex + targetDeltaIndex).getTag() == 10) {
                        preferedLineCount = 1;
                    }
                    layoutBlockList.add(lowerScoreBlockIndex + targetDeltaIndex, new SeparatorLayoutBlock(2, preferedLineCount));
                    ++targetDeltaIndex;
                } else {
                    LayoutBlock afterLayoutBlock = layoutBlockList.get(lowerScoreBlockIndex + targetDeltaIndex);
                    int preferedLineCount = 2;
                    if (markerStartTag == 9 && layoutBlockList.get(lowerScoreBlockIndex + targetDeltaIndex + 1).getTag() == 9) {
                        preferedLineCount = 1;
                    }
                    afterLayoutBlock.setPreferedLineCount(preferedLineCount);
                }
                lsTarget.setLastBlockIndex(lsTarget.getLastBlockIndex() + targetDeltaIndex);
                int sectionIndex = lsTarget.getIndex() + 1;
                while (sectionIndex <= lsSource.getIndex() - 1) {
                    LayoutSection ls = layoutSectionList.get(sectionIndex);
                    ls.setFirstBlockIndex(ls.getFirstBlockIndex() + targetDeltaIndex);
                    ls.setLastBlockIndex(ls.getLastBlockIndex() + targetDeltaIndex);
                    ++sectionIndex;
                }
                lsSource.setFirstBlockIndex(lsSource.getFirstBlockIndex() + targetDeltaIndex);
                int delta = sourceDeltaIndex - targetDeltaIndex;
                if (delta != 0) {
                    lsSource.setLastBlockIndex(lsSource.getLastBlockIndex() - delta);
                    int sectionIndex2 = layoutSectionList.size() - 1;
                    while (sectionIndex2 > lsSource.getIndex()) {
                        LayoutSection ls = layoutSectionList.get(sectionIndex2);
                        ls.setFirstBlockIndex(ls.getFirstBlockIndex() - delta);
                        ls.setLastBlockIndex(ls.getLastBlockIndex() - delta);
                        --sectionIndex2;
                    }
                }
                int blockLength = layoutBlockList.size();
                blockIndex = lowerScoreBlockIndex;
                while (blockIndex < blockLength) {
                    layoutBlockList.get(blockIndex).setIndex(blockIndex);
                    ++blockIndex;
                }
                ClassFileLayouter.updateRelayoutFlag(layoutBlockList, lsSource);
                ClassFileLayouter.updateRelayoutFlag(layoutBlockList, lsTarget);
                return true;
            }
            if (lb.getTag() == 9 || lb.getTag() == 11 || lb.getTag() == 7) {
                blockIndex = ((MarkerLayoutBlock)lb).getOther().getIndex();
                continue;
            }
            if (lb.getTag() == 14) break;
        }
        return false;
    }

    private static void updateRelayoutFlag(List<LayoutBlock> layoutBlockList, LayoutSection section) {
        section.setRelayout(true);
        int lastBlockIndex = section.getLastBlockIndex();
        int blockIndex = section.getFirstBlockIndex();
        while (blockIndex < lastBlockIndex) {
            BlockLayoutBlock blb;
            LayoutSection otherSection;
            LayoutBlock block = layoutBlockList.get(blockIndex);
            if (!(block.getTag() != 13 && block.getTag() != 14 && block.getTag() != 16 && block.getTag() != 17 && block.getTag() != 19 && block.getTag() != 20 && block.getTag() != 22 && block.getTag() != 23 && block.getTag() != 28 && block.getTag() != 29 && block.getTag() != 25 && block.getTag() != 26 && block.getTag() != 31 && block.getTag() != 32 || (otherSection = (blb = (BlockLayoutBlock)block).getOther().getSection()).isRelayout())) {
                ClassFileLayouter.updateRelayoutFlag(layoutBlockList, otherSection);
            }
            ++blockIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static List<SubListLayoutBlock> createSortedBlocksForLambda(Preferences preferences, LambdaInstruction lambdaInstruction) {
        classFile = lambdaInstruction.getClassFile();
        method = lambdaInstruction.getMethod();
        sortedMethodBlockList = new ArrayList<SubListLayoutBlock>();
        javaSourceLayouter = new JavaSourceLayouter();
        constants = classFile.getConstantPool();
        as = method.getAttributeSignature();
        signatureIndex = method.getSignatureIndex();
        signature = constants.getConstantUtf8(signatureIndex);
        subLayoutBlockList = new ArrayList<LayoutBlock>();
        nullCodeFlag = method.getCode() == null;
        subLayoutBlockList.add(new LambdaMethodLayoutBlock(classFile, method, signature, as == null, nullCodeFlag, lambdaInstruction.getParameterNames()));
        lineNumber = lambdaInstruction.getLineNumber();
        arrow = new LambdaArrowLayoutBlock(classFile, method, lineNumber);
        subLayoutBlockList.add(arrow);
        firstLineNumber = 0;
        lastLineNumber = 0;
        preferedLineNumber = 0x7FFFFFFF;
        if (!nullCodeFlag) {
            if (method.containsError()) {
                mbbslb = new MethodBodyBlockStartLayoutBlock();
                subLayoutBlockList.add(mbbslb);
                subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                mbbelb = new MethodBodyBlockEndLayoutBlock();
                subLayoutBlockList.add(mbbelb);
                mbbslb.setOther(mbbelb);
                mbbelb.setOther(mbbslb);
            } else {
                block13: {
                    list = method.getFastNodes();
                    mbbslb = new InnerTypeBodyBlockStartLayoutBlock();
                    n = list.size();
                    v0 = block = n != 1 || list.get(n - 1) instanceof AThrow != false;
                    if (block) {
                        subLayoutBlockList.add(mbbslb);
                    } else {
                        lineNumber = list.get(n - 1).getLineNumber();
                        arrow.setFirstLineNumber(lineNumber);
                        arrow.setLastLineNumber(lineNumber);
                    }
                    subLayoutBlockListLength = subLayoutBlockList.size();
                    if (!list.isEmpty()) {
                        try {
                            beforeIndex = subLayoutBlockList.size();
                            javaSourceLayouter.createBlocks(preferences, subLayoutBlockList, classFile, method, list);
                            afterIndex = subLayoutBlockList.size();
                            firstLineNumber = ClassFileLayouter.searchFirstLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                            lastLineNumber = ClassFileLayouter.searchLastLineNumber(subLayoutBlockList, beforeIndex, afterIndex);
                            break block13;
                        }
                        catch (Exception e) {
                            if (!ClassFileLayouter.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                                throw new AssertionError();
                            }
                            currentLength = subLayoutBlockList.size();
                            ** while (currentLength > subLayoutBlockListLength)
                        }
lbl-1000:
                        // 1 sources

                        {
                            subLayoutBlockList.remove(--currentLength);
                            continue;
                        }
lbl62:
                        // 1 sources

                        subLayoutBlockList.add(new ByteCodeLayoutBlock(classFile, method));
                    }
                }
                mbbelb = new InnerTypeBodyBlockEndLayoutBlock();
                mbbslb.setOther(mbbelb);
                mbbelb.setOther(mbbslb);
                if (block) {
                    if (n == 0) {
                        mbbslb.transformToStartEndBlock();
                    } else {
                        subLayoutBlockList.add(mbbelb);
                    }
                }
            }
        }
        sortedMethodBlockList.add(new SubListLayoutBlock(59, subLayoutBlockList, firstLineNumber, lastLineNumber, preferedLineNumber));
        return ClassFileLayouter.sortBlocks(sortedMethodBlockList, false);
    }
}

