/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.layout.block.AnnotationsLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class AnnotationLayouter {
    private AnnotationLayouter() {
    }

    public static void createBlocksForAnnotations(ClassFile classFile, Attribute[] attributes, List<LayoutBlock> layoutBlockList, boolean addOverride) {
        int attributesLength = attributes.length;
        ArrayList<AnnotationEntry> annotations = new ArrayList<AnnotationEntry>(attributesLength);
        Attribute[] attributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry[] array;
            Attribute attribute = attributeArray[n2];
            if ((attribute.getTag() == 13 || attribute.getTag() == 12) && (array = ((Annotations)attribute).getAnnotationEntries()) != null) {
                Collections.addAll(annotations, array);
            }
            ++n2;
        }
        if (addOverride) {
            AnnotationEntry annotationEntry;
            block6: {
                ConstantPool constants = classFile.getConstantPool();
                int typeIndex = constants.getOverrideSignatureIndex();
                annotationEntry = new AnnotationEntry(typeIndex, constants.getConstantPool(), false);
                try {
                    Field elementValuePairs = annotationEntry.getClass().getDeclaredField("elementValuePairs");
                    elementValuePairs.setAccessible(true);
                    elementValuePairs.set(annotationEntry, Collections.emptyList());
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block6;
                    throw new AssertionError();
                }
            }
            annotations.add(annotationEntry);
        }
        if (!annotations.isEmpty()) {
            layoutBlockList.add(new AnnotationsLayoutBlock(classFile, annotations));
        }
    }

    public static void createBlocksForAnnotations(ClassFile classFile, Attribute[] attributes, List<LayoutBlock> layoutBlockList) {
        AnnotationLayouter.createBlocksForAnnotations(classFile, attributes, layoutBlockList, false);
    }
}

