/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.deserializer;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Stream;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class ClassFileDeserializer {
    private ClassFileDeserializer() {
    }

    public static ClassFile deserialize(Loader loader, String internalClassPath) {
        return ClassFileDeserializer.deserialize(loader, internalClassPath, false);
    }

    public static ClassFile deserialize(Loader loader, String internalClassPath, boolean skipInnerClasses) {
        ClassFile classFile = ClassFileDeserializer.loadSingleClass(loader, internalClassPath);
        if (classFile == null) {
            return null;
        }
        if (classFile.getSuperClassName() != null && !"java/lang/Object".equals(internalClassPath) && loader.canLoad(classFile.getSuperClassName())) {
            ClassFile superClass = ClassFileDeserializer.deserialize(loader, classFile.getSuperClassName(), true);
            classFile.getSuperClassAndInterfaces().put(classFile.getSuperClassName(), superClass);
        }
        int[] nArray = classFile.getInterfaces();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int interfaceIndex = nArray[n2];
            String interfaceName = classFile.getConstantPool().getConstantClassName(interfaceIndex);
            if (loader.canLoad(interfaceName)) {
                ClassFile interfass = ClassFileDeserializer.deserialize(loader, interfaceName);
                classFile.getSuperClassAndInterfaces().put(interfaceName, interfass);
            }
            ++n2;
        }
        if (skipInnerClasses) {
            return classFile;
        }
        InnerClasses aics = classFile.getAttributeInnerClasses();
        if (aics == null) {
            return classFile;
        }
        String internalClassPathPrefix = internalClassPath.substring(0, internalClassPath.length() - ".class".length());
        String innerInternalClassNamePrefix = String.valueOf(internalClassPathPrefix) + '$';
        ConstantPool constants = classFile.getConstantPool();
        ArrayList<ClassFile> innerClassFiles = new ArrayList<ClassFile>(aics.getLength());
        InnerClass[] innerClassArray = aics.getInnerClasses();
        int n3 = innerClassArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ClassFile innerClassFile;
            String tmpInnerInternalClassPath;
            int offsetInternalInnerSeparator;
            InnerClass innerClass = innerClassArray[n4];
            String innerInternalClassPath = constants.getConstantClassName(innerClass.getInnerClassIndex());
            if (innerInternalClassPath.startsWith(innerInternalClassNamePrefix) && ((offsetInternalInnerSeparator = innerInternalClassPath.indexOf(36, innerInternalClassNamePrefix.length())) == -1 || !loader.canLoad(tmpInnerInternalClassPath = String.valueOf(innerInternalClassPath.substring(0, offsetInternalInnerSeparator)) + ".class")) && (innerClassFile = ClassFileDeserializer.deserialize(loader, String.valueOf(innerInternalClassPath) + ".class")) != null) {
                innerClassFile.setAccessFlags(innerClass.getInnerAccessFlags());
                innerClassFile.setOuterClass(classFile);
                innerClassFiles.add(innerClassFile);
            }
            ++n4;
        }
        classFile.setInnerClassFiles(innerClassFiles);
        return classFile;
    }

    private static ClassFile loadSingleClass(Loader loader, String internalClassPath) {
        ClassFile classFile;
        block12: {
            classFile = null;
            if (loader.canLoad(internalClassPath)) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(loader.load(internalClassPath)));){
                        classFile = ClassFileDeserializer.deserialize(dis, loader, internalClassPath);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block12;
                    throw new AssertionError();
                }
            }
        }
        return classFile;
    }

    private static ClassFile deserialize(DataInputStream di, Loader loader, String internalClassPath) throws IOException {
        Method[] methodInfos;
        ClassParser parser = new ClassParser((InputStream)di, internalClassPath);
        JavaClass javaClass = parser.parse();
        ConstantPool constantPool = new ConstantPool(javaClass.getConstantPool());
        int accessFlags = javaClass.getAccessFlags();
        int thisClass = javaClass.getClassNameIndex();
        int superClass = javaClass.getSuperclassNameIndex();
        int[] interfaces = javaClass.getInterfaceIndices();
        Field[] fieldInfos = (Field[])Stream.of(javaClass.getFields()).map(Field::new).toArray(Field[]::new);
        Method[] methodArray = methodInfos = (Method[])Stream.of(javaClass.getMethods()).map(Method::new).toArray(Method[]::new);
        int n = methodInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            byte[] methodCode = method.getCode();
            if (methodCode != null) {
                ByteCodeUtil.cleanUpByteCode((byte[])methodCode);
            }
            ++n2;
        }
        return new ClassFile(javaClass.getMinor(), javaClass.getMajor(), constantPool, accessFlags, thisClass, superClass, interfaces, fieldInfos, methodInfos, javaClass.getAttributes(), loader);
    }
}

