/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.variable;

import java.util.HashSet;
import java.util.Set;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Field;
import jd.core.process.analyzer.variable.VariableNameGenerator;
import jd.core.util.SignatureUtil;

public class DefaultVariableNameGenerator
implements VariableNameGenerator {
    private final Set<String> fieldNames = new HashSet<String>();
    private final Set<String> localNames = new HashSet<String>();

    public DefaultVariableNameGenerator(ClassFile classFile) {
        Field[] fieldArray = classFile.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.fieldNames.add(classFile.getConstantPool().getConstantUtf8(field.getNameIndex()));
            ++n2;
        }
    }

    @Override
    public void clearLocalNames() {
        this.localNames.clear();
    }

    @Override
    public String generateParameterNameFromSignature(String signature, boolean appearsOnceFlag, boolean varargsFlag, int anonymousClassDepth) {
        String prefix;
        switch (anonymousClassDepth) {
            case 0: {
                String string = "param";
                break;
            }
            case 1: {
                String string = "paramAnonymous";
                break;
            }
            default: {
                String string = prefix = "paramAnonymous" + anonymousClassDepth;
            }
        }
        if (varargsFlag) {
            return String.valueOf(prefix) + "VarArgs";
        }
        int index = SignatureUtil.countDimensionOfArray(signature);
        if (index > 0) {
            prefix = String.valueOf(prefix) + "ArrayOf";
        }
        return this.generateValidName(String.valueOf(prefix) + DefaultVariableNameGenerator.getSuffixFromSignature(signature.substring(index)), appearsOnceFlag);
    }

    @Override
    public String generateLocalVariableNameFromSignature(String signature, boolean appearsOnce) {
        int index = SignatureUtil.countDimensionOfArray(signature);
        if (index > 0) {
            return this.generateValidName("arrayOf" + DefaultVariableNameGenerator.getSuffixFromSignature(signature.substring(index)), appearsOnce);
        }
        switch (signature.charAt(0)) {
            case 'L': {
                String s = DefaultVariableNameGenerator.formatSignature(signature);
                if ("String".equals(s)) {
                    return this.generateValidName("str", appearsOnce);
                }
                return this.generateValidName("local" + s, appearsOnce);
            }
            case 'B': {
                return this.generateValidName("b", appearsOnce);
            }
            case 'C': {
                return this.generateValidName("c", appearsOnce);
            }
            case 'D': {
                return this.generateValidName("d", appearsOnce);
            }
            case 'F': {
                return this.generateValidName("f", appearsOnce);
            }
            case 'I': {
                return this.generateValidIntName();
            }
            case 'J': {
                return this.generateValidName("l", appearsOnce);
            }
            case 'S': {
                return this.generateValidName("s", appearsOnce);
            }
            case 'Z': {
                return this.generateValidName("bool", appearsOnce);
            }
            case 'T': {
                return this.generateValidName("generic", appearsOnce);
            }
        }
        new Throwable("NameGenerator.generateParameterNameFromSignature: invalid signature '" + signature + "'").printStackTrace();
        return "?";
    }

    private static String getSuffixFromSignature(String signature) {
        switch (signature.charAt(0)) {
            case 'L': {
                return DefaultVariableNameGenerator.formatSignature(signature);
            }
            case 'B': {
                return "Byte";
            }
            case 'C': {
                return "Char";
            }
            case 'D': {
                return "Double";
            }
            case 'F': {
                return "Float";
            }
            case 'I': {
                return "Int";
            }
            case 'J': {
                return "Long";
            }
            case 'S': {
                return "Short";
            }
            case 'Z': {
                return "Boolean";
            }
            case '[': {
                return "Array";
            }
            case 'T': {
                return DefaultVariableNameGenerator.formatTemplate(signature);
            }
        }
        new Throwable("NameGenerator.generateParameterNameFromSignature: invalid signature '" + signature + "'").printStackTrace();
        return "?";
    }

    private static String formatSignature(String signature) {
        int index = (signature = signature.substring(1, signature.length() - 1)).indexOf(60);
        if (index != -1) {
            signature = signature.substring(0, index);
        }
        if ((index = signature.lastIndexOf(36)) != -1) {
            signature = signature.substring(index + 1);
        }
        if ((index = signature.lastIndexOf(47)) != -1) {
            signature = signature.substring(index + 1);
        }
        return signature;
    }

    private static String formatTemplate(String signature) {
        return signature.substring(1, signature.length() - 1);
    }

    private String generateValidName(String name, boolean appearsOnceFlag) {
        if (Character.isUpperCase(name.charAt(0))) {
            name = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
        }
        if (appearsOnceFlag && !this.fieldNames.contains(name) && !this.localNames.contains(name)) {
            this.localNames.add(name);
            return name;
        }
        int index = 1;
        while (true) {
            String newName;
            if (!this.fieldNames.contains(newName = String.valueOf(name) + index) && !this.localNames.contains(newName)) {
                this.localNames.add(newName);
                return newName;
            }
            ++index;
        }
    }

    private String generateValidIntName() {
        if (!this.fieldNames.contains("i") && !this.localNames.contains("i")) {
            this.localNames.add("i");
            return "i";
        }
        if (!this.fieldNames.contains("j") && !this.localNames.contains("j")) {
            this.localNames.add("j");
            return "j";
        }
        if (!this.fieldNames.contains("k") && !this.localNames.contains("k")) {
            this.localNames.add("k");
            return "k";
        }
        if (!this.fieldNames.contains("m") && !this.localNames.contains("m")) {
            this.localNames.add("m");
            return "m";
        }
        if (!this.fieldNames.contains("n") && !this.localNames.contains("n")) {
            this.localNames.add("n");
            return "n";
        }
        return this.generateValidName("i", false);
    }
}

